#!/bin/csh -fb
set usage = "usage: $0 (amino|namino|camino|uamino|unamino|ucamino|nucleic|unucleic|general|ions)"
if ($#argv != 1) then
	echo "$usage"
	exit 1
endif
switch ($1)
case amino:
	set file = amino4.lib
	set residues = (ALA ARG ASN ASP CYS CYX GLN GLU GLY HID HIE HIP ILE LEU LYS MET PHE PRO SER THR TRP TYR VAL)
	breaksw
case namino:
	set file = namino4.lib
	set residues = (ACE NALA NARG NASN NASP NCYS NCYX NGLN NGLU NGLY NHID NHIE NHIP NILE NLEU NLYS NMET NPHE NPRO NSER NTHR NTRP NTYR NVAL)
	breaksw
case camino:
	set file = camino4.lib
	set residues = (CALA CARG CASN CASP CCYS CCYX CGLN CGLU CGLY CHID CHIE CHIP CILE CLEU CLYS CMET CPHE CPRO CSER CTHR CTRP CTYR CVAL NHE NME)
	breaksw
case uamino:
	set file = uamino4.lib
	set residues = (UALA UARG UASN UASP UCYS UCYX UGLN UGLU UGLY UHID UHIE UHIP UILE ULEU ULYS UMET UPHE UPRO USER UTHR UTRP UTYR UVAL)
	breaksw
case unamino:
	set file = unamino4.lib
	set residues = (UACE UNALA UNARG UNASN UNASP UNCYS UNCYX UNGLN UNGLU UNGLY UNHID UNHIE UNHIP UNILE UNLEU UNLYS UNMET UNPHE UNPRO UNSER UNTHR UNTRP UNTYR UNVAL)
	breaksw
case ucamino:
	set file = ucamino4.lib
	set residues = (UCALA UCARG UCASN UCASP UCCYS UCCYX UCGLN UCGLU UCGLY UCHID UCHIE UCHIP UCILE UCLEU UCLYS UCMET UCPHE UCPRO UCSER UCTHR UCTRP UCTYR UCVAL UNME)
	breaksw
case nucleic:
	set file = nucleic4.lib
	set residues = (DADE DCYT DGUA DOHE DPOM DTHY HB HE RADE RCYT RGUA ROHE RPOM RURA)
	breaksw
case unucleic:
	set file = unucleic4.lib
	set residues = (HB HE UDADE UDCYT UDGUA UDOHE UDPOM UDTHY URADE URCYT URGUA UROHE URPOM URURA)
	breaksw
case general:
	set file = general.lib
	set residues = (TIP3)
	breaksw
case ions:
	set file = ions.lib
	set residues = (Cs\\\\+ IB K\\\\+ Li\\\\+ Na\\\\+ Rb\\\\+)
	breaksw
default:
	echo "$usage"
	exit 1
endsw
set echo
echo '#include "TmplMolecule.h"' > $1.cc
foreach r ($residues)
	sed s/XXX/$r/g < extract.awk > $$.awk
	nawk -f $$.awk $file >> $1.cc
end
cat << EOF >> $1.cc

void
tmpl_init_$1(TmplMolecule *m, int *seqno)
{
EOF
foreach r ($residues)
	echo "	init_$r(m, (*seqno)++);" >> $1.cc
end
echo '}' >> $1.cc
rm $$.awk
