#include "TmplMolecule.h"

static void
init_ACE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "ACE", MolResId(seqno));
	p = (new TmplAtom(m, r, "CH3", 6, "CT"))->getCoord();
	p->xyz[0] = 2.000001;
	p->xyz[1] = 2.090000;
	p->xyz[2] = 1.211769E-07;
	p = (new TmplAtom(m, r, "H2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.486264;
	p->xyz[1] = 2.453849;
	p->xyz[2] = 0.889824;
	p = (new TmplAtom(m, r, "H3", 1, "HC"))->getCoord();
	p->xyz[0] = 1.486259;
	p->xyz[1] = 2.453852;
	p->xyz[2] = -0.889820;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 3.427420;
	p->xyz[1] = 2.640795;
	p->xyz[2] = -2.981008E-06;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.390580;
	p->xyz[1] = 1.877406;
	p->xyz[2] = -6.602402E-06;
	p = (new TmplAtom(m, r, "H1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.000001;
	p->xyz[1] = 1.000000;
	p->xyz[2] = -1.346410E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CH3"), r->lookupAtom("H2"));
	(void) new TmplBond(r->lookupAtom("CH3"), r->lookupAtom("H3"));
	(void) new TmplBond(r->lookupAtom("CH3"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("H1"), r->lookupAtom("CH3"));
}

static void
init_NALA(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NALA", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.871570;
	p->xyz[1] = 0.825969;
	p->xyz[2] = -1.205866;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB1"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NARG(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NARG", MolResId(seqno));
	p = (new TmplAtom(m, r, "NH2", 7, "N2"))->getCoord();
	p->xyz[0] = 10.386419;
	p->xyz[1] = -0.375392;
	p->xyz[2] = -3.287202;
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN21", 1, "H3"))->getCoord();
	p->xyz[0] = 10.808467;
	p->xyz[1] = 0.083311;
	p->xyz[2] = -2.492490;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN22", 1, "H3"))->getCoord();
	p->xyz[0] = 10.964285;
	p->xyz[1] = -0.789488;
	p->xyz[2] = -4.004625;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655467;
	p->xyz[1] = 0.323669;
	p->xyz[2] = -0.296107;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 6.855371;
	p->xyz[1] = 0.121199;
	p->xyz[2] = -2.426877;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507063;
	p->xyz[1] = 0.629711;
	p->xyz[2] = -3.325875;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507057;
	p->xyz[1] = -0.911608;
	p->xyz[2] = -2.436227;
	p = (new TmplAtom(m, r, "NE", 7, "N2"))->getCoord();
	p->xyz[0] = 8.335369;
	p->xyz[1] = 0.122485;
	p->xyz[2] = -2.424640;
	p = (new TmplAtom(m, r, "HNE", 1, "H3"))->getCoord();
	p->xyz[0] = 8.815752;
	p->xyz[1] = 0.566619;
	p->xyz[2] = -1.655174;
	p = (new TmplAtom(m, r, "CZ", 6, "CA"))->getCoord();
	p->xyz[0] = 9.061684;
	p->xyz[1] = -0.434489;
	p->xyz[2] = -3.389599;
	p = (new TmplAtom(m, r, "NH1", 7, "N2"))->getCoord();
	p->xyz[0] = 8.501706;
	p->xyz[1] = -1.037553;
	p->xyz[2] = -4.434415;
	p = (new TmplAtom(m, r, "HN11", 1, "H3"))->getCoord();
	p->xyz[0] = 7.495397;
	p->xyz[1] = -1.080677;
	p->xyz[2] = -4.509135;
	p = (new TmplAtom(m, r, "HN12", 1, "H3"))->getCoord();
	p->xyz[0] = 9.085342;
	p->xyz[1] = -1.449623;
	p->xyz[2] = -5.148325;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("NH2"), r->lookupAtom("HN21"));
	(void) new TmplBond(r->lookupAtom("NH2"), r->lookupAtom("HN22"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("NE"));
	(void) new TmplBond(r->lookupAtom("NE"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("NH1"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("NH2"));
	(void) new TmplBond(r->lookupAtom("NH1"), r->lookupAtom("HN11"));
	(void) new TmplBond(r->lookupAtom("NH1"), r->lookupAtom("HN12"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NASN(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NASN", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "C"))->getCoord();
	p->xyz[0] = 6.303995;
	p->xyz[1] = 0.810753;
	p->xyz[2] = -1.232225;
	p = (new TmplAtom(m, r, "OD1", 8, "O"))->getCoord();
	p->xyz[0] = 6.927762;
	p->xyz[1] = 1.340121;
	p->xyz[2] = -0.315096;
	p = (new TmplAtom(m, r, "ND2", 7, "N"))->getCoord();
	p->xyz[0] = 6.901752;
	p->xyz[1] = 0.214021;
	p->xyz[2] = -2.266063;
	p = (new TmplAtom(m, r, "HND1", 1, "H"))->getCoord();
	p->xyz[0] = 6.342826;
	p->xyz[1] = -0.206522;
	p->xyz[2] = -2.994656;
	p = (new TmplAtom(m, r, "HND2", 1, "H"))->getCoord();
	p->xyz[0] = 7.910177;
	p->xyz[1] = 0.185833;
	p->xyz[2] = -2.314893;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND2"));
	(void) new TmplBond(r->lookupAtom("ND2"), r->lookupAtom("HND1"));
	(void) new TmplBond(r->lookupAtom("ND2"), r->lookupAtom("HND2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NASP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NASP", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "C"))->getCoord();
	p->xyz[0] = 6.308377;
	p->xyz[1] = 0.832467;
	p->xyz[2] = -1.194607;
	p = (new TmplAtom(m, r, "OD1", 8, "O2"))->getCoord();
	p->xyz[0] = 6.884086;
	p->xyz[1] = -0.129931;
	p->xyz[2] = -0.620195;
	p = (new TmplAtom(m, r, "OD2", 8, "O2"))->getCoord();
	p->xyz[0] = 6.884090;
	p->xyz[1] = 1.811242;
	p->xyz[2] = -1.740640;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("OD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NCYS(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NCYS", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "SG", 16, "SH"))->getCoord();
	p->xyz[0] = 6.585379;
	p->xyz[1] = 0.733465;
	p->xyz[2] = -1.366126;
	p = (new TmplAtom(m, r, "HSG", 1, "HS"))->getCoord();
	p->xyz[0] = 6.610910;
	p->xyz[1] = 0.068717;
	p->xyz[2] = -2.517802;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.693110;
	p->xyz[1] = 0.392220;
	p->xyz[2] = -0.789076;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.693113;
	p->xyz[1] = 1.403829;
	p->xyz[2] = -1.372977;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("SG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("HSG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NCYX(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NCYX", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "SG", 16, "S"))->getCoord();
	p->xyz[0] = 6.585379;
	p->xyz[1] = 0.733465;
	p->xyz[2] = -1.366126;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.693110;
	p->xyz[1] = 0.392220;
	p->xyz[2] = -0.789076;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.693113;
	p->xyz[1] = 1.403829;
	p->xyz[2] = -1.372977;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("SG"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SG"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NGLN(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NGLN", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655467;
	p->xyz[1] = 0.323669;
	p->xyz[2] = -0.296107;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "CD", 6, "C"))->getCoord();
	p->xyz[0] = 6.894460;
	p->xyz[1] = 0.130677;
	p->xyz[2] = -2.410457;
	p = (new TmplAtom(m, r, "OE1", 8, "O"))->getCoord();
	p->xyz[0] = 6.158776;
	p->xyz[1] = -0.361468;
	p->xyz[2] = -3.263102;
	p = (new TmplAtom(m, r, "NE2", 7, "N"))->getCoord();
	p->xyz[0] = 8.226416;
	p->xyz[1] = 0.085629;
	p->xyz[2] = -2.488494;
	p = (new TmplAtom(m, r, "HNE1", 1, "H"))->getCoord();
	p->xyz[0] = 8.786371;
	p->xyz[1] = 0.505828;
	p->xyz[2] = -1.760495;
	p = (new TmplAtom(m, r, "HNE2", 1, "H"))->getCoord();
	p->xyz[0] = 8.668061;
	p->xyz[1] = -0.368443;
	p->xyz[2] = -3.275176;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE1"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE1"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NGLU(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NGLU", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.291384;
	p->xyz[1] = 0.832225;
	p->xyz[2] = -1.195025;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.640473;
	p->xyz[1] = 0.323455;
	p->xyz[2] = -0.296476;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.640476;
	p->xyz[1] = 1.864773;
	p->xyz[2] = -1.186125;
	p = (new TmplAtom(m, r, "CD", 6, "C"))->getCoord();
	p->xyz[0] = 6.841098;
	p->xyz[1] = 0.120053;
	p->xyz[2] = -2.428863;
	p = (new TmplAtom(m, r, "OE1", 8, "O2"))->getCoord();
	p->xyz[0] = 7.048438;
	p->xyz[1] = 0.822027;
	p->xyz[2] = -3.454456;
	p = (new TmplAtom(m, r, "OE2", 8, "O2"))->getCoord();
	p->xyz[0] = 7.048431;
	p->xyz[1] = -1.119147;
	p->xyz[2] = -2.334012;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE1"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("OE2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NGLY(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NGLY", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA1", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596849;
	p->xyz[1] = 1.008357;
	p->xyz[2] = -0.889884;
	p = (new TmplAtom(m, r, "HA2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.763531;
	p->xyz[1] = 2.948540;
	p->xyz[2] = 0.000155;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 3.988433;
	p->xyz[1] = 3.902304;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA1"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA2"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NHID(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NHID", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 6.288498;
	p->xyz[1] = 0.759412;
	p->xyz[2] = -1.321174;
	p = (new TmplAtom(m, r, "ND1", 7, "NA"))->getCoord();
	p->xyz[0] = 6.943203;
	p->xyz[1] = 0.146452;
	p->xyz[2] = -2.383126;
	p = (new TmplAtom(m, r, "HND", 1, "H"))->getCoord();
	p->xyz[0] = 6.502033;
	p->xyz[1] = -0.307735;
	p->xyz[2] = -3.170008;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 8.242748;
	p->xyz[1] = 0.262167;
	p->xyz[2] = -2.182642;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 8.944842;
	p->xyz[1] = -0.154635;
	p->xyz[2] = -2.904750;
	p = (new TmplAtom(m, r, "NE2", 7, "NB"))->getCoord();
	p->xyz[0] = 8.445422;
	p->xyz[1] = 0.909153;
	p->xyz[2] = -1.061735;
	p = (new TmplAtom(m, r, "CD2", 6, "CV"))->getCoord();
	p->xyz[0] = 7.254792;
	p->xyz[1] = 1.237725;
	p->xyz[2] = -0.492489;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 7.233870;
	p->xyz[1] = 1.782519;
	p->xyz[2] = 0.451366;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("HND"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NHIE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NHIE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 6.288498;
	p->xyz[1] = 0.759412;
	p->xyz[2] = -1.321174;
	p = (new TmplAtom(m, r, "ND1", 7, "NB"))->getCoord();
	p->xyz[0] = 6.943203;
	p->xyz[1] = 0.146452;
	p->xyz[2] = -2.383126;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 8.242748;
	p->xyz[1] = 0.262167;
	p->xyz[2] = -2.182642;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 8.944842;
	p->xyz[1] = -0.154635;
	p->xyz[2] = -2.904750;
	p = (new TmplAtom(m, r, "NE2", 7, "NA"))->getCoord();
	p->xyz[0] = 8.445422;
	p->xyz[1] = 0.909153;
	p->xyz[2] = -1.061735;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 9.352430;
	p->xyz[1] = 1.131276;
	p->xyz[2] = -0.676902;
	p = (new TmplAtom(m, r, "CD2", 6, "CW"))->getCoord();
	p->xyz[0] = 7.254792;
	p->xyz[1] = 1.237725;
	p->xyz[2] = -0.492489;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 7.233870;
	p->xyz[1] = 1.782519;
	p->xyz[2] = 0.451366;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NHIP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NHIP", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CC"))->getCoord();
	p->xyz[0] = 6.288498;
	p->xyz[1] = 0.759412;
	p->xyz[2] = -1.321174;
	p = (new TmplAtom(m, r, "ND1", 7, "NA"))->getCoord();
	p->xyz[0] = 6.943203;
	p->xyz[1] = 0.146452;
	p->xyz[2] = -2.383126;
	p = (new TmplAtom(m, r, "HND", 1, "H"))->getCoord();
	p->xyz[0] = 6.502033;
	p->xyz[1] = -0.307735;
	p->xyz[2] = -3.170008;
	p = (new TmplAtom(m, r, "CE1", 6, "CR"))->getCoord();
	p->xyz[0] = 8.242748;
	p->xyz[1] = 0.262167;
	p->xyz[2] = -2.182642;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 8.944842;
	p->xyz[1] = -0.154635;
	p->xyz[2] = -2.904750;
	p = (new TmplAtom(m, r, "NE2", 7, "NA"))->getCoord();
	p->xyz[0] = 8.445422;
	p->xyz[1] = 0.909153;
	p->xyz[2] = -1.061735;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 9.352430;
	p->xyz[1] = 1.131276;
	p->xyz[2] = -0.676902;
	p = (new TmplAtom(m, r, "CD2", 6, "CW"))->getCoord();
	p->xyz[0] = 7.254792;
	p->xyz[1] = 1.237725;
	p->xyz[2] = -0.492489;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 7.233870;
	p->xyz[1] = 1.782519;
	p->xyz[2] = 0.451366;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("ND1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("HND"));
	(void) new TmplBond(r->lookupAtom("ND1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("NE2"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NILE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NILE", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.741302;
	p->xyz[1] = 0.803238;
	p->xyz[2] = -1.245250;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 4.378214;
	p->xyz[1] = -0.224510;
	p->xyz[2] = -1.245833;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 4.232939;
	p->xyz[1] = 1.522295;
	p->xyz[2] = -2.490300;
	p = (new TmplAtom(m, r, "HG21", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596027;
	p->xyz[1] = 2.550044;
	p->xyz[2] = -2.490655;
	p = (new TmplAtom(m, r, "HG22", 1, "HC"))->getCoord();
	p->xyz[0] = 4.595979;
	p->xyz[1] = 1.008939;
	p->xyz[2] = -3.380675;
	p = (new TmplAtom(m, r, "HG23", 1, "HC"))->getCoord();
	p->xyz[0] = 3.142939;
	p->xyz[1] = 1.522585;
	p->xyz[2] = -2.490741;
	p = (new TmplAtom(m, r, "CG1", 6, "CT"))->getCoord();
	p->xyz[0] = 6.266302;
	p->xyz[1] = 0.803235;
	p->xyz[2] = -1.245251;
	p = (new TmplAtom(m, r, "HG13", 1, "HC"))->getCoord();
	p->xyz[0] = 6.630152;
	p->xyz[1] = 0.289395;
	p->xyz[2] = -0.355486;
	p = (new TmplAtom(m, r, "HG12", 1, "HC"))->getCoord();
	p->xyz[0] = 6.630155;
	p->xyz[1] = 1.830713;
	p->xyz[2] = -1.245135;
	p = (new TmplAtom(m, r, "CD1", 6, "CT"))->getCoord();
	p->xyz[0] = 6.774604;
	p->xyz[1] = 0.084477;
	p->xyz[2] = -2.490499;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 6.411519;
	p->xyz[1] = 0.598047;
	p->xyz[2] = -3.380732;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 7.864603;
	p->xyz[1] = 0.084187;
	p->xyz[2] = -2.490993;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.411514;
	p->xyz[1] = -0.943271;
	p->xyz[2] = -2.491084;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG21"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG22"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG23"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG13"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG12"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NLEU(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NLEU", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "CD1", 6, "CT"))->getCoord();
	p->xyz[0] = 6.794026;
	p->xyz[1] = 0.120484;
	p->xyz[2] = 0.062700;
	p = (new TmplAtom(m, r, "HD11", 1, "HC"))->getCoord();
	p->xyz[0] = 6.445691;
	p->xyz[1] = -0.912324;
	p->xyz[2] = 0.054289;
	p = (new TmplAtom(m, r, "HD12", 1, "HC"))->getCoord();
	p->xyz[0] = 7.883577;
	p->xyz[1] = 0.135696;
	p->xyz[2] = 0.090047;
	p = (new TmplAtom(m, r, "HD13", 1, "HC"))->getCoord();
	p->xyz[0] = 6.401853;
	p->xyz[1] = 0.628482;
	p->xyz[2] = 0.943744;
	p = (new TmplAtom(m, r, "CD2", 6, "CT"))->getCoord();
	p->xyz[0] = 6.855371;
	p->xyz[1] = 0.121199;
	p->xyz[2] = -2.426877;
	p = (new TmplAtom(m, r, "HD21", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507063;
	p->xyz[1] = 0.629711;
	p->xyz[2] = -3.325875;
	p = (new TmplAtom(m, r, "HD22", 1, "HC"))->getCoord();
	p->xyz[0] = 7.944947;
	p->xyz[1] = 0.136410;
	p->xyz[2] = -2.400518;
	p = (new TmplAtom(m, r, "HD23", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507057;
	p->xyz[1] = -0.911608;
	p->xyz[2] = -2.436227;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD11"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD12"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD13"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD21"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD22"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD23"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NLYS(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NLYS", MolResId(seqno));
	p = (new TmplAtom(m, r, "HNZ3", 1, "H3"))->getCoord();
	p->xyz[0] = 8.585936;
	p->xyz[1] = -1.499627;
	p->xyz[2] = -3.585303;
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655467;
	p->xyz[1] = 0.323669;
	p->xyz[2] = -0.296107;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 6.855371;
	p->xyz[1] = 0.121199;
	p->xyz[2] = -2.426877;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507063;
	p->xyz[1] = 0.629711;
	p->xyz[2] = -3.325875;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507057;
	p->xyz[1] = -0.911608;
	p->xyz[2] = -2.436227;
	p = (new TmplAtom(m, r, "CE", 6, "CT"))->getCoord();
	p->xyz[0] = 8.379754;
	p->xyz[1] = 0.142879;
	p->xyz[2] = -2.389308;
	p = (new TmplAtom(m, r, "HE3", 1, "HC"))->getCoord();
	p->xyz[0] = 8.728843;
	p->xyz[1] = -0.365893;
	p->xyz[2] = -1.490760;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 8.728848;
	p->xyz[1] = 1.175427;
	p->xyz[2] = -2.380406;
	p = (new TmplAtom(m, r, "NZ", 7, "N3"))->getCoord();
	p->xyz[0] = 8.908948;
	p->xyz[1] = -0.542707;
	p->xyz[2] = -3.577089;
	p = (new TmplAtom(m, r, "HNZ1", 1, "H3"))->getCoord();
	p->xyz[0] = 8.585943;
	p->xyz[1] = -0.071167;
	p->xyz[2] = -4.409806;
	p = (new TmplAtom(m, r, "HNZ2", 1, "H3"))->getCoord();
	p->xyz[0] = 9.918540;
	p->xyz[1] = -0.528350;
	p->xyz[2] = -3.552207;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("CE"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE3"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("NZ"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ1"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ2"));
	(void) new TmplBond(r->lookupAtom("NZ"), r->lookupAtom("HNZ3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NMET(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NMET", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655467;
	p->xyz[1] = 0.323669;
	p->xyz[2] = -0.296107;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "SD", 16, "S"))->getCoord();
	p->xyz[0] = 6.973563;
	p->xyz[1] = -0.008672;
	p->xyz[2] = -2.651878;
	p = (new TmplAtom(m, r, "LP1", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.689327;
	p->xyz[1] = 0.398188;
	p->xyz[2] = -3.115253;
	p = (new TmplAtom(m, r, "LP2", AtomicSymbol::LonePair, "LP"))->getCoord();
	p->xyz[0] = 6.689323;
	p->xyz[1] = -0.613422;
	p->xyz[2] = -2.531352;
	p = (new TmplAtom(m, r, "CE", 6, "CT"))->getCoord();
	p->xyz[0] = 8.717019;
	p->xyz[1] = 0.170703;
	p->xyz[2] = -2.341101;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 8.969833;
	p->xyz[1] = -0.311744;
	p->xyz[2] = -1.396945;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 9.280529;
	p->xyz[1] = -0.295724;
	p->xyz[2] = -3.149187;
	p = (new TmplAtom(m, r, "HE3", 1, "HC"))->getCoord();
	p->xyz[0] = 8.969838;
	p->xyz[1] = 1.229576;
	p->xyz[2] = -2.286591;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("SD"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("LP1"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("LP2"));
	(void) new TmplBond(r->lookupAtom("SD"), r->lookupAtom("CE"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE"), r->lookupAtom("HE3"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NPHE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NPHE", MolResId(seqno));
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CA"))->getCoord();
	p->xyz[0] = 6.288498;
	p->xyz[1] = 0.759412;
	p->xyz[2] = -1.321174;
	p = (new TmplAtom(m, r, "CD1", 6, "CA"))->getCoord();
	p->xyz[0] = 6.904411;
	p->xyz[1] = 0.130914;
	p->xyz[2] = -2.410046;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 6.296469;
	p->xyz[1] = -0.321354;
	p->xyz[2] = -3.193602;
	p = (new TmplAtom(m, r, "CE1", 6, "CA"))->getCoord();
	p->xyz[0] = 8.301169;
	p->xyz[1] = 0.083308;
	p->xyz[2] = -2.492515;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 8.780702;
	p->xyz[1] = -0.406022;
	p->xyz[2] = -3.340280;
	p = (new TmplAtom(m, r, "CZ", 6, "CA"))->getCoord();
	p->xyz[0] = 9.082016;
	p->xyz[1] = 0.664199;
	p->xyz[2] = -1.486114;
	p = (new TmplAtom(m, r, "HZ1", 1, "HC"))->getCoord();
	p->xyz[0] = 10.169491;
	p->xyz[1] = 0.627135;
	p->xyz[2] = -1.550323;
	p = (new TmplAtom(m, r, "CE2", 6, "CA"))->getCoord();
	p->xyz[0] = 8.466105;
	p->xyz[1] = 1.292698;
	p->xyz[2] = -0.397241;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 9.074050;
	p->xyz[1] = 1.744964;
	p->xyz[2] = 0.386314;
	p = (new TmplAtom(m, r, "CD2", 6, "CA"))->getCoord();
	p->xyz[0] = 7.069348;
	p->xyz[1] = 1.340306;
	p->xyz[2] = -0.314768;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.589818;
	p->xyz[1] = 1.829638;
	p->xyz[2] = 0.532996;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("HZ1"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NPRO(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NPRO", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CD", 6, "CT"))->getCoord();
	p->xyz[0] = 3.643051;
	p->xyz[1] = 0.346679;
	p->xyz[2] = 0.080119;
	p = (new TmplAtom(m, r, "HD3", 1, "HC"))->getCoord();
	p->xyz[0] = 3.713268;
	p->xyz[1] = -0.120328;
	p->xyz[2] = -0.902263;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 3.221466;
	p->xyz[1] = -0.364389;
	p->xyz[2] = 0.790575;
	p = (new TmplAtom(m, r, "CG", 6, "CT"))->getCoord();
	p->xyz[0] = 4.952962;
	p->xyz[1] = 0.910863;
	p->xyz[2] = 0.544693;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 5.045427;
	p->xyz[1] = 0.776138;
	p->xyz[2] = 1.622376;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.770512;
	p->xyz[1] = 0.393278;
	p->xyz[2] = 0.042879;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.925510;
	p->xyz[1] = 2.377195;
	p->xyz[2] = 0.185226;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 5.309383;
	p->xyz[1] = 2.963696;
	p->xyz[2] = 1.019946;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 5.546549;
	p->xyz[1] = 2.547937;
	p->xyz[2] = -0.694124;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 3.522621;
	p->xyz[1] = 2.766556;
	p->xyz[2] = -0.104509;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 3.571013;
	p->xyz[1] = 3.244214;
	p->xyz[2] = 0.874062;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 2.579319;
	p->xyz[1] = 3.956798;
	p->xyz[2] = -0.204454;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 1.361690;
	p->xyz[1] = 3.790592;
	p->xyz[2] = -0.190496;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD3"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("CD"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CD"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NSER(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NSER", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "OG", 8, "OH"))->getCoord();
	p->xyz[0] = 6.211416;
	p->xyz[1] = 0.831088;
	p->xyz[2] = -1.196996;
	p = (new TmplAtom(m, r, "HOG", 1, "HO"))->getCoord();
	p->xyz[0] = 6.557012;
	p->xyz[1] = 0.383357;
	p->xyz[2] = -1.972690;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("OG"));
	(void) new TmplBond(r->lookupAtom("OG"), r->lookupAtom("HOG"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NTHR(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NTHR", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 5.871570;
	p->xyz[1] = 0.825969;
	p->xyz[2] = -1.205866;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 4.294281;
	p->xyz[1] = -0.634098;
	p->xyz[2] = -1.244620;
	p = (new TmplAtom(m, r, "HG1", 1, "HC"))->getCoord();
	p->xyz[0] = 3.204729;
	p->xyz[1] = -0.650120;
	p->xyz[2] = -1.271448;
	p = (new TmplAtom(m, r, "HG2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.686411;
	p->xyz[1] = -1.142940;
	p->xyz[2] = -2.125196;
	p = (new TmplAtom(m, r, "HG3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.642610;
	p->xyz[1] = -1.143419;
	p->xyz[2] = -0.346089;
	p = (new TmplAtom(m, r, "OG1", 8, "OH"))->getCoord();
	p->xyz[0] = 4.324667;
	p->xyz[1] = 1.478378;
	p->xyz[2] = -2.411221;
	p = (new TmplAtom(m, r, "HOG", 1, "HO"))->getCoord();
	p->xyz[0] = 4.670262;
	p->xyz[1] = 1.030645;
	p->xyz[2] = -3.186914;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("OG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG1"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG2"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG3"));
	(void) new TmplBond(r->lookupAtom("OG1"), r->lookupAtom("HOG"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NTRP(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NTRP", MolResId(seqno));
	p = (new TmplAtom(m, r, "CE3", 6, "CA"))->getCoord();
	p->xyz[0] = 8.280012;
	p->xyz[1] = 3.271780;
	p->xyz[2] = -0.037756;
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HE", 1, "HC"))->getCoord();
	p->xyz[0] = 8.123300;
	p->xyz[1] = 4.339210;
	p->xyz[2] = -0.193108;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "CD2", 6, "CB"))->getCoord();
	p->xyz[0] = 8.261207;
	p->xyz[1] = 2.338546;
	p->xyz[2] = -1.081174;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "C*"))->getCoord();
	p->xyz[0] = 6.288498;
	p->xyz[1] = 0.759412;
	p->xyz[2] = -1.321174;
	p = (new TmplAtom(m, r, "CD1", 6, "CW"))->getCoord();
	p->xyz[0] = 7.020273;
	p->xyz[1] = 0.198248;
	p->xyz[2] = -2.293388;
	p = (new TmplAtom(m, r, "HD", 1, "HC"))->getCoord();
	p->xyz[0] = 6.527120;
	p->xyz[1] = -0.287686;
	p->xyz[2] = -3.135272;
	p = (new TmplAtom(m, r, "NE1", 7, "NA"))->getCoord();
	p->xyz[0] = 8.394188;
	p->xyz[1] = 0.396485;
	p->xyz[2] = -1.949935;
	p = (new TmplAtom(m, r, "HNE", 1, "H"))->getCoord();
	p->xyz[0] = 9.185718;
	p->xyz[1] = 0.082865;
	p->xyz[2] = -2.493280;
	p = (new TmplAtom(m, r, "CE2", 6, "CN"))->getCoord();
	p->xyz[0] = 8.460468;
	p->xyz[1] = 1.050517;
	p->xyz[2] = -0.816820;
	p = (new TmplAtom(m, r, "CZ2", 6, "CA"))->getCoord();
	p->xyz[0] = 8.695401;
	p->xyz[1] = 0.535040;
	p->xyz[2] = 0.463449;
	p = (new TmplAtom(m, r, "HZ1", 1, "HC"))->getCoord();
	p->xyz[0] = 8.850010;
	p->xyz[1] = -0.535249;
	p->xyz[2] = 0.600115;
	p = (new TmplAtom(m, r, "CH2", 6, "CA"))->getCoord();
	p->xyz[0] = 8.714072;
	p->xyz[1] = 1.461610;
	p->xyz[2] = 1.499412;
	p = (new TmplAtom(m, r, "HH", 1, "HC"))->getCoord();
	p->xyz[0] = 8.891452;
	p->xyz[1] = 1.131299;
	p->xyz[2] = 2.522901;
	p = (new TmplAtom(m, r, "CZ3", 6, "CA"))->getCoord();
	p->xyz[0] = 8.514941;
	p->xyz[1] = 2.775366;
	p->xyz[2] = 1.260890;
	p = (new TmplAtom(m, r, "HZ2", 1, "HC"))->getCoord();
	p->xyz[0] = 8.533008;
	p->xyz[1] = 3.487869;
	p->xyz[2] = 2.085580;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CE3"), r->lookupAtom("HE"));
	(void) new TmplBond(r->lookupAtom("CE3"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("NE1"));
	(void) new TmplBond(r->lookupAtom("NE1"), r->lookupAtom("HNE"));
	(void) new TmplBond(r->lookupAtom("NE1"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CZ2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CZ2"), r->lookupAtom("HZ1"));
	(void) new TmplBond(r->lookupAtom("CZ2"), r->lookupAtom("CH2"));
	(void) new TmplBond(r->lookupAtom("CH2"), r->lookupAtom("HH"));
	(void) new TmplBond(r->lookupAtom("CH2"), r->lookupAtom("CZ3"));
	(void) new TmplBond(r->lookupAtom("CZ3"), r->lookupAtom("HZ2"));
	(void) new TmplBond(r->lookupAtom("CZ3"), r->lookupAtom("CE3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NTYR(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NTYR", MolResId(seqno));
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB3", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433685;
	p->xyz[1] = 1.319266;
	p->xyz[2] = -2.131223;
	p = (new TmplAtom(m, r, "HB2", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG", 6, "CA"))->getCoord();
	p->xyz[0] = 6.291384;
	p->xyz[1] = 0.832225;
	p->xyz[2] = -1.195025;
	p = (new TmplAtom(m, r, "CD1", 6, "CA"))->getCoord();
	p->xyz[0] = 7.025587;
	p->xyz[1] = 0.236323;
	p->xyz[2] = -2.227424;
	p = (new TmplAtom(m, r, "HD1", 1, "HC"))->getCoord();
	p->xyz[0] = 6.507659;
	p->xyz[1] = -0.243126;
	p->xyz[2] = -3.058073;
	p = (new TmplAtom(m, r, "CE1", 6, "CA"))->getCoord();
	p->xyz[0] = 8.425021;
	p->xyz[1] = 0.256226;
	p->xyz[2] = -2.192934;
	p = (new TmplAtom(m, r, "HE1", 1, "HC"))->getCoord();
	p->xyz[0] = 8.996651;
	p->xyz[1] = -0.207725;
	p->xyz[2] = -2.996730;
	p = (new TmplAtom(m, r, "CZ", 6, "C"))->getCoord();
	p->xyz[0] = 9.090253;
	p->xyz[1] = 0.872031;
	p->xyz[2] = -1.126046;
	p = (new TmplAtom(m, r, "OH", 8, "OH"))->getCoord();
	p->xyz[0] = 10.449703;
	p->xyz[1] = 0.891367;
	p->xyz[2] = -1.092542;
	p = (new TmplAtom(m, r, "HOH", 1, "HO"))->getCoord();
	p->xyz[0] = 10.849789;
	p->xyz[1] = 0.455123;
	p->xyz[2] = -1.848335;
	p = (new TmplAtom(m, r, "CE2", 6, "CA"))->getCoord();
	p->xyz[0] = 8.356053;
	p->xyz[1] = 1.467934;
	p->xyz[2] = -0.093646;
	p = (new TmplAtom(m, r, "HE2", 1, "HC"))->getCoord();
	p->xyz[0] = 8.873984;
	p->xyz[1] = 1.947383;
	p->xyz[2] = 0.737002;
	p = (new TmplAtom(m, r, "CD2", 6, "CA"))->getCoord();
	p->xyz[0] = 6.956619;
	p->xyz[1] = 1.448033;
	p->xyz[2] = -0.128132;
	p = (new TmplAtom(m, r, "HD2", 1, "HC"))->getCoord();
	p->xyz[0] = 6.384992;
	p->xyz[1] = 1.911987;
	p->xyz[2] = 0.675664;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB3"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB2"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD1"));
	(void) new TmplBond(r->lookupAtom("CG"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("HD1"));
	(void) new TmplBond(r->lookupAtom("CD1"), r->lookupAtom("CE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("HE1"));
	(void) new TmplBond(r->lookupAtom("CE1"), r->lookupAtom("CZ"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("OH"));
	(void) new TmplBond(r->lookupAtom("CZ"), r->lookupAtom("CE2"));
	(void) new TmplBond(r->lookupAtom("OH"), r->lookupAtom("HOH"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("HE2"));
	(void) new TmplBond(r->lookupAtom("CE2"), r->lookupAtom("CD2"));
	(void) new TmplBond(r->lookupAtom("CD2"), r->lookupAtom("HD2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

static void
init_NVAL(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "NVAL", MolResId(seqno));
	p = (new TmplAtom(m, r, "HN1", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279001;
	p->xyz[1] = 0.647314;
	p->xyz[2] = -1.117489E-06;
	p = (new TmplAtom(m, r, "HN2", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279000;
	p->xyz[1] = 1.084657;
	p->xyz[2] = -0.757502;
	p = (new TmplAtom(m, r, "HN3", 1, "H3"))->getCoord();
	p->xyz[0] = 2.279002;
	p->xyz[1] = 1.084657;
	p->xyz[2] = 0.757499;
	p = (new TmplAtom(m, r, "CA", 6, "CT"))->getCoord();
	p->xyz[0] = 4.233001;
	p->xyz[1] = 1.521998;
	p->xyz[2] = -3.748502E-06;
	p = (new TmplAtom(m, r, "HA", 1, "HC"))->getCoord();
	p->xyz[0] = 4.596852;
	p->xyz[1] = 1.008158;
	p->xyz[2] = 0.889761;
	p = (new TmplAtom(m, r, "CB", 6, "CT"))->getCoord();
	p->xyz[0] = 4.781995;
	p->xyz[1] = 0.810757;
	p->xyz[2] = -1.232224;
	p = (new TmplAtom(m, r, "HB", 1, "HC"))->getCoord();
	p->xyz[0] = 4.433682;
	p->xyz[1] = -0.222050;
	p->xyz[2] = -1.241572;
	p = (new TmplAtom(m, r, "CG1", 6, "CT"))->getCoord();
	p->xyz[0] = 4.294285;
	p->xyz[1] = 1.522731;
	p->xyz[2] = -2.489546;
	p = (new TmplAtom(m, r, "HG11", 1, "HC"))->getCoord();
	p->xyz[0] = 4.642620;
	p->xyz[1] = 2.555538;
	p->xyz[2] = -2.481136;
	p = (new TmplAtom(m, r, "HG12", 1, "HC"))->getCoord();
	p->xyz[0] = 4.686413;
	p->xyz[1] = 1.014744;
	p->xyz[2] = -3.370617;
	p = (new TmplAtom(m, r, "HG13", 1, "HC"))->getCoord();
	p->xyz[0] = 3.204733;
	p->xyz[1] = 1.507520;
	p->xyz[2] = -2.516839;
	p = (new TmplAtom(m, r, "CG2", 6, "CT"))->getCoord();
	p->xyz[0] = 6.306378;
	p->xyz[1] = 0.832439;
	p->xyz[2] = -1.194656;
	p = (new TmplAtom(m, r, "HG21", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655467;
	p->xyz[1] = 0.323669;
	p->xyz[2] = -0.296107;
	p = (new TmplAtom(m, r, "HG22", 1, "HC"))->getCoord();
	p->xyz[0] = 6.699306;
	p->xyz[1] = 0.324180;
	p->xyz[2] = -2.075213;
	p = (new TmplAtom(m, r, "HG23", 1, "HC"))->getCoord();
	p->xyz[0] = 6.655470;
	p->xyz[1] = 1.864987;
	p->xyz[2] = -1.185756;
	p = (new TmplAtom(m, r, "C", 6, "C"))->getCoord();
	p->xyz[0] = 4.780919;
	p->xyz[1] = 2.941952;
	p->xyz[2] = 0.000154;
	p = (new TmplAtom(m, r, "O", 8, "O"))->getCoord();
	p->xyz[0] = 4.017532;
	p->xyz[1] = 3.905114;
	p->xyz[2] = 0.000263;
	p = (new TmplAtom(m, r, "N", 7, "N3"))->getCoord();
	p->xyz[0] = 2.784001;
	p->xyz[1] = 1.522000;
	p->xyz[2] = -1.797458E-06;
	r->link(r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("HA"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("CB"));
	(void) new TmplBond(r->lookupAtom("CA"), r->lookupAtom("C"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("HB"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG1"));
	(void) new TmplBond(r->lookupAtom("CB"), r->lookupAtom("CG2"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG11"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG12"));
	(void) new TmplBond(r->lookupAtom("CG1"), r->lookupAtom("HG13"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG21"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG22"));
	(void) new TmplBond(r->lookupAtom("CG2"), r->lookupAtom("HG23"));
	(void) new TmplBond(r->lookupAtom("C"), r->lookupAtom("O"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN1"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN2"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("HN3"));
	(void) new TmplBond(r->lookupAtom("N"), r->lookupAtom("CA"));
}

void
tmpl_init_namino(TmplMolecule *m, int *seqno)
{
	init_ACE(m, (*seqno)++);
	init_NALA(m, (*seqno)++);
	init_NARG(m, (*seqno)++);
	init_NASN(m, (*seqno)++);
	init_NASP(m, (*seqno)++);
	init_NCYS(m, (*seqno)++);
	init_NCYX(m, (*seqno)++);
	init_NGLN(m, (*seqno)++);
	init_NGLU(m, (*seqno)++);
	init_NGLY(m, (*seqno)++);
	init_NHID(m, (*seqno)++);
	init_NHIE(m, (*seqno)++);
	init_NHIP(m, (*seqno)++);
	init_NILE(m, (*seqno)++);
	init_NLEU(m, (*seqno)++);
	init_NLYS(m, (*seqno)++);
	init_NMET(m, (*seqno)++);
	init_NPHE(m, (*seqno)++);
	init_NPRO(m, (*seqno)++);
	init_NSER(m, (*seqno)++);
	init_NTHR(m, (*seqno)++);
	init_NTRP(m, (*seqno)++);
	init_NTYR(m, (*seqno)++);
	init_NVAL(m, (*seqno)++);
}
