#include "TmplMolecule.h"

static void
init_DADE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DADE", MolResId(seqno));
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -0.428684;
	p->xyz[1] = 2.418219;
	p->xyz[2] = -7.273946;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "C4", 6, "CB"))->getCoord();
	p->xyz[0] = -0.949510;
	p->xyz[1] = 2.234703;
	p->xyz[2] = -6.042052;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942963;
	p->xyz[1] = 0.128935;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.102653;
	p->xyz[1] = 2.968029;
	p->xyz[2] = -2.080357;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "H2'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "H2'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.741879;
	p->xyz[1] = 4.103005;
	p->xyz[2] = -4.368991;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N9", 7, "N*"))->getCoord();
	p->xyz[0] = -0.266629;
	p->xyz[1] = 2.222552;
	p->xyz[2] = -4.860740;
	p = (new TmplAtom(m, r, "C8", 6, "CK"))->getCoord();
	p->xyz[0] = -1.220065;
	p->xyz[1] = 2.003742;
	p->xyz[2] = -3.901583;
	p = (new TmplAtom(m, r, "H8", 1, "HC"))->getCoord();
	p->xyz[0] = -0.944106;
	p->xyz[1] = 1.997217;
	p->xyz[2] = -2.857455;
	p = (new TmplAtom(m, r, "N7", 7, "NB"))->getCoord();
	p->xyz[0] = -2.424720;
	p->xyz[1] = 1.879541;
	p->xyz[2] = -4.374214;
	p = (new TmplAtom(m, r, "C5", 6, "CB"))->getCoord();
	p->xyz[0] = -2.264056;
	p->xyz[1] = 2.025899;
	p->xyz[2] = -5.747118;
	p = (new TmplAtom(m, r, "C6", 6, "CA"))->getCoord();
	p->xyz[0] = -3.171710;
	p->xyz[1] = 1.996442;
	p->xyz[2] = -6.812622;
	p = (new TmplAtom(m, r, "N6", 7, "N2"))->getCoord();
	p->xyz[0] = -4.488136;
	p->xyz[1] = 1.800019;
	p->xyz[2] = -6.657569;
	p = (new TmplAtom(m, r, "H61", 1, "H2"))->getCoord();
	p->xyz[0] = -4.872965;
	p->xyz[1] = 1.663200;
	p->xyz[2] = -5.733833;
	p = (new TmplAtom(m, r, "H62", 1, "H2"))->getCoord();
	p->xyz[0] = -5.095539;
	p->xyz[1] = 1.788787;
	p->xyz[2] = -7.464436;
	p = (new TmplAtom(m, r, "N1", 7, "NC"))->getCoord();
	p->xyz[0] = -2.681103;
	p->xyz[1] = 2.175958;
	p->xyz[2] = -8.046590;
	p = (new TmplAtom(m, r, "C2", 6, "CQ"))->getCoord();
	p->xyz[0] = -1.373718;
	p->xyz[1] = 2.370461;
	p->xyz[2] = -8.194288;
	p = (new TmplAtom(m, r, "H2", 1, "HC"))->getCoord();
	p->xyz[0] = -0.957572;
	p->xyz[1] = 2.517224;
	p->xyz[2] = -9.180028;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'1"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'2"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N9"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C8"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("H8"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("N7"));
	(void) new TmplBond(r->lookupAtom("N7"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("N6"), r->lookupAtom("H61"));
	(void) new TmplBond(r->lookupAtom("N6"), r->lookupAtom("H62"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("H2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_DCYT(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DCYT", MolResId(seqno));
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.277333;
	p->xyz[1] = 2.955359;
	p->xyz[2] = -2.117808;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942962;
	p->xyz[1] = 0.128933;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "H2'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.457967;
	p->xyz[1] = 4.356004;
	p->xyz[2] = -3.104012;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "H2'2", 1, "HC"))->getCoord();
	p->xyz[0] = 0.803615;
	p->xyz[1] = 2.706933;
	p->xyz[2] = -3.243756;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N1", 7, "N*"))->getCoord();
	p->xyz[0] = -0.230372;
	p->xyz[1] = 2.189660;
	p->xyz[2] = -4.854812;
	p = (new TmplAtom(m, r, "C6", 6, "CM"))->getCoord();
	p->xyz[0] = -0.988446;
	p->xyz[1] = 1.979047;
	p->xyz[2] = -3.745504;
	p = (new TmplAtom(m, r, "H6", 1, "HC"))->getCoord();
	p->xyz[0] = -0.535471;
	p->xyz[1] = 2.020847;
	p->xyz[2] = -2.765980;
	p = (new TmplAtom(m, r, "C5", 6, "CM"))->getCoord();
	p->xyz[0] = -2.318623;
	p->xyz[1] = 1.714243;
	p->xyz[2] = -3.846043;
	p = (new TmplAtom(m, r, "H5", 1, "HC"))->getCoord();
	p->xyz[0] = -2.910771;
	p->xyz[1] = 1.548020;
	p->xyz[2] = -2.946136;
	p = (new TmplAtom(m, r, "C4", 6, "CA"))->getCoord();
	p->xyz[0] = -2.871580;
	p->xyz[1] = 1.669472;
	p->xyz[2] = -5.164047;
	p = (new TmplAtom(m, r, "N4", 7, "N2"))->getCoord();
	p->xyz[0] = -4.156008;
	p->xyz[1] = 1.417551;
	p->xyz[2] = -5.334867;
	p = (new TmplAtom(m, r, "H41", 1, "H2"))->getCoord();
	p->xyz[0] = -4.717569;
	p->xyz[1] = 1.261377;
	p->xyz[2] = -4.510027;
	p = (new TmplAtom(m, r, "H42", 1, "H2"))->getCoord();
	p->xyz[0] = -4.549255;
	p->xyz[1] = 1.385322;
	p->xyz[2] = -6.264608;
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -2.122764;
	p->xyz[1] = 1.876680;
	p->xyz[2] = -6.243509;
	p = (new TmplAtom(m, r, "C2", 6, "C"))->getCoord();
	p->xyz[0] = -0.794088;
	p->xyz[1] = 2.140091;
	p->xyz[2] = -6.121710;
	p = (new TmplAtom(m, r, "O2", 8, "O"))->getCoord();
	p->xyz[0] = -0.063346;
	p->xyz[1] = 2.338641;
	p->xyz[2] = -7.103644;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'1"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'2"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("H6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("H5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N4"), r->lookupAtom("H41"));
	(void) new TmplBond(r->lookupAtom("N4"), r->lookupAtom("H42"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("O2"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_DGUA(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DGUA", MolResId(seqno));
	p = (new TmplAtom(m, r, "H22", 1, "H2"))->getCoord();
	p->xyz[0] = -0.043799;
	p->xyz[1] = 2.463024;
	p->xyz[2] = -9.704881;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -0.430920;
	p->xyz[1] = 2.271844;
	p->xyz[2] = -7.261304;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942963;
	p->xyz[1] = 0.128935;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "C4", 6, "CB"))->getCoord();
	p->xyz[0] = -0.954748;
	p->xyz[1] = 2.102423;
	p->xyz[2] = -6.017720;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.277333;
	p->xyz[1] = 2.955359;
	p->xyz[2] = -2.117808;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "H2'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "H2'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.741879;
	p->xyz[1] = 4.103005;
	p->xyz[2] = -4.368991;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N9", 7, "N*"))->getCoord();
	p->xyz[0] = -0.230176;
	p->xyz[1] = 2.188644;
	p->xyz[2] = -4.854712;
	p = (new TmplAtom(m, r, "C8", 6, "CK"))->getCoord();
	p->xyz[0] = -1.148250;
	p->xyz[1] = 1.950416;
	p->xyz[2] = -3.852321;
	p = (new TmplAtom(m, r, "H8", 1, "HC"))->getCoord();
	p->xyz[0] = -0.834538;
	p->xyz[1] = 1.961469;
	p->xyz[2] = -2.818947;
	p = (new TmplAtom(m, r, "N7", 7, "NB"))->getCoord();
	p->xyz[0] = -2.363371;
	p->xyz[1] = 1.722974;
	p->xyz[2] = -4.285738;
	p = (new TmplAtom(m, r, "C5", 6, "CB"))->getCoord();
	p->xyz[0] = -2.247744;
	p->xyz[1] = 1.815668;
	p->xyz[2] = -5.667816;
	p = (new TmplAtom(m, r, "C6", 6, "C"))->getCoord();
	p->xyz[0] = -3.226770;
	p->xyz[1] = 1.665783;
	p->xyz[2] = -6.685383;
	p = (new TmplAtom(m, r, "O6", 8, "O"))->getCoord();
	p->xyz[0] = -4.425330;
	p->xyz[1] = 1.414377;
	p->xyz[2] = -6.570721;
	p = (new TmplAtom(m, r, "N1", 7, "NA"))->getCoord();
	p->xyz[0] = -2.671296;
	p->xyz[1] = 1.843180;
	p->xyz[2] = -7.958167;
	p = (new TmplAtom(m, r, "H1", 1, "H"))->getCoord();
	p->xyz[0] = -3.284176;
	p->xyz[1] = 1.755168;
	p->xyz[2] = -8.743426;
	p = (new TmplAtom(m, r, "C2", 6, "CA"))->getCoord();
	p->xyz[0] = -1.346169;
	p->xyz[1] = 2.129674;
	p->xyz[2] = -8.215771;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "N2", 7, "N2"))->getCoord();
	p->xyz[0] = -1.013612;
	p->xyz[1] = 2.261921;
	p->xyz[2] = -9.507094;
	p = (new TmplAtom(m, r, "H21", 1, "H2"))->getCoord();
	p->xyz[0] = -1.624538;
	p->xyz[1] = 2.163148;
	p->xyz[2] = -10.305289;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'1"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'2"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N9"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C8"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("H8"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("N7"));
	(void) new TmplBond(r->lookupAtom("N7"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("O6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("H1"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N2"), r->lookupAtom("H21"));
	(void) new TmplBond(r->lookupAtom("N2"), r->lookupAtom("H22"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_DOHE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DOHE", MolResId(seqno));
	p = (new TmplAtom(m, r, "H", 1, "HO"))->getCoord();
	p->xyz[0] = 1.857301;
	p->xyz[1] = 0.771722;
	p->xyz[2] = -2.045449;
	p = (new TmplAtom(m, r, "O", 8, "OH"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O"));
	r->link(r->lookupAtom("H"));
	(void) new TmplBond(r->lookupAtom("O"), r->lookupAtom("H"));
}

static void
init_DPOM(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DPOM", MolResId(seqno));
	p = (new TmplAtom(m, r, "OA", 8, "O2"))->getCoord();
	p->xyz[0] = 2.478156;
	p->xyz[1] = 3.017579;
	p->xyz[2] = -0.290368;
	p = (new TmplAtom(m, r, "OB", 8, "O2"))->getCoord();
	p->xyz[0] = 3.462952;
	p->xyz[1] = 0.852149;
	p->xyz[2] = 0.499558;
	p = (new TmplAtom(m, r, "P", 15, "P"))->getCoord();
	p->xyz[0] = 2.307246;
	p->xyz[1] = 1.776673;
	p->xyz[2] = 0.497884;
	r->chief(r->lookupAtom("P"));
	r->link(r->lookupAtom("P"));
	(void) new TmplBond(r->lookupAtom("P"), r->lookupAtom("OA"));
	(void) new TmplBond(r->lookupAtom("P"), r->lookupAtom("OB"));
}

static void
init_DTHY(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "DTHY", MolResId(seqno));
	p = (new TmplAtom(m, r, "C2", 6, "C"))->getCoord();
	p->xyz[0] = -0.768245;
	p->xyz[1] = 2.257235;
	p->xyz[2] = -6.139854;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "O2", 8, "O"))->getCoord();
	p->xyz[0] = -0.062608;
	p->xyz[1] = 2.434266;
	p->xyz[2] = -7.119209;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.484407;
	p->xyz[1] = 1.032943;
	p->xyz[2] = -3.188383;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.675387;
	p->xyz[1] = -0.431373;
	p->xyz[2] = -2.581420;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.102653;
	p->xyz[1] = 2.968029;
	p->xyz[2] = -2.080357;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "H2'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "H2'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.741879;
	p->xyz[1] = 4.103005;
	p->xyz[2] = -4.368991;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N1", 7, "N*"))->getCoord();
	p->xyz[0] = -0.276456;
	p->xyz[1] = 2.220858;
	p->xyz[2] = -4.861487;
	p = (new TmplAtom(m, r, "C6", 6, "CM"))->getCoord();
	p->xyz[0] = -1.084734;
	p->xyz[1] = 2.020839;
	p->xyz[2] = -3.773562;
	p = (new TmplAtom(m, r, "H6", 1, "HC"))->getCoord();
	p->xyz[0] = -0.665767;
	p->xyz[1] = 2.042115;
	p->xyz[2] = -2.778367;
	p = (new TmplAtom(m, r, "C5", 6, "CM"))->getCoord();
	p->xyz[0] = -2.406530;
	p->xyz[1] = 1.849994;
	p->xyz[2] = -3.912365;
	p = (new TmplAtom(m, r, "C7", 6, "CT"))->getCoord();
	p->xyz[0] = -3.300025;
	p->xyz[1] = 1.630351;
	p->xyz[2] = -2.727704;
	p = (new TmplAtom(m, r, "H71", 1, "HC"))->getCoord();
	p->xyz[0] = -3.231152;
	p->xyz[1] = 2.486302;
	p->xyz[2] = -2.056358;
	p = (new TmplAtom(m, r, "H72", 1, "HC"))->getCoord();
	p->xyz[0] = -4.330135;
	p->xyz[1] = 1.515885;
	p->xyz[2] = -3.065154;
	p = (new TmplAtom(m, r, "H73", 1, "HC"))->getCoord();
	p->xyz[0] = -2.988986;
	p->xyz[1] = 0.729032;
	p->xyz[2] = -2.199519;
	p = (new TmplAtom(m, r, "C4", 6, "C"))->getCoord();
	p->xyz[0] = -3.019580;
	p->xyz[1] = 1.871651;
	p->xyz[2] = -5.215170;
	p = (new TmplAtom(m, r, "O4", 8, "O"))->getCoord();
	p->xyz[0] = -4.219995;
	p->xyz[1] = 1.724489;
	p->xyz[2] = -5.439330;
	p = (new TmplAtom(m, r, "N3", 7, "NA"))->getCoord();
	p->xyz[0] = -2.132046;
	p->xyz[1] = 2.078388;
	p->xyz[2] = -6.251482;
	p = (new TmplAtom(m, r, "H3", 1, "H"))->getCoord();
	p->xyz[0] = -2.549644;
	p->xyz[1] = 2.102844;
	p->xyz[2] = -7.258018;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("O2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'1"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'2"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("H6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C7"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C7"), r->lookupAtom("H71"));
	(void) new TmplBond(r->lookupAtom("C7"), r->lookupAtom("H72"));
	(void) new TmplBond(r->lookupAtom("C7"), r->lookupAtom("H73"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("O4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("H3"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_HB(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "HB", MolResId(seqno));
	p = (new TmplAtom(m, r, "H", 1, "HO"))->getCoord();
	p->xyz[0] = 1.866026;
	p->xyz[1] = 1.500000;
	p->xyz[2] = -1.166025E-06;
	r->link(r->lookupAtom("H"));
}

static void
init_HE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "HE", MolResId(seqno));
	p = (new TmplAtom(m, r, "H", 1, "HO"))->getCoord();
	p->xyz[0] = 1.094801;
	p->xyz[1] = 0.771723;
	p->xyz[2] = -2.215816;
	p = (new TmplAtom(m, r, "O", 8, "OH"))->getCoord();
	p->xyz[0] = 0.690022;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.537328;
	r->chief(r->lookupAtom("O"));
	r->link(r->lookupAtom("H"));
	(void) new TmplBond(r->lookupAtom("O"), r->lookupAtom("H"));
	(void) new TmplBond(r->lookupAtom("O"), r->lookupAtom("H"));
}

static void
init_RADE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "RADE", MolResId(seqno));
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -0.428684;
	p->xyz[1] = 2.418219;
	p->xyz[2] = -7.273946;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "C4", 6, "CB"))->getCoord();
	p->xyz[0] = -0.949510;
	p->xyz[1] = 2.234703;
	p->xyz[2] = -6.042052;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942963;
	p->xyz[1] = 0.128935;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 2.001836;
	p->xyz[1] = 3.312551;
	p->xyz[2] = -3.306361;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "H2'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "O2'", 8, "OH"))->getCoord();
	p->xyz[0] = 1.786594;
	p->xyz[1] = 4.328792;
	p->xyz[2] = -4.619233;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "HO2'", 1, "HO"))->getCoord();
	p->xyz[0] = 0.918044;
	p->xyz[1] = 4.664208;
	p->xyz[2] = -4.853147;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N9", 7, "N*"))->getCoord();
	p->xyz[0] = -0.266629;
	p->xyz[1] = 2.222552;
	p->xyz[2] = -4.860740;
	p = (new TmplAtom(m, r, "C8", 6, "CK"))->getCoord();
	p->xyz[0] = -1.220065;
	p->xyz[1] = 2.003742;
	p->xyz[2] = -3.901583;
	p = (new TmplAtom(m, r, "H8", 1, "HC"))->getCoord();
	p->xyz[0] = -0.944106;
	p->xyz[1] = 1.997217;
	p->xyz[2] = -2.857455;
	p = (new TmplAtom(m, r, "N7", 7, "NB"))->getCoord();
	p->xyz[0] = -2.424720;
	p->xyz[1] = 1.879541;
	p->xyz[2] = -4.374214;
	p = (new TmplAtom(m, r, "C5", 6, "CB"))->getCoord();
	p->xyz[0] = -2.264056;
	p->xyz[1] = 2.025899;
	p->xyz[2] = -5.747118;
	p = (new TmplAtom(m, r, "C6", 6, "CA"))->getCoord();
	p->xyz[0] = -3.171710;
	p->xyz[1] = 1.996442;
	p->xyz[2] = -6.812622;
	p = (new TmplAtom(m, r, "N6", 7, "N2"))->getCoord();
	p->xyz[0] = -4.488136;
	p->xyz[1] = 1.800019;
	p->xyz[2] = -6.657569;
	p = (new TmplAtom(m, r, "H61", 1, "H2"))->getCoord();
	p->xyz[0] = -4.872965;
	p->xyz[1] = 1.663200;
	p->xyz[2] = -5.733833;
	p = (new TmplAtom(m, r, "H62", 1, "H2"))->getCoord();
	p->xyz[0] = -5.095539;
	p->xyz[1] = 1.788787;
	p->xyz[2] = -7.464436;
	p = (new TmplAtom(m, r, "N1", 7, "NC"))->getCoord();
	p->xyz[0] = -2.681103;
	p->xyz[1] = 2.175958;
	p->xyz[2] = -8.046590;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "C2", 6, "CQ"))->getCoord();
	p->xyz[0] = -1.373718;
	p->xyz[1] = 2.370461;
	p->xyz[2] = -8.194288;
	p = (new TmplAtom(m, r, "H2", 1, "HC"))->getCoord();
	p->xyz[0] = -0.957572;
	p->xyz[1] = 2.517224;
	p->xyz[2] = -9.180028;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("O2'"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("O2'"), r->lookupAtom("HO2'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N9"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C8"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("H8"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("N7"));
	(void) new TmplBond(r->lookupAtom("N7"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("N6"), r->lookupAtom("H61"));
	(void) new TmplBond(r->lookupAtom("N6"), r->lookupAtom("H62"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("H2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_RCYT(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "RCYT", MolResId(seqno));
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.277333;
	p->xyz[1] = 2.955359;
	p->xyz[2] = -2.117808;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942962;
	p->xyz[1] = 0.128933;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "H2'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "O2'", 8, "OH"))->getCoord();
	p->xyz[0] = 1.786594;
	p->xyz[1] = 4.328792;
	p->xyz[2] = -4.619233;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "HO2'", 1, "HO"))->getCoord();
	p->xyz[0] = 0.918044;
	p->xyz[1] = 4.664208;
	p->xyz[2] = -4.853147;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N1", 7, "N*"))->getCoord();
	p->xyz[0] = -0.230372;
	p->xyz[1] = 2.189660;
	p->xyz[2] = -4.854812;
	p = (new TmplAtom(m, r, "C6", 6, "CM"))->getCoord();
	p->xyz[0] = -0.988446;
	p->xyz[1] = 1.979047;
	p->xyz[2] = -3.745504;
	p = (new TmplAtom(m, r, "H6", 1, "HC"))->getCoord();
	p->xyz[0] = -0.535471;
	p->xyz[1] = 2.020847;
	p->xyz[2] = -2.765980;
	p = (new TmplAtom(m, r, "C5", 6, "CM"))->getCoord();
	p->xyz[0] = -2.318623;
	p->xyz[1] = 1.714243;
	p->xyz[2] = -3.846043;
	p = (new TmplAtom(m, r, "H5", 1, "HC"))->getCoord();
	p->xyz[0] = -2.910771;
	p->xyz[1] = 1.548020;
	p->xyz[2] = -2.946136;
	p = (new TmplAtom(m, r, "C4", 6, "CA"))->getCoord();
	p->xyz[0] = -2.871580;
	p->xyz[1] = 1.669472;
	p->xyz[2] = -5.164047;
	p = (new TmplAtom(m, r, "N4", 7, "N2"))->getCoord();
	p->xyz[0] = -4.156008;
	p->xyz[1] = 1.417551;
	p->xyz[2] = -5.334867;
	p = (new TmplAtom(m, r, "H41", 1, "H2"))->getCoord();
	p->xyz[0] = -4.717569;
	p->xyz[1] = 1.261377;
	p->xyz[2] = -4.510027;
	p = (new TmplAtom(m, r, "H42", 1, "H2"))->getCoord();
	p->xyz[0] = -4.549255;
	p->xyz[1] = 1.385322;
	p->xyz[2] = -6.264608;
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -2.122764;
	p->xyz[1] = 1.876680;
	p->xyz[2] = -6.243509;
	p = (new TmplAtom(m, r, "C2", 6, "C"))->getCoord();
	p->xyz[0] = -0.794088;
	p->xyz[1] = 2.140091;
	p->xyz[2] = -6.121710;
	p = (new TmplAtom(m, r, "O2", 8, "O"))->getCoord();
	p->xyz[0] = -0.063346;
	p->xyz[1] = 2.338641;
	p->xyz[2] = -7.103644;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("O2'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("O2'"), r->lookupAtom("HO2'"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("H6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("H5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N4"), r->lookupAtom("H41"));
	(void) new TmplBond(r->lookupAtom("N4"), r->lookupAtom("H42"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("O2"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_RGUA(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "RGUA", MolResId(seqno));
	p = (new TmplAtom(m, r, "H22", 1, "H2"))->getCoord();
	p->xyz[0] = -0.043799;
	p->xyz[1] = 2.463024;
	p->xyz[2] = -9.704881;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "N3", 7, "NC"))->getCoord();
	p->xyz[0] = -0.430920;
	p->xyz[1] = 2.271844;
	p->xyz[2] = -7.261304;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.942963;
	p->xyz[1] = 0.128935;
	p->xyz[2] = -1.625974;
	p = (new TmplAtom(m, r, "C4", 6, "CB"))->getCoord();
	p->xyz[0] = -0.954748;
	p->xyz[1] = 2.102423;
	p->xyz[2] = -6.017720;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.631289;
	p->xyz[1] = -0.344437;
	p->xyz[2] = -2.731673;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.277333;
	p->xyz[1] = 2.955359;
	p->xyz[2] = -2.117808;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "H2'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "O2'", 8, "OH"))->getCoord();
	p->xyz[0] = 1.786594;
	p->xyz[1] = 4.328792;
	p->xyz[2] = -4.619233;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N9", 7, "N*"))->getCoord();
	p->xyz[0] = -0.230176;
	p->xyz[1] = 2.188644;
	p->xyz[2] = -4.854712;
	p = (new TmplAtom(m, r, "C8", 6, "CK"))->getCoord();
	p->xyz[0] = -1.148250;
	p->xyz[1] = 1.950416;
	p->xyz[2] = -3.852321;
	p = (new TmplAtom(m, r, "H8", 1, "HC"))->getCoord();
	p->xyz[0] = -0.834538;
	p->xyz[1] = 1.961469;
	p->xyz[2] = -2.818947;
	p = (new TmplAtom(m, r, "N7", 7, "NB"))->getCoord();
	p->xyz[0] = -2.363371;
	p->xyz[1] = 1.722974;
	p->xyz[2] = -4.285738;
	p = (new TmplAtom(m, r, "C5", 6, "CB"))->getCoord();
	p->xyz[0] = -2.247744;
	p->xyz[1] = 1.815668;
	p->xyz[2] = -5.667816;
	p = (new TmplAtom(m, r, "C6", 6, "C"))->getCoord();
	p->xyz[0] = -3.226770;
	p->xyz[1] = 1.665783;
	p->xyz[2] = -6.685383;
	p = (new TmplAtom(m, r, "O6", 8, "O"))->getCoord();
	p->xyz[0] = -4.425330;
	p->xyz[1] = 1.414377;
	p->xyz[2] = -6.570721;
	p = (new TmplAtom(m, r, "N1", 7, "NA"))->getCoord();
	p->xyz[0] = -2.671296;
	p->xyz[1] = 1.843180;
	p->xyz[2] = -7.958167;
	p = (new TmplAtom(m, r, "H1", 1, "H"))->getCoord();
	p->xyz[0] = -3.284176;
	p->xyz[1] = 1.755168;
	p->xyz[2] = -8.743426;
	p = (new TmplAtom(m, r, "C2", 6, "CA"))->getCoord();
	p->xyz[0] = -1.346169;
	p->xyz[1] = 2.129674;
	p->xyz[2] = -8.215771;
	p = (new TmplAtom(m, r, "HO2'", 1, "HO"))->getCoord();
	p->xyz[0] = 0.918044;
	p->xyz[1] = 4.664208;
	p->xyz[2] = -4.853147;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "N2", 7, "N2"))->getCoord();
	p->xyz[0] = -1.013612;
	p->xyz[1] = 2.261921;
	p->xyz[2] = -9.507094;
	p = (new TmplAtom(m, r, "H21", 1, "H2"))->getCoord();
	p->xyz[0] = -1.624538;
	p->xyz[1] = 2.163148;
	p->xyz[2] = -10.305289;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("O2'"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N9"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("O2'"), r->lookupAtom("HO2'"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C8"));
	(void) new TmplBond(r->lookupAtom("N9"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("H8"));
	(void) new TmplBond(r->lookupAtom("C8"), r->lookupAtom("N7"));
	(void) new TmplBond(r->lookupAtom("N7"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("O6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("H1"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N2"), r->lookupAtom("H21"));
	(void) new TmplBond(r->lookupAtom("N2"), r->lookupAtom("H22"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

static void
init_ROHE(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "ROHE", MolResId(seqno));
	p = (new TmplAtom(m, r, "H", 1, "HO"))->getCoord();
	p->xyz[0] = 1.094801;
	p->xyz[1] = 0.771723;
	p->xyz[2] = -2.215816;
	p = (new TmplAtom(m, r, "O", 8, "OH"))->getCoord();
	p->xyz[0] = 0.690022;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.537328;
	r->chief(r->lookupAtom("O"));
	r->link(r->lookupAtom("H"));
	(void) new TmplBond(r->lookupAtom("O"), r->lookupAtom("H"));
}

static void
init_RPOM(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "RPOM", MolResId(seqno));
	p = (new TmplAtom(m, r, "OA", 8, "O2"))->getCoord();
	p->xyz[0] = 2.182245;
	p->xyz[1] = 3.195608;
	p->xyz[2] = 0.345177;
	p = (new TmplAtom(m, r, "OB", 8, "O2"))->getCoord();
	p->xyz[0] = 3.388516;
	p->xyz[1] = 0.936284;
	p->xyz[2] = 0.796198;
	p = (new TmplAtom(m, r, "P", 15, "P"))->getCoord();
	p->xyz[0] = 2.170641;
	p->xyz[1] = 1.776673;
	p->xyz[2] = 0.765756;
	r->chief(r->lookupAtom("P"));
	r->link(r->lookupAtom("P"));
	(void) new TmplBond(r->lookupAtom("P"), r->lookupAtom("OA"));
	(void) new TmplBond(r->lookupAtom("P"), r->lookupAtom("OB"));
}

static void
init_RURA(TmplMolecule *m, int seqno)
{
	TmplCoord	*p;

	TmplResidue *r = new TmplResidue(m, "RURA", MolResId(seqno));
	p = (new TmplAtom(m, r, "H3'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.102653;
	p->xyz[1] = 2.968029;
	p->xyz[2] = -2.080357;
	p = (new TmplAtom(m, r, "C5'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.164773;
	p->xyz[1] = 0.499046;
	p->xyz[2] = -2.293460;
	p = (new TmplAtom(m, r, "C2'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.598528;
	p->xyz[1] = 3.379161;
	p->xyz[2] = -3.566744;
	p = (new TmplAtom(m, r, "H5'1", 1, "HC"))->getCoord();
	p->xyz[0] = 2.484407;
	p->xyz[1] = 1.032943;
	p->xyz[2] = -3.188383;
	p = (new TmplAtom(m, r, "H2'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.132112;
	p->xyz[1] = 3.871154;
	p->xyz[2] = -2.713223;
	p = (new TmplAtom(m, r, "H5'2", 1, "HC"))->getCoord();
	p->xyz[0] = 1.675387;
	p->xyz[1] = -0.431373;
	p->xyz[2] = -2.581420;
	p = (new TmplAtom(m, r, "O2'", 8, "OH"))->getCoord();
	p->xyz[0] = 1.786594;
	p->xyz[1] = 4.328792;
	p->xyz[2] = -4.619233;
	p = (new TmplAtom(m, r, "C4'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.787184;
	p->xyz[1] = 1.309314;
	p->xyz[2] = -3.418835;
	p = (new TmplAtom(m, r, "HO2'", 1, "HO"))->getCoord();
	p->xyz[0] = 0.918044;
	p->xyz[1] = 4.664208;
	p->xyz[2] = -4.853147;
	p = (new TmplAtom(m, r, "H4'", 1, "HC"))->getCoord();
	p->xyz[0] = 3.710736;
	p->xyz[1] = 0.830493;
	p->xyz[2] = -3.744234;
	p = (new TmplAtom(m, r, "O3'", 8, "OS"))->getCoord();
	p->xyz[0] = 3.951586;
	p->xyz[1] = 3.479350;
	p->xyz[2] = -3.901110;
	p = (new TmplAtom(m, r, "O1'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.911853;
	p->xyz[1] = 1.246482;
	p->xyz[2] = -4.585646;
	p = (new TmplAtom(m, r, "C1'", 6, "CT"))->getCoord();
	p->xyz[0] = 1.227115;
	p->xyz[1] = 2.479940;
	p->xyz[2] = -4.747253;
	p = (new TmplAtom(m, r, "H1'", 1, "HC"))->getCoord();
	p->xyz[0] = 1.476331;
	p->xyz[1] = 2.910072;
	p->xyz[2] = -5.717293;
	p = (new TmplAtom(m, r, "N1", 7, "N*"))->getCoord();
	p->xyz[0] = -0.276456;
	p->xyz[1] = 2.220858;
	p->xyz[2] = -4.861487;
	p = (new TmplAtom(m, r, "C6", 6, "CM"))->getCoord();
	p->xyz[0] = -1.084734;
	p->xyz[1] = 2.020839;
	p->xyz[2] = -3.773562;
	p = (new TmplAtom(m, r, "H6", 1, "HC"))->getCoord();
	p->xyz[0] = -0.665767;
	p->xyz[1] = 2.042115;
	p->xyz[2] = -2.778367;
	p = (new TmplAtom(m, r, "C5", 6, "CM"))->getCoord();
	p->xyz[0] = -2.406530;
	p->xyz[1] = 1.849994;
	p->xyz[2] = -3.912365;
	p = (new TmplAtom(m, r, "H5", 1, "HC"))->getCoord();
	p->xyz[0] = -3.030996;
	p->xyz[1] = 1.692298;
	p->xyz[2] = -3.033005;
	p = (new TmplAtom(m, r, "C4", 6, "C"))->getCoord();
	p->xyz[0] = -3.019580;
	p->xyz[1] = 1.871651;
	p->xyz[2] = -5.215170;
	p = (new TmplAtom(m, r, "O4", 8, "O"))->getCoord();
	p->xyz[0] = -4.219995;
	p->xyz[1] = 1.724489;
	p->xyz[2] = -5.439330;
	p = (new TmplAtom(m, r, "N3", 7, "NA"))->getCoord();
	p->xyz[0] = -2.132046;
	p->xyz[1] = 2.078388;
	p->xyz[2] = -6.251482;
	p = (new TmplAtom(m, r, "H3", 1, "H"))->getCoord();
	p->xyz[0] = -2.549644;
	p->xyz[1] = 2.102844;
	p->xyz[2] = -7.258018;
	p = (new TmplAtom(m, r, "C2", 6, "C"))->getCoord();
	p->xyz[0] = -0.768245;
	p->xyz[1] = 2.257235;
	p->xyz[2] = -6.139854;
	p = (new TmplAtom(m, r, "O2", 8, "O"))->getCoord();
	p->xyz[0] = -0.062608;
	p->xyz[1] = 2.434266;
	p->xyz[2] = -7.119209;
	p = (new TmplAtom(m, r, "C3'", 6, "CT"))->getCoord();
	p->xyz[0] = 2.953825;
	p->xyz[1] = 2.805886;
	p->xyz[2] = -3.147905;
	p = (new TmplAtom(m, r, "O5'", 8, "OS"))->getCoord();
	p->xyz[0] = 1.242359;
	p->xyz[1] = 1.317074;
	p->xyz[2] = -1.549428;
	r->chief(r->lookupAtom("O5'"));
	r->link(r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'1"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("H5'2"));
	(void) new TmplBond(r->lookupAtom("C5'"), r->lookupAtom("C4'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("H2'"));
	(void) new TmplBond(r->lookupAtom("C2'"), r->lookupAtom("O2'"));
	(void) new TmplBond(r->lookupAtom("O2'"), r->lookupAtom("HO2'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("H4'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("O1'"));
	(void) new TmplBond(r->lookupAtom("C4'"), r->lookupAtom("C3'"));
	(void) new TmplBond(r->lookupAtom("O1'"), r->lookupAtom("C1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("H1'"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("N1"));
	(void) new TmplBond(r->lookupAtom("C1'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C6"));
	(void) new TmplBond(r->lookupAtom("N1"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("H6"));
	(void) new TmplBond(r->lookupAtom("C6"), r->lookupAtom("C5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("H5"));
	(void) new TmplBond(r->lookupAtom("C5"), r->lookupAtom("C4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("O4"));
	(void) new TmplBond(r->lookupAtom("C4"), r->lookupAtom("N3"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("H3"));
	(void) new TmplBond(r->lookupAtom("N3"), r->lookupAtom("C2"));
	(void) new TmplBond(r->lookupAtom("C2"), r->lookupAtom("O2"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("H3'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("C2'"));
	(void) new TmplBond(r->lookupAtom("C3'"), r->lookupAtom("O3'"));
	(void) new TmplBond(r->lookupAtom("O5'"), r->lookupAtom("C5'"));
}

void
tmpl_init_nucleic(TmplMolecule *m, int *seqno)
{
	init_DADE(m, (*seqno)++);
	init_DCYT(m, (*seqno)++);
	init_DGUA(m, (*seqno)++);
	init_DOHE(m, (*seqno)++);
	init_DPOM(m, (*seqno)++);
	init_DTHY(m, (*seqno)++);
	init_HB(m, (*seqno)++);
	init_HE(m, (*seqno)++);
	init_RADE(m, (*seqno)++);
	init_RCYT(m, (*seqno)++);
	init_RGUA(m, (*seqno)++);
	init_ROHE(m, (*seqno)++);
	init_RPOM(m, (*seqno)++);
	init_RURA(m, (*seqno)++);
}
