      subroutine ang110(x,y,z,weight)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xunit(110),yunit(110),zunit(110)

      dimension x(*),y(*),z(*),weight(*)

      data xunit/1.0d0,-1.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0/

      data yunit/0.0d0, 0.0d0, 1.0d0,-1.0d0, 0.0d0, 0.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0/

      data zunit/0.0d0, 0.0d0, 0.0d0, 0.0d0, 1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0/

      data wght1,wght2,wght3,wght4,wght5,wght6/0.00382827049494d0,
     &                                         0.00979373751249d0,
     &                                         0.00821173728319d0,
     &                                         0.00959547133607d0,
     &                                         0.00994281489118d0,
     &                                         0.00969499636166d0/

      data vrtex1,vrtex2,vrtex3,
     &     vrtex4,vrtex5,vrtex6,
     &     vrtex7,vrtex8,vrtex9/0.185115635345d0,0.965124035087d0,
     &                          0.395689473056d0,0.828769981253d0,
     &                          0.690421048382d0,0.215957291846d0,
     &                          0.878158910604d0,0.478369028812d0,
     &                          0.000000000000d0/

      data one,three/1.0d0,3.0d0/

      rsqrt3=one/sqrt(three)

      do 1001 i=1,6
 1001 weight(i)=wght1

      do 1002 i=7,14
 1002 weight(i)=wght2

      do 1003 i=15,38
 1003 weight(i)=wght3

      do 1004 i=39,62
 1004 weight(i)=wght4

      do 1005 i=63,86
 1005 weight(i)=wght5

      do 1006 i=87,110
 1006 weight(i)=wght6

      do 1007 i=1,6
      x(i)=xunit(i)
      y(i)=yunit(i)
 1007 z(i)=zunit(i)

      do 1008 i=7,14
      x(i)=rsqrt3*xunit(i)
      y(i)=rsqrt3*yunit(i)
 1008 z(i)=rsqrt3*zunit(i)

      do 1009 i=15,22
      x(i)=vrtex1*xunit(i)
      y(i)=vrtex1*yunit(i)
 1009 z(i)=vrtex2*zunit(i)

      do 1010 i=23,30
      x(i)=vrtex1*xunit(i)
      y(i)=vrtex2*yunit(i)
 1010 z(i)=vrtex1*zunit(i)

      do 1011 i=31,38
      x(i)=vrtex2*xunit(i)
      y(i)=vrtex1*yunit(i)
 1011 z(i)=vrtex1*zunit(i)

      do 1012 i=39,46
      x(i)=vrtex3*xunit(i)
      y(i)=vrtex3*yunit(i)
 1012 z(i)=vrtex4*zunit(i)

      do 1013 i=47,54
      x(i)=vrtex3*xunit(i)
      y(i)=vrtex4*yunit(i)
 1013 z(i)=vrtex3*zunit(i)

      do 1014 i=55,62
      x(i)=vrtex4*xunit(i)
      y(i)=vrtex3*yunit(i)
 1014 z(i)=vrtex3*zunit(i)

      do 1015 i=63,70
      x(i)=vrtex5*xunit(i)
      y(i)=vrtex5*yunit(i)
 1015 z(i)=vrtex6*zunit(i)

      do 1016 i=71,78
      x(i)=vrtex5*xunit(i)
      y(i)=vrtex6*yunit(i)
 1016 z(i)=vrtex5*zunit(i)

      do 1017 i=79,86
      x(i)=vrtex6*xunit(i)
      y(i)=vrtex5*yunit(i)
 1017 z(i)=vrtex5*zunit(i)

      do 1018 i=87,90
      x(i)=vrtex7*xunit(i)
      y(i)=vrtex8*yunit(i)
 1018 z(i)=vrtex9*zunit(i)

      do 1019 i=91,94
      x(i)=vrtex7*xunit(i)
      y(i)=vrtex9*yunit(i)
 1019 z(i)=vrtex8*zunit(i)

      do 1020 i=95,98
      x(i)=vrtex9*xunit(i)
      y(i)=vrtex7*yunit(i)
 1020 z(i)=vrtex8*zunit(i)

      do 1021 i=99,102
      x(i)=vrtex8*xunit(i)
      y(i)=vrtex7*yunit(i)
 1021 z(i)=vrtex9*zunit(i)

      do 1022 i=103,106
      x(i)=vrtex8*xunit(i)
      y(i)=vrtex9*yunit(i)
 1022 z(i)=vrtex7*zunit(i)

      do 1023 i=107,110
      x(i)=vrtex9*xunit(i)
      y(i)=vrtex8*yunit(i)
 1023 z(i)=vrtex7*zunit(i)

      return
      end
