      subroutine ang50(x,y,z,weight)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension xunit(50),yunit(50),zunit(50)

      dimension x(*),y(*),z(*),weight(*)

      data xunit/1.0d0,-1.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           0.0d0, 0.0d0, 0.0d0, 0.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0, 1.0d0,-1.0d0/

      data yunit/0.0d0, 0.0d0, 1.0d0,-1.0d0, 0.0d0, 0.0d0,
     &           1.0d0,-1.0d0, 1.0d0,-1.0d0, 0.0d0, 0.0d0,
     &           0.0d0, 0.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0/

      data zunit/0.0d0, 0.0d0, 0.0d0, 0.0d0, 1.0d0,-1.0d0,
     &           1.0d0, 1.0d0,-1.0d0,-1.0d0, 1.0d0, 1.0d0,
     &          -1.0d0,-1.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0,
     &           1.0d0, 1.0d0, 1.0d0, 1.0d0,-1.0d0,-1.0d0,-1.0d0,-1.0d0/

      data vrtex1,vrtex2/0.301511344578d0,0.904534033733d0/

      data wght1,wght2,wght3,wght4/0.0126984126985d0,0.0225749559083d0,
     &                             0.0210937500000d0,0.0201733355379d0/

      data one,two,three/1.0d0,2.0d0,3.0d0/

      sqrt2=one/sqrt(two)
      sqrt3=one/sqrt(three)

      do 1001 i=1,6
 1001 weight(i)=wght1

      do 1002 i=7,18
 1002 weight(i)=wght2

      do 1003 i=19,26
 1003 weight(i)=wght3

      do 1004 i=27,50
 1004 weight(i)=wght4

      do 1005 i=1,6
      x(i)=xunit(i)
      y(i)=yunit(i)
 1005 z(i)=zunit(i)

      do 1006 i=7,18
      x(i)=sqrt2*xunit(i)
      y(i)=sqrt2*yunit(i)
 1006 z(i)=sqrt2*zunit(i)

      do 1007 i=19,26
      x(i)=sqrt3*xunit(i)
      y(i)=sqrt3*yunit(i)
 1007 z(i)=sqrt3*zunit(i)

      do 1008 i=27,34
      x(i)=vrtex1*xunit(i)
      y(i)=vrtex1*yunit(i)
 1008 z(i)=vrtex2*zunit(i)

      do 1009 i=35,42
      x(i)=vrtex1*xunit(i)
      y(i)=vrtex2*yunit(i)
 1009 z(i)=vrtex1*zunit(i)

      do 1010 i=43,50
      x(i)=vrtex2*xunit(i)
      y(i)=vrtex1*yunit(i)
 1010 z(i)=vrtex1*zunit(i)

      return
      end
