      subroutine auggv(n,ndim,iloc,tvalue,gv,expfac,term,sum)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.
c
c  based on brett dunlap's incomplete gamma function subroutines

      implicit real*8(a-h,o-z)

      dimension iloc(*)

      dimension tvalue(*),gv(ndim,*),expfac(*),term(*),sum(*)

      common/igfdata/table(17,161),smallu(17),bigu(13)

      data small,eterm/0.00000001d0,0.018315638888734d0/

      data a1,a2,a3/0.2507213d0,0.0292732d0,0.0038278d0/

      data b1,b2,b3,b4,b5/1.333333333333d0,0.53333333333333d0,
     &                    0.152380952000d0,3.28125000000000d0,
     &                    0.937500000000d0/

      data c1,c2,c3,c4/1.772453850905500d0,0.88622692545276d0,
     &                 0.041666666666667d0,0.16666666666667d0/

      data zero,tenth,quarter,three8ths,half,
     &     one,two,ten,sixteen,plus16,thirty6/0.000d0, 0.100d0, 0.250d0,
     &                                        0.375d0, 0.500d0, 1.000d0,
     &                                        2.000d0,10.000d0,16.000d0,
     &                                       16.050d0,36.000d0/

      do 1001 i=1,n
      do 1001 j=1,ndim
 1001 gv(j,i)=smallu(i)

      nn=0

      do 1002 j=1,ndim
      if((tvalue(j).lt.plus16).and.(tvalue(j).gt.small)) then
                                                              nn=nn+1
                                                              iloc(nn)=j
                                                         endif
 1002 continue

      if(nn.eq.0) goto 1003

cfpp$ nodepchk
      do 1004 j=1,nn
      i=ten*tvalue(iloc(j))
      x1=tvalue(iloc(j))-tenth*real64(i)
      x2=2*n-1
 1004 gv(iloc(j),n)=(((c3*table(n+4,i+1)*x1
     &                -c4*table(n+3,i+1))*x1
     &              +half*table(n+2,i+1))*x1
     &                   -table(n+1,i+1))*x1
     &                   +table(n,i+1)

      do 1005 j=1,nn
 1005 expfac(j)=exp(-tvalue(iloc(j)))

      do 1006 i=1,n-1
      x2=x2-two
cfpp$ nodepchk
      do 1007 j=1,nn
 1007 gv(iloc(j),n-i)=(gv(iloc(j),n-i+1)
     &               *two*tvalue(iloc(j))+expfac(j))/x2
 1006 continue

 1003 nn=0

      do 1008 j=1,ndim
      if(tvalue(j).ge.plus16) then
                                    nn=nn+1
                                    iloc(nn)=j
                              endif
 1008 continue

      if(nn.eq.0) return

cfpp$ nodepchk
      do 1009 j=1,nn
 1009 gv(iloc(j),n)=c2*bigu(n)/sqrt(tvalue(iloc(j)))

      do 1010 i=1,n-1
cfpp$ nodepchk
      do 1011 j=1,nn
 1011 gv(iloc(j),n)=gv(iloc(j),n)*half/tvalue(iloc(j))
 1010 continue

      x1=2*n-1
      x2=2*n-1

      do 1012 j=1,nn
      term(j)=one
 1012 sum(j)=one

      do 1013 i=1,n
      x1=x1-two
      do 1014 j=1,nn
 1014 term(j)=term(j)*x1/(two*tvalue(iloc(j)))
      do 1015 j=1,nn
 1015 sum(j)=sum(j)+term(j)
 1013 continue

      do 1016 j=1,nn
 1016 expfac(j)=zero

      do 1017 j=1,nn
 1017 if(tvalue(iloc(j)).lt.thirty6) expfac(j)=exp(-tvalue(iloc(j)))

cfpp$ nodepchk
      do 1018 j=1,nn
 1018 gv(iloc(j),n)=gv(iloc(j),n)-sum(j)*expfac(j)/(two*tvalue(iloc(j)))

      do 1019 i=1,n-1
      x2=x2-two
cfpp$ nodepchk
      do 1020 j=1,nn
 1020 gv(iloc(j),n-i)=(gv(iloc(j),n-i+1)
     &               *two*tvalue(iloc(j))+expfac(j))/x2
 1019 continue

      return
      end
