      subroutine becke_partial(npts,nalpha,nbeta,
     &                         dnstya,dnstyb,dnstyt,gmoda,gmodb,
     &                         bval,dbdrhoa,dbdrhob,dbdgama,dbdgamb)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension dnstya(*),dnstyb(*),dnstyt(*),gmoda(*),gmodb(*)
      dimension bval(*),dbdrhoa(*),dbdrhob(*),dbdgama(*),dbdgamb(*)

      data tol,beta,gx/1.0d-15,0.0042d0,-0.93052573634910d0/
      data zero,one,two,six/0.0d0,1.0d0,2.0d0,6.0d0/
      data half,thrhlf/0.5d0,1.5d0/
      data third,fourthirds/0.33333333333333d0,1.33333333333333d0/

      do 1001 i=1,npts

      if(dnstyt(i).lt.tol) goto 1001

      gxa=zero
      gxb=zero

      dnsta13=zero
      dnstb13=zero

      if(dnstya(i).gt.tol) then

                gxa=gx
                dnsta13=dnstya(i)**third
                xa=gmoda(i)/(dnstya(i)*dnsta13)
                sinhxa=log(xa+sqrt(xa*xa+one))
                factora=one+six*beta*xa*sinhxa
                gxa=gxa-beta*xa*xa/factora
                topa=six*beta*beta*xa*xa
     &              *((xa/sqrt(xa*xa+one))-sinhxa)-two*beta*xa
                dgdxa=topa/(factora*factora)
                dbdrhoa(i)=dbdrhoa(i)+fourthirds*dnsta13*(gxa-xa*dgdxa)
                if(gmoda(i).gt.tol) dbdgama(i)=dbdgama(i)
     &                                        +half*(one/gmoda(i))*dgdxa

                           endif

      if(nalpha.eq.nbeta) then
                                dbdrhob(i)=dbdrhoa(i)
                                dbdgamb(i)=dbdgama(i)

                                goto 1002
                          endif

      if(dnstyb(i).gt.tol) then

                gxb=gx
                dnstb13=dnstyb(i)**third
                xb=gmodb(i)/(dnstyb(i)*dnstb13)
                sinhxb=log(xb+sqrt(xb*xb+one))
                factorb=one+six*beta*xb*sinhxb
                gxb=gxb-beta*xb*xb/factorb
                topb=six*beta*beta*xb*xb
     &              *((xb/sqrt(xb*xb+one))-sinhxb)-two*beta*xb
                dgdxb=topb/(factorb*factorb)
                dbdrhob(i)=dbdrhob(i)+fourthirds*dnstb13*(gxb-xb*dgdxb)
                if(gmodb(i).gt.tol) dbdgamb(i)=dbdgamb(i)
     &                                        +half*(one/gmodb(i))*dgdxb

                           endif

 1002 continue

      if(nalpha.eq.nbeta) then
                                temp=two*dnstya(i)*dnsta13*gxa
                          else
                                temp=dnstya(i)*dnsta13*gxa
     &                              +dnstyb(i)*dnstb13*gxb
                          endif

      if(dnstyt(i).gt.tol) then
                                 temp=temp/dnstyt(i)
                           else
                                 temp=zero
                           endif

      bval(i)=bval(i)+temp

 1001 continue

      return
      end
