      subroutine boys_print(n,natoms,nconts,ncontp,ncontd,nshels,nshelp,
     &                      nsheld,icfunc,nfunc,natomtype,overlap,
     &                      coeffmo,pmat,smat,pstmat,pop,bond)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nshels(*),nshelp(*),nsheld(*),nfunc(*),icfunc(*),
     &          natomtype(*)

      dimension overlap(*),coeffmo(*)

      dimension pmat(n,*),smat(n,*),pstmat(n,*),pop(*),bond(natoms,*)

      data zero,two,cutoff,tol/0.0d0,2.0d0,0.05d0,1.0d-14/

      do 1001 j=1,n
 1001 call utilityc(n,coeffmo(j),pmat(1,j),coeffmo)

      ij=0

      do 1002 i=1,n
      do 1002 j=1,i
      ij=ij+1
      smat(i,j)=overlap(ij)
 1002 smat(j,i)=overlap(ij)

      do 1003 j=1,n
      call utility2(n,zero,pstmat(1,j))
      do 1003 k=1,n
 1003 if(abs(smat(k,j)).gt.tol) call utility3(n,smat(k,j),
     &                                        pstmat(1,j),pmat(1,k))

      write(6,1004)
 1004 format(/,'         mulliken population analysis :',/)

      do 1005 i=1,natoms
 1005 pop(i)=zero

      do 1006 j=1,n
 1006 pop(nfunc(j))=pop(nfunc(j))+pstmat(j,j)

      do 1007 i=1,natoms
 1007 if(abs(pop(i)).gt.cutoff) write(6,1008) i,pop(i)
 1008 format(15x,' atom # ',i4,'       population = ',f8.4)

      write(6,1009)
 1009 format(/,'         mayer bond order analysis :',/)

      do 1010 i=1,natoms
      do 1010 j=1,natoms
 1010 bond(j,i)=zero

      do 1016 k=1,n
      kk=nfunc(k)
      do 1016 l=1,n
 1016 bond(kk,nfunc(l))=bond(kk,nfunc(l))+pstmat(k,l)*pstmat(l,k)

      do 1017 i=1,natoms
      do 1017 j=i+1,natoms
 1017 if(abs(two*bond(i,j)).gt.cutoff) write(6,1018) i,j,two*bond(i,j)
 1018 format(15x,' atoms # ',i4,' and ',i4,'       bond order = ',f8.4)

      write(6,1019)
 1019 format()

      ii=0

      do 1020 j=1,nconts
      if(abs(coeffmo(ii+1)).gt.cutoff)
     &       write(6,1021) ii+1,nfunc(ii+1),coeffmo(ii+1)
 1021 format('         a.o. #',i5,',     center',i4,',    s  ',f15.8)
 1020 ii=ii+1

      do 1022 j=1,ncontp
      if(abs(coeffmo(ii+1)).gt.cutoff)
     &       write(6,1023) ii+1,nfunc(ii+1),coeffmo(ii+1)
 1023 format('         a.o. #',i5,',     center',i4,',    px ',f15.8)
      if(abs(coeffmo(ii+2)).gt.cutoff)
     &       write(6,1024) ii+2,nfunc(ii+2),coeffmo(ii+2)
 1024 format('         a.o. #',i5,',     center',i4,',    py ',f15.8)
      if(abs(coeffmo(ii+3)).gt.cutoff)
     &       write(6,1025) ii+3,nfunc(ii+3),coeffmo(ii+3)
 1025 format('         a.o. #',i5,',     center',i4,',    pz ',f15.8)
 1022 ii=ii+3

      do 1026 j=1,ncontd
      if(abs(coeffmo(ii+1)).gt.cutoff)
     &       write(6,1027) ii+1,nfunc(ii+1),coeffmo(ii+1)
 1027 format('         a.o. #',i5,',     center',i4,',    dxx',f15.8)
      if(abs(coeffmo(ii+2)).gt.cutoff)
     &       write(6,1028) ii+2,nfunc(ii+2),coeffmo(ii+2)
 1028 format('         a.o. #',i5,',     center',i4,',    dxy',f15.8)
      if(abs(coeffmo(ii+3)).gt.cutoff)
     &       write(6,1029) ii+3,nfunc(ii+3),coeffmo(ii+3)
 1029 format('         a.o. #',i5,',     center',i4,',    dxz',f15.8)
      if(abs(coeffmo(ii+4)).gt.cutoff)
     &       write(6,1030) ii+4,nfunc(ii+4),coeffmo(ii+4)
 1030 format('         a.o. #',i5,',     center',i4,',    dyy',f15.8)
      if(abs(coeffmo(ii+5)).gt.cutoff)
     &       write(6,1031) ii+5,nfunc(ii+5),coeffmo(ii+5)
 1031 format('         a.o. #',i5,',     center',i4,',    dyz',f15.8)
      if(abs(coeffmo(ii+6)).gt.cutoff)
     &       write(6,1032) ii+6,nfunc(ii+6),coeffmo(ii+6)
 1032 format('         a.o. #',i5,',     center',i4,',    dzz',f15.8)
 1026 ii=ii+6

      write(6,1033)
 1033 format(//)

      return
      end
