      subroutine cdcalls(nreal,ncds,ncdspd,ndim,nmaxatoms,natoms,
     &                   nbsystems,isys,isave,ilfunc,icfunc,iwkvec,
     &                   cutoff,alpha,coeffs,coeffp,coeffd,cdsmat,cent,
     &                   wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension isys(nmaxatoms,*),isave(*),ilfunc(*),icfunc(*)
      dimension iwkvec(*)

      dimension alpha(*),coeffs(*),coeffp(*),coeffd(*),cdsmat(*)
      dimension cent(3,*),wkvec(*)

      ntotal=ncds+10*ncdspd

      call cdovss(ncds,ntotal,ilfunc,icfunc,alpha,coeffs,cdsmat,cent)

      call cdovxs(ncds,ncdspd,ntotal,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      call cdovxx(ncds,ncdspd,ntotal,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      rewind 17

      nnn=(ntotal*(ntotal+1))/2

      call fastwr(17,cdsmat,nnn)

      ncds_save=ncds
      ncdspd_save=ncdspd

      do 1001 i=1,ndim
 1001 isave(i)=ilfunc(i)

      rewind 18

      do 1002 i=1,nbsystems

      do 1003 j=1,natoms
 1003 iwkvec(j)=0

      do 1004 j=1,isys(1,i)
 1004 iwkvec(isys(j+1,i))=1

      do 1005 j=1,natoms
      do 1005 k=1,isys(1,i)
 1005 if(dist(cent(1,j),cent(1,isys(k+1,i))).le.cutoff) iwkvec(j)=1

      ncds=0

      do 1006 j=1,ncds_save
      if(iwkvec(icfunc(isave(j))).eq.1) then
                                              ncds=ncds+1
                                              ilfunc(ncds)=isave(j)
                                        endif
 1006 continue

      ncdspd=0

      do 1007 j=1,ncdspd_save
      if(iwkvec(icfunc(isave(ncds_save+j))).eq.1) then

                               ncdspd=ncdspd+1
                               ilfunc(ncds+ncdspd)=isave(ncds_save+j)

                                                  endif
 1007 continue

      ntotal=ncds+10*ncdspd

      ja=((ntotal*(ntotal+1))/2)+1
      jb=ja+ntotal*ntotal
      jc=jb+ntotal
      jd=jc+ntotal*3

      if(jd.gt.nreal) stop 'real overflow in cdcalls'

      call cdovss(ncds,ntotal,ilfunc,icfunc,alpha,coeffs,cdsmat,cent)

      call cdovxs(ncds,ncdspd,ntotal,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      call cdovxx(ncds,ncdspd,ntotal,ilfunc,icfunc,alpha,coeffs,coeffp,
     &            coeffd,cdsmat,cent)

      call cdtran(wkvec(ja),cdsmat,wkvec(jb),wkvec(jc),ntotal)

      ncds=ncds_save
      ncdspd=ncdspd_save

      do 1008 j=1,ndim
 1008 ilfunc(j)=isave(j)

 1002 continue

      return
      end
