      subroutine cdftdp(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                  iloc,g,coord,alphaaux,coeffs,coeffp,coeffd,tvec,
     &                  dmat,zeta,axbx,ayby,azbz,px,py,pz,base,pxax,
     &                  pyay,pzaz,u,zetarec,wxcx,wycy,wzcz,wxpx,wypy,
     &                  wzpz,sss0,sss1,sss2,sss3,sss4,sss5,pss0,pss1,
     &                  pss2,pss3,pss4,dss,dss0,dss1,dss2,dss3,fss,fss0,
     &                  fss1,fss2,psp1,dsp,dsp0,dsp1,fsp,fsp0,fsp1,dsd,
     &                  dsd0,fsd,fsd0,dps0,dpp0,dpd0,zetac1,zetac2,c,c1,
     &                  c2,c3,c4,c5,gather)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),iloc(*)

      dimension g(*),coord(3,*),alphaaux(*),coeffs(*),coeffp(*),
     &          coeffd(*),tvec(*),dmat(*),zeta(*),axbx(*),ayby(*),
     &          azbz(*),px(*),py(*),pz(*),base(*),pxax(*),pyay(*),
     &          pzaz(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),wxpx(*),
     &          wypy(*),wzpz(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),
     &          sss5(*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          pss4(n,*),dss(n,*),dss0(n,*),dss1(n,*),dss2(n,*),
     &          dss3(n,*),fss(n,*),fss0(n,*),fss1(n,*),fss2(n,*),
     &          psp1(n,*),dsp(n,*),dsp0(n,*),dsp1(n,*),fsp(n,*),
     &          fsp0(n,*),fsp1(n,*),dsd(n,*),dsd0(n,*),fsd(n,*),
     &          fsd0(n,*),dps0(n,*),dpp0(n,*),dpd0(n,*),zetac1(*),
     &          zetac2(*),c(*),c1(n,*),c2(n,*),c3(n,*),c4(n,*),c5(n,*),
     &          gather(n,*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data four,five,seven/4.0d0,5.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(4,n,iloc,u,fss0,sss0,sss1,sss2)

      do 1004 i=1,n
      sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,3)/zeta(i)/zetaux
 1004 sss3(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,4)/zeta(i)/zetaux

      do 1005 i=1,n
 1005 zetac1(i)=zetaux*zetarec(i)

      do 1006 i=1,n
      wxpx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-px(i)
      wypy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-py(i)
 1006 wzpz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-pz(i)

      do 1007 i=1,n

      pss0(i,1)=pxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=pyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=pzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=pxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=pyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=pzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=pxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=pyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=pzaz(i)*sss2(i)+wzpz(i)*sss3(i)

 1007 continue

      do 1008 i=1,n

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zeta(i))

      dss0(i,1)=pxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=pyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=pzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=pyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=pzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=pzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zeta(i))

      dss1(i,1)=pxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=pyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=pzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=pyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=pzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=pzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

 1008 continue

      do 1009 j=1,3
      do 1009 i=1,n
 1009 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zeta(i))

      do 1010 i=1,n
      fss0(i,01)=pxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=pyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=pzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=pyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=pzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=pzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=pyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=pzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=pzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1010 fss0(i,10)=pzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1011 i=1,n
      dps0(i,01)=axbx(icontr(i))*dss0(i,1)+fss0(i,01)
      dps0(i,02)=ayby(icontr(i))*dss0(i,1)+fss0(i,02)
      dps0(i,03)=azbz(icontr(i))*dss0(i,1)+fss0(i,03)
      dps0(i,04)=axbx(icontr(i))*dss0(i,2)+fss0(i,02)
      dps0(i,05)=ayby(icontr(i))*dss0(i,2)+fss0(i,04)
      dps0(i,06)=azbz(icontr(i))*dss0(i,2)+fss0(i,05)
      dps0(i,07)=axbx(icontr(i))*dss0(i,3)+fss0(i,03)
      dps0(i,08)=ayby(icontr(i))*dss0(i,3)+fss0(i,05)
      dps0(i,09)=azbz(icontr(i))*dss0(i,3)+fss0(i,06)
      dps0(i,10)=axbx(icontr(i))*dss0(i,4)+fss0(i,04)
      dps0(i,11)=ayby(icontr(i))*dss0(i,4)+fss0(i,07)
      dps0(i,12)=azbz(icontr(i))*dss0(i,4)+fss0(i,08)
      dps0(i,13)=axbx(icontr(i))*dss0(i,5)+fss0(i,05)
      dps0(i,14)=ayby(icontr(i))*dss0(i,5)+fss0(i,08)
      dps0(i,15)=azbz(icontr(i))*dss0(i,5)+fss0(i,09)
      dps0(i,16)=axbx(icontr(i))*dss0(i,6)+fss0(i,06)
      dps0(i,17)=ayby(icontr(i))*dss0(i,6)+fss0(i,09)
 1011 dps0(i,18)=azbz(icontr(i))*dss0(i,6)+fss0(i,10)

      do 1012 i=1,n
 1012 gather(i,1)=zero

      do 1013 j=1,18
      do 1013 i=1,n
 1013 gather(i,1)=gather(i,1)+dmat(inddyy(icontr(i),j))*dps0(i,j)

      do 1014 i=1,n
 1014 gather(i,1)=gather(i,1)*cdfits

      do 1015 i=1,n
 1015 tvec(naux)=tvec(naux)+gather(i,1)

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      cdfitp(1)=coeffp(ilaux)
      cdfitp(2)=coeffp(ilaux)
      cdfitp(3)=coeffp(ilaux)

      cdfitd(1)=coeffd(ilaux)/dnormcd
      cdfitd(2)=coeffd(ilaux)
      cdfitd(3)=coeffd(ilaux)
      cdfitd(4)=coeffd(ilaux)/dnormcd
      cdfitd(5)=coeffd(ilaux)
      cdfitd(6)=coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(6,n,iloc,u,fss0,sss0,sss1,sss2)

      do 2004 i=1,n
      sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,4)/zeta(i)/zetaux
      sss4(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,5)/zeta(i)/zetaux
 2004 sss5(i)=base(i)*twoecnst*sqrt(zetarec(i))*fss0(i,6)/zeta(i)/zetaux

      do 2005 i=1,n
      zetac1(i)=zetaux*zetarec(i)
 2005 zetac2(i)=zeta(i)*zetarec(i)

      do 2006 i=1,n
      wxcx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-ccy
 2006 wzcz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2007 i=1,n
      wxpx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-px(i)
      wypy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-py(i)
 2007 wzpz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-pz(i)

      do 2008 i=1,n

      pss0(i,1)=pxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=pyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=pzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=pxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=pyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=pzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=pxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=pyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=pzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=pxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=pyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=pzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      pss4(i,1)=pxax(i)*sss4(i)+wxpx(i)*sss5(i)
      pss4(i,2)=pyay(i)*sss4(i)+wypy(i)*sss5(i)
      pss4(i,3)=pzaz(i)*sss4(i)+wzpz(i)*sss5(i)

 2008 continue

      do 2009 i=1,n

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zeta(i))

      dss0(i,1)=pxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=pyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=pzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=pyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=pzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=pzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zeta(i))

      dss1(i,1)=pxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=pyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=pzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=pyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=pzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=pzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zeta(i))

      dss2(i,1)=pxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=pyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=pzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=pyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=pzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=pzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      c(i)=(sss3(i)-zetac1(i)*sss4(i))/(two*zeta(i))

      dss3(i,1)=pxax(i)*pss3(i,1)+wxpx(i)*pss4(i,1)+c(i)
      dss3(i,2)=pyay(i)*pss3(i,1)+wypy(i)*pss4(i,1)
      dss3(i,3)=pzaz(i)*pss3(i,1)+wzpz(i)*pss4(i,1)
      dss3(i,4)=pyay(i)*pss3(i,2)+wypy(i)*pss4(i,2)+c(i)
      dss3(i,5)=pzaz(i)*pss3(i,2)+wzpz(i)*pss4(i,2)
      dss3(i,6)=pzaz(i)*pss3(i,3)+wzpz(i)*pss4(i,3)+c(i)

 2009 continue

      do 2010 j=1,3
      do 2010 i=1,n
 2010 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zeta(i))

      do 2011 i=1,n
      fss0(i,01)=pxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=pyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=pzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=pyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=pzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=pzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=pyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=pzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=pzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 2011 fss0(i,10)=pzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 2012 j=1,3
      do 2012 i=1,n
 2012 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zeta(i))

      do 2013 i=1,n
      fss1(i,01)=pxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=pyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=pzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=pyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=pzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=pzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=pyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=pzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=pzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 2013 fss1(i,10)=pzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 2014 j=1,3
      do 2014 i=1,n
 2014 c1(i,j)=(pss2(i,j)-zetac1(i)*pss3(i,j))/(two*zeta(i))

      do 2015 i=1,n
      fss2(i,01)=pxax(i)*dss2(i,1)+wxpx(i)*dss3(i,1)+c1(i,1)+c1(i,1)
      fss2(i,02)=pyay(i)*dss2(i,1)+wypy(i)*dss3(i,1)
      fss2(i,03)=pzaz(i)*dss2(i,1)+wzpz(i)*dss3(i,1)
      fss2(i,04)=pyay(i)*dss2(i,2)+wypy(i)*dss3(i,2)+c1(i,1)
      fss2(i,05)=pzaz(i)*dss2(i,2)+wzpz(i)*dss3(i,2)
      fss2(i,06)=pzaz(i)*dss2(i,3)+wzpz(i)*dss3(i,3)+c1(i,1)
      fss2(i,07)=pyay(i)*dss2(i,4)+wypy(i)*dss3(i,4)+c1(i,2)+c1(i,2)
      fss2(i,08)=pzaz(i)*dss2(i,4)+wzpz(i)*dss3(i,4)
      fss2(i,09)=pzaz(i)*dss2(i,5)+wzpz(i)*dss3(i,5)+c1(i,2)
 2015 fss2(i,10)=pzaz(i)*dss2(i,6)+wzpz(i)*dss3(i,6)+c1(i,3)+c1(i,3)

      do 2016 i=1,n

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2016 continue

      do 2017 j=1,3
      do 2017 i=1,n
 2017 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 2018 i=1,n
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 2018 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 2019 j=1,3
      do 2019 i=1,n
 2019 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 2020 i=1,n
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 2020 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 2021 j=1,6
      do 2021 i=1,n
 2021 c2(i,j)=half*dss1(i,j)*zetarec(i)

      do 2022 i=1,n
      fsp0(i,01)=wxcx(i)*fss1(i,01)+c2(i,1)*three
      fsp0(i,02)=wycy(i)*fss1(i,01)
      fsp0(i,03)=wzcz(i)*fss1(i,01)
      fsp0(i,04)=wxcx(i)*fss1(i,02)+c2(i,2)*two
      fsp0(i,05)=wycy(i)*fss1(i,02)+c2(i,1)
      fsp0(i,06)=wzcz(i)*fss1(i,02)
      fsp0(i,07)=wxcx(i)*fss1(i,03)+c2(i,3)*two
      fsp0(i,08)=wycy(i)*fss1(i,03)
      fsp0(i,09)=wzcz(i)*fss1(i,03)+c2(i,1)
      fsp0(i,10)=wxcx(i)*fss1(i,04)+c2(i,4)
      fsp0(i,11)=wycy(i)*fss1(i,04)+c2(i,2)*two
      fsp0(i,12)=wzcz(i)*fss1(i,04)
      fsp0(i,13)=wxcx(i)*fss1(i,05)+c2(i,5)
      fsp0(i,14)=wycy(i)*fss1(i,05)+c2(i,3)
      fsp0(i,15)=wzcz(i)*fss1(i,05)+c2(i,2)
      fsp0(i,16)=wxcx(i)*fss1(i,06)+c2(i,6)
      fsp0(i,17)=wycy(i)*fss1(i,06)
      fsp0(i,18)=wzcz(i)*fss1(i,06)+c2(i,3)*two
      fsp0(i,19)=wxcx(i)*fss1(i,07)
      fsp0(i,20)=wycy(i)*fss1(i,07)+c2(i,4)*three
      fsp0(i,21)=wzcz(i)*fss1(i,07)
      fsp0(i,22)=wxcx(i)*fss1(i,08)
      fsp0(i,23)=wycy(i)*fss1(i,08)+c2(i,5)*two
      fsp0(i,24)=wzcz(i)*fss1(i,08)+c2(i,4)
      fsp0(i,25)=wxcx(i)*fss1(i,09)
      fsp0(i,26)=wycy(i)*fss1(i,09)+c2(i,6)
      fsp0(i,27)=wzcz(i)*fss1(i,09)+c2(i,5)*two
      fsp0(i,28)=wxcx(i)*fss1(i,10)
      fsp0(i,29)=wycy(i)*fss1(i,10)
 2022 fsp0(i,30)=wzcz(i)*fss1(i,10)+c2(i,6)*three

      do 2023 j=1,6
      do 2023 i=1,n
 2023 c2(i,j)=half*dss2(i,j)*zetarec(i)

      do 2024 i=1,n
      fsp1(i,01)=wxcx(i)*fss2(i,01)+c2(i,1)*three
      fsp1(i,02)=wycy(i)*fss2(i,01)
      fsp1(i,03)=wzcz(i)*fss2(i,01)
      fsp1(i,04)=wxcx(i)*fss2(i,02)+c2(i,2)*two
      fsp1(i,05)=wycy(i)*fss2(i,02)+c2(i,1)
      fsp1(i,06)=wzcz(i)*fss2(i,02)
      fsp1(i,07)=wxcx(i)*fss2(i,03)+c2(i,3)*two
      fsp1(i,08)=wycy(i)*fss2(i,03)
      fsp1(i,09)=wzcz(i)*fss2(i,03)+c2(i,1)
      fsp1(i,10)=wxcx(i)*fss2(i,04)+c2(i,4)
      fsp1(i,11)=wycy(i)*fss2(i,04)+c2(i,2)*two
      fsp1(i,12)=wzcz(i)*fss2(i,04)
      fsp1(i,13)=wxcx(i)*fss2(i,05)+c2(i,5)
      fsp1(i,14)=wycy(i)*fss2(i,05)+c2(i,3)
      fsp1(i,15)=wzcz(i)*fss2(i,05)+c2(i,2)
      fsp1(i,16)=wxcx(i)*fss2(i,06)+c2(i,6)
      fsp1(i,17)=wycy(i)*fss2(i,06)
      fsp1(i,18)=wzcz(i)*fss2(i,06)+c2(i,3)*two
      fsp1(i,19)=wxcx(i)*fss2(i,07)
      fsp1(i,20)=wycy(i)*fss2(i,07)+c2(i,4)*three
      fsp1(i,21)=wzcz(i)*fss2(i,07)
      fsp1(i,22)=wxcx(i)*fss2(i,08)
      fsp1(i,23)=wycy(i)*fss2(i,08)+c2(i,5)*two
      fsp1(i,24)=wzcz(i)*fss2(i,08)+c2(i,4)
      fsp1(i,25)=wxcx(i)*fss2(i,09)
      fsp1(i,26)=wycy(i)*fss2(i,09)+c2(i,6)
      fsp1(i,27)=wzcz(i)*fss2(i,09)+c2(i,5)*two
      fsp1(i,28)=wxcx(i)*fss2(i,10)
      fsp1(i,29)=wycy(i)*fss2(i,10)
 2024 fsp1(i,30)=wzcz(i)*fss2(i,10)+c2(i,6)*three

      do 2025 j=1,6
      do 2025 i=1,n
 2025 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 2026 j=1,9
      do 2026 i=1,n
 2026 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 2027 i=1,n
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 2027 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 2028 j=1,10
      do 2028 i=1,n
 2028 c4(i,j)=(fss0(i,j)-zetac2(i)*fss1(i,j))/(two*zetaux)

      do 2029 j=1,18
      do 2029 i=1,n
 2029 c5(i,j)=half*dsp1(i,j)*zetarec(i)

      do 2030 i=1,n
      fsd0(i,01)=wxcx(i)*fsp1(i,01)+c4(i,01)+c5(i,01)*three
      fsd0(i,02)=wycy(i)*fsp1(i,01)
      fsd0(i,03)=wzcz(i)*fsp1(i,01)
      fsd0(i,04)=wycy(i)*fsp1(i,02)+c4(i,01)
      fsd0(i,05)=wzcz(i)*fsp1(i,02)
      fsd0(i,06)=wzcz(i)*fsp1(i,03)+c4(i,01)
      fsd0(i,07)=wxcx(i)*fsp1(i,04)+c4(i,02)+c5(i,04)*two
      fsd0(i,08)=wycy(i)*fsp1(i,04)         +c5(i,01)
      fsd0(i,09)=wzcz(i)*fsp1(i,04)
      fsd0(i,10)=wycy(i)*fsp1(i,05)+c4(i,02)+c5(i,02)
      fsd0(i,11)=wzcz(i)*fsp1(i,05)
      fsd0(i,12)=wzcz(i)*fsp1(i,06)+c4(i,02)
      fsd0(i,13)=wxcx(i)*fsp1(i,07)+c4(i,03)+c5(i,07)*two
      fsd0(i,14)=wycy(i)*fsp1(i,07)
      fsd0(i,15)=wzcz(i)*fsp1(i,07)         +c5(i,01)
      fsd0(i,16)=wycy(i)*fsp1(i,08)+c4(i,03)
      fsd0(i,17)=wzcz(i)*fsp1(i,08)         +c5(i,02)
      fsd0(i,18)=wzcz(i)*fsp1(i,09)+c4(i,03)+c5(i,03)
      fsd0(i,19)=wxcx(i)*fsp1(i,10)+c4(i,04)+c5(i,10)
      fsd0(i,20)=wycy(i)*fsp1(i,10)         +c5(i,04)*two
      fsd0(i,21)=wzcz(i)*fsp1(i,10)
      fsd0(i,22)=wycy(i)*fsp1(i,11)+c4(i,04)+c5(i,05)*two
      fsd0(i,23)=wzcz(i)*fsp1(i,11)
      fsd0(i,24)=wzcz(i)*fsp1(i,12)+c4(i,04)
      fsd0(i,25)=wxcx(i)*fsp1(i,13)+c4(i,05)+c5(i,13)
      fsd0(i,26)=wycy(i)*fsp1(i,13)         +c5(i,07)
      fsd0(i,27)=wzcz(i)*fsp1(i,13)         +c5(i,04)
      fsd0(i,28)=wycy(i)*fsp1(i,14)+c4(i,05)+c5(i,08)
      fsd0(i,29)=wzcz(i)*fsp1(i,14)         +c5(i,05)
      fsd0(i,30)=wzcz(i)*fsp1(i,15)+c4(i,05)+c5(i,06)
      fsd0(i,31)=wxcx(i)*fsp1(i,16)+c4(i,06)+c5(i,16)
      fsd0(i,32)=wycy(i)*fsp1(i,16)
      fsd0(i,33)=wzcz(i)*fsp1(i,16)         +c5(i,07)*two
      fsd0(i,34)=wycy(i)*fsp1(i,17)+c4(i,06)
      fsd0(i,35)=wzcz(i)*fsp1(i,17)         +c5(i,08)*two
      fsd0(i,36)=wzcz(i)*fsp1(i,18)+c4(i,06)+c5(i,09)*two
      fsd0(i,37)=wxcx(i)*fsp1(i,19)+c4(i,07)
      fsd0(i,38)=wycy(i)*fsp1(i,19)         +c5(i,10)*three
      fsd0(i,39)=wzcz(i)*fsp1(i,19)
      fsd0(i,40)=wycy(i)*fsp1(i,20)+c4(i,07)+c5(i,11)*three
      fsd0(i,41)=wzcz(i)*fsp1(i,20)
      fsd0(i,42)=wzcz(i)*fsp1(i,21)+c4(i,07)
      fsd0(i,43)=wxcx(i)*fsp1(i,22)+c4(i,08)
      fsd0(i,44)=wycy(i)*fsp1(i,22)         +c5(i,13)*two
      fsd0(i,45)=wzcz(i)*fsp1(i,22)         +c5(i,10)
      fsd0(i,46)=wycy(i)*fsp1(i,23)+c4(i,08)+c5(i,14)*two
      fsd0(i,47)=wzcz(i)*fsp1(i,23)         +c5(i,11)
      fsd0(i,48)=wzcz(i)*fsp1(i,24)+c4(i,08)+c5(i,12)
      fsd0(i,49)=wxcx(i)*fsp1(i,25)+c4(i,09)
      fsd0(i,50)=wycy(i)*fsp1(i,25)         +c5(i,16)
      fsd0(i,51)=wzcz(i)*fsp1(i,25)         +c5(i,13)*two
      fsd0(i,52)=wycy(i)*fsp1(i,26)+c4(i,09)+c5(i,17)
      fsd0(i,53)=wzcz(i)*fsp1(i,26)         +c5(i,14)*two
      fsd0(i,54)=wzcz(i)*fsp1(i,27)+c4(i,09)+c5(i,15)*two
      fsd0(i,55)=wxcx(i)*fsp1(i,28)+c4(i,10)
      fsd0(i,56)=wycy(i)*fsp1(i,28)
      fsd0(i,57)=wzcz(i)*fsp1(i,28)         +c5(i,16)*three
      fsd0(i,58)=wycy(i)*fsp1(i,29)+c4(i,10)
      fsd0(i,59)=wzcz(i)*fsp1(i,29)         +c5(i,17)*three
 2030 fsd0(i,60)=wzcz(i)*fsp1(i,30)+c4(i,10)+c5(i,18)*three

      do 2031 i=1,n
      dps0(i,01)=axbx(icontr(i))*dss0(i,1)+fss0(i,01)
      dps0(i,02)=ayby(icontr(i))*dss0(i,1)+fss0(i,02)
      dps0(i,03)=azbz(icontr(i))*dss0(i,1)+fss0(i,03)
      dps0(i,04)=axbx(icontr(i))*dss0(i,2)+fss0(i,02)
      dps0(i,05)=ayby(icontr(i))*dss0(i,2)+fss0(i,04)
      dps0(i,06)=azbz(icontr(i))*dss0(i,2)+fss0(i,05)
      dps0(i,07)=axbx(icontr(i))*dss0(i,3)+fss0(i,03)
      dps0(i,08)=ayby(icontr(i))*dss0(i,3)+fss0(i,05)
      dps0(i,09)=azbz(icontr(i))*dss0(i,3)+fss0(i,06)
      dps0(i,10)=axbx(icontr(i))*dss0(i,4)+fss0(i,04)
      dps0(i,11)=ayby(icontr(i))*dss0(i,4)+fss0(i,07)
      dps0(i,12)=azbz(icontr(i))*dss0(i,4)+fss0(i,08)
      dps0(i,13)=axbx(icontr(i))*dss0(i,5)+fss0(i,05)
      dps0(i,14)=ayby(icontr(i))*dss0(i,5)+fss0(i,08)
      dps0(i,15)=azbz(icontr(i))*dss0(i,5)+fss0(i,09)
      dps0(i,16)=axbx(icontr(i))*dss0(i,6)+fss0(i,06)
      dps0(i,17)=ayby(icontr(i))*dss0(i,6)+fss0(i,09)
 2031 dps0(i,18)=azbz(icontr(i))*dss0(i,6)+fss0(i,10)

      do 2032 i=1,n
      dpp0(i,01)=axbx(icontr(i))*dsp0(i,01)+fsp0(i,01)
      dpp0(i,02)=axbx(icontr(i))*dsp0(i,02)+fsp0(i,02)
      dpp0(i,03)=axbx(icontr(i))*dsp0(i,03)+fsp0(i,03)
      dpp0(i,04)=ayby(icontr(i))*dsp0(i,01)+fsp0(i,04)
      dpp0(i,05)=ayby(icontr(i))*dsp0(i,02)+fsp0(i,05)
      dpp0(i,06)=ayby(icontr(i))*dsp0(i,03)+fsp0(i,06)
      dpp0(i,07)=azbz(icontr(i))*dsp0(i,01)+fsp0(i,07)
      dpp0(i,08)=azbz(icontr(i))*dsp0(i,02)+fsp0(i,08)
      dpp0(i,09)=azbz(icontr(i))*dsp0(i,03)+fsp0(i,09)
      dpp0(i,10)=axbx(icontr(i))*dsp0(i,04)+fsp0(i,04)
      dpp0(i,11)=axbx(icontr(i))*dsp0(i,05)+fsp0(i,05)
      dpp0(i,12)=axbx(icontr(i))*dsp0(i,06)+fsp0(i,06)
      dpp0(i,13)=ayby(icontr(i))*dsp0(i,04)+fsp0(i,10)
      dpp0(i,14)=ayby(icontr(i))*dsp0(i,05)+fsp0(i,11)
      dpp0(i,15)=ayby(icontr(i))*dsp0(i,06)+fsp0(i,12)
      dpp0(i,16)=azbz(icontr(i))*dsp0(i,04)+fsp0(i,13)
      dpp0(i,17)=azbz(icontr(i))*dsp0(i,05)+fsp0(i,14)
      dpp0(i,18)=azbz(icontr(i))*dsp0(i,06)+fsp0(i,15)
      dpp0(i,19)=axbx(icontr(i))*dsp0(i,07)+fsp0(i,07)
      dpp0(i,20)=axbx(icontr(i))*dsp0(i,08)+fsp0(i,08)
      dpp0(i,21)=axbx(icontr(i))*dsp0(i,09)+fsp0(i,09)
      dpp0(i,22)=ayby(icontr(i))*dsp0(i,07)+fsp0(i,13)
      dpp0(i,23)=ayby(icontr(i))*dsp0(i,08)+fsp0(i,14)
      dpp0(i,24)=ayby(icontr(i))*dsp0(i,09)+fsp0(i,15)
      dpp0(i,25)=azbz(icontr(i))*dsp0(i,07)+fsp0(i,16)
      dpp0(i,26)=azbz(icontr(i))*dsp0(i,08)+fsp0(i,17)
      dpp0(i,27)=azbz(icontr(i))*dsp0(i,09)+fsp0(i,18)
      dpp0(i,28)=axbx(icontr(i))*dsp0(i,10)+fsp0(i,10)
      dpp0(i,29)=axbx(icontr(i))*dsp0(i,11)+fsp0(i,11)
      dpp0(i,30)=axbx(icontr(i))*dsp0(i,12)+fsp0(i,12)
      dpp0(i,31)=ayby(icontr(i))*dsp0(i,10)+fsp0(i,19)
      dpp0(i,32)=ayby(icontr(i))*dsp0(i,11)+fsp0(i,20)
      dpp0(i,33)=ayby(icontr(i))*dsp0(i,12)+fsp0(i,21)
      dpp0(i,34)=azbz(icontr(i))*dsp0(i,10)+fsp0(i,22)
      dpp0(i,35)=azbz(icontr(i))*dsp0(i,11)+fsp0(i,23)
      dpp0(i,36)=azbz(icontr(i))*dsp0(i,12)+fsp0(i,24)
      dpp0(i,37)=axbx(icontr(i))*dsp0(i,13)+fsp0(i,13)
      dpp0(i,38)=axbx(icontr(i))*dsp0(i,14)+fsp0(i,14)
      dpp0(i,39)=axbx(icontr(i))*dsp0(i,15)+fsp0(i,15)
      dpp0(i,40)=ayby(icontr(i))*dsp0(i,13)+fsp0(i,22)
      dpp0(i,41)=ayby(icontr(i))*dsp0(i,14)+fsp0(i,23)
      dpp0(i,42)=ayby(icontr(i))*dsp0(i,15)+fsp0(i,24)
      dpp0(i,43)=azbz(icontr(i))*dsp0(i,13)+fsp0(i,25)
      dpp0(i,44)=azbz(icontr(i))*dsp0(i,14)+fsp0(i,26)
      dpp0(i,45)=azbz(icontr(i))*dsp0(i,15)+fsp0(i,27)
      dpp0(i,46)=axbx(icontr(i))*dsp0(i,16)+fsp0(i,16)
      dpp0(i,47)=axbx(icontr(i))*dsp0(i,17)+fsp0(i,17)
      dpp0(i,48)=axbx(icontr(i))*dsp0(i,18)+fsp0(i,18)
      dpp0(i,49)=ayby(icontr(i))*dsp0(i,16)+fsp0(i,25)
      dpp0(i,50)=ayby(icontr(i))*dsp0(i,17)+fsp0(i,26)
      dpp0(i,51)=ayby(icontr(i))*dsp0(i,18)+fsp0(i,27)
      dpp0(i,52)=azbz(icontr(i))*dsp0(i,16)+fsp0(i,28)
      dpp0(i,53)=azbz(icontr(i))*dsp0(i,17)+fsp0(i,29)
 2032 dpp0(i,54)=azbz(icontr(i))*dsp0(i,18)+fsp0(i,30)

      do 2033 i=1,n
      dpd0(i,001)=axbx(icontr(i))*dsd0(i,01)+fsd0(i,01)
      dpd0(i,002)=axbx(icontr(i))*dsd0(i,02)+fsd0(i,02)
      dpd0(i,003)=axbx(icontr(i))*dsd0(i,03)+fsd0(i,03)
      dpd0(i,004)=axbx(icontr(i))*dsd0(i,04)+fsd0(i,04)
      dpd0(i,005)=axbx(icontr(i))*dsd0(i,05)+fsd0(i,05)
      dpd0(i,006)=axbx(icontr(i))*dsd0(i,06)+fsd0(i,06)
      dpd0(i,007)=ayby(icontr(i))*dsd0(i,01)+fsd0(i,07)
      dpd0(i,008)=ayby(icontr(i))*dsd0(i,02)+fsd0(i,08)
      dpd0(i,009)=ayby(icontr(i))*dsd0(i,03)+fsd0(i,09)
      dpd0(i,010)=ayby(icontr(i))*dsd0(i,04)+fsd0(i,10)
      dpd0(i,011)=ayby(icontr(i))*dsd0(i,05)+fsd0(i,11)
      dpd0(i,012)=ayby(icontr(i))*dsd0(i,06)+fsd0(i,12)
      dpd0(i,013)=azbz(icontr(i))*dsd0(i,01)+fsd0(i,13)
      dpd0(i,014)=azbz(icontr(i))*dsd0(i,02)+fsd0(i,14)
      dpd0(i,015)=azbz(icontr(i))*dsd0(i,03)+fsd0(i,15)
      dpd0(i,016)=azbz(icontr(i))*dsd0(i,04)+fsd0(i,16)
      dpd0(i,017)=azbz(icontr(i))*dsd0(i,05)+fsd0(i,17)
      dpd0(i,018)=azbz(icontr(i))*dsd0(i,06)+fsd0(i,18)
      dpd0(i,019)=axbx(icontr(i))*dsd0(i,07)+fsd0(i,07)
      dpd0(i,020)=axbx(icontr(i))*dsd0(i,08)+fsd0(i,08)
      dpd0(i,021)=axbx(icontr(i))*dsd0(i,09)+fsd0(i,09)
      dpd0(i,022)=axbx(icontr(i))*dsd0(i,10)+fsd0(i,10)
      dpd0(i,023)=axbx(icontr(i))*dsd0(i,11)+fsd0(i,11)
      dpd0(i,024)=axbx(icontr(i))*dsd0(i,12)+fsd0(i,12)
      dpd0(i,025)=ayby(icontr(i))*dsd0(i,07)+fsd0(i,19)
      dpd0(i,026)=ayby(icontr(i))*dsd0(i,08)+fsd0(i,20)
      dpd0(i,027)=ayby(icontr(i))*dsd0(i,09)+fsd0(i,21)
      dpd0(i,028)=ayby(icontr(i))*dsd0(i,10)+fsd0(i,22)
      dpd0(i,029)=ayby(icontr(i))*dsd0(i,11)+fsd0(i,23)
      dpd0(i,030)=ayby(icontr(i))*dsd0(i,12)+fsd0(i,24)
      dpd0(i,031)=azbz(icontr(i))*dsd0(i,07)+fsd0(i,25)
      dpd0(i,032)=azbz(icontr(i))*dsd0(i,08)+fsd0(i,26)
      dpd0(i,033)=azbz(icontr(i))*dsd0(i,09)+fsd0(i,27)
      dpd0(i,034)=azbz(icontr(i))*dsd0(i,10)+fsd0(i,28)
      dpd0(i,035)=azbz(icontr(i))*dsd0(i,11)+fsd0(i,29)
      dpd0(i,036)=azbz(icontr(i))*dsd0(i,12)+fsd0(i,30)
      dpd0(i,037)=axbx(icontr(i))*dsd0(i,13)+fsd0(i,13)
      dpd0(i,038)=axbx(icontr(i))*dsd0(i,14)+fsd0(i,14)
      dpd0(i,039)=axbx(icontr(i))*dsd0(i,15)+fsd0(i,15)
      dpd0(i,040)=axbx(icontr(i))*dsd0(i,16)+fsd0(i,16)
      dpd0(i,041)=axbx(icontr(i))*dsd0(i,17)+fsd0(i,17)
      dpd0(i,042)=axbx(icontr(i))*dsd0(i,18)+fsd0(i,18)
      dpd0(i,043)=ayby(icontr(i))*dsd0(i,13)+fsd0(i,25)
      dpd0(i,044)=ayby(icontr(i))*dsd0(i,14)+fsd0(i,26)
      dpd0(i,045)=ayby(icontr(i))*dsd0(i,15)+fsd0(i,27)
      dpd0(i,046)=ayby(icontr(i))*dsd0(i,16)+fsd0(i,28)
      dpd0(i,047)=ayby(icontr(i))*dsd0(i,17)+fsd0(i,29)
      dpd0(i,048)=ayby(icontr(i))*dsd0(i,18)+fsd0(i,30)
      dpd0(i,049)=azbz(icontr(i))*dsd0(i,13)+fsd0(i,31)
      dpd0(i,050)=azbz(icontr(i))*dsd0(i,14)+fsd0(i,32)
      dpd0(i,051)=azbz(icontr(i))*dsd0(i,15)+fsd0(i,33)
      dpd0(i,052)=azbz(icontr(i))*dsd0(i,16)+fsd0(i,34)
      dpd0(i,053)=azbz(icontr(i))*dsd0(i,17)+fsd0(i,35)
      dpd0(i,054)=azbz(icontr(i))*dsd0(i,18)+fsd0(i,36)
      dpd0(i,055)=axbx(icontr(i))*dsd0(i,19)+fsd0(i,19)
      dpd0(i,056)=axbx(icontr(i))*dsd0(i,20)+fsd0(i,20)
      dpd0(i,057)=axbx(icontr(i))*dsd0(i,21)+fsd0(i,21)
      dpd0(i,058)=axbx(icontr(i))*dsd0(i,22)+fsd0(i,22)
      dpd0(i,059)=axbx(icontr(i))*dsd0(i,23)+fsd0(i,23)
      dpd0(i,060)=axbx(icontr(i))*dsd0(i,24)+fsd0(i,24)
      dpd0(i,061)=ayby(icontr(i))*dsd0(i,19)+fsd0(i,37)
      dpd0(i,062)=ayby(icontr(i))*dsd0(i,20)+fsd0(i,38)
      dpd0(i,063)=ayby(icontr(i))*dsd0(i,21)+fsd0(i,39)
      dpd0(i,064)=ayby(icontr(i))*dsd0(i,22)+fsd0(i,40)
      dpd0(i,065)=ayby(icontr(i))*dsd0(i,23)+fsd0(i,41)
      dpd0(i,066)=ayby(icontr(i))*dsd0(i,24)+fsd0(i,42)
      dpd0(i,067)=azbz(icontr(i))*dsd0(i,19)+fsd0(i,43)
      dpd0(i,068)=azbz(icontr(i))*dsd0(i,20)+fsd0(i,44)
      dpd0(i,069)=azbz(icontr(i))*dsd0(i,21)+fsd0(i,45)
      dpd0(i,070)=azbz(icontr(i))*dsd0(i,22)+fsd0(i,46)
      dpd0(i,071)=azbz(icontr(i))*dsd0(i,23)+fsd0(i,47)
      dpd0(i,072)=azbz(icontr(i))*dsd0(i,24)+fsd0(i,48)
      dpd0(i,073)=axbx(icontr(i))*dsd0(i,25)+fsd0(i,25)
      dpd0(i,074)=axbx(icontr(i))*dsd0(i,26)+fsd0(i,26)
      dpd0(i,075)=axbx(icontr(i))*dsd0(i,27)+fsd0(i,27)
      dpd0(i,076)=axbx(icontr(i))*dsd0(i,28)+fsd0(i,28)
      dpd0(i,077)=axbx(icontr(i))*dsd0(i,29)+fsd0(i,29)
      dpd0(i,078)=axbx(icontr(i))*dsd0(i,30)+fsd0(i,30)
      dpd0(i,079)=ayby(icontr(i))*dsd0(i,25)+fsd0(i,43)
      dpd0(i,080)=ayby(icontr(i))*dsd0(i,26)+fsd0(i,44)
      dpd0(i,081)=ayby(icontr(i))*dsd0(i,27)+fsd0(i,45)
      dpd0(i,082)=ayby(icontr(i))*dsd0(i,28)+fsd0(i,46)
      dpd0(i,083)=ayby(icontr(i))*dsd0(i,29)+fsd0(i,47)
      dpd0(i,084)=ayby(icontr(i))*dsd0(i,30)+fsd0(i,48)
      dpd0(i,085)=azbz(icontr(i))*dsd0(i,25)+fsd0(i,49)
      dpd0(i,086)=azbz(icontr(i))*dsd0(i,26)+fsd0(i,50)
      dpd0(i,087)=azbz(icontr(i))*dsd0(i,27)+fsd0(i,51)
      dpd0(i,088)=azbz(icontr(i))*dsd0(i,28)+fsd0(i,52)
      dpd0(i,089)=azbz(icontr(i))*dsd0(i,29)+fsd0(i,53)
      dpd0(i,090)=azbz(icontr(i))*dsd0(i,30)+fsd0(i,54)
      dpd0(i,091)=axbx(icontr(i))*dsd0(i,31)+fsd0(i,31)
      dpd0(i,092)=axbx(icontr(i))*dsd0(i,32)+fsd0(i,32)
      dpd0(i,093)=axbx(icontr(i))*dsd0(i,33)+fsd0(i,33)
      dpd0(i,094)=axbx(icontr(i))*dsd0(i,34)+fsd0(i,34)
      dpd0(i,095)=axbx(icontr(i))*dsd0(i,35)+fsd0(i,35)
      dpd0(i,096)=axbx(icontr(i))*dsd0(i,36)+fsd0(i,36)
      dpd0(i,097)=ayby(icontr(i))*dsd0(i,31)+fsd0(i,49)
      dpd0(i,098)=ayby(icontr(i))*dsd0(i,32)+fsd0(i,50)
      dpd0(i,099)=ayby(icontr(i))*dsd0(i,33)+fsd0(i,51)
      dpd0(i,100)=ayby(icontr(i))*dsd0(i,34)+fsd0(i,52)
      dpd0(i,101)=ayby(icontr(i))*dsd0(i,35)+fsd0(i,53)
      dpd0(i,102)=ayby(icontr(i))*dsd0(i,36)+fsd0(i,54)
      dpd0(i,103)=azbz(icontr(i))*dsd0(i,31)+fsd0(i,55)
      dpd0(i,104)=azbz(icontr(i))*dsd0(i,32)+fsd0(i,56)
      dpd0(i,105)=azbz(icontr(i))*dsd0(i,33)+fsd0(i,57)
      dpd0(i,106)=azbz(icontr(i))*dsd0(i,34)+fsd0(i,58)
      dpd0(i,107)=azbz(icontr(i))*dsd0(i,35)+fsd0(i,59)
 2033 dpd0(i,108)=azbz(icontr(i))*dsd0(i,36)+fsd0(i,60)

      do 2034 j=1,10
      do 2034 i=1,n
 2034 gather(i,j)=zero

      do 2035 j=1,18
      do 2035 i=1,n
 2035 gather(i,1)=gather(i,1)+dmat(inddyy(icontr(i),j))*dps0(i,j)

      do 2036 k=1,3
      do 2036 j=1,18
      do 2036 i=1,n
 2036 gather(i,k+1)=gather(i,k+1)
     &             +dmat(inddyy(icontr(i),j))*dpp0(i,3*(j-1)+k)

      do 2037 k=1,6
      do 2037 j=1,18
      do 2037 i=1,n
 2037 gather(i,k+4)=gather(i,k+4)
     &             +dmat(inddyy(icontr(i),j))*dpd0(i,6*(j-1)+k)

      do 2038 i=1,n
      gather(i,01)=gather(i,01)*cdfits
      gather(i,02)=gather(i,02)*cdfitp(1)
      gather(i,03)=gather(i,03)*cdfitp(2)
      gather(i,04)=gather(i,04)*cdfitp(3)
      gather(i,05)=gather(i,05)*cdfitd(1)
      gather(i,06)=gather(i,06)*cdfitd(2)
      gather(i,07)=gather(i,07)*cdfitd(3)
      gather(i,08)=gather(i,08)*cdfitd(4)
      gather(i,09)=gather(i,09)*cdfitd(5)
 2038 gather(i,10)=gather(i,10)*cdfitd(6)

      nc=ncds+(naux-1)*10

      do 2039 i=1,n
      do 2039 j=1,10
 2039 tvec(nc+j)=tvec(nc+j)+gather(i,j)

 2001 continue

      return
      end
