      subroutine cdftps(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                  iloc,g,coord,alphaaux,coeffs,coeffp,coeffd,tvec,
     &                  dmat,zeta,px,py,pz,base,pxax,pyay,pzaz,u,
     &                  zetarec,wxcx,wycy,wzcz,wxpx,wypy,wzpz,sss0,sss1,
     &                  sss2,sss3,pss,pss0,pss1,pss2,ssp1,psp,psp0,psp1,
     &                  psd,psd0,zetac1,zetac2,c,c1,c2,gather)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),iloc(*)

      dimension g(*),coord(3,*),alphaaux(*),coeffs(*),coeffp(*),
     &          coeffd(*),tvec(*),dmat(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),pxax(*),pyay(*),pzaz(*),u(*),zetarec(*),wxcx(*),
     &          wycy(*),wzcz(*),wxpx(*),wypy(*),wzpz(*),sss0(*),sss1(*),
     &          sss2(*),sss3(*),pss(m,*),pss0(n,*),pss1(n,*),pss2(n,*),
     &          ssp1(n,*),psp(m,*),psp0(n,*),psp1(n,*),psd(m,*),
     &          psd0(n,*),zetac1(*),zetac2(*),c(*),c1(n,*),c2(n,*),
     &          gather(n,*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data five,seven/5.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(2,n,iloc,u,psp0,sss0,sss1,sss2)

      do 1004 i=1,n
      sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,1)/zeta(i)/zetaux
 1004 sss1(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,2)/zeta(i)/zetaux

      do 1005 i=1,n
 1005 zetac1(i)=zetaux*zetarec(i)

      do 1006 i=1,n
      wxpx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-px(i)
      wypy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-py(i)
 1006 wzpz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-pz(i)

      do 1007 i=1,n
      pss0(i,1)=pxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=pyay(i)*sss0(i)+wypy(i)*sss1(i)
 1007 pss0(i,3)=pzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1008 i=1,n
 1008 gather(i,1)=zero

      do 1009 j=1,3
      do 1009 i=1,n
 1009 gather(i,1)=gather(i,1)+dmat(inddyy(icontr(i),j))*pss0(i,j)

      do 1010 i=1,n
 1010 gather(i,1)=gather(i,1)*cdfits

      do 1011 i=1,n
 1011 tvec(naux)=tvec(naux)+gather(i,1)

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      cdfitp(1)=coeffp(ilaux)
      cdfitp(2)=coeffp(ilaux)
      cdfitp(3)=coeffp(ilaux)

      cdfitd(1)=coeffd(ilaux)/dnormcd
      cdfitd(2)=coeffd(ilaux)
      cdfitd(3)=coeffd(ilaux)
      cdfitd(4)=coeffd(ilaux)/dnormcd
      cdfitd(5)=coeffd(ilaux)
      cdfitd(6)=coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(4,n,iloc,u,psp0,sss0,sss1,sss2)

      do 2004 i=1,n
      sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,3)/zeta(i)/zetaux
 2004 sss3(i)=base(i)*twoecnst*sqrt(zetarec(i))*psp0(i,4)/zeta(i)/zetaux

      do 2005 i=1,n
      zetac1(i)=zetaux*zetarec(i)
 2005 zetac2(i)=zeta(i)*zetarec(i)

      do 2006 i=1,n
      wxcx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-ccy
 2006 wzcz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2007 i=1,n
      wxpx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-px(i)
      wypy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-py(i)
 2007 wzpz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-pz(i)

      do 2008 i=1,n

      pss0(i,1)=pxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=pyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=pzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=pxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=pyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=pzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=pxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=pyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=pzaz(i)*sss2(i)+wzpz(i)*sss3(i)

 2008 continue

      do 2009 i=1,n
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 2009 ssp1(i,3)=wzcz(i)*sss2(i)

      do 2010 i=1,n

      c(i)=half*sss1(i)*zetarec(i)

      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
      psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2010 continue

      do 2011 j=1,3
      do 2011 i=1,n
 2011 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 2012 j=1,3
      do 2012 i=1,n
 2012 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 2013 i=1,n
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 2013 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 2014 j=1,10
      do 2014 i=1,n
 2014 gather(i,j)=zero

      do 2015 j=1,3
      do 2015 i=1,n
 2015 gather(i,1)=gather(i,1)+dmat(inddyy(icontr(i),j))*pss0(i,j)

      do 2016 k=1,3
      do 2016 j=1,3
      do 2016 i=1,n
 2016 gather(i,k+1)=gather(i,k+1)
     &             +dmat(inddyy(icontr(i),j))*psp0(i,3*(j-1)+k)

      do 2017 k=1,6
      do 2017 j=1,3
      do 2017 i=1,n
 2017 gather(i,k+4)=gather(i,k+4)
     &             +dmat(inddyy(icontr(i),j))*psd0(i,6*(j-1)+k)

      do 2018 i=1,n
      gather(i,01)=gather(i,01)*cdfits
      gather(i,02)=gather(i,02)*cdfitp(1)
      gather(i,03)=gather(i,03)*cdfitp(2)
      gather(i,04)=gather(i,04)*cdfitp(3)
      gather(i,05)=gather(i,05)*cdfitd(1)
      gather(i,06)=gather(i,06)*cdfitd(2)
      gather(i,07)=gather(i,07)*cdfitd(3)
      gather(i,08)=gather(i,08)*cdfitd(4)
      gather(i,09)=gather(i,09)*cdfitd(5)
 2018 gather(i,10)=gather(i,10)*cdfitd(6)

      nc=ncds+(naux-1)*10

      do 2019 i=1,n
      do 2019 j=1,10
 2019 tvec(nc+j)=tvec(nc+j)+gather(i,j)

 2001 continue

      return
      end
