      subroutine cdftss(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                  iloc,g,coord,alphaaux,coeffs,coeffp,coeffd,tvec,
     &                  dmat,zeta,px,py,pz,base,u,zetarec,wxcx,wycy,
     &                  wzcz,sss,sss0,sss1,sss2,ssp,ssp0,ssp1,ssd,ssd0,
     &                  zetac,c,gather)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(*),iloc(*)

      dimension g(*),coord(3,*),alphaaux(*),coeffs(*),coeffp(*),
     &          coeffd(*),tvec(*),dmat(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),sss(*),
     &          sss0(*),sss1(*),sss2(*),ssp(m,*),ssp0(n,*),ssp1(n,*),
     &          ssd(m,*),ssd0(n,*),zetac(*),c(*),gather(n,*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data five,seven/5.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(1,n,iloc,u,ssp0,sss0,sss1,sss2)

      do 1004 i=1,n
 1004 sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*ssp0(i,1)/zeta(i)/zetaux

      do 1005 i=1,n
 1005 gather(i,1)=dmat(inddyy(icontr(i)))*sss0(i)*cdfits

      do 1006 i=1,n
 1006 tvec(naux)=tvec(naux)+gather(i,1)

 1001 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=coeffs(ilaux)

      cdfitp(1)=coeffp(ilaux)
      cdfitp(2)=coeffp(ilaux)
      cdfitp(3)=coeffp(ilaux)

      cdfitd(1)=coeffd(ilaux)/dnormcd
      cdfitd(2)=coeffd(ilaux)
      cdfitd(3)=coeffd(ilaux)
      cdfitd(4)=coeffd(ilaux)/dnormcd
      cdfitd(5)=coeffd(ilaux)
      cdfitd(6)=coeffd(ilaux)/dnormcd

      do 2002 i=1,n
 2002 zetarec(i)=one/(zeta(i)+zetaux)

      do 2003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 2003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      call auggv(3,n,iloc,u,ssp0,sss0,sss1,sss2)

      do 2004 i=1,n
      sss0(i)=base(i)*twoecnst*sqrt(zetarec(i))*ssp0(i,1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoecnst*sqrt(zetarec(i))*ssp0(i,2)/zeta(i)/zetaux
 2004 sss2(i)=base(i)*twoecnst*sqrt(zetarec(i))*ssp0(i,3)/zeta(i)/zetaux

      do 2005 i=1,n
 2005 zetac(i)=zeta(i)*zetarec(i)

      do 2006 i=1,n
      wxcx(i)=((zeta(i)*px(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zeta(i)*py(i)+zetaux*ccy)*zetarec(i))-ccy
 2006 wzcz(i)=((zeta(i)*pz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2007 i=1,n

      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
      ssp0(i,3)=wzcz(i)*sss1(i)

      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
      ssp1(i,3)=wzcz(i)*sss2(i)

 2007 continue

      do 2008 i=1,n

      c(i)=(sss0(i)-zetac(i)*sss1(i))/(two*zetaux)

      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
      ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

 2008 continue

      do 2009 i=1,n
      gather(i,01)=dmat(inddyy(icontr(i)))*sss0(i)*cdfits
      gather(i,02)=dmat(inddyy(icontr(i)))*ssp0(i,1)*cdfitp(1)
      gather(i,03)=dmat(inddyy(icontr(i)))*ssp0(i,2)*cdfitp(2)
      gather(i,04)=dmat(inddyy(icontr(i)))*ssp0(i,3)*cdfitp(3)
      gather(i,05)=dmat(inddyy(icontr(i)))*ssd0(i,1)*cdfitd(1)
      gather(i,06)=dmat(inddyy(icontr(i)))*ssd0(i,2)*cdfitd(2)
      gather(i,07)=dmat(inddyy(icontr(i)))*ssd0(i,3)*cdfitd(3)
      gather(i,08)=dmat(inddyy(icontr(i)))*ssd0(i,4)*cdfitd(4)
      gather(i,09)=dmat(inddyy(icontr(i)))*ssd0(i,5)*cdfitd(5)
 2009 gather(i,10)=dmat(inddyy(icontr(i)))*ssd0(i,6)*cdfitd(6)

      nc=ncds+(naux-1)*10

      do 2010 i=1,n
      do 2010 j=1,10
 2010 tvec(nc+j)=tvec(nc+j)+gather(i,j)

 2001 continue

      return
      end
