      subroutine cdgrmm(natoms,ncds,ncdspd,ilfunc,icfunc,cdfitc,alpha,
     &                  coeffs,coeffp,coeffd,coord,gradient,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension istat(mpi_status_size)
 
      dimension ilfunc(*),icfunc(*)

      dimension cdfitc(*),alpha(*),coeffs(*),coeffp(*),coeffd(*)
      dimension coord(3,*),gradient(3,*),wkvec(*)

      data zero/0.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      do 1001 i=1,3*natoms
 1001 wkvec(i)=zero

      call cdgrss(ncds,ilfunc,icfunc,cdfitc,alpha,coeffs,coord,wkvec)

      call cdgrxs(ncds,ncdspd,ilfunc,icfunc,cdfitc,alpha,coeffs,coeffp,
     &            coeffd,coord,wkvec)

      call cdgrxx(ncds,ncdspd,ilfunc,icfunc,cdfitc,alpha,coeffs,coeffp,
     &            coeffd,coord,wkvec)

      call mpi_reduce(wkvec(1),wkvec(3*natoms+1),3*natoms,
     &                mpi_real8,mpi_sum,0,mpi_comm_world,ierr)

      if(myid.eq.0) then
                          do 1002 i=1,natoms
                          do 1002 j=1,3
 1002                     gradient(j,i)=gradient(j,i)
     &                                 +wkvec(3*natoms+3*(i-1)+j)
                    endif

      return
      end
