      subroutine cdpops(n,natoms,nmaxatoms,nbsystems,icfunc,nfuncatom,
     &                  isys,overlap,dmta,dmtb,cdnorm,pmat,smat,psvec,
     &                  population)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nfuncatom(*),icfunc(*),isys(nmaxatoms,*)

      dimension overlap(*),dmta(*),dmtb(*)
      dimension cdnorm(*),pmat(n,*),smat(n,*),psvec(*),population(*)

      data zero,half,one/0.0d0,0.5d0,1.0d0/

      ij=0

      do 1001 i=1,n
      do 1001 j=1,i
      ij=ij+1
      factor=half
      if(i.eq.j) factor=one
      pmat(i,j)=(dmta(ij)+dmtb(ij))*factor
 1001 pmat(j,i)=(dmta(ij)+dmtb(ij))*factor

      ij=0

      do 1002 i=1,n
      do 1002 j=1,i
      ij=ij+1
      smat(i,j)=overlap(ij)
 1002 smat(j,i)=overlap(ij)

      do 1003 j=1,n
 1003 psvec(j)=zero

      do 1004 k=1,n
 1004 call utility1(n,psvec,pmat(1,k),smat(1,k))

      do 1005 i=1,natoms
 1005 population(i)=zero

      do 1006 j=1,n
 1006 population(nfuncatom(j))=population(nfuncatom(j))+psvec(j)

      do 1007 i=1,nbsystems
 1007 cdnorm(i)=zero

      do 1008 i=1,nbsystems
      do 1008 j=1,isys(1,i)
 1008 cdnorm(i)=cdnorm(i)+population(isys(j+1,i))

      return
      end
