      subroutine chrgps(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                  iloc,itemp,g,coord,cdfitc,alphaaux,coeffs,
     &                  coeffp,coeffd,fock,zeta,px,py,pz,base,pxax,pyay,
     &                  pzaz,u,zetarec,wxcx,wycy,wzcz,wxpx,wypy,wzpz,
     &                  sss0,sss1,sss2,sss3,pss,pss0,pss1,pss2,ssp1,psp,
     &                  psp0,psp1,psd,psd0,zetac1,zetac2,c,c1,c2,zzeta,
     &                  ppx,ppy,ppz,ppxax,ppyay,ppzaz,gather,extent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),iloc(*),
     &          itemp(*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),pxax(*),pyay(*),pzaz(*),u(*),zetarec(*),wxcx(*),
     &          wycy(*),wzcz(*),wxpx(*),wypy(*),wzpz(*),sss0(*),sss1(*),
     &          sss2(*),sss3(*),pss(m,*),pss0(n,*),pss1(n,*),pss2(n,*),
     &          ssp1(n,*),psp(m,*),psp0(n,*),psp1(n,*),psd(m,*),
     &          psd0(n,*),zetac1(*),zetac2(*),c(*),c1(n,*),c2(n,*),
     &          zzeta(*),ppx(*),ppy(*),ppz(*),ppxax(*),ppyay(*),
     &          ppzaz(*),gather(n,*),extent(*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data four,five,six,seven/4.0d0,5.0d0,6.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/
      data rmultipole/16.7d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 i=1,n
 1001 extent(i)=(sqrt(two/zeta(i))*five+rmultipole)**2

      do 1002 j=1,3
      do 1002 i=1,n
 1002 gather(i,j)=zero

      do 1003 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      nn=0

      do 1004 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      pc=pxcx*pxcx+pycy*pycy+pzcz*pzcz
      if(extent(i).gt.pc) then
                                 nn=nn+1

                                 zetarec(nn)=one/(zeta(i)+zetaux)

                                 u(nn)=zetaux*zetarec(nn)*zeta(i)*pc

                                 iloc(nn)=i

                                 zzeta(nn)=zeta(i)

                                 ppx(nn)=px(i)
                                 ppy(nn)=py(i)
                                 ppz(nn)=pz(i)

                                 ppxax(nn)=pxax(i)
                                 ppyay(nn)=pyay(i)
                                 ppzaz(nn)=pzaz(i)
                          endif
 1004 continue

      if(nn.eq.0) goto 1003

      call auggnew(2,nn,n,itemp,u,psp0,wxcx,wycy,wzcz)

      factor=twoecnst/zetaux

      do 1005 i=1,nn
 1005 c(i)=base(iloc(i))*factor*sqrt(zetarec(i))/zzeta(i)

      do 1006 i=1,nn
      sss0(i)=c(i)*psp0(i,1)
 1006 sss1(i)=c(i)*psp0(i,2)

      do 1007 i=1,nn
 1007 zetac1(i)=zetaux*zetarec(i)

      do 1008 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1008 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1009 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1009 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 gather(iloc(i),j)=gather(iloc(i),j)+pss0(i,j)*cdfits

 1003 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      nn=0

      do 2002 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      pc=pxcx*pxcx+pycy*pycy+pzcz*pzcz
      if(extent(i).gt.pc) then
                                 nn=nn+1

                                 zetarec(nn)=one/(zeta(i)+zetaux)

                                 u(nn)=zetaux*zetarec(nn)*zeta(i)*pc

                                 iloc(nn)=i

                                 zzeta(nn)=zeta(i)

                                 ppx(nn)=px(i)
                                 ppy(nn)=py(i)
                                 ppz(nn)=pz(i)

                                 ppxax(nn)=pxax(i)
                                 ppyay(nn)=pyay(i)
                                 ppzaz(nn)=pzaz(i)
                          endif
 2002 continue

      if(nn.eq.0) goto 2001

      call auggnew(4,nn,n,itemp,u,psp0,wxcx,wycy,wzcz)

      factor=twoecnst/zetaux

      do 2003 i=1,nn
 2003 c(i)=base(iloc(i))*factor*sqrt(zetarec(i))/zzeta(i)

      do 2004 i=1,nn
      sss0(i)=c(i)*psp0(i,1)
      sss1(i)=c(i)*psp0(i,2)
      sss2(i)=c(i)*psp0(i,3)
 2004 sss3(i)=c(i)*psp0(i,4)

      do 2005 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 2005 zetac2(i)=zzeta(i)*zetarec(i)

      do 2006 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2006 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 2007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 2008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

 2008 continue

      do 2009 i=1,nn
      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
 2009 ssp1(i,3)=wzcz(i)*sss2(i)

      do 2010 i=1,nn

      c(i)=half*sss1(i)*zetarec(i)

      psp0(i,1)=wxcx(i)*pss1(i,1)+c(i)
      psp0(i,2)=wycy(i)*pss1(i,1)
      psp0(i,3)=wzcz(i)*pss1(i,1)
      psp0(i,4)=wxcx(i)*pss1(i,2)
      psp0(i,5)=wycy(i)*pss1(i,2)+c(i)
      psp0(i,6)=wzcz(i)*pss1(i,2)
      psp0(i,7)=wxcx(i)*pss1(i,3)
      psp0(i,8)=wycy(i)*pss1(i,3)
      psp0(i,9)=wzcz(i)*pss1(i,3)+c(i)

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 2010 continue

      do 2011 j=1,3
      do 2011 i=1,nn
 2011 c1(i,j)=(pss0(i,j)-zetac2(i)*pss1(i,j))/(two*zetaux)

      do 2012 j=1,3
      do 2012 i=1,nn
 2012 c2(i,j)=half*ssp1(i,j)*zetarec(i)

      do 2013 i=1,nn
      psd0(i,01)=wxcx(i)*psp1(i,1)+c1(i,1)+c2(i,1)
      psd0(i,02)=wycy(i)*psp1(i,1)
      psd0(i,03)=wzcz(i)*psp1(i,1)
      psd0(i,04)=wycy(i)*psp1(i,2)+c1(i,1)
      psd0(i,05)=wzcz(i)*psp1(i,2)
      psd0(i,06)=wzcz(i)*psp1(i,3)+c1(i,1)
      psd0(i,07)=wxcx(i)*psp1(i,4)+c1(i,2)
      psd0(i,08)=wycy(i)*psp1(i,4)        +c2(i,1)
      psd0(i,09)=wzcz(i)*psp1(i,4)
      psd0(i,10)=wycy(i)*psp1(i,5)+c1(i,2)+c2(i,2)
      psd0(i,11)=wzcz(i)*psp1(i,5)
      psd0(i,12)=wzcz(i)*psp1(i,6)+c1(i,2)
      psd0(i,13)=wxcx(i)*psp1(i,7)+c1(i,3)
      psd0(i,14)=wycy(i)*psp1(i,7)
      psd0(i,15)=wzcz(i)*psp1(i,7)        +c2(i,1)
      psd0(i,16)=wycy(i)*psp1(i,8)+c1(i,3)
      psd0(i,17)=wzcz(i)*psp1(i,8)        +c2(i,2)
 2013 psd0(i,18)=wzcz(i)*psp1(i,9)+c1(i,3)+c2(i,3)

      do 2014 j=1,3
      do 2014 i=1,nn
 2014 gather(iloc(i),j)=gather(iloc(i),j)
     &                 +pss0(i,j)*cdfits
     &                 +psp0(i,3*(j-1)+1)*cdfitp(1)
     &                 +psp0(i,3*(j-1)+2)*cdfitp(2)
     &                 +psp0(i,3*(j-1)+3)*cdfitp(3)
     &                 +psd0(i,6*(j-1)+1)*cdfitd(1)
     &                 +psd0(i,6*(j-1)+2)*cdfitd(2)
     &                 +psd0(i,6*(j-1)+3)*cdfitd(3)
     &                 +psd0(i,6*(j-1)+4)*cdfitd(4)
     &                 +psd0(i,6*(j-1)+5)*cdfitd(5)
     &                 +psd0(i,6*(j-1)+6)*cdfitd(6)

 2001 continue

      return
      end
