      subroutine chrgss(m,n,ncds,ncdspd,ilfunc,icfunc,icontr,inddyy,
     &                  iloc,itemp,g,coord,cdfitc,alphaaux,coeffs,
     &                  coeffp,coeffd,fock,zeta,px,py,pz,base,u,zetarec,
     &                  wxcx,wycy,wzcz,sss,sss0,sss1,sss2,ssp,ssp0,ssp1,
     &                  ssd,ssd0,zetac,c,zzeta,ppx,ppy,ppz,gather,
     &                  extent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(*),iloc(*),itemp(*)

      dimension g(*),coord(3,*),cdfitc(*),alphaaux(*),coeffs(*),
     &          coeffp(*),coeffd(*),fock(*),zeta(*),px(*),py(*),pz(*),
     &          base(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),sss(*),
     &          sss0(*),sss1(*),sss2(*),ssp(m,*),ssp0(n,*),ssp1(n,*),
     &          ssd(m,*),ssd0(n,*),zetac(*),c(*),zzeta(*),ppx(*),ppy(*),
     &          ppz(*),gather(*),extent(*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data four,five,six,seven/4.0d0,5.0d0,6.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/
      data rmultipole/16.7d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 i=1,n
 1001 extent(i)=(sqrt(two/zeta(i))*five+rmultipole)**2

      do 1002 i=1,n
 1002 gather(i)=zero

      do 1003 naux=1,ncds

      ilaux=ilfunc(naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      nn=0

      do 1004 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      pc=pxcx*pxcx+pycy*pycy+pzcz*pzcz
      if(extent(i).gt.pc) then
                                 nn=nn+1

                                 zetarec(nn)=one/(zeta(i)+zetaux)

                                 u(nn)=zetaux*zetarec(nn)*zeta(i)*pc

                                 iloc(nn)=i

                                 zzeta(nn)=zeta(i)
                          endif
 1004 continue

      if(nn.eq.0) goto 1003

      call auggnew(1,nn,n,itemp,u,ssp0,wxcx,wycy,wzcz)

      factor=twoecnst/zetaux

      do 1005 i=1,nn
 1005 c(i)=base(iloc(i))*factor*sqrt(zetarec(i))/zzeta(i)

      do 1006 i=1,nn
 1006 sss0(i)=c(i)*ssp0(i,1)

      do 1007 i=1,nn
 1007 gather(iloc(i))=gather(iloc(i))+sss0(i)*cdfits

 1003 continue

      do 2001 naux=1,ncdspd

      ilaux=ilfunc(ncds+naux)

      ccx=coord(1,icfunc(ilaux))
      ccy=coord(2,icfunc(ilaux))
      ccz=coord(3,icfunc(ilaux))

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(ncds+(naux-1)*10+1)*coeffs(ilaux)

      cdfitp(1)=cdfitc(ncds+(naux-1)*10+2)*coeffp(ilaux)
      cdfitp(2)=cdfitc(ncds+(naux-1)*10+3)*coeffp(ilaux)
      cdfitp(3)=cdfitc(ncds+(naux-1)*10+4)*coeffp(ilaux)

      cdfitd(1)=cdfitc(ncds+(naux-1)*10+05)*coeffd(ilaux)/dnormcd
      cdfitd(2)=cdfitc(ncds+(naux-1)*10+06)*coeffd(ilaux)
      cdfitd(3)=cdfitc(ncds+(naux-1)*10+07)*coeffd(ilaux)
      cdfitd(4)=cdfitc(ncds+(naux-1)*10+08)*coeffd(ilaux)/dnormcd
      cdfitd(5)=cdfitc(ncds+(naux-1)*10+09)*coeffd(ilaux)
      cdfitd(6)=cdfitc(ncds+(naux-1)*10+10)*coeffd(ilaux)/dnormcd

      nn=0

      do 2002 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      pc=pxcx*pxcx+pycy*pycy+pzcz*pzcz
      if(extent(i).gt.pc) then
                                 nn=nn+1

                                 zetarec(nn)=one/(zeta(i)+zetaux)

                                 u(nn)=zetaux*zetarec(nn)*zeta(i)*pc

                                 iloc(nn)=i

                                 zzeta(nn)=zeta(i)

                                 ppx(nn)=px(i)
                                 ppy(nn)=py(i)
                                 ppz(nn)=pz(i)
                          endif
 2002 continue

      if(nn.eq.0) goto 2001

      call auggnew(3,nn,n,itemp,u,ssp0,wxcx,wycy,wzcz)

      factor=twoecnst/zetaux

      do 2003 i=1,nn
 2003 c(i)=base(iloc(i))*factor*sqrt(zetarec(i))/zzeta(i)

      do 2004 i=1,nn
      sss0(i)=c(i)*ssp0(i,1)
      sss1(i)=c(i)*ssp0(i,2)
 2004 sss2(i)=c(i)*ssp0(i,3)

      do 2005 i=1,nn
 2005 zetac(i)=zzeta(i)*zetarec(i)

      do 2006 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 2006 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 2007 i=1,nn

      ssp0(i,1)=wxcx(i)*sss1(i)
      ssp0(i,2)=wycy(i)*sss1(i)
      ssp0(i,3)=wzcz(i)*sss1(i)

      ssp1(i,1)=wxcx(i)*sss2(i)
      ssp1(i,2)=wycy(i)*sss2(i)
      ssp1(i,3)=wzcz(i)*sss2(i)

 2007 continue

      do 2008 i=1,nn

      c(i)=(sss0(i)-zetac(i)*sss1(i))/(two*zetaux)

      ssd0(i,1)=wxcx(i)*ssp1(i,1)+c(i)
      ssd0(i,2)=wycy(i)*ssp1(i,1)
      ssd0(i,3)=wzcz(i)*ssp1(i,1)
      ssd0(i,4)=wycy(i)*ssp1(i,2)+c(i)
      ssd0(i,5)=wzcz(i)*ssp1(i,2)
      ssd0(i,6)=wzcz(i)*ssp1(i,3)+c(i)

 2008 continue

      do 2009 i=1,nn
 2009 gather(iloc(i))=gather(iloc(i))
     &               +sss0(i)*cdfits
     &               +ssp0(i,1)*cdfitp(1)
     &               +ssp0(i,2)*cdfitp(2)
     &               +ssp0(i,3)*cdfitp(3)
     &               +ssd0(i,1)*cdfitd(1)
     &               +ssd0(i,2)*cdfitd(2)
     &               +ssd0(i,3)*cdfitd(3)
     &               +ssd0(i,4)*cdfitd(4)
     &               +ssd0(i,5)*cdfitd(5)
     &               +ssd0(i,6)*cdfitd(6)

 2001 continue

      return
      end
