      subroutine compg0(ncntrt,npts,nd,natoms,nconts,ncontp,ncontd,
     &                  ilfunc,icfunc,ngauss,nptrs,nptrp,nptrd,cent,
     &                  alpha,coeff,x,y,z,qf,extent1,extent3,dcc,xx,yy,
     &                  zz,rr,rralpha,s,px,py,pz,dxx,dxy,dxz,dyy,dyz,
     &                  dzz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension cent(3,*),alpha(*),coeff(*)
      dimension x(*),y(*),z(*),qf(nd,*)
      dimension extent1(*),extent3(*),dcc(*)
      dimension xx(*),yy(*),zz(*),rr(*),rralpha(*)
      dimension s(*),px(*),py(*),pz(*)
      dimension dxx(*),dxy(*),dxz(*),dyy(*),dyz(*),dzz(*)

      common/valexp/expval(0:450000)

      data zero,half,one,two,three,five,expcut/0.0d0,0.5d0,1.0d0,
     &                                         2.0d0,3.0d0,5.0d0,45.0d0/
      data spacing,dspacing,six/0.0001d0,10000.0d0,6.0d0/

      rsqrt3=one/sqrt(three)

      dinv2=one/two
      dinv3=one/six

      call utility2(ncntrt,zero,extent3)

      k=0

      if(nconts.eq.0) return

      ncc=0

      do 1001 i=1,nconts

      ilabel=nptrs(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(i)) goto 1001

      k1=k+1

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      call utility2(npts,zero,qf(1,k1))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1002 nprimitive=iptr1,iptr2

      twozeta=-two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1003 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       qf(j,k1)=qf(j,k1)+s(j)

                              endif
 1003 continue
 1002 continue

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)

 1001 k=k+1

      if(ncontp.eq.0) return

      ncc=0

      do 1004 i=1,ncontp

      ilabel=nptrp(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(nconts+i)) goto 1004

      k1=k+1
      k2=k+2
      k3=k+3

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1005 l=1,3
 1005 call utility2(npts,zero,qf(1,k+l))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1006 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1007 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       px(j)=xx(j)*s(j)
                       py(j)=yy(j)*s(j)
                       pz(j)=zz(j)*s(j)

                       qf(j,k1)=qf(j,k1)+px(j)
                       qf(j,k2)=qf(j,k2)+py(j)
                       qf(j,k3)=qf(j,k3)+pz(j)

                               endif
 1007 continue
 1006 continue

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)
      extent3(k2)=sumsum(npts,qf(1,k2))/real64(npts)
      extent3(k3)=sumsum(npts,qf(1,k3))/real64(npts)

 1004 k=k+3

      if(ncontd.eq.0) return

      ncc=0

      do 1008 i=1,ncontd

      ilabel=nptrd(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(nconts+ncontp+i)) goto 1008

      k1=k+1
      k2=k+2
      k3=k+3
      k4=k+4
      k5=k+5
      k6=k+6

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1009 l=1,6
 1009 call utility2(npts,zero,qf(1,k+l))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1010 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1011 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       px(j)=xx(j)*s(j)
                       py(j)=yy(j)*s(j)
                       pz(j)=zz(j)*s(j)

                       dxx(j)=xx(j)*px(j)
                       dxy(j)=xx(j)*py(j)
                       dxz(j)=xx(j)*pz(j)
                       dyy(j)=yy(j)*py(j)
                       dyz(j)=yy(j)*pz(j)
                       dzz(j)=zz(j)*pz(j)

                       qf(j,k1)=qf(j,k1)+dxx(j)
                       qf(j,k2)=qf(j,k2)+dxy(j)
                       qf(j,k3)=qf(j,k3)+dxz(j)
                       qf(j,k4)=qf(j,k4)+dyy(j)
                       qf(j,k5)=qf(j,k5)+dyz(j)
                       qf(j,k6)=qf(j,k6)+dzz(j)

                               endif
 1011 continue
 1010 continue

      call utility5(npts,rsqrt3,qf(1,k1))
      call utility5(npts,rsqrt3,qf(1,k4))
      call utility5(npts,rsqrt3,qf(1,k6))

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)
      extent3(k2)=sumsum(npts,qf(1,k2))/real64(npts)
      extent3(k3)=sumsum(npts,qf(1,k3))/real64(npts)
      extent3(k4)=sumsum(npts,qf(1,k4))/real64(npts)
      extent3(k5)=sumsum(npts,qf(1,k5))/real64(npts)
      extent3(k6)=sumsum(npts,qf(1,k6))/real64(npts)

 1008 k=k+6

      return
      end
