      subroutine compg2(ncntrt,npts,nd,nconts,ncontp,ncontd,ilfunc,
     &                  icfunc,ngauss,nptrs,nptrp,nptrd,xcenter,ycenter,
     &                  zcenter,cent,alpha,coeff,x,y,z,qf,qx,qy,qz,q1,
     &                  q2,q3,q4,q5,q6,extent1,extent3,dcc,xx,yy,zz,rr,
     &                  rralpha,s,px,py,pz,dxx,dxy,dxz,dyy,dyz,dzz,fxxx,
     &                  fxxy,fxxz,fxyy,fxyz,fxzz,fyyy,fyyz,fyzz,fzzz,
     &                  gxxxx,gxxxy,gxxxz,gxxyy,gxxyz,gxxzz,gxyyy,gxyyz,
     &                  gxyzz,gxzzz,gyyyy,gyyyz,gyyzz,gyzzz,gzzzz)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension cent(3,*),alpha(*),coeff(*)
      dimension x(*),y(*),z(*),qf(nd,*),qx(nd,*),qy(nd,*),qz(nd,*)
      dimension q1(nd,*),q2(nd,*),q3(nd,*),q4(nd,*),q5(nd,*),q6(nd,*)
      dimension extent1(*),extent3(*),dcc(*)
      dimension xx(*),yy(*),zz(*),rr(*),rralpha(*)
      dimension s(*),px(*),py(*),pz(*)
      dimension dxx(*),dxy(*),dxz(*),dyy(*),dyz(*),dzz(*)
      dimension fxxx(*),fxxy(*),fxxz(*),fxyy(*),fxyz(*),
     &          fxzz(*),fyyy(*),fyyz(*),fyzz(*),fzzz(*)
      dimension gxxxx(*),gxxxy(*),gxxxz(*),gxxyy(*),gxxyz(*),
     &          gxxzz(*),gxyyy(*),gxyyz(*),gxyzz(*),gxzzz(*),
     &          gyyyy(*),gyyyz(*),gyyzz(*),gyzzz(*),gzzzz(*)

      common/valexp/expval(0:450000)

      data zero,half,one,two,three,five,expcut/0.0d0,0.5d0,1.0d0,
     &                                         2.0d0,3.0d0,5.0d0,45.0d0/
      data spacing,dspacing,six/0.0001d0,10000.0d0,6.0d0/

      rsqrt3=one/sqrt(three)

      dinv2=one/two
      dinv3=one/six

      call utility2(ncntrt,zero,extent3)

      k=0

      if(nconts.eq.0) return

      ncc=0

      do 1001 i=1,nconts

      ilabel=nptrs(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(i)) goto 1001

      k1=k+1

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      call utility2(npts,zero,qf(1,k1))
      call utility2(npts,zero,qx(1,k1))
      call utility2(npts,zero,qy(1,k1))
      call utility2(npts,zero,qz(1,k1))
      call utility2(npts,zero,q1(1,k1))
      call utility2(npts,zero,q2(1,k1))
      call utility2(npts,zero,q3(1,k1))
      call utility2(npts,zero,q4(1,k1))
      call utility2(npts,zero,q5(1,k1))
      call utility2(npts,zero,q6(1,k1))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1002 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1003 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       qf(j,k1)=qf(j,k1)+s(j)

                       s(j)=s(j)*twozeta

                       px(j)=xx(j)*s(j)
                       py(j)=yy(j)*s(j)
                       pz(j)=zz(j)*s(j)

                       qx(j,k1)=qx(j,k1)-px(j)
                       qy(j,k1)=qy(j,k1)-py(j)
                       qz(j,k1)=qz(j,k1)-pz(j)

                       px(j)=px(j)*twozeta
                       py(j)=py(j)*twozeta
                       pz(j)=pz(j)*twozeta

                       q1(j,k1)=q1(j,k1)+xx(j)*px(j)-s(j)
                       q2(j,k1)=q2(j,k1)+xx(j)*py(j)
                       q3(j,k1)=q3(j,k1)+xx(j)*pz(j)
                       q4(j,k1)=q4(j,k1)+yy(j)*py(j)-s(j)
                       q5(j,k1)=q5(j,k1)+yy(j)*pz(j)
                       q6(j,k1)=q6(j,k1)+zz(j)*pz(j)-s(j)

                               endif
 1003 continue
 1002 continue

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)

 1001 k=k+1

      if(ncontp.eq.0) return

      ncc=0

      do 1004 i=1,ncontp

      ilabel=nptrp(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(nconts+i)) goto 1004

      k1=k+1
      k2=k+2
      k3=k+3

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1005 l=1,3
      call utility2(npts,zero,qf(1,k+l))
      call utility2(npts,zero,qx(1,k+l))
      call utility2(npts,zero,qy(1,k+l))
      call utility2(npts,zero,qz(1,k+l))
      call utility2(npts,zero,q1(1,k+l))
      call utility2(npts,zero,q2(1,k+l))
      call utility2(npts,zero,q3(1,k+l))
      call utility2(npts,zero,q4(1,k+l))
      call utility2(npts,zero,q5(1,k+l))
 1005 call utility2(npts,zero,q6(1,k+l))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1006 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1007 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       px(j)=xx(j)*s(j)
                       py(j)=yy(j)*s(j)
                       pz(j)=zz(j)*s(j)

                       qf(j,k1)=qf(j,k1)+px(j)
                       qf(j,k2)=qf(j,k2)+py(j)
                       qf(j,k3)=qf(j,k3)+pz(j)

                       px(j)=px(j)*twozeta
                       py(j)=py(j)*twozeta
                       pz(j)=pz(j)*twozeta

                       dxx(j)=xx(j)*px(j)
                       dxy(j)=xx(j)*py(j)
                       dxz(j)=xx(j)*pz(j)
                       dyy(j)=yy(j)*py(j)
                       dyz(j)=yy(j)*pz(j)
                       dzz(j)=zz(j)*pz(j)

                       qx(j,k1)=qx(j,k1)-dxx(j)+s(j)
                       qy(j,k1)=qy(j,k1)-dxy(j)
                       qz(j,k1)=qz(j,k1)-dxz(j)

                       qx(j,k2)=qx(j,k2)-dxy(j)
                       qy(j,k2)=qy(j,k2)-dyy(j)+s(j)
                       qz(j,k2)=qz(j,k2)-dyz(j)

                       qx(j,k3)=qx(j,k3)-dxz(j)
                       qy(j,k3)=qy(j,k3)-dyz(j)
                       qz(j,k3)=qz(j,k3)-dzz(j)+s(j)

                       dxx(j)=dxx(j)*twozeta
                       dxy(j)=dxy(j)*twozeta
                       dxz(j)=dxz(j)*twozeta
                       dyy(j)=dyy(j)*twozeta
                       dyz(j)=dyz(j)*twozeta
                       dzz(j)=dzz(j)*twozeta

                       fxxx(j)=xx(j)*dxx(j)
                       fxxy(j)=xx(j)*dxy(j)
                       fxxz(j)=xx(j)*dxz(j)
                       fxyy(j)=xx(j)*dyy(j)
                       fxyz(j)=xx(j)*dyz(j)
                       fxzz(j)=xx(j)*dzz(j)
                       fyyy(j)=yy(j)*dyy(j)
                       fyyz(j)=yy(j)*dyz(j)
                       fyzz(j)=yy(j)*dzz(j)
                       fzzz(j)=zz(j)*dzz(j)

                       q1(j,k1)=q1(j,k1)+fxxx(j)-px(j)-px(j)-px(j)
                       q2(j,k1)=q2(j,k1)+fxxy(j)-py(j)
                       q3(j,k1)=q3(j,k1)+fxxz(j)-pz(j)
                       q4(j,k1)=q4(j,k1)+fxyy(j)-px(j)
                       q5(j,k1)=q5(j,k1)+fxyz(j)
                       q6(j,k1)=q6(j,k1)+fxzz(j)-px(j)

                       q1(j,k2)=q1(j,k2)+fxxy(j)-py(j)
                       q2(j,k2)=q2(j,k2)+fxyy(j)-px(j)
                       q3(j,k2)=q3(j,k2)+fxyz(j)
                       q4(j,k2)=q4(j,k2)+fyyy(j)-py(j)-py(j)-py(j)
                       q5(j,k2)=q5(j,k2)+fyyz(j)-pz(j)
                       q6(j,k2)=q6(j,k2)+fyzz(j)-py(j)

                       q1(j,k3)=q1(j,k3)+fxxz(j)-pz(j)
                       q2(j,k3)=q2(j,k3)+fxyz(j)
                       q3(j,k3)=q3(j,k3)+fxzz(j)-px(j)
                       q4(j,k3)=q4(j,k3)+fyyz(j)-pz(j)
                       q5(j,k3)=q5(j,k3)+fyzz(j)-py(j)
                       q6(j,k3)=q6(j,k3)+fzzz(j)-pz(j)-pz(j)-pz(j)

                               endif
 1007 continue
 1006 continue

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)
      extent3(k2)=sumsum(npts,qf(1,k2))/real64(npts)
      extent3(k3)=sumsum(npts,qf(1,k3))/real64(npts)

 1004 k=k+3

      if(ncontd.eq.0) return

      ncc=0

      do 1008 i=1,ncontd

      ilabel=nptrd(i)

      nc=icfunc(ilabel)

      if(dcc(nc).gt.extent1(nconts+ncontp+i)) goto 1008

      k1=k+1
      k2=k+2
      k3=k+3
      k4=k+4
      k5=k+5
      k6=k+6

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1009 l=1,6
      call utility2(npts,zero,qf(1,k+l))
      call utility2(npts,zero,qx(1,k+l))
      call utility2(npts,zero,qy(1,k+l))
      call utility2(npts,zero,qz(1,k+l))
      call utility2(npts,zero,q1(1,k+l))
      call utility2(npts,zero,q2(1,k+l))
      call utility2(npts,zero,q3(1,k+l))
      call utility2(npts,zero,q4(1,k+l))
      call utility2(npts,zero,q5(1,k+l))
 1009 call utility2(npts,zero,q6(1,k+l))

      if(nc.ne.ncc) then
                          call utilityb(npts,xx,x,cent(1,nc))
                          call utilityb(npts,yy,y,cent(2,nc))
                          call utilityb(npts,zz,z,cent(3,nc))

                          call utilityd(npts,rr,xx,yy,zz)
                    endif

      ncc=nc

      do 1010 nprimitive=iptr1,iptr2

      twozeta=two*alpha(nprimitive)

      call utilityc(npts,alpha(nprimitive),rralpha,rr)

      do 1011 j=1,npts
      if(rralpha(j).lt.expcut) then

                       iindex=int(rralpha(j)*dspacing+half)
                       avalue=real64(iindex)*spacing
                       diff=rralpha(j)-avalue

                       diff2=diff*diff

                       series=one-diff+dinv2*diff2-dinv3*diff2*diff

                       s(j)=coeff(nprimitive)*series*expval(iindex)

                       px(j)=xx(j)*s(j)
                       py(j)=yy(j)*s(j)
                       pz(j)=zz(j)*s(j)

                       dxx(j)=xx(j)*px(j)
                       dxy(j)=xx(j)*py(j)
                       dxz(j)=xx(j)*pz(j)
                       dyy(j)=yy(j)*py(j)
                       dyz(j)=yy(j)*pz(j)
                       dzz(j)=zz(j)*pz(j)

                       qf(j,k1)=qf(j,k1)+dxx(j)
                       qf(j,k2)=qf(j,k2)+dxy(j)
                       qf(j,k3)=qf(j,k3)+dxz(j)
                       qf(j,k4)=qf(j,k4)+dyy(j)
                       qf(j,k5)=qf(j,k5)+dyz(j)
                       qf(j,k6)=qf(j,k6)+dzz(j)

                       dxx(j)=dxx(j)*twozeta
                       dxy(j)=dxy(j)*twozeta
                       dxz(j)=dxz(j)*twozeta
                       dyy(j)=dyy(j)*twozeta
                       dyz(j)=dyz(j)*twozeta
                       dzz(j)=dzz(j)*twozeta

                       fxxx(j)=xx(j)*dxx(j)
                       fxxy(j)=xx(j)*dxy(j)
                       fxxz(j)=xx(j)*dxz(j)
                       fxyy(j)=xx(j)*dyy(j)
                       fxyz(j)=xx(j)*dyz(j)
                       fxzz(j)=xx(j)*dzz(j)
                       fyyy(j)=yy(j)*dyy(j)
                       fyyz(j)=yy(j)*dyz(j)
                       fyzz(j)=yy(j)*dzz(j)
                       fzzz(j)=zz(j)*dzz(j)

                       qx(j,k1)=qx(j,k1)-fxxx(j)+px(j)+px(j)
                       qy(j,k1)=qy(j,k1)-fxxy(j)
                       qz(j,k1)=qz(j,k1)-fxxz(j)

                       qx(j,k2)=qx(j,k2)-fxxy(j)+py(j)
                       qy(j,k2)=qy(j,k2)-fxyy(j)+px(j)
                       qz(j,k2)=qz(j,k2)-fxyz(j)

                       qx(j,k3)=qx(j,k3)-fxxz(j)+pz(j)
                       qy(j,k3)=qy(j,k3)-fxyz(j)
                       qz(j,k3)=qz(j,k3)-fxzz(j)+px(j)

                       qx(j,k4)=qx(j,k4)-fxyy(j)
                       qy(j,k4)=qy(j,k4)-fyyy(j)+py(j)+py(j)
                       qz(j,k4)=qz(j,k4)-fyyz(j)

                       qx(j,k5)=qx(j,k5)-fxyz(j)
                       qy(j,k5)=qy(j,k5)-fyyz(j)+pz(j)
                       qz(j,k5)=qz(j,k5)-fyzz(j)+py(j)

                       qx(j,k6)=qx(j,k6)-fxzz(j)
                       qy(j,k6)=qy(j,k6)-fyzz(j)
                       qz(j,k6)=qz(j,k6)-fzzz(j)+pz(j)+pz(j)

                       fxxx(j)=fxxx(j)*twozeta
                       fxxy(j)=fxxy(j)*twozeta
                       fxxz(j)=fxxz(j)*twozeta
                       fxyy(j)=fxyy(j)*twozeta
                       fxyz(j)=fxyz(j)*twozeta
                       fxzz(j)=fxzz(j)*twozeta
                       fyyy(j)=fyyy(j)*twozeta
                       fyyz(j)=fyyz(j)*twozeta
                       fyzz(j)=fyzz(j)*twozeta
                       fzzz(j)=fzzz(j)*twozeta

                       gxxxx(j)=xx(j)*fxxx(j)
                       gxxxy(j)=xx(j)*fxxy(j)
                       gxxxz(j)=xx(j)*fxxz(j)
                       gxxyy(j)=xx(j)*fxyy(j)
                       gxxyz(j)=xx(j)*fxyz(j)
                       gxxzz(j)=xx(j)*fxzz(j)
                       gxyyy(j)=xx(j)*fyyy(j)
                       gxyyz(j)=xx(j)*fyyz(j)
                       gxyzz(j)=xx(j)*fyzz(j)
                       gxzzz(j)=xx(j)*fzzz(j)
                       gyyyy(j)=yy(j)*fyyy(j)
                       gyyyz(j)=yy(j)*fyyz(j)
                       gyyzz(j)=yy(j)*fyzz(j)
                       gyzzz(j)=yy(j)*fzzz(j)
                       gzzzz(j)=zz(j)*fzzz(j)

                       q1(j,k1)=q1(j,k1)+gxxxx(j)+s(j)+s(j)-dxx(j)*five
                       q2(j,k1)=q2(j,k1)+gxxxy(j)-dxy(j)-dxy(j)
                       q3(j,k1)=q3(j,k1)+gxxxz(j)-dxz(j)-dxz(j)
                       q4(j,k1)=q4(j,k1)+gxxyy(j)-dxx(j)
                       q5(j,k1)=q5(j,k1)+gxxyz(j)
                       q6(j,k1)=q6(j,k1)+gxxzz(j)-dxx(j)

                       q1(j,k2)=q1(j,k2)+gxxxy(j)-dxy(j)-dxy(j)-dxy(j)
                       q2(j,k2)=q2(j,k2)+gxxyy(j)+s(j)-dyy(j)-dxx(j)
                       q3(j,k2)=q3(j,k2)+gxxyz(j)-dyz(j)
                       q4(j,k2)=q4(j,k2)+gxyyy(j)-dxy(j)-dxy(j)-dxy(j)
                       q5(j,k2)=q5(j,k2)+gxyyz(j)-dxz(j)
                       q6(j,k2)=q6(j,k2)+gxyzz(j)-dxy(j)

                       q1(j,k3)=q1(j,k3)+gxxxz(j)-dxz(j)-dxz(j)-dxz(j)
                       q2(j,k3)=q2(j,k3)+gxxyz(j)-dyz(j)
                       q3(j,k3)=q3(j,k3)+gxxzz(j)+s(j)-dzz(j)-dxx(j)
                       q4(j,k3)=q4(j,k3)+gxyyz(j)-dxz(j)
                       q5(j,k3)=q5(j,k3)+gxyzz(j)-dxy(j)
                       q6(j,k3)=q6(j,k3)+gxzzz(j)-dxz(j)-dxz(j)-dxz(j)

                       q1(j,k4)=q1(j,k4)+gxxyy(j)-dyy(j)
                       q2(j,k4)=q2(j,k4)+gxyyy(j)-dxy(j)-dxy(j)
                       q3(j,k4)=q3(j,k4)+gxyyz(j)
                       q4(j,k4)=q4(j,k4)+gyyyy(j)+s(j)+s(j)-dyy(j)*five
                       q5(j,k4)=q5(j,k4)+gyyyz(j)-dyz(j)-dyz(j)
                       q6(j,k4)=q6(j,k4)+gyyzz(j)-dyy(j)

                       q1(j,k5)=q1(j,k5)+gxxyz(j)-dyz(j)
                       q2(j,k5)=q2(j,k5)+gxyyz(j)-dxz(j)
                       q3(j,k5)=q3(j,k5)+gxyzz(j)-dxy(j)
                       q4(j,k5)=q4(j,k5)+gyyyz(j)-dyz(j)-dyz(j)-dyz(j)
                       q5(j,k5)=q5(j,k5)+gyyzz(j)+s(j)-dzz(j)-dyy(j)
                       q6(j,k5)=q6(j,k5)+gyzzz(j)-dyz(j)-dyz(j)-dyz(j)

                       q1(j,k6)=q1(j,k6)+gxxzz(j)-dzz(j)
                       q2(j,k6)=q2(j,k6)+gxyzz(j)
                       q3(j,k6)=q3(j,k6)+gxzzz(j)-dxz(j)-dxz(j)
                       q4(j,k6)=q4(j,k6)+gyyzz(j)-dzz(j)
                       q5(j,k6)=q5(j,k6)+gyzzz(j)-dyz(j)-dyz(j)
                       q6(j,k6)=q6(j,k6)+gzzzz(j)+s(j)+s(j)-dzz(j)*five

                               endif
 1011 continue
 1010 continue

      call utility5(npts,rsqrt3,qf(1,k1))
      call utility5(npts,rsqrt3,qf(1,k4))
      call utility5(npts,rsqrt3,qf(1,k6))

      call utility5(npts,rsqrt3,qx(1,k1))
      call utility5(npts,rsqrt3,qx(1,k4))
      call utility5(npts,rsqrt3,qx(1,k6))

      call utility5(npts,rsqrt3,qy(1,k1))
      call utility5(npts,rsqrt3,qy(1,k4))
      call utility5(npts,rsqrt3,qy(1,k6))

      call utility5(npts,rsqrt3,qz(1,k1))
      call utility5(npts,rsqrt3,qz(1,k4))
      call utility5(npts,rsqrt3,qz(1,k6))

      call utility5(npts,rsqrt3,q1(1,k1))
      call utility5(npts,rsqrt3,q1(1,k4))
      call utility5(npts,rsqrt3,q1(1,k6))

      call utility5(npts,rsqrt3,q2(1,k1))
      call utility5(npts,rsqrt3,q2(1,k4))
      call utility5(npts,rsqrt3,q2(1,k6))

      call utility5(npts,rsqrt3,q3(1,k1))
      call utility5(npts,rsqrt3,q3(1,k4))
      call utility5(npts,rsqrt3,q3(1,k6))

      call utility5(npts,rsqrt3,q4(1,k1))
      call utility5(npts,rsqrt3,q4(1,k4))
      call utility5(npts,rsqrt3,q4(1,k6))

      call utility5(npts,rsqrt3,q5(1,k1))
      call utility5(npts,rsqrt3,q5(1,k4))
      call utility5(npts,rsqrt3,q5(1,k6))

      call utility5(npts,rsqrt3,q6(1,k1))
      call utility5(npts,rsqrt3,q6(1,k4))
      call utility5(npts,rsqrt3,q6(1,k6))

      extent3(k1)=sumsum(npts,qf(1,k1))/real64(npts)
      extent3(k2)=sumsum(npts,qf(1,k2))/real64(npts)
      extent3(k3)=sumsum(npts,qf(1,k3))/real64(npts)
      extent3(k4)=sumsum(npts,qf(1,k4))/real64(npts)
      extent3(k5)=sumsum(npts,qf(1,k5))/real64(npts)
      extent3(k6)=sumsum(npts,qf(1,k6))/real64(npts)

 1008 k=k+6

      return
      end
