      subroutine coredp(m,n,ncentr,icontr,inddyy,iloc,coord,charge,
     &                  overlap,core,zeta,zetaa,axbx,ayby,azbz,px,py,
     &                  pz,pxax,pyay,pzaz,pxbx,pyby,pzbz,eta,base,etarr,
     &                  ss,ss0,ss1,ss2,ss3,ps,ps0,ps1,ps2,ds0,ds1,fs0,
     &                  dp,dpcond,c,c1,pxcx,pycy,pzcz,u,twozeta,eta2)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*),iloc(*)

      dimension coord(3,*),charge(*),overlap(*),core(*),zeta(*),
     &          zetaa(*),axbx(*),ayby(*),azbz(*),px(*),py(*),pz(*),
     &          pxax(*),pyay(*),pzaz(*),pxbx(*),pyby(*),pzbz(*),eta(*),
     &          base(*),etarr(*),ss(*),ss0(*),ss1(*),ss2(*),ss3(*),
     &          ps(n,*),ps0(n,*),ps1(n,*),ps2(n,*),ds0(n,*),ds1(n,*),
     &          fs0(n,*),dp(n,*),dpcond(n,*),c(*),c1(n,*),pxcx(*),
     &          pycy(*),pzcz(*),u(*),twozeta(*),eta2(*)

      data zero,thrhlf,two,three,pi/0.0d0,1.5d0,
     &                              2.0d0,3.0d0,3.1415926535898d0/

      sqrt3=sqrt(three)

      do 1001 i=1,n
      eta2(i)=two*eta(i)
 1001 twozeta(i)=two*zeta(i)

      do 1002 i=1,n
 1002 ss0(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1003 i=1,n
      ps0(i,1)=pxax(i)*ss0(i)
      ps0(i,2)=pyay(i)*ss0(i)
 1003 ps0(i,3)=pzaz(i)*ss0(i)

      do 1004 i=1,n
 1004 c(i)=ss0(i)/twozeta(i)

      do 1005 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)
 1005 ds0(i,6)=pzaz(i)*ps0(i,3)+c(i)

      do 1006 j=1,3
      do 1006 i=1,n
 1006 c1(i,j)=ps0(i,j)/twozeta(i)

      do 1007 i=1,n
      dp(i,01)=pxbx(i)*ds0(i,1)+c1(i,1)*two
      dp(i,02)=pyby(i)*ds0(i,1)
      dp(i,03)=pzbz(i)*ds0(i,1)
      dp(i,04)=pxbx(i)*ds0(i,2)+c1(i,2)
      dp(i,05)=pyby(i)*ds0(i,2)+c1(i,1)
      dp(i,06)=pzbz(i)*ds0(i,2)
      dp(i,07)=pxbx(i)*ds0(i,3)+c1(i,3)
      dp(i,08)=pyby(i)*ds0(i,3)
      dp(i,09)=pzbz(i)*ds0(i,3)+c1(i,1)
      dp(i,10)=pxbx(i)*ds0(i,4)
      dp(i,11)=pyby(i)*ds0(i,4)+c1(i,2)*two
      dp(i,12)=pzbz(i)*ds0(i,4)
      dp(i,13)=pxbx(i)*ds0(i,5)
      dp(i,14)=pyby(i)*ds0(i,5)+c1(i,3)
      dp(i,15)=pzbz(i)*ds0(i,5)+c1(i,2)
      dp(i,16)=pxbx(i)*ds0(i,6)
      dp(i,17)=pyby(i)*ds0(i,6)
 1007 dp(i,18)=pzbz(i)*ds0(i,6)+c1(i,3)*two

      do 1008 j=1,18
      do 1008 i=1,n
 1008 overlap(inddyy(icontr(i),j))=overlap(inddyy(icontr(i),j))+dp(i,j)

      do 1009 i=1,n
 1009 ss(i)=eta(i)*(three-two*etarr(i))*ss0(i)

      do 1010 i=1,n
      ps(i,1)=pxax(i)*ss(i)+eta2(i)*ps0(i,1)
      ps(i,2)=pyay(i)*ss(i)+eta2(i)*ps0(i,2)
 1010 ps(i,3)=pzaz(i)*ss(i)+eta2(i)*ps0(i,3)

      do 1011 i=1,n
 1011 c(i)=ss(i)/twozeta(i)-eta2(i)*ss0(i)/(two*zetaa(i))

      do 1012 i=1,n
      ds1(i,1)=pxax(i)*ps(i,1)+eta2(i)*ds0(i,1)+c(i)
      ds1(i,2)=pyay(i)*ps(i,1)+eta2(i)*ds0(i,2)
      ds1(i,3)=pzaz(i)*ps(i,1)+eta2(i)*ds0(i,3)
      ds1(i,4)=pyay(i)*ps(i,2)+eta2(i)*ds0(i,4)+c(i)
      ds1(i,5)=pzaz(i)*ps(i,2)+eta2(i)*ds0(i,5)
 1012 ds1(i,6)=pzaz(i)*ps(i,3)+eta2(i)*ds0(i,6)+c(i)

      do 1013 j=1,3
      do 1013 i=1,n
 1013 c1(i,j)=ps(i,j)/twozeta(i)

      do 1014 i=1,n
      dp(i,01)=pxbx(i)*ds1(i,1)+eta2(i)*dp(i,01)+c1(i,1)*two
      dp(i,02)=pyby(i)*ds1(i,1)+eta2(i)*dp(i,02)
      dp(i,03)=pzbz(i)*ds1(i,1)+eta2(i)*dp(i,03)
      dp(i,04)=pxbx(i)*ds1(i,2)+eta2(i)*dp(i,04)+c1(i,2)
      dp(i,05)=pyby(i)*ds1(i,2)+eta2(i)*dp(i,05)+c1(i,1)
      dp(i,06)=pzbz(i)*ds1(i,2)+eta2(i)*dp(i,06)
      dp(i,07)=pxbx(i)*ds1(i,3)+eta2(i)*dp(i,07)+c1(i,3)
      dp(i,08)=pyby(i)*ds1(i,3)+eta2(i)*dp(i,08)
      dp(i,09)=pzbz(i)*ds1(i,3)+eta2(i)*dp(i,09)+c1(i,1)
      dp(i,10)=pxbx(i)*ds1(i,4)+eta2(i)*dp(i,10)
      dp(i,11)=pyby(i)*ds1(i,4)+eta2(i)*dp(i,11)+c1(i,2)*two
      dp(i,12)=pzbz(i)*ds1(i,4)+eta2(i)*dp(i,12)
      dp(i,13)=pxbx(i)*ds1(i,5)+eta2(i)*dp(i,13)
      dp(i,14)=pyby(i)*ds1(i,5)+eta2(i)*dp(i,14)+c1(i,3)
      dp(i,15)=pzbz(i)*ds1(i,5)+eta2(i)*dp(i,15)+c1(i,2)
      dp(i,16)=pxbx(i)*ds1(i,6)+eta2(i)*dp(i,16)
      dp(i,17)=pyby(i)*ds1(i,6)+eta2(i)*dp(i,17)
 1014 dp(i,18)=pzbz(i)*ds1(i,6)+eta2(i)*dp(i,18)+c1(i,3)*two

      do 1015 j=1,18
      do 1015 i=1,n
 1015 core(inddyy(icontr(i),j))=core(inddyy(icontr(i),j))+dp(i,j)

      do 1016 j=1,18
      do 1016 i=1,n
 1016 dpcond(i,j)=zero

      do 2001 nn=1,ncentr

      ccx=coord(1,nn)
      ccy=coord(2,nn)
      ccz=coord(3,nn)

      twopichrg=two*pi*charge(nn)

      do 2002 i=1,n
      pxcx(i)=px(i)-ccx
      pycy(i)=py(i)-ccy
      pzcz(i)=pz(i)-ccz
 2002 u(i)=zeta(i)*(pxcx(i)*pxcx(i)+pycy(i)*pycy(i)+pzcz(i)*pzcz(i))

      call auggv(4,n,iloc,u,ds0,ss0,ss1,ss2)

      do 2003 i=1,n
      ss0(i)=base(i)*ds0(i,1)*twopichrg/zeta(i)
      ss1(i)=base(i)*ds0(i,2)*twopichrg/zeta(i)
      ss2(i)=base(i)*ds0(i,3)*twopichrg/zeta(i)
 2003 ss3(i)=base(i)*ds0(i,4)*twopichrg/zeta(i)

      do 2004 i=1,n

      ps0(i,1)=pxax(i)*ss0(i)-pxcx(i)*ss1(i)
      ps0(i,2)=pyay(i)*ss0(i)-pycy(i)*ss1(i)
      ps0(i,3)=pzaz(i)*ss0(i)-pzcz(i)*ss1(i)

      ps1(i,1)=pxax(i)*ss1(i)-pxcx(i)*ss2(i)
      ps1(i,2)=pyay(i)*ss1(i)-pycy(i)*ss2(i)
      ps1(i,3)=pzaz(i)*ss1(i)-pzcz(i)*ss2(i)

      ps2(i,1)=pxax(i)*ss2(i)-pxcx(i)*ss3(i)
      ps2(i,2)=pyay(i)*ss2(i)-pycy(i)*ss3(i)
      ps2(i,3)=pzaz(i)*ss2(i)-pzcz(i)*ss3(i)

 2004 continue

      do 2005 i=1,n
 2005 c(i)=(ss0(i)-ss1(i))/twozeta(i)

      do 2006 i=1,n
      ds0(i,1)=pxax(i)*ps0(i,1)-pxcx(i)*ps1(i,1)+c(i)
      ds0(i,2)=pyay(i)*ps0(i,1)-pycy(i)*ps1(i,1)
      ds0(i,3)=pzaz(i)*ps0(i,1)-pzcz(i)*ps1(i,1)
      ds0(i,4)=pyay(i)*ps0(i,2)-pycy(i)*ps1(i,2)+c(i)
      ds0(i,5)=pzaz(i)*ps0(i,2)-pzcz(i)*ps1(i,2)
 2006 ds0(i,6)=pzaz(i)*ps0(i,3)-pzcz(i)*ps1(i,3)+c(i)

      do 2007 i=1,n
 2007 c(i)=(ss1(i)-ss2(i))/twozeta(i)

      do 2008 i=1,n
      ds1(i,1)=pxax(i)*ps1(i,1)-pxcx(i)*ps2(i,1)+c(i)
      ds1(i,2)=pyay(i)*ps1(i,1)-pycy(i)*ps2(i,1)
      ds1(i,3)=pzaz(i)*ps1(i,1)-pzcz(i)*ps2(i,1)
      ds1(i,4)=pyay(i)*ps1(i,2)-pycy(i)*ps2(i,2)+c(i)
      ds1(i,5)=pzaz(i)*ps1(i,2)-pzcz(i)*ps2(i,2)
 2008 ds1(i,6)=pzaz(i)*ps1(i,3)-pzcz(i)*ps2(i,3)+c(i)

      do 2009 j=1,3
      do 2009 i=1,n
 2009 c1(i,j)=(ps0(i,j)-ps1(i,j))/twozeta(i)

      do 2010 i=1,n
      fs0(i,01)=pxax(i)*ds0(i,1)-pxcx(i)*ds1(i,1)+c1(i,1)*two
      fs0(i,02)=pyay(i)*ds0(i,1)-pycy(i)*ds1(i,1)
      fs0(i,03)=pzaz(i)*ds0(i,1)-pzcz(i)*ds1(i,1)
      fs0(i,04)=pyay(i)*ds0(i,2)-pycy(i)*ds1(i,2)+c1(i,1)
      fs0(i,05)=pzaz(i)*ds0(i,2)-pzcz(i)*ds1(i,2)
      fs0(i,06)=pzaz(i)*ds0(i,3)-pzcz(i)*ds1(i,3)+c1(i,1)
      fs0(i,07)=pyay(i)*ds0(i,4)-pycy(i)*ds1(i,4)+c1(i,2)*two
      fs0(i,08)=pzaz(i)*ds0(i,4)-pzcz(i)*ds1(i,4)
      fs0(i,09)=pzaz(i)*ds0(i,5)-pzcz(i)*ds1(i,5)+c1(i,2)
 2010 fs0(i,10)=pzaz(i)*ds0(i,6)-pzcz(i)*ds1(i,6)+c1(i,3)*two

      do 2011 i=1,n
      dpcond(i,01)=dpcond(i,01)+axbx(icontr(i))*ds0(i,1)+fs0(i,01)
      dpcond(i,02)=dpcond(i,02)+ayby(icontr(i))*ds0(i,1)+fs0(i,02)
      dpcond(i,03)=dpcond(i,03)+azbz(icontr(i))*ds0(i,1)+fs0(i,03)
      dpcond(i,04)=dpcond(i,04)+axbx(icontr(i))*ds0(i,2)+fs0(i,02)
      dpcond(i,05)=dpcond(i,05)+ayby(icontr(i))*ds0(i,2)+fs0(i,04)
      dpcond(i,06)=dpcond(i,06)+azbz(icontr(i))*ds0(i,2)+fs0(i,05)
      dpcond(i,07)=dpcond(i,07)+axbx(icontr(i))*ds0(i,3)+fs0(i,03)
      dpcond(i,08)=dpcond(i,08)+ayby(icontr(i))*ds0(i,3)+fs0(i,05)
      dpcond(i,09)=dpcond(i,09)+azbz(icontr(i))*ds0(i,3)+fs0(i,06)
      dpcond(i,10)=dpcond(i,10)+axbx(icontr(i))*ds0(i,4)+fs0(i,04)
      dpcond(i,11)=dpcond(i,11)+ayby(icontr(i))*ds0(i,4)+fs0(i,07)
      dpcond(i,12)=dpcond(i,12)+azbz(icontr(i))*ds0(i,4)+fs0(i,08)
      dpcond(i,13)=dpcond(i,13)+axbx(icontr(i))*ds0(i,5)+fs0(i,05)
      dpcond(i,14)=dpcond(i,14)+ayby(icontr(i))*ds0(i,5)+fs0(i,08)
      dpcond(i,15)=dpcond(i,15)+azbz(icontr(i))*ds0(i,5)+fs0(i,09)
      dpcond(i,16)=dpcond(i,16)+axbx(icontr(i))*ds0(i,6)+fs0(i,06)
      dpcond(i,17)=dpcond(i,17)+ayby(icontr(i))*ds0(i,6)+fs0(i,09)
 2011 dpcond(i,18)=dpcond(i,18)+azbz(icontr(i))*ds0(i,6)+fs0(i,10)

 2001 continue

      do 2012 j=1,18
      do 2012 i=1,n
 2012 core(inddyy(icontr(i),j))=core(inddyy(icontr(i),j))-dpcond(i,j)

      return
      end
