      subroutine ddiis(iunit,nalpha,nbeta,niteration,ncnt,iwkvec,dmix,
     &                 elevelshift,focka,fockb,amat,bmat,wkmat1,wkmat2,
     &                 wkmat3,overlap,ematrix,wkvec)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      parameter(maxdiis=250)

      dimension bmatrix(maxdiis,maxdiis),bbmatrix(maxdiis,maxdiis)

      dimension iwkvec(*)

      dimension focka(*),fockb(*),amat(*),bmat(*)

      dimension wkmat1(ncnt,*),wkmat2(ncnt,*),wkmat3(ncnt,*),
     &          overlap(ncnt,*),ematrix(ncnt,*),wkvec(*)

      data zero,half,one,two,startdiis/0.0d0,0.5d0,1.0d0,2.0d0,9999.9d0/

      save ndiiss,ndiisw,bmatrix

      diis_start=startdiis
      if(dmix.lt.one) diis_start=dmix

      ncntsq=ncnt**2

      if(mod(niteration,2).eq.1) then
                                       iunita=iunit+0
                                       iunitb=iunit+2
                                       iunite=iunit+1

                                       junita=iunit+5
                                       junitb=iunit+3
                                       junite=iunit+4
                                 else
                                       junita=iunit+0
                                       junitb=iunit+2
                                       junite=iunit+1

                                       iunita=iunit+5
                                       iunitb=iunit+3
                                       iunite=iunit+4
                                 endif

      if(niteration.gt.1) goto 1002

      ndiiss=0

      do 1001 i=1,maxdiis
      bmatrix(i,1)=-one
 1001 bmatrix(1,i)=-one

      bmatrix(1,1)=zero

      return

 1002 continue

      if(ndiiss.eq.0) then

                rewind 45

                call fastrd(45,overlap,ncntsq)

                ij=0
                do 1003 i=1,ncnt
                do 1003 j=1,i
                ij=ij+1
                wkmat1(i,j)=focka(ij)
 1003           wkmat1(j,i)=focka(ij)

                ij=0
                do 1004 i=1,ncnt
                do 1004 j=1,i
                ij=ij+1
                wkmat2(i,j)=half*amat(ij)
 1004           wkmat2(j,i)=half*amat(ij)

                do 1005 i=1,ncnt
 1005           wkmat2(i,i)=wkmat2(i,i)*two

                call mxmy(ncnt,wkmat2,wkmat1,wkmat3)
                call mxmz(ncnt,iwkvec,overlap,wkmat3,ematrix)
                call mxmy(ncnt,wkmat2,overlap,wkmat3)
                call mxmz(ncnt,iwkvec,wkmat1,wkmat3,wkmat2)

                do 1006 j=1,ncnt
                do 1006 i=1,ncnt
 1006           ematrix(i,j)=wkmat2(i,j)-ematrix(i,j)

                rewind iunita

                call fastwr(iunita,wkmat1,ncntsq)

                if(nalpha.ne.nbeta) then

                          ij=0
                          do 1007 i=1,ncnt
                          do 1007 j=1,i
                          ij=ij+1
                          wkmat1(i,j)=fockb(ij)
 1007                     wkmat1(j,i)=fockb(ij)

                          ij=0
                          do 1008 i=1,ncnt
                          do 1008 j=1,i
                          ij=ij+1
                          wkmat2(i,j)=half*bmat(ij)
 1008                     wkmat2(j,i)=half*bmat(ij)

                          do 1009 i=1,ncnt
 1009                     wkmat2(i,i)=wkmat2(i,i)*two

                          call mxmy(ncnt,wkmat2,wkmat1,wkmat3)
                          call mxmz(ncnt,iwkvec,overlap,wkmat3,wkmat2)

                          do 1010 j=1,ncnt
                          do 1010 i=1,ncnt
 1010                     ematrix(i,j)=ematrix(i,j)-wkmat2(i,j)

                          ij=0
                          do 1011 i=1,ncnt
                          do 1011 j=1,i
                          ij=ij+1
                          wkmat2(i,j)=half*bmat(ij)
 1011                     wkmat2(j,i)=half*bmat(ij)

                          do 1012 i=1,ncnt
 1012                     wkmat2(i,i)=wkmat2(i,i)*two

                          call mxmy(ncnt,wkmat2,overlap,wkmat3)
                          call mxmz(ncnt,iwkvec,wkmat1,wkmat3,wkmat2)

                          do 1013 j=1,ncnt
                          do 1013 i=1,ncnt
 1013                     ematrix(i,j)=ematrix(i,j)+wkmat2(i,j)

                          rewind iunitb

                          call fastwr(iunitb,wkmat1,ncntsq)

                                    endif

                rewind iunite

                call fastwr(iunite,ematrix,ncntsq)

                emax=zero

                do 1014 i=1,ncnt
                do 1014 j=1,ncnt
 1014           if(abs(ematrix(i,j)).gt.emax) emax=abs(ematrix(i,j))

                if((diis_start.lt.one).and.(niteration.le.5)) return
                if(emax.gt.diis_start) return

                dmix=one

                ndiiss=1

                ndiisw=niteration

                bmatrix(2,2)=zero

                do 1015 j=1,ncnt
                do 1015 i=1,ncnt
 1015           bmatrix(2,2)=bmatrix(2,2)+ematrix(i,j)**2

                return

                      endif

      rewind 45

      call fastrd(45,overlap,ncntsq)

      ij=0
      do 1016 i=1,ncnt
      do 1016 j=1,i
      ij=ij+1
      wkmat1(i,j)=focka(ij)
 1016 wkmat1(j,i)=focka(ij)

      ij=0
      do 1017 i=1,ncnt
      do 1017 j=1,i
      ij=ij+1
      wkmat2(i,j)=half*amat(ij)
 1017 wkmat2(j,i)=half*amat(ij)

      do 1018 i=1,ncnt
 1018 wkmat2(i,i)=wkmat2(i,i)*two

      call mxmy(ncnt,wkmat2,wkmat1,wkmat3)
      call mxmz(ncnt,iwkvec,overlap,wkmat3,ematrix)
      call mxmy(ncnt,wkmat2,overlap,wkmat3)
      call mxmz(ncnt,iwkvec,wkmat1,wkmat3,wkmat2)

      do 1019 j=1,ncnt
      do 1019 i=1,ncnt
 1019 ematrix(i,j)=wkmat2(i,j)-ematrix(i,j)

      nn_start=ndiisw
      nn_end=niteration

      rewind iunita
      rewind junita

      do 1020 k=nn_start,nn_end-1
      call fastrd(junita,wkmat2,ncntsq)
 1020 call fastwr(iunita,wkmat2,ncntsq)

      call fastwr(iunita,wkmat1,ncntsq)

      if(nalpha.ne.nbeta) then

                          ij=0
                          do 1021 i=1,ncnt
                          do 1021 j=1,i
                          ij=ij+1
                          wkmat1(i,j)=fockb(ij)
 1021                     wkmat1(j,i)=fockb(ij)

                          ij=0
                          do 1022 i=1,ncnt
                          do 1022 j=1,i
                          ij=ij+1
                          wkmat2(i,j)=half*bmat(ij)
 1022                     wkmat2(j,i)=half*bmat(ij)

                          do 1023 i=1,ncnt
 1023                     wkmat2(i,i)=wkmat2(i,i)*two

                          call mxmy(ncnt,wkmat2,wkmat1,wkmat3)
                          call mxmz(ncnt,iwkvec,overlap,wkmat3,wkmat2)

                          do 1024 j=1,ncnt
                          do 1024 i=1,ncnt
 1024                     ematrix(i,j)=ematrix(i,j)-wkmat2(i,j)

                          ij=0
                          do 1025 i=1,ncnt
                          do 1025 j=1,i
                          ij=ij+1
                          wkmat2(i,j)=half*bmat(ij)
 1025                     wkmat2(j,i)=half*bmat(ij)

                          do 1026 i=1,ncnt
 1026                     wkmat2(i,i)=wkmat2(i,i)*two

                          call mxmy(ncnt,wkmat2,overlap,wkmat3)
                          call mxmz(ncnt,iwkvec,wkmat1,wkmat3,wkmat2)

                          do 1027 j=1,ncnt
                          do 1027 i=1,ncnt
 1027                     ematrix(i,j)=ematrix(i,j)+wkmat2(i,j)

                          endif

      if(nalpha.ne.nbeta) then
                                rewind iunitb
                                rewind junitb

                                do 1028 k=nn_start,nn_end-1
                                call fastrd(junitb,wkmat2,ncntsq)
 1028                           call fastwr(iunitb,wkmat2,ncntsq)

                                call fastwr(iunitb,wkmat1,ncntsq)
                          endif

      rewind iunite
      rewind junite

      do 1029 k=nn_start,nn_end-1
      call fastrd(junite,wkmat1,ncntsq)
 1029 call fastwr(iunite,wkmat1,ncntsq)

      call fastwr(iunite,ematrix,ncntsq)

      rewind iunite

      do 1030 k=nn_start,nn_end

      call fastrd(iunite,wkmat1,ncntsq)

      factor=zero

      do 1031 i=1,ncnt
      do 1031 j=1,ncnt
 1031 factor=factor+wkmat1(j,i)*ematrix(j,i)

      bmatrix(k-nn_start+2,niteration-nn_start+2)=factor
      bmatrix(niteration-nn_start+2,k-nn_start+2)=factor

 1030 continue

      nn_stop=niteration-ndiisw+2

      do 1032 i=1,nn_stop
      do 1032 j=1,nn_stop
 1032 bbmatrix(j,i)=bmatrix(j,i)

      do 1033 i=1,nn_stop
 1033 wkvec(i)=zero

      wkvec(1)=-one

      emax=zero

      do 1034 i=1,ncnt
      do 1034 j=1,ncnt
 1034 if(abs(ematrix(j,i)).gt.emax) emax=abs(ematrix(j,i))

      ndiisd=nn_stop

      if(nn_stop.gt.ndiisd) then
                                  nnn=nn_stop-ndiisd

                                  do 1035 i=2,ndiisd
                                  do 1035 j=2,ndiisd
 1035                             bbmatrix(i,j)=bmatrix(i+nnn,j+nnn)
                            endif

      ndim=min(ndiisd,nn_stop)

      call matinv(bbmatrix,wkvec,ndim,2,maxdiis)

      rewind iunita
      if(nalpha.ne.nbeta) rewind iunitb

      if(nn_stop.gt.ndiisd) then

             nnn=nn_stop-ndiisd

             do 1036 k=1,nnn
 1036        call fastrd(iunita,wkmat1,1)

             if(nalpha.ne.nbeta) then
                                       do 1037 k=1,nnn
 1037                                  call fastrd(iunitb,wkmat1(1,i),1)
                                 endif

                            endif

      do 1038 i=1,ncnt
      do 1038 j=1,ncnt
 1038 wkmat1(j,i)=zero

      if(nalpha.ne.nbeta) then
                                do 1039 i=1,ncnt
                                do 1039 j=1,ncnt
 1039                           wkmat2(j,i)=zero
                          endif

      do 1040 k=2,ndim

      call fastrd(iunita,wkmat3,ncntsq)

      if(nalpha.ne.nbeta) call fastrd(iunitb,overlap,ncntsq)

      do 1041 i=1,ncnt
      do 1041 j=1,ncnt
 1041 wkmat1(j,i)=wkmat1(j,i)+wkvec(k)*wkmat3(j,i)

      if(nalpha.ne.nbeta) then

                          do 1042 i=1,ncnt
                          do 1042 j=1,ncnt
 1042                     wkmat2(j,i)=wkmat2(j,i)+wkvec(k)*overlap(j,i)

                          endif

 1040 continue

      ij=0

      do 1043 i=1,ncnt
      do 1043 j=1,i
      ij=ij+1
 1043 focka(ij)=wkmat1(j,i)

      ij=0

      if(nalpha.ne.nbeta) then
                                do 1044 i=1,ncnt
                                do 1044 j=1,i
                                ij=ij+1
 1044                           fockb(ij)=wkmat2(j,i)
                          endif

      return
      end
