      subroutine delphi(iswitch,iteration,ncenters,nptcharges,ngridx,
     &                  ngridy,ngridz,ngridxby2,ngridyby2,ngridzby2,
     &                  natomtype,nboundary,epsilon,hstep,deltag,coord,
     &                  charges,coordptcharge,ptcharges,phinew,phiold,
     &                  gridcharge,dielectric,avgdielectric,
     &                  coordneighbour,radneighbour)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      logical connol

      dimension vanderwaal(18),cubepts(3,6)

      dimension natomtype(*),nboundary(ngridx,ngridy,*)

      dimension coord(3,*),charges(*),coordptcharge(3,*),ptcharges(*),
     &          phinew(ngridx,ngridy,*),phiold(ngridx,ngridy,*),
     &          gridcharge(ngridx,ngridy,*),
     &          dielectric(6,ngridx,ngridy,*),
     &          avgdielectric(ngridx,ngridy,*),coordneighbour(3,*),
     &          radneighbour(*)

      data zero,half,one/0.0d0,0.5d0,1.0d0/
      data pi,six/3.1415926535898d0,6.0d0/
      data bohr,efactor1,efactor2/0.529177d0,27.212d0,23.062d0/
      data tolerance,probe/0.0001d0,1.40d0/

      data vanderwaal/
     &     1.40d0,                                               1.62d0,
     &     2.02d0,0.00d0,     0.00d0,1.92d0,1.77d0,1.62d0,1.57d0,1.76d0,
     &     2.52d0,1.92d0,     0.00d0,2.32d0,2.07d0,2.07d0,2.02d0,2.14d0/

      rewind 49
      rewind 50

      fourpi=pi/half/half

      proberadius=probe/bohr
      call utility2(ngridx*ngridy*ngridz,zero,gridcharge)
      call utility2(ngridx*ngridy*ngridz,zero,phiold)
      call utilityk(ngridx*ngridy*ngridz,0,nboundary)

      do 1001 i=1,ncenters

      if(natomtype(i).eq.0) goto 1001

      ix=int((coord(1,i)+real64(ngridxby2)*hstep)/hstep)
      iy=int((coord(2,i)+real64(ngridyby2)*hstep)/hstep)
      iz=int((coord(3,i)+real64(ngridzby2)*hstep)/hstep)

      ix1=ix
      iy1=iy
      iz1=iz

      ix2=ix
      iy2=iy
      iz2=iz+1

      ix3=ix
      iy3=iy+1
      iz3=iz

      ix4=ix
      iy4=iy+1
      iz4=iz+1

      ix5=ix+1
      iy5=iy
      iz5=iz

      ix6=ix+1
      iy6=iy
      iz6=iz+1

      ix7=ix+1
      iy7=iy+1
      iz7=iz

      ix8=ix+1
      iy8=iy+1
      iz8=iz+1

      x1=real64(ix1-ngridxby2)*hstep
      y1=real64(iy1-ngridyby2)*hstep
      z1=real64(iz1-ngridzby2)*hstep

      x2=real64(ix2-ngridxby2)*hstep
      y2=real64(iy2-ngridyby2)*hstep
      z2=real64(iz2-ngridzby2)*hstep

      x3=real64(ix3-ngridxby2)*hstep
      y3=real64(iy3-ngridyby2)*hstep
      z3=real64(iz3-ngridzby2)*hstep

      x4=real64(ix4-ngridxby2)*hstep
      y4=real64(iy4-ngridyby2)*hstep
      z4=real64(iz4-ngridzby2)*hstep

      x5=real64(ix5-ngridxby2)*hstep
      y5=real64(iy5-ngridyby2)*hstep
      z5=real64(iz5-ngridzby2)*hstep

      x6=real64(ix6-ngridxby2)*hstep
      y6=real64(iy6-ngridyby2)*hstep
      z6=real64(iz6-ngridzby2)*hstep

      x7=real64(ix7-ngridxby2)*hstep
      y7=real64(iy7-ngridyby2)*hstep
      z7=real64(iz7-ngridzby2)*hstep

      x8=real64(ix8-ngridxby2)*hstep
      y8=real64(iy8-ngridyby2)*hstep
      z8=real64(iz8-ngridzby2)*hstep

      x1=abs(x1-coord(1,i))/hstep
      y1=abs(y1-coord(2,i))/hstep
      z1=abs(z1-coord(3,i))/hstep

      x2=abs(x2-coord(1,i))/hstep
      y2=abs(y2-coord(2,i))/hstep
      z2=abs(z2-coord(3,i))/hstep

      x3=abs(x3-coord(1,i))/hstep
      y3=abs(y3-coord(2,i))/hstep
      z3=abs(z3-coord(3,i))/hstep

      x4=abs(x4-coord(1,i))/hstep
      y4=abs(y4-coord(2,i))/hstep
      z4=abs(z4-coord(3,i))/hstep

      x5=abs(x5-coord(1,i))/hstep
      y5=abs(y5-coord(2,i))/hstep
      z5=abs(z5-coord(3,i))/hstep

      x6=abs(x6-coord(1,i))/hstep
      y6=abs(y6-coord(2,i))/hstep
      z6=abs(z6-coord(3,i))/hstep

      x7=abs(x7-coord(1,i))/hstep
      y7=abs(y7-coord(2,i))/hstep
      z7=abs(z7-coord(3,i))/hstep

      x8=abs(x8-coord(1,i))/hstep
      y8=abs(y8-coord(2,i))/hstep
      z8=abs(z8-coord(3,i))/hstep

      gridcharge(ix1,iy1,iz1)=gridcharge(ix1,iy1,iz1)
     &                       +(one-x1)*(one-y1)*(one-z1)*charges(i)

      gridcharge(ix2,iy2,iz2)=gridcharge(ix2,iy2,iz2)
     &                       +(one-x2)*(one-y2)*(one-z2)*charges(i)

      gridcharge(ix3,iy3,iz3)=gridcharge(ix3,iy3,iz3)
     &                       +(one-x3)*(one-y3)*(one-z3)*charges(i)

      gridcharge(ix4,iy4,iz4)=gridcharge(ix4,iy4,iz4)
     &                       +(one-x4)*(one-y4)*(one-z4)*charges(i)

      gridcharge(ix5,iy5,iz5)=gridcharge(ix5,iy5,iz5)
     &                       +(one-x5)*(one-y5)*(one-z5)*charges(i)

      gridcharge(ix6,iy6,iz6)=gridcharge(ix6,iy6,iz6)
     &                       +(one-x6)*(one-y6)*(one-z6)*charges(i)

      gridcharge(ix7,iy7,iz7)=gridcharge(ix7,iy7,iz7)
     &                       +(one-x7)*(one-y7)*(one-z7)*charges(i)

      gridcharge(ix8,iy8,iz8)=gridcharge(ix8,iy8,iz8)
     &                       +(one-x8)*(one-y8)*(one-z8)*charges(i)

 1001 continue

      if(iteration.gt.1) call fastrd(50,phiold,ngridx*ngridy*ngridz)

      call utility2(ngridx*ngridy,zero,phiold(1,1,1))
      call utility2(ngridx*ngridy,zero,phiold(1,1,ngridz))

      do 1002 j=1,ngridz
      call utility2(ngridx,zero,phiold(1,1,j))
 1002 call utility2(ngridx,zero,phiold(1,ngridy,j))

      do 1003 j=1,ngridz
      do 1003 i=1,ngridy
      phiold(1,i,j)=zero
 1003 phiold(ngridx,i,j)=zero

      do 1004 k=1,ncenters

      if(natomtype(k).ne.0) then

             xx=coord(1,k)
             yy=coord(2,k)
             zz=coord(3,k)

             da=real64(1-ngridzby2)*hstep
             db=real64(ngridz-ngridzby2)*hstep

             do 1005 j=2,ngridy-1
             dj=real64(j-ngridyby2)*hstep
             do 1005 i=2,ngridx-1
             di=real64(i-ngridxby2)*hstep
             phiold(i,j,1)=phiold(i,j,1)+charges(k)/epsilon/
     &                     sqrt((di-xx)**2+(dj-yy)**2+(da-zz)**2)
 1005        phiold(i,j,ngridz)=phiold(i,j,ngridz)+charges(k)/epsilon/
     &                          sqrt((di-xx)**2+(dj-yy)**2+(db-zz)**2)

             da=real64(1-ngridyby2)*hstep
             db=real64(ngridy-ngridyby2)*hstep

             do 1006 j=2,ngridz-1
             dj=real64(j-ngridzby2)*hstep
             do 1006 i=2,ngridx-1
             di=real64(i-ngridxby2)*hstep
             phiold(i,1,j)=phiold(i,1,j)+charges(k)/epsilon/
     &                     sqrt((di-xx)**2+(da-yy)**2+(dj-zz)**2)
 1006        phiold(i,ngridy,j)=phiold(i,ngridy,j)+charges(k)/epsilon/
     &                          sqrt((di-xx)**2+(db-yy)**2+(dj-zz)**2)

             da=real64(1-ngridxby2)*hstep
             db=real64(ngridx-ngridxby2)*hstep

             do 1007 j=2,ngridz-1
             dj=real64(j-ngridzby2)*hstep
             do 1007 i=2,ngridy-1
             di=real64(i-ngridyby2)*hstep
             phiold(1,i,j)=phiold(1,i,j)+charges(k)/epsilon/
     &                     sqrt((da-xx)**2+(di-yy)**2+(dj-zz)**2)
 1007        phiold(ngridx,i,j)=phiold(ngridx,i,j)+charges(k)/epsilon/
     &                          sqrt((db-xx)**2+(di-yy)**2+(dj-zz)**2)

                            endif
 1004 continue

      ntemp=ngridx*ngridy

      call stringcopy(ntemp,phinew(1,1,1),phiold(1,1,1))
      call stringcopy(ntemp,phinew(1,1,ngridz),phiold(1,1,ngridz))

      do 1008 j=1,ngridz
      call stringcopy(ngridx,phinew(1,1,j),phiold(1,1,j))
 1008 call stringcopy(ngridx,phinew(1,ngridy,j),phiold(1,ngridy,j))

      do 1009 j=1,ngridz
      do 1009 i=1,ngridy
      phinew(1,i,j)=phiold(1,i,j)
 1009 phinew(ngridx,i,j)=phiold(ngridx,i,j)

      if(iteration.gt.1) then

                call fastrd(49,dielectric,6*ngridx*ngridy*ngridz)

                         else

                ntemp=6*ngridx*ngridy*ngridz

                call utility2(ntemp,epsilon,dielectric)

                do 1010 l=1,ncenters

                if(natomtype(l).eq.0) goto 1010 

                if(natomtype(l).eq.04) stop 'cannot do delphi'
                if(natomtype(l).eq.05) stop 'cannot do delphi'
                if(natomtype(l).eq.13) stop 'cannot do delphi'
                if(natomtype(l).gt.18) stop 'cannot do delphi'

                radius=vanderwaal(natomtype(l))/bohr

                neighbour=0

                do 1011 i=1,ncenters
                if((i.ne.l).and.(natomtype(i).ne.0)) then

                   neighbour=neighbour+1

                   coordneighbour(1,neighbour)=coord(1,i)
                   coordneighbour(2,neighbour)=coord(2,i)
                   coordneighbour(3,neighbour)=coord(3,i)

                   radneighbour(neighbour)=vanderwaal(natomtype(i))/bohr

                                                     endif
 1011           continue

                do 1012 k=2,ngridz-1
                z=real64(k-ngridzby2)*hstep

                do 1012 j=2,ngridy-1
                y=real64(j-ngridyby2)*hstep

                do 1012 i=2,ngridx-1
                x=real64(i-ngridxby2)*hstep

                cubepts(1,1)=x+hstep*half
                cubepts(2,1)=y
                cubepts(3,1)=z

                cubepts(1,2)=x-hstep*half
                cubepts(2,2)=y
                cubepts(3,2)=z

                cubepts(1,3)=x
                cubepts(2,3)=y+hstep*half
                cubepts(3,3)=z

                cubepts(1,4)=x
                cubepts(2,4)=y-hstep*half
                cubepts(3,4)=z

                cubepts(1,5)=x
                cubepts(2,5)=y
                cubepts(3,5)=z+hstep*half

                cubepts(1,6)=x
                cubepts(2,6)=y
                cubepts(3,6)=z-hstep*half

       do 1013 m=1,6

       if(dist(cubepts(1,m),coord(1,l)).le.radius)
     &                                  dielectric(m,i,j,k)=one

       if((dist(cubepts(1,m),coord(1,l)).gt.radius).and.
     &    (dist(cubepts(1,m),coord(1,l)).le.(radius+proberadius))) then

                                     if(connol(cubepts(1,m),proberadius,
     &                                  coordneighbour,radneighbour,
     &                                  coord(1,l),radius,neighbour))
     &                                           dielectric(m,i,j,k)=one

                                                                   endif

 1013  continue

 1012           continue

 1010           continue

                rewind 49

                call fastwr(49,dielectric,6*ngridx*ngridy*ngridz)

                         endif

      do 1014 k=2,ngridz-1
      do 1014 j=2,ngridy-1
      do 1014 i=2,ngridx-1
 1014 avgdielectric(i,j,k)=dielectric(1,i,j,k)+dielectric(2,i,j,k)
     &                    +dielectric(3,i,j,k)+dielectric(4,i,j,k)
     &                    +dielectric(5,i,j,k)+dielectric(6,i,j,k)

      do 1015 k=2,ngridz-1
      do 1015 j=2,ngridy-1
      do 1015 i=2,ngridx-1
      a1=abs(six-avgdielectric(i,j,k))
      a2=abs(six-avgdielectric(i,j,k)/epsilon)
 1015 if(min(a1,a2).gt.tolerance) nboundary(i,j,k)=1

      do 1016 n=1,150

      do 1017 k=2,ngridz-1
      do 1017 j=2,ngridy-1
      do 1017 i=2,ngridx-1
      phinew(i,j,k)=phiold(i+1,j,k)*dielectric(1,i,j,k)
     &             +phiold(i-1,j,k)*dielectric(2,i,j,k)
     &             +phiold(i,j+1,k)*dielectric(3,i,j,k)
     &             +phiold(i,j-1,k)*dielectric(4,i,j,k)
     &             +phiold(i,j,k+1)*dielectric(5,i,j,k)
     &             +phiold(i,j,k-1)*dielectric(6,i,j,k)
     &             +fourpi*gridcharge(i,j,k)/hstep
 1017 phinew(i,j,k)=phinew(i,j,k)/avgdielectric(i,j,k)

      do 1018 k=2,ngridz-1
      do 1018 j=2,ngridy-1
      do 1018 i=2,ngridx-1
 1018 phiold(i,j,k)=phinew(i,j,k)

 1016 continue

      rewind 50

      call fastwr(50,phiold,ngridx*ngridy*ngridz)

      do 1019 k=2,ngridz-1
      do 1019 j=2,ngridy-1
      do 1019 i=2,ngridx-1
 1019 phiold(i,j,k)=(hstep/fourpi)*(six*phinew(i,j,k)
     &                             -phinew(i+1,j,k)-phinew(i-1,j,k)
     &                             -phinew(i,j+1,k)-phinew(i,j-1,k)
     &                             -phinew(i,j,k+1)-phinew(i,j,k-1))
     &                             -gridcharge(i,j,k)

      nptcharges=0

      if(iswitch.eq.1) write(6,1020)
 1020 format(/,' surface induced charges',
     &         ' (can be displayed with MIDAS): ',/)

      do 1021 k=2,ngridz-1
      do 1021 j=2,ngridy-1
      do 1021 i=2,ngridx-1

      if(nboundary(i,j,k).eq.0) goto 1021

      nptcharges=nptcharges+1

      x=real64(i-ngridxby2)*hstep
      y=real64(j-ngridyby2)*hstep
      z=real64(k-ngridzby2)*hstep

      coordptcharge(1,nptcharges)=x
      coordptcharge(2,nptcharges)=y
      coordptcharge(3,nptcharges)=z

      ptcharges(nptcharges)=phiold(i,j,k)

      if(iswitch.eq.1) then

         if(phiold(i,j,k).lt.zero) then

             write(6,1022) nptcharges,nptcharges+1,x,y,z,phiold(i,j,k)
 1022        format('ATOM',3x,i4,'  CL- CIO ',i5,4x,3f8.3,f12.9)

                                   else

             write(6,1023) nptcharges,nptcharges+1,x,y,z,phiold(i,j,k)
 1023        format('ATOM',3x,i4,'  NA+ CIO ',i5,4x,3f8.3,f12.9)

                                   endif

                       endif
 1021 continue

      deltag=zero

      do 1024 j=1,ncenters
      do 1024 i=1,nptcharges
 1024 deltag=deltag+half*ptcharges(i)*charges(j)/
     &                               dist(coordptcharge(1,i),coord(1,j))

      write(6,1025) nptcharges
 1025 format(/,' there are ',i5,' surface induced charges',/)

      deltag=deltag*efactor1*efactor2

      write(6,1026) deltag
 1026 format(' electrostatic contribution to free energy of solvation',
     &       ' = ',f9.4,' kcal/mole',////)

      return
      end
