      subroutine delphidr(nreal,ninteger,natoms,nmaxorbs,nmaxaux,
     &                    nmaxpts,nmaxesp,mesp,nmaxiterations,idiis,
     &                    ngridtype,nfunctional,iptsflag,ncenters,
     &                    nptcharges,nbsystems,level,nalpha,nbeta,
     &                    nconts,ncontp,ncontd,ncds,ncdspd,nxcsw,
     &                    natomtype,nptsatom,nshels,nshelp,nsheld,
     &                    ilfunc,icfunc,ngaussians,mtloca,nfuncatom,
     &                    icdlfunc,icdcfunc,isys,iwkvec,cutoff,epsilon,
     &                    dconvergence,dmixing,elevelshift,coord,charge,
     &                    coordptcharge,ptcharge,core,focka,fockb,focke,
     &                    dmta,dmtb,coeffa,coeffb,alpha,coeffs,alphacd,
     &                    coefscd,coefpcd,coefdcd,cdfitc,tvector,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),ngaussians(*),mtloca(*),
     &          nfuncatom(*),icdlfunc(*),icdcfunc(*),isys(natoms,*),
     &          iwkvec(*)

      dimension coord(3,*),charge(*),coordptcharge(3,*),ptcharge(*),
     &          core(*),focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),alpha(*),
     &          coeffs(*),alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),
     &          cdfitc(*),tvector(*),wkvec(*)

      data zero,one,two,five,hundred/0.0d0,1.0d0,2.0d0,5.0d0,100.0d0/
      data hstep,dlarge/0.25d0,1.0d+25/

      ncontractions=nconts+3*ncontp+6*ncontd

      ncdtotal=ncds+10*ncdspd

      savedmixing=dmixing

      xmin=+dlarge
      ymin=+dlarge
      zmin=+dlarge

      xmax=-dlarge
      ymax=-dlarge
      zmax=-dlarge

      do 1001 i=1,ncenters
      xmin=min(coord(1,i),xmin)
      ymin=min(coord(2,i),ymin)
      zmin=min(coord(3,i),zmin)
      xmax=max(coord(1,i),xmax)
      ymax=max(coord(2,i),ymax)
 1001 zmax=max(coord(3,i),zmax)

      xshift=xmax-((xmax-xmin)/two)
      yshift=ymax-((ymax-ymin)/two)
      zshift=zmax-((zmax-zmin)/two)

      do 1002 i=1,ncenters
      coord(1,i)=coord(1,i)-xshift
      coord(2,i)=coord(2,i)-yshift
 1002 coord(3,i)=coord(3,i)-zshift

      xmax=xmax-xshift
      ymax=ymax-yshift
      zmax=zmax-zshift

      dx=(xmax+five)/hstep
      dy=(ymax+five)/hstep
      dz=(zmax+five)/hstep

      nx=int(dx)+1
      ny=int(dy)+1
      nz=int(dz)+1

      ngridx=2*nx+1
      ngridy=2*ny+1
      ngridz=2*nz+1

      ngridxby2=nx+1
      ngridyby2=ny+1
      ngridzby2=nz+1

      write(6,2222) ngridx,ngridy,ngridz,ngridxby2,ngridyby2,ngridzby2
 2222 format(' testing lattice parameters ',6i6)

      ii=0
      ndelphi=0

      deltag_new=zero
      deltag_old=hundred

      do 1003 i=1,nmaxiterations

      ii=ii+1

      if(abs(deltag_new-deltag_old).lt.(one/hundred)) goto 1003

      ja=1
      jb=ja+nmaxaux

      call scfcycle(ii,nmaxiterations,nreal-jb,ninteger-nmaxaux,natoms,
     &              nmaxpts,idiis,nfunctional,ngridtype,ncenters,
     &              nptcharges,nbsystems,nalpha,nbeta,ncontractions,
     &              nconts,ncontp,ncontd,ncds,ncdspd,nxcsw,natomtype,
     &              nptsatom,nshels,nshelp,nsheld,mtloca,ilfunc,icfunc,
     &              ngaussians,nfuncatom,icdlfunc,icdcfunc,isys,
     &              iwkvec(1),iwkvec(nmaxaux+1),dconvergence,energy,
     &              elevelshift,dmixing,dmaxpc,rmschange,cutoff,coord,
     &              coordptcharge,charge,ptcharge,core,focka,fockb,
     &              focke,dmta,dmtb,coeffa,coeffb,alpha,coeffs,alphacd,
     &              coefscd,coefpcd,coefdcd,cdfitc,tvector,wkvec(ja),
     &              wkvec(jb))

      cut=max(dconvergence,dconvergence*(10**(3-ndelphi)))

      if((ii.le.3).or.
     &   (dmaxpc.gt.(cut*hundred)).or.(rmschange.gt.cut)) goto 1003

      ii=0

      write(6,1004)
 1004 format(//)

      ja=1
      jb=ja+3*mesp
      jc=jb+4*natoms*natoms
      jd=jc+2*natoms
      je=jd+natoms
      jf=je+3*natoms
      jg=jf+3*natoms
      jh=jg+3*nmaxesp

      ka=1
      kb=ka+mesp
      kc=kb+mesp
      kd=kb+natoms*2
      ke=kb+natoms*natoms

      call mespgen(nreal-jh,ninteger-ke,iptsflag,natoms,mesp,nmaxesp,
     &             nmaxaux,level,ncenters,nbsystems,0,0,nalpha,nbeta,
     &             nconts,ncontp,ncontd,ncds,ncdspd,nshels,nshelp,
     &             nsheld,ilfunc,ngaussians,icfunc,mtloca,icdlfunc,
     &             icdcfunc,natomtype,iwkvec(kc),iwkvec(kd),isys,
     &             iwkvec(ka),iwkvec(kb),iwkvec(ke),coord,charge,dmta,
     &             dmtb,alpha,coeffs,alphacd,coefscd,coefpcd,coefdcd,
     &             cdfitc,wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh))

      ndelphi=ndelphi+1

      do 1005 j=1,ncenters
 1005 wkvec(j)=wkvec(jc+j-1)

      ja=1
      jb=ja+ncenters
      jc=jb+ngridx*ngridy*ngridz
      jd=jc+ngridx*ngridy*ngridz
      je=jd+ngridx*ngridy*ngridz
      jf=je+ngridx*ngridy*ngridz*6
      jg=jf+ngridx*ngridy*ngridz
      jh=jg+ncenters*3

      ji=jh+ncenters

      if(ji.gt.nreal) stop 'delphi driver real overflow'

      itest=ngridx*ngridy*ngridz

      if(itest.gt.ninteger) stop 'delphi driver integer overflow'

      if(ndelphi.eq.5) iswitch=1

      deltag_old=deltag_new

      call delphi(iswitch,ndelphi,ncenters,nptcharges,ngridx,ngridy,
     &            ngridz,ngridxby2,ngridyby2,ngridzby2,natomtype,iwkvec,
     &            epsilon,hstep,deltag,coord,wkvec(ja),coordptcharge,
     &            ptcharge,wkvec(jb),wkvec(jc),wkvec(jd),wkvec(je),
     &            wkvec(jf),wkvec(jg),wkvec(jh))

      deltag_new=deltag

      ja=1
      jb=ja+ncontractions*ncontractions
      jc=jb+(ncenters+nptcharges)*3
      jd=jc+(ncenters+nptcharges)

      call coremm(nreal-jc,ninteger,ncenters,nptcharges,nconts,ncontp,
     &            ncontd,nshels,nshelp,nsheld,mtloca,ilfunc,ngaussians,
     &            icfunc,iwkvec,wkvec(jb),coord,coordptcharge,wkvec(jc),
     &            charge,ptcharge,alpha,coeffs,wkvec(ja),core,wkvec(jd))

 1003 continue

      dmixing=savedmixing

      if(dmaxpc.le.dconvergence) then
                                       write(6,1006)
                                 else
                                       write(6,1007)
                                 endif

 1006 format(/,' scf converged!!! :-) :-) :-) ')
 1007 format(/,' scf terminated unsuccessfully??? :-( :-( :-( ')

      return
      end
