      subroutine diffuse2(nconts,ncontp,ncontd,ilfunc,icfunc,ngauss,
     &                    nptrs,nptrp,nptrd,tolerance,alpha,coeff,
     &                    extent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)

      dimension alpha(*),coeff(*),extent(*)

      data nextent/50/
      data zero,one,expcut/0.0d0,1.0d0,45.0d0/

      do 1001 i=1,nconts+ncontp+ncontd
 1001 extent(i)=zero

      do 1002 iloop=1,nextent

      xx=real64(iloop)
      rr=xx*xx

      do 1003 i=1,nconts

      s=zero

      ilabel=nptrs(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1004 j=iptr1,iptr2
      rralpha=rr*alpha(j)
 1004 if(rralpha.le.expcut) s=s+coeff(j)*exp(-rralpha)

 1003 if(abs(s).gt.tolerance) extent(i)=xx

      do 1005 i=1,ncontp

      px=zero

      ilabel=nptrp(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1006 j=iptr1,iptr2
      rralpha=rr*alpha(j)
 1006 if(rralpha.le.expcut) px=px+xx*coeff(j)*exp(-rralpha)

 1005 if(abs(px).gt.tolerance) extent(nconts+i)=xx

      do 1007 i=1,ncontd

      dxx=zero

      ilabel=nptrd(i)

      iptr1=ilfunc(ilabel)
      iptr2=iptr1+ngauss(ilabel)-1

      do 1008 j=iptr1,iptr2
      rralpha=rr*alpha(j)
 1008 if(rralpha.le.expcut) dxx=dxx+xx*xx*coeff(j)*exp(-rralpha)

 1007 if(abs(dxx).gt.tolerance) extent(nconts+ncontp+i)=xx

 1002 continue

      do 1009 i=1,nconts+ncontp+ncontd
 1009 if(extent(i).ge.real64(nextent-1)) stop 'extent may be a problem'

      do 1010 i=1,nconts+ncontp+ncontd
 1010 extent(i)=extent(i)+one

      return
      end
