      subroutine dipoleps(m,n,icontr,inddyy,density,zeta,px,py,pz,pxax,
     &                    pyay,pzaz,base,ss,ps,c,pscond,dipole)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*)

      dimension density(*),zeta(*),px(*),py(*),pz(*),pxax(*),pyay(*),
     &          pzaz(*),base(*),ss(n,*),ps(n,*),c(*),pscond(m,*),
     &          dipole(*)

      data zero,thrhlf,two,pi/0.0d0,1.5d0,2.0d0,3.1415926535898d0/

      do 1001 i=1,n
 1001 base(i)=base(i)*((pi/zeta(i))**thrhlf)

      do 1002 i=1,n
      ss(i,1)=px(i)*base(i)
      ss(i,2)=py(i)*base(i)
 1002 ss(i,3)=pz(i)*base(i)

      do 1003 i=1,n
 1003 c(i)=base(i)/(two*zeta(i))

      do 1004 i=1,n
      ps(i,1)=pxax(i)*ss(i,1)+c(i)
      ps(i,2)=pxax(i)*ss(i,2)
      ps(i,3)=pxax(i)*ss(i,3)
      ps(i,4)=pyay(i)*ss(i,1)
      ps(i,5)=pyay(i)*ss(i,2)+c(i)
      ps(i,6)=pyay(i)*ss(i,3)
      ps(i,7)=pzaz(i)*ss(i,1)
      ps(i,8)=pzaz(i)*ss(i,2)
 1004 ps(i,9)=pzaz(i)*ss(i,3)+c(i)

      do 1005 j=1,9
      do 1005 i=1,m
 1005 pscond(i,j)=zero

      do 1006 j=1,9
      do 1006 i=1,n
 1006 pscond(icontr(i),j)=pscond(icontr(i),j)+ps(i,j)

      do 1007 k=1,3
      do 1007 j=1,3
      do 1007 i=1,m
 1007 dipole(j)=dipole(j)-density(inddyy(i,k))*pscond(i,3*(k-1)+j)

      return
      end
