      subroutine fardp(m,n,natoms,icontr,iicontr,inddyy,iloc,itemp,g,
     &                 coord,redfit,fock,zeta,axbx,ayby,azbz,px,py,pz,
     &                 base,pxax,pyay,pzaz,u,zetarec,wxcx,wycy,wzcz,
     &                 wxpx,wypy,wzpz,sss0,sss1,sss2,sss3,sss4,sss5,
     &                 pss0,pss1,pss2,pss3,pss4,dss,dss0,dss1,dss2,dss3,
     &                 fss,fss0,fss1,fss2,psp1,dsp,dsp0,dsp1,fsp,fsp0,
     &                 fsp1,dsd,dsd0,fsd,fsd0,dps0,dpp0,dpd0,zetac1,
     &                 zetac2,c,c1,c2,c3,c4,c5,zzeta,ppx,ppy,ppz,ppxax,
     &                 ppyay,ppzaz,gather,extent)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension cdfitp(3),cdfitd(6)

      dimension icontr(*),iicontr(*),inddyy(m,*),iloc(*),itemp(*)

      dimension g(*),coord(3,*),redfit(10,*),fock(*),zeta(*),axbx(*),
     &          ayby(*),azbz(*),px(*),py(*),pz(*),base(*),pxax(*),
     &          pyay(*),pzaz(*),u(*),zetarec(*),wxcx(*),wycy(*),wzcz(*),
     &          wxpx(*),wypy(*),wzpz(*),sss0(*),sss1(*),sss2(*),sss3(*),
     &          sss4(*),sss5(*),pss0(n,*),pss1(n,*),pss2(n,*),pss3(n,*),
     &          pss4(n,*),dss(n,*),dss0(n,*),dss1(n,*),dss2(n,*),
     &          dss3(n,*),fss(n,*),fss0(n,*),fss1(n,*),fss2(n,*),
     &          psp1(n,*),dsp(n,*),dsp0(n,*),dsp1(n,*),fsp(n,*),
     &          fsp0(n,*),fsp1(n,*),dsd(n,*),dsd0(n,*),fsd(n,*),
     &          fsd0(n,*),dps0(n,*),dpp0(n,*),dpd0(n,*),zetac1(*),
     &          zetac2(*),c(*),c1(n,*),c2(n,*),c3(n,*),c4(n,*),c5(n,*),
     &          zzeta(*),ppx(*),ppy(*),ppz(*),ppxax(*),ppyay(*),
     &          ppzaz(*),gather(n,*),extent(*)

      data one,two,three/1.0d0,2.0d0,3.0d0/
      data four,five,six,seven/4.0d0,5.0d0,6.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/
      data calcut/1.0d-16/
      data rmultipole,onethousand/16.7d0,1000.0d0/
      data cs,cp,cd/1130.5901d0,123849.94d0,10112305.0d0/

      twoecnst=two*pi**(five/two)

      sqrt3=sqrt(three)

      dnormcd=seven/sqrt3

      do 1001 iatom=1,natoms

      ccx=coord(1,iatom)
      ccy=coord(2,iatom)
      ccz=coord(3,iatom)

      zetaux=onethousand

      cdfits=redfit(01,iatom)*cs

      cdfitp(1)=redfit(02,iatom)*cp
      cdfitp(2)=redfit(03,iatom)*cp
      cdfitp(3)=redfit(04,iatom)*cp

      cdfitd(1)=redfit(05,iatom)*cd/dnormcd
      cdfitd(2)=redfit(06,iatom)*cd
      cdfitd(3)=redfit(07,iatom)*cd
      cdfitd(4)=redfit(08,iatom)*cd/dnormcd
      cdfitd(5)=redfit(09,iatom)*cd
      cdfitd(6)=redfit(10,iatom)*cd/dnormcd

      nn=0

      do 1002 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
      pc=pxcx*pxcx+pycy*pycy+pzcz*pzcz
      if(extent(i).le.pc) then
                                 nn=nn+1

                                 zetarec(nn)=one/(zeta(i)+zetaux)

                                 u(nn)=zetaux*zetarec(nn)*zeta(i)*pc

                                 iloc(nn)=i

                                 iicontr(nn)=icontr(i)

                                 zzeta(nn)=zeta(i)

                                 ppx(nn)=px(i)
                                 ppy(nn)=py(i)
                                 ppz(nn)=pz(i)

                                 ppxax(nn)=pxax(i)
                                 ppyay(nn)=pyay(i)
                                 ppzaz(nn)=pzaz(i)
                          endif
 1002 continue

      if(nn.eq.0) goto 1001

      call auggnew(6,nn,n,itemp,u,fss0,wxcx,wycy,wzcz)

      factor=twoecnst/zetaux

      do 1003 i=1,nn
 1003 c(i)=base(iloc(i))*factor*sqrt(zetarec(i))/zzeta(i)

      do 1004 i=1,nn
      sss0(i)=c(i)*fss0(i,1)
      sss1(i)=c(i)*fss0(i,2)
      sss2(i)=c(i)*fss0(i,3)
      sss3(i)=c(i)*fss0(i,4)
      sss4(i)=c(i)*fss0(i,5)
 1004 sss5(i)=c(i)*fss0(i,6)

      do 1005 i=1,nn
      zetac1(i)=zetaux*zetarec(i)
 1005 zetac2(i)=zzeta(i)*zetarec(i)

      do 1006 i=1,nn
      wxcx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ccx
      wycy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ccy
 1006 wzcz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ccz

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn

      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
      pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
      pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
      pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
      pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      pss4(i,1)=ppxax(i)*sss4(i)+wxpx(i)*sss5(i)
      pss4(i,2)=ppyay(i)*sss4(i)+wypy(i)*sss5(i)
      pss4(i,3)=ppzaz(i)*sss4(i)+wzpz(i)*sss5(i)

 1008 continue

      do 1009 i=1,nn

      c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
      dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
      dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
      dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      c(i)=(sss3(i)-zetac1(i)*sss4(i))/(two*zzeta(i))

      dss3(i,1)=ppxax(i)*pss3(i,1)+wxpx(i)*pss4(i,1)+c(i)
      dss3(i,2)=ppyay(i)*pss3(i,1)+wypy(i)*pss4(i,1)
      dss3(i,3)=ppzaz(i)*pss3(i,1)+wzpz(i)*pss4(i,1)
      dss3(i,4)=ppyay(i)*pss3(i,2)+wypy(i)*pss4(i,2)+c(i)
      dss3(i,5)=ppzaz(i)*pss3(i,2)+wzpz(i)*pss4(i,2)
      dss3(i,6)=ppzaz(i)*pss3(i,3)+wzpz(i)*pss4(i,3)+c(i)

 1009 continue

      do 1010 j=1,3
      do 1010 i=1,nn
 1010 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 1011 i=1,nn
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1011 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1012 j=1,3
      do 1012 i=1,nn
 1012 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 1013 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 1013 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 1014 j=1,3
      do 1014 i=1,nn
 1014 c1(i,j)=(pss2(i,j)-zetac1(i)*pss3(i,j))/(two*zzeta(i))

      do 1015 i=1,nn
      fss2(i,01)=ppxax(i)*dss2(i,1)+wxpx(i)*dss3(i,1)+c1(i,1)+c1(i,1)
      fss2(i,02)=ppyay(i)*dss2(i,1)+wypy(i)*dss3(i,1)
      fss2(i,03)=ppzaz(i)*dss2(i,1)+wzpz(i)*dss3(i,1)
      fss2(i,04)=ppyay(i)*dss2(i,2)+wypy(i)*dss3(i,2)+c1(i,1)
      fss2(i,05)=ppzaz(i)*dss2(i,2)+wzpz(i)*dss3(i,2)
      fss2(i,06)=ppzaz(i)*dss2(i,3)+wzpz(i)*dss3(i,3)+c1(i,1)
      fss2(i,07)=ppyay(i)*dss2(i,4)+wypy(i)*dss3(i,4)+c1(i,2)+c1(i,2)
      fss2(i,08)=ppzaz(i)*dss2(i,4)+wzpz(i)*dss3(i,4)
      fss2(i,09)=ppzaz(i)*dss2(i,5)+wzpz(i)*dss3(i,5)+c1(i,2)
 1015 fss2(i,10)=ppzaz(i)*dss2(i,6)+wzpz(i)*dss3(i,6)+c1(i,3)+c1(i,3)

      do 1016 i=1,nn

      c(i)=half*sss2(i)*zetarec(i)

      psp1(i,1)=wxcx(i)*pss2(i,1)+c(i)
      psp1(i,2)=wycy(i)*pss2(i,1)
      psp1(i,3)=wzcz(i)*pss2(i,1)
      psp1(i,4)=wxcx(i)*pss2(i,2)
      psp1(i,5)=wycy(i)*pss2(i,2)+c(i)
      psp1(i,6)=wzcz(i)*pss2(i,2)
      psp1(i,7)=wxcx(i)*pss2(i,3)
      psp1(i,8)=wycy(i)*pss2(i,3)
      psp1(i,9)=wzcz(i)*pss2(i,3)+c(i)

 1016 continue

      do 1017 j=1,3
      do 1017 i=1,nn
 1017 c1(i,j)=half*pss1(i,j)*zetarec(i)

      do 1018 i=1,nn
      dsp0(i,01)=wxcx(i)*dss1(i,1)+c1(i,1)*two
      dsp0(i,02)=wycy(i)*dss1(i,1)
      dsp0(i,03)=wzcz(i)*dss1(i,1)
      dsp0(i,04)=wxcx(i)*dss1(i,2)+c1(i,2)
      dsp0(i,05)=wycy(i)*dss1(i,2)+c1(i,1)
      dsp0(i,06)=wzcz(i)*dss1(i,2)
      dsp0(i,07)=wxcx(i)*dss1(i,3)+c1(i,3)
      dsp0(i,08)=wycy(i)*dss1(i,3)
      dsp0(i,09)=wzcz(i)*dss1(i,3)+c1(i,1)
      dsp0(i,10)=wxcx(i)*dss1(i,4)
      dsp0(i,11)=wycy(i)*dss1(i,4)+c1(i,2)*two
      dsp0(i,12)=wzcz(i)*dss1(i,4)
      dsp0(i,13)=wxcx(i)*dss1(i,5)
      dsp0(i,14)=wycy(i)*dss1(i,5)+c1(i,3)
      dsp0(i,15)=wzcz(i)*dss1(i,5)+c1(i,2)
      dsp0(i,16)=wxcx(i)*dss1(i,6)
      dsp0(i,17)=wycy(i)*dss1(i,6)
 1018 dsp0(i,18)=wzcz(i)*dss1(i,6)+c1(i,3)*two

      do 1019 j=1,3
      do 1019 i=1,nn
 1019 c1(i,j)=half*pss2(i,j)*zetarec(i)

      do 1020 i=1,nn
      dsp1(i,01)=wxcx(i)*dss2(i,1)+c1(i,1)*two
      dsp1(i,02)=wycy(i)*dss2(i,1)
      dsp1(i,03)=wzcz(i)*dss2(i,1)
      dsp1(i,04)=wxcx(i)*dss2(i,2)+c1(i,2)
      dsp1(i,05)=wycy(i)*dss2(i,2)+c1(i,1)
      dsp1(i,06)=wzcz(i)*dss2(i,2)
      dsp1(i,07)=wxcx(i)*dss2(i,3)+c1(i,3)
      dsp1(i,08)=wycy(i)*dss2(i,3)
      dsp1(i,09)=wzcz(i)*dss2(i,3)+c1(i,1)
      dsp1(i,10)=wxcx(i)*dss2(i,4)
      dsp1(i,11)=wycy(i)*dss2(i,4)+c1(i,2)*two
      dsp1(i,12)=wzcz(i)*dss2(i,4)
      dsp1(i,13)=wxcx(i)*dss2(i,5)
      dsp1(i,14)=wycy(i)*dss2(i,5)+c1(i,3)
      dsp1(i,15)=wzcz(i)*dss2(i,5)+c1(i,2)
      dsp1(i,16)=wxcx(i)*dss2(i,6)
      dsp1(i,17)=wycy(i)*dss2(i,6)
 1020 dsp1(i,18)=wzcz(i)*dss2(i,6)+c1(i,3)*two

      do 1021 j=1,6
      do 1021 i=1,nn
 1021 c2(i,j)=half*dss1(i,j)*zetarec(i)

      do 1022 i=1,nn
      fsp0(i,01)=wxcx(i)*fss1(i,01)+c2(i,1)*three
      fsp0(i,02)=wycy(i)*fss1(i,01)
      fsp0(i,03)=wzcz(i)*fss1(i,01)
      fsp0(i,04)=wxcx(i)*fss1(i,02)+c2(i,2)*two
      fsp0(i,05)=wycy(i)*fss1(i,02)+c2(i,1)
      fsp0(i,06)=wzcz(i)*fss1(i,02)
      fsp0(i,07)=wxcx(i)*fss1(i,03)+c2(i,3)*two
      fsp0(i,08)=wycy(i)*fss1(i,03)
      fsp0(i,09)=wzcz(i)*fss1(i,03)+c2(i,1)
      fsp0(i,10)=wxcx(i)*fss1(i,04)+c2(i,4)
      fsp0(i,11)=wycy(i)*fss1(i,04)+c2(i,2)*two
      fsp0(i,12)=wzcz(i)*fss1(i,04)
      fsp0(i,13)=wxcx(i)*fss1(i,05)+c2(i,5)
      fsp0(i,14)=wycy(i)*fss1(i,05)+c2(i,3)
      fsp0(i,15)=wzcz(i)*fss1(i,05)+c2(i,2)
      fsp0(i,16)=wxcx(i)*fss1(i,06)+c2(i,6)
      fsp0(i,17)=wycy(i)*fss1(i,06)
      fsp0(i,18)=wzcz(i)*fss1(i,06)+c2(i,3)*two
      fsp0(i,19)=wxcx(i)*fss1(i,07)
      fsp0(i,20)=wycy(i)*fss1(i,07)+c2(i,4)*three
      fsp0(i,21)=wzcz(i)*fss1(i,07)
      fsp0(i,22)=wxcx(i)*fss1(i,08)
      fsp0(i,23)=wycy(i)*fss1(i,08)+c2(i,5)*two
      fsp0(i,24)=wzcz(i)*fss1(i,08)+c2(i,4)
      fsp0(i,25)=wxcx(i)*fss1(i,09)
      fsp0(i,26)=wycy(i)*fss1(i,09)+c2(i,6)
      fsp0(i,27)=wzcz(i)*fss1(i,09)+c2(i,5)*two
      fsp0(i,28)=wxcx(i)*fss1(i,10)
      fsp0(i,29)=wycy(i)*fss1(i,10)
 1022 fsp0(i,30)=wzcz(i)*fss1(i,10)+c2(i,6)*three

      do 1023 j=1,6
      do 1023 i=1,nn
 1023 c2(i,j)=half*dss2(i,j)*zetarec(i)

      do 1024 i=1,nn
      fsp1(i,01)=wxcx(i)*fss2(i,01)+c2(i,1)*three
      fsp1(i,02)=wycy(i)*fss2(i,01)
      fsp1(i,03)=wzcz(i)*fss2(i,01)
      fsp1(i,04)=wxcx(i)*fss2(i,02)+c2(i,2)*two
      fsp1(i,05)=wycy(i)*fss2(i,02)+c2(i,1)
      fsp1(i,06)=wzcz(i)*fss2(i,02)
      fsp1(i,07)=wxcx(i)*fss2(i,03)+c2(i,3)*two
      fsp1(i,08)=wycy(i)*fss2(i,03)
      fsp1(i,09)=wzcz(i)*fss2(i,03)+c2(i,1)
      fsp1(i,10)=wxcx(i)*fss2(i,04)+c2(i,4)
      fsp1(i,11)=wycy(i)*fss2(i,04)+c2(i,2)*two
      fsp1(i,12)=wzcz(i)*fss2(i,04)
      fsp1(i,13)=wxcx(i)*fss2(i,05)+c2(i,5)
      fsp1(i,14)=wycy(i)*fss2(i,05)+c2(i,3)
      fsp1(i,15)=wzcz(i)*fss2(i,05)+c2(i,2)
      fsp1(i,16)=wxcx(i)*fss2(i,06)+c2(i,6)
      fsp1(i,17)=wycy(i)*fss2(i,06)
      fsp1(i,18)=wzcz(i)*fss2(i,06)+c2(i,3)*two
      fsp1(i,19)=wxcx(i)*fss2(i,07)
      fsp1(i,20)=wycy(i)*fss2(i,07)+c2(i,4)*three
      fsp1(i,21)=wzcz(i)*fss2(i,07)
      fsp1(i,22)=wxcx(i)*fss2(i,08)
      fsp1(i,23)=wycy(i)*fss2(i,08)+c2(i,5)*two
      fsp1(i,24)=wzcz(i)*fss2(i,08)+c2(i,4)
      fsp1(i,25)=wxcx(i)*fss2(i,09)
      fsp1(i,26)=wycy(i)*fss2(i,09)+c2(i,6)
      fsp1(i,27)=wzcz(i)*fss2(i,09)+c2(i,5)*two
      fsp1(i,28)=wxcx(i)*fss2(i,10)
      fsp1(i,29)=wycy(i)*fss2(i,10)
 1024 fsp1(i,30)=wzcz(i)*fss2(i,10)+c2(i,6)*three

      do 1025 j=1,6
      do 1025 i=1,nn
 1025 c2(i,j)=(dss0(i,j)-zetac2(i)*dss1(i,j))/(two*zetaux)

      do 1026 j=1,9
      do 1026 i=1,nn
 1026 c3(i,j)=half*psp1(i,j)*zetarec(i)

      do 1027 i=1,nn
      dsd0(i,01)=wxcx(i)*dsp1(i,01)+c2(i,1)+c3(i,1)*two
      dsd0(i,02)=wycy(i)*dsp1(i,01)
      dsd0(i,03)=wzcz(i)*dsp1(i,01)
      dsd0(i,04)=wycy(i)*dsp1(i,02)+c2(i,1)
      dsd0(i,05)=wzcz(i)*dsp1(i,02)
      dsd0(i,06)=wzcz(i)*dsp1(i,03)+c2(i,1)
      dsd0(i,07)=wxcx(i)*dsp1(i,04)+c2(i,2)+c3(i,4)
      dsd0(i,08)=wycy(i)*dsp1(i,04)        +c3(i,1)
      dsd0(i,09)=wzcz(i)*dsp1(i,04)
      dsd0(i,10)=wycy(i)*dsp1(i,05)+c2(i,2)+c3(i,2)
      dsd0(i,11)=wzcz(i)*dsp1(i,05)
      dsd0(i,12)=wzcz(i)*dsp1(i,06)+c2(i,2)
      dsd0(i,13)=wxcx(i)*dsp1(i,07)+c2(i,3)+c3(i,7)
      dsd0(i,14)=wycy(i)*dsp1(i,07)
      dsd0(i,15)=wzcz(i)*dsp1(i,07)        +c3(i,1)
      dsd0(i,16)=wycy(i)*dsp1(i,08)+c2(i,3)
      dsd0(i,17)=wzcz(i)*dsp1(i,08)        +c3(i,2)
      dsd0(i,18)=wzcz(i)*dsp1(i,09)+c2(i,3)+c3(i,3)
      dsd0(i,19)=wxcx(i)*dsp1(i,10)+c2(i,4)
      dsd0(i,20)=wycy(i)*dsp1(i,10)        +c3(i,4)*two
      dsd0(i,21)=wzcz(i)*dsp1(i,10)
      dsd0(i,22)=wycy(i)*dsp1(i,11)+c2(i,4)+c3(i,5)*two
      dsd0(i,23)=wzcz(i)*dsp1(i,11)
      dsd0(i,24)=wzcz(i)*dsp1(i,12)+c2(i,4)
      dsd0(i,25)=wxcx(i)*dsp1(i,13)+c2(i,5)
      dsd0(i,26)=wycy(i)*dsp1(i,13)        +c3(i,7)
      dsd0(i,27)=wzcz(i)*dsp1(i,13)        +c3(i,4)
      dsd0(i,28)=wycy(i)*dsp1(i,14)+c2(i,5)+c3(i,8)
      dsd0(i,29)=wzcz(i)*dsp1(i,14)        +c3(i,5)
      dsd0(i,30)=wzcz(i)*dsp1(i,15)+c2(i,5)+c3(i,6)
      dsd0(i,31)=wxcx(i)*dsp1(i,16)+c2(i,6)
      dsd0(i,32)=wycy(i)*dsp1(i,16)
      dsd0(i,33)=wzcz(i)*dsp1(i,16)        +c3(i,7)*two
      dsd0(i,34)=wycy(i)*dsp1(i,17)+c2(i,6)
      dsd0(i,35)=wzcz(i)*dsp1(i,17)        +c3(i,8)*two
 1027 dsd0(i,36)=wzcz(i)*dsp1(i,18)+c2(i,6)+c3(i,9)*two

      do 1028 j=1,10
      do 1028 i=1,nn
 1028 c4(i,j)=(fss0(i,j)-zetac2(i)*fss1(i,j))/(two*zetaux)

      do 1029 j=1,18
      do 1029 i=1,nn
 1029 c5(i,j)=half*dsp1(i,j)*zetarec(i)

      do 1030 i=1,nn
      fsd0(i,01)=wxcx(i)*fsp1(i,01)+c4(i,01)+c5(i,01)*three
      fsd0(i,02)=wycy(i)*fsp1(i,01)
      fsd0(i,03)=wzcz(i)*fsp1(i,01)
      fsd0(i,04)=wycy(i)*fsp1(i,02)+c4(i,01)
      fsd0(i,05)=wzcz(i)*fsp1(i,02)
      fsd0(i,06)=wzcz(i)*fsp1(i,03)+c4(i,01)
      fsd0(i,07)=wxcx(i)*fsp1(i,04)+c4(i,02)+c5(i,04)*two
      fsd0(i,08)=wycy(i)*fsp1(i,04)         +c5(i,01)
      fsd0(i,09)=wzcz(i)*fsp1(i,04)
      fsd0(i,10)=wycy(i)*fsp1(i,05)+c4(i,02)+c5(i,02)
      fsd0(i,11)=wzcz(i)*fsp1(i,05)
      fsd0(i,12)=wzcz(i)*fsp1(i,06)+c4(i,02)
      fsd0(i,13)=wxcx(i)*fsp1(i,07)+c4(i,03)+c5(i,07)*two
      fsd0(i,14)=wycy(i)*fsp1(i,07)
      fsd0(i,15)=wzcz(i)*fsp1(i,07)         +c5(i,01)
      fsd0(i,16)=wycy(i)*fsp1(i,08)+c4(i,03)
      fsd0(i,17)=wzcz(i)*fsp1(i,08)         +c5(i,02)
      fsd0(i,18)=wzcz(i)*fsp1(i,09)+c4(i,03)+c5(i,03)
      fsd0(i,19)=wxcx(i)*fsp1(i,10)+c4(i,04)+c5(i,10)
      fsd0(i,20)=wycy(i)*fsp1(i,10)         +c5(i,04)*two
      fsd0(i,21)=wzcz(i)*fsp1(i,10)
      fsd0(i,22)=wycy(i)*fsp1(i,11)+c4(i,04)+c5(i,05)*two
      fsd0(i,23)=wzcz(i)*fsp1(i,11)
      fsd0(i,24)=wzcz(i)*fsp1(i,12)+c4(i,04)
      fsd0(i,25)=wxcx(i)*fsp1(i,13)+c4(i,05)+c5(i,13)
      fsd0(i,26)=wycy(i)*fsp1(i,13)         +c5(i,07)
      fsd0(i,27)=wzcz(i)*fsp1(i,13)         +c5(i,04)
      fsd0(i,28)=wycy(i)*fsp1(i,14)+c4(i,05)+c5(i,08)
      fsd0(i,29)=wzcz(i)*fsp1(i,14)         +c5(i,05)
      fsd0(i,30)=wzcz(i)*fsp1(i,15)+c4(i,05)+c5(i,06)
      fsd0(i,31)=wxcx(i)*fsp1(i,16)+c4(i,06)+c5(i,16)
      fsd0(i,32)=wycy(i)*fsp1(i,16)
      fsd0(i,33)=wzcz(i)*fsp1(i,16)         +c5(i,07)*two
      fsd0(i,34)=wycy(i)*fsp1(i,17)+c4(i,06)
      fsd0(i,35)=wzcz(i)*fsp1(i,17)         +c5(i,08)*two
      fsd0(i,36)=wzcz(i)*fsp1(i,18)+c4(i,06)+c5(i,09)*two
      fsd0(i,37)=wxcx(i)*fsp1(i,19)+c4(i,07)
      fsd0(i,38)=wycy(i)*fsp1(i,19)         +c5(i,10)*three
      fsd0(i,39)=wzcz(i)*fsp1(i,19)
      fsd0(i,40)=wycy(i)*fsp1(i,20)+c4(i,07)+c5(i,11)*three
      fsd0(i,41)=wzcz(i)*fsp1(i,20)
      fsd0(i,42)=wzcz(i)*fsp1(i,21)+c4(i,07)
      fsd0(i,43)=wxcx(i)*fsp1(i,22)+c4(i,08)
      fsd0(i,44)=wycy(i)*fsp1(i,22)         +c5(i,13)*two
      fsd0(i,45)=wzcz(i)*fsp1(i,22)         +c5(i,10)
      fsd0(i,46)=wycy(i)*fsp1(i,23)+c4(i,08)+c5(i,14)*two
      fsd0(i,47)=wzcz(i)*fsp1(i,23)         +c5(i,11)
      fsd0(i,48)=wzcz(i)*fsp1(i,24)+c4(i,08)+c5(i,12)
      fsd0(i,49)=wxcx(i)*fsp1(i,25)+c4(i,09)
      fsd0(i,50)=wycy(i)*fsp1(i,25)         +c5(i,16)
      fsd0(i,51)=wzcz(i)*fsp1(i,25)         +c5(i,13)*two
      fsd0(i,52)=wycy(i)*fsp1(i,26)+c4(i,09)+c5(i,17)
      fsd0(i,53)=wzcz(i)*fsp1(i,26)         +c5(i,14)*two
      fsd0(i,54)=wzcz(i)*fsp1(i,27)+c4(i,09)+c5(i,15)*two
      fsd0(i,55)=wxcx(i)*fsp1(i,28)+c4(i,10)
      fsd0(i,56)=wycy(i)*fsp1(i,28)
      fsd0(i,57)=wzcz(i)*fsp1(i,28)         +c5(i,16)*three
      fsd0(i,58)=wycy(i)*fsp1(i,29)+c4(i,10)
      fsd0(i,59)=wzcz(i)*fsp1(i,29)         +c5(i,17)*three
 1030 fsd0(i,60)=wzcz(i)*fsp1(i,30)+c4(i,10)+c5(i,18)*three

      do 1031 i=1,nn
      dps0(i,01)=axbx(iicontr(i))*dss0(i,1)+fss0(i,01)
      dps0(i,02)=ayby(iicontr(i))*dss0(i,1)+fss0(i,02)
      dps0(i,03)=azbz(iicontr(i))*dss0(i,1)+fss0(i,03)
      dps0(i,04)=axbx(iicontr(i))*dss0(i,2)+fss0(i,02)
      dps0(i,05)=ayby(iicontr(i))*dss0(i,2)+fss0(i,04)
      dps0(i,06)=azbz(iicontr(i))*dss0(i,2)+fss0(i,05)
      dps0(i,07)=axbx(iicontr(i))*dss0(i,3)+fss0(i,03)
      dps0(i,08)=ayby(iicontr(i))*dss0(i,3)+fss0(i,05)
      dps0(i,09)=azbz(iicontr(i))*dss0(i,3)+fss0(i,06)
      dps0(i,10)=axbx(iicontr(i))*dss0(i,4)+fss0(i,04)
      dps0(i,11)=ayby(iicontr(i))*dss0(i,4)+fss0(i,07)
      dps0(i,12)=azbz(iicontr(i))*dss0(i,4)+fss0(i,08)
      dps0(i,13)=axbx(iicontr(i))*dss0(i,5)+fss0(i,05)
      dps0(i,14)=ayby(iicontr(i))*dss0(i,5)+fss0(i,08)
      dps0(i,15)=azbz(iicontr(i))*dss0(i,5)+fss0(i,09)
      dps0(i,16)=axbx(iicontr(i))*dss0(i,6)+fss0(i,06)
      dps0(i,17)=ayby(iicontr(i))*dss0(i,6)+fss0(i,09)
 1031 dps0(i,18)=azbz(iicontr(i))*dss0(i,6)+fss0(i,10)

      do 1032 i=1,nn
      dpp0(i,01)=axbx(iicontr(i))*dsp0(i,01)+fsp0(i,01)
      dpp0(i,02)=axbx(iicontr(i))*dsp0(i,02)+fsp0(i,02)
      dpp0(i,03)=axbx(iicontr(i))*dsp0(i,03)+fsp0(i,03)
      dpp0(i,04)=ayby(iicontr(i))*dsp0(i,01)+fsp0(i,04)
      dpp0(i,05)=ayby(iicontr(i))*dsp0(i,02)+fsp0(i,05)
      dpp0(i,06)=ayby(iicontr(i))*dsp0(i,03)+fsp0(i,06)
      dpp0(i,07)=azbz(iicontr(i))*dsp0(i,01)+fsp0(i,07)
      dpp0(i,08)=azbz(iicontr(i))*dsp0(i,02)+fsp0(i,08)
      dpp0(i,09)=azbz(iicontr(i))*dsp0(i,03)+fsp0(i,09)
      dpp0(i,10)=axbx(iicontr(i))*dsp0(i,04)+fsp0(i,04)
      dpp0(i,11)=axbx(iicontr(i))*dsp0(i,05)+fsp0(i,05)
      dpp0(i,12)=axbx(iicontr(i))*dsp0(i,06)+fsp0(i,06)
      dpp0(i,13)=ayby(iicontr(i))*dsp0(i,04)+fsp0(i,10)
      dpp0(i,14)=ayby(iicontr(i))*dsp0(i,05)+fsp0(i,11)
      dpp0(i,15)=ayby(iicontr(i))*dsp0(i,06)+fsp0(i,12)
      dpp0(i,16)=azbz(iicontr(i))*dsp0(i,04)+fsp0(i,13)
      dpp0(i,17)=azbz(iicontr(i))*dsp0(i,05)+fsp0(i,14)
      dpp0(i,18)=azbz(iicontr(i))*dsp0(i,06)+fsp0(i,15)
      dpp0(i,19)=axbx(iicontr(i))*dsp0(i,07)+fsp0(i,07)
      dpp0(i,20)=axbx(iicontr(i))*dsp0(i,08)+fsp0(i,08)
      dpp0(i,21)=axbx(iicontr(i))*dsp0(i,09)+fsp0(i,09)
      dpp0(i,22)=ayby(iicontr(i))*dsp0(i,07)+fsp0(i,13)
      dpp0(i,23)=ayby(iicontr(i))*dsp0(i,08)+fsp0(i,14)
      dpp0(i,24)=ayby(iicontr(i))*dsp0(i,09)+fsp0(i,15)
      dpp0(i,25)=azbz(iicontr(i))*dsp0(i,07)+fsp0(i,16)
      dpp0(i,26)=azbz(iicontr(i))*dsp0(i,08)+fsp0(i,17)
      dpp0(i,27)=azbz(iicontr(i))*dsp0(i,09)+fsp0(i,18)
      dpp0(i,28)=axbx(iicontr(i))*dsp0(i,10)+fsp0(i,10)
      dpp0(i,29)=axbx(iicontr(i))*dsp0(i,11)+fsp0(i,11)
      dpp0(i,30)=axbx(iicontr(i))*dsp0(i,12)+fsp0(i,12)
      dpp0(i,31)=ayby(iicontr(i))*dsp0(i,10)+fsp0(i,19)
      dpp0(i,32)=ayby(iicontr(i))*dsp0(i,11)+fsp0(i,20)
      dpp0(i,33)=ayby(iicontr(i))*dsp0(i,12)+fsp0(i,21)
      dpp0(i,34)=azbz(iicontr(i))*dsp0(i,10)+fsp0(i,22)
      dpp0(i,35)=azbz(iicontr(i))*dsp0(i,11)+fsp0(i,23)
      dpp0(i,36)=azbz(iicontr(i))*dsp0(i,12)+fsp0(i,24)
      dpp0(i,37)=axbx(iicontr(i))*dsp0(i,13)+fsp0(i,13)
      dpp0(i,38)=axbx(iicontr(i))*dsp0(i,14)+fsp0(i,14)
      dpp0(i,39)=axbx(iicontr(i))*dsp0(i,15)+fsp0(i,15)
      dpp0(i,40)=ayby(iicontr(i))*dsp0(i,13)+fsp0(i,22)
      dpp0(i,41)=ayby(iicontr(i))*dsp0(i,14)+fsp0(i,23)
      dpp0(i,42)=ayby(iicontr(i))*dsp0(i,15)+fsp0(i,24)
      dpp0(i,43)=azbz(iicontr(i))*dsp0(i,13)+fsp0(i,25)
      dpp0(i,44)=azbz(iicontr(i))*dsp0(i,14)+fsp0(i,26)
      dpp0(i,45)=azbz(iicontr(i))*dsp0(i,15)+fsp0(i,27)
      dpp0(i,46)=axbx(iicontr(i))*dsp0(i,16)+fsp0(i,16)
      dpp0(i,47)=axbx(iicontr(i))*dsp0(i,17)+fsp0(i,17)
      dpp0(i,48)=axbx(iicontr(i))*dsp0(i,18)+fsp0(i,18)
      dpp0(i,49)=ayby(iicontr(i))*dsp0(i,16)+fsp0(i,25)
      dpp0(i,50)=ayby(iicontr(i))*dsp0(i,17)+fsp0(i,26)
      dpp0(i,51)=ayby(iicontr(i))*dsp0(i,18)+fsp0(i,27)
      dpp0(i,52)=azbz(iicontr(i))*dsp0(i,16)+fsp0(i,28)
      dpp0(i,53)=azbz(iicontr(i))*dsp0(i,17)+fsp0(i,29)
 1032 dpp0(i,54)=azbz(iicontr(i))*dsp0(i,18)+fsp0(i,30)

      do 1033 i=1,nn
      dpd0(i,001)=axbx(iicontr(i))*dsd0(i,01)+fsd0(i,01)
      dpd0(i,002)=axbx(iicontr(i))*dsd0(i,02)+fsd0(i,02)
      dpd0(i,003)=axbx(iicontr(i))*dsd0(i,03)+fsd0(i,03)
      dpd0(i,004)=axbx(iicontr(i))*dsd0(i,04)+fsd0(i,04)
      dpd0(i,005)=axbx(iicontr(i))*dsd0(i,05)+fsd0(i,05)
      dpd0(i,006)=axbx(iicontr(i))*dsd0(i,06)+fsd0(i,06)
      dpd0(i,007)=ayby(iicontr(i))*dsd0(i,01)+fsd0(i,07)
      dpd0(i,008)=ayby(iicontr(i))*dsd0(i,02)+fsd0(i,08)
      dpd0(i,009)=ayby(iicontr(i))*dsd0(i,03)+fsd0(i,09)
      dpd0(i,010)=ayby(iicontr(i))*dsd0(i,04)+fsd0(i,10)
      dpd0(i,011)=ayby(iicontr(i))*dsd0(i,05)+fsd0(i,11)
      dpd0(i,012)=ayby(iicontr(i))*dsd0(i,06)+fsd0(i,12)
      dpd0(i,013)=azbz(iicontr(i))*dsd0(i,01)+fsd0(i,13)
      dpd0(i,014)=azbz(iicontr(i))*dsd0(i,02)+fsd0(i,14)
      dpd0(i,015)=azbz(iicontr(i))*dsd0(i,03)+fsd0(i,15)
      dpd0(i,016)=azbz(iicontr(i))*dsd0(i,04)+fsd0(i,16)
      dpd0(i,017)=azbz(iicontr(i))*dsd0(i,05)+fsd0(i,17)
      dpd0(i,018)=azbz(iicontr(i))*dsd0(i,06)+fsd0(i,18)
      dpd0(i,019)=axbx(iicontr(i))*dsd0(i,07)+fsd0(i,07)
      dpd0(i,020)=axbx(iicontr(i))*dsd0(i,08)+fsd0(i,08)
      dpd0(i,021)=axbx(iicontr(i))*dsd0(i,09)+fsd0(i,09)
      dpd0(i,022)=axbx(iicontr(i))*dsd0(i,10)+fsd0(i,10)
      dpd0(i,023)=axbx(iicontr(i))*dsd0(i,11)+fsd0(i,11)
      dpd0(i,024)=axbx(iicontr(i))*dsd0(i,12)+fsd0(i,12)
      dpd0(i,025)=ayby(iicontr(i))*dsd0(i,07)+fsd0(i,19)
      dpd0(i,026)=ayby(iicontr(i))*dsd0(i,08)+fsd0(i,20)
      dpd0(i,027)=ayby(iicontr(i))*dsd0(i,09)+fsd0(i,21)
      dpd0(i,028)=ayby(iicontr(i))*dsd0(i,10)+fsd0(i,22)
      dpd0(i,029)=ayby(iicontr(i))*dsd0(i,11)+fsd0(i,23)
      dpd0(i,030)=ayby(iicontr(i))*dsd0(i,12)+fsd0(i,24)
      dpd0(i,031)=azbz(iicontr(i))*dsd0(i,07)+fsd0(i,25)
      dpd0(i,032)=azbz(iicontr(i))*dsd0(i,08)+fsd0(i,26)
      dpd0(i,033)=azbz(iicontr(i))*dsd0(i,09)+fsd0(i,27)
      dpd0(i,034)=azbz(iicontr(i))*dsd0(i,10)+fsd0(i,28)
      dpd0(i,035)=azbz(iicontr(i))*dsd0(i,11)+fsd0(i,29)
      dpd0(i,036)=azbz(iicontr(i))*dsd0(i,12)+fsd0(i,30)
      dpd0(i,037)=axbx(iicontr(i))*dsd0(i,13)+fsd0(i,13)
      dpd0(i,038)=axbx(iicontr(i))*dsd0(i,14)+fsd0(i,14)
      dpd0(i,039)=axbx(iicontr(i))*dsd0(i,15)+fsd0(i,15)
      dpd0(i,040)=axbx(iicontr(i))*dsd0(i,16)+fsd0(i,16)
      dpd0(i,041)=axbx(iicontr(i))*dsd0(i,17)+fsd0(i,17)
      dpd0(i,042)=axbx(iicontr(i))*dsd0(i,18)+fsd0(i,18)
      dpd0(i,043)=ayby(iicontr(i))*dsd0(i,13)+fsd0(i,25)
      dpd0(i,044)=ayby(iicontr(i))*dsd0(i,14)+fsd0(i,26)
      dpd0(i,045)=ayby(iicontr(i))*dsd0(i,15)+fsd0(i,27)
      dpd0(i,046)=ayby(iicontr(i))*dsd0(i,16)+fsd0(i,28)
      dpd0(i,047)=ayby(iicontr(i))*dsd0(i,17)+fsd0(i,29)
      dpd0(i,048)=ayby(iicontr(i))*dsd0(i,18)+fsd0(i,30)
      dpd0(i,049)=azbz(iicontr(i))*dsd0(i,13)+fsd0(i,31)
      dpd0(i,050)=azbz(iicontr(i))*dsd0(i,14)+fsd0(i,32)
      dpd0(i,051)=azbz(iicontr(i))*dsd0(i,15)+fsd0(i,33)
      dpd0(i,052)=azbz(iicontr(i))*dsd0(i,16)+fsd0(i,34)
      dpd0(i,053)=azbz(iicontr(i))*dsd0(i,17)+fsd0(i,35)
      dpd0(i,054)=azbz(iicontr(i))*dsd0(i,18)+fsd0(i,36)
      dpd0(i,055)=axbx(iicontr(i))*dsd0(i,19)+fsd0(i,19)
      dpd0(i,056)=axbx(iicontr(i))*dsd0(i,20)+fsd0(i,20)
      dpd0(i,057)=axbx(iicontr(i))*dsd0(i,21)+fsd0(i,21)
      dpd0(i,058)=axbx(iicontr(i))*dsd0(i,22)+fsd0(i,22)
      dpd0(i,059)=axbx(iicontr(i))*dsd0(i,23)+fsd0(i,23)
      dpd0(i,060)=axbx(iicontr(i))*dsd0(i,24)+fsd0(i,24)
      dpd0(i,061)=ayby(iicontr(i))*dsd0(i,19)+fsd0(i,37)
      dpd0(i,062)=ayby(iicontr(i))*dsd0(i,20)+fsd0(i,38)
      dpd0(i,063)=ayby(iicontr(i))*dsd0(i,21)+fsd0(i,39)
      dpd0(i,064)=ayby(iicontr(i))*dsd0(i,22)+fsd0(i,40)
      dpd0(i,065)=ayby(iicontr(i))*dsd0(i,23)+fsd0(i,41)
      dpd0(i,066)=ayby(iicontr(i))*dsd0(i,24)+fsd0(i,42)
      dpd0(i,067)=azbz(iicontr(i))*dsd0(i,19)+fsd0(i,43)
      dpd0(i,068)=azbz(iicontr(i))*dsd0(i,20)+fsd0(i,44)
      dpd0(i,069)=azbz(iicontr(i))*dsd0(i,21)+fsd0(i,45)
      dpd0(i,070)=azbz(iicontr(i))*dsd0(i,22)+fsd0(i,46)
      dpd0(i,071)=azbz(iicontr(i))*dsd0(i,23)+fsd0(i,47)
      dpd0(i,072)=azbz(iicontr(i))*dsd0(i,24)+fsd0(i,48)
      dpd0(i,073)=axbx(iicontr(i))*dsd0(i,25)+fsd0(i,25)
      dpd0(i,074)=axbx(iicontr(i))*dsd0(i,26)+fsd0(i,26)
      dpd0(i,075)=axbx(iicontr(i))*dsd0(i,27)+fsd0(i,27)
      dpd0(i,076)=axbx(iicontr(i))*dsd0(i,28)+fsd0(i,28)
      dpd0(i,077)=axbx(iicontr(i))*dsd0(i,29)+fsd0(i,29)
      dpd0(i,078)=axbx(iicontr(i))*dsd0(i,30)+fsd0(i,30)
      dpd0(i,079)=ayby(iicontr(i))*dsd0(i,25)+fsd0(i,43)
      dpd0(i,080)=ayby(iicontr(i))*dsd0(i,26)+fsd0(i,44)
      dpd0(i,081)=ayby(iicontr(i))*dsd0(i,27)+fsd0(i,45)
      dpd0(i,082)=ayby(iicontr(i))*dsd0(i,28)+fsd0(i,46)
      dpd0(i,083)=ayby(iicontr(i))*dsd0(i,29)+fsd0(i,47)
      dpd0(i,084)=ayby(iicontr(i))*dsd0(i,30)+fsd0(i,48)
      dpd0(i,085)=azbz(iicontr(i))*dsd0(i,25)+fsd0(i,49)
      dpd0(i,086)=azbz(iicontr(i))*dsd0(i,26)+fsd0(i,50)
      dpd0(i,087)=azbz(iicontr(i))*dsd0(i,27)+fsd0(i,51)
      dpd0(i,088)=azbz(iicontr(i))*dsd0(i,28)+fsd0(i,52)
      dpd0(i,089)=azbz(iicontr(i))*dsd0(i,29)+fsd0(i,53)
      dpd0(i,090)=azbz(iicontr(i))*dsd0(i,30)+fsd0(i,54)
      dpd0(i,091)=axbx(iicontr(i))*dsd0(i,31)+fsd0(i,31)
      dpd0(i,092)=axbx(iicontr(i))*dsd0(i,32)+fsd0(i,32)
      dpd0(i,093)=axbx(iicontr(i))*dsd0(i,33)+fsd0(i,33)
      dpd0(i,094)=axbx(iicontr(i))*dsd0(i,34)+fsd0(i,34)
      dpd0(i,095)=axbx(iicontr(i))*dsd0(i,35)+fsd0(i,35)
      dpd0(i,096)=axbx(iicontr(i))*dsd0(i,36)+fsd0(i,36)
      dpd0(i,097)=ayby(iicontr(i))*dsd0(i,31)+fsd0(i,49)
      dpd0(i,098)=ayby(iicontr(i))*dsd0(i,32)+fsd0(i,50)
      dpd0(i,099)=ayby(iicontr(i))*dsd0(i,33)+fsd0(i,51)
      dpd0(i,100)=ayby(iicontr(i))*dsd0(i,34)+fsd0(i,52)
      dpd0(i,101)=ayby(iicontr(i))*dsd0(i,35)+fsd0(i,53)
      dpd0(i,102)=ayby(iicontr(i))*dsd0(i,36)+fsd0(i,54)
      dpd0(i,103)=azbz(iicontr(i))*dsd0(i,31)+fsd0(i,55)
      dpd0(i,104)=azbz(iicontr(i))*dsd0(i,32)+fsd0(i,56)
      dpd0(i,105)=azbz(iicontr(i))*dsd0(i,33)+fsd0(i,57)
      dpd0(i,106)=azbz(iicontr(i))*dsd0(i,34)+fsd0(i,58)
      dpd0(i,107)=azbz(iicontr(i))*dsd0(i,35)+fsd0(i,59)
 1033 dpd0(i,108)=azbz(iicontr(i))*dsd0(i,36)+fsd0(i,60)

      do 1034 j=1,18
      do 1034 i=1,nn
 1034 gather(iloc(i),j)=gather(iloc(i),j)
     &                 +dps0(i,j)*cdfits
     &                 +dpp0(i,3*(j-1)+1)*cdfitp(1)
     &                 +dpp0(i,3*(j-1)+2)*cdfitp(2)
     &                 +dpp0(i,3*(j-1)+3)*cdfitp(3)
     &                 +dpd0(i,6*(j-1)+1)*cdfitd(1)
     &                 +dpd0(i,6*(j-1)+2)*cdfitd(2)
     &                 +dpd0(i,6*(j-1)+3)*cdfitd(3)
     &                 +dpd0(i,6*(j-1)+4)*cdfitd(4)
     &                 +dpd0(i,6*(j-1)+5)*cdfitd(5)
     &                 +dpd0(i,6*(j-1)+6)*cdfitd(6)

 1001 continue

      do 1035 i=1,n
      do 1035 j=1,18
 1035 fock(inddyy(icontr(i),j))=fock(inddyy(icontr(i),j))+gather(i,j)

      return
      end
