      subroutine frac_occ(noccupied,norbitals,energy,occupation)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension energy(*),occupation(*)

      data zero,one,two,ten/0.0d0,1.0d0,2.0d0,10.0d0/
      data tol,beta/0.000000000001d0,500.0d0/

      factor=energy(noccupied+1)-energy(noccupied)

      beta_value=beta

      total_density=real64(noccupied)

      epsilon=zero

      spacing=ten

      iswitch=0
      jswitch=0

      do 1001 k=1,50000

      density=zero

      do 1002 j=1,norbitals
      occupation(j)=one/(one+exp(-beta_value*(epsilon-energy(j))))
 1002 density=density+occupation(j)

      if(density.gt.total_density) epsilon=epsilon-spacing
      if(density.lt.total_density) epsilon=epsilon+spacing

      jswitch=iswitch

      if(density.gt.total_density) iswitch=0
      if(density.lt.total_density) iswitch=1

      if((iswitch.ne.jswitch).and.(k.ne.1)) spacing=spacing/two

      if(abs(density-total_density).lt.tol) then

         cut=sqrt(tol)

         do 1003 j=1,norbitals
         if((j.le.noccupied).and.
     &      (occupation(j).lt.(one-cut))) write(6,1004) j,occupation(j)
         if((j.gt.noccupied).and.
     &      (occupation(j).gt.cut)) write(6,1004) j,occupation(j)
 1003    continue
 1004    format(' fractional occupation, orbital # ',i6,
     &          ' population = ',f13.4)

         return

                                            endif

 1001 continue

      stop 'no convergence in fractional occupation routine'
      end
