      subroutine gengrid(nreal,ninteger,maxpoints,ngridtype,ncenters,
     &                   nconts,ncontp,ncontd,ilfunc,icfunc,ngauss,
     &                   nptrs,nptrp,nptrd,natomtype,nptsatom,iwkvec,
     &                   cent,alpha,coeff,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension istat(mpi_status_size)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)
      dimension natomtype(*),nptsatom(*),iwkvec(*)

      dimension cent(3,*),alpha(*),coeff(*),wkvec(*)

      data small,two,four,eight,dlarge/0.1d0,2.0d0,4.0d0,8.0d0,1.0d+35/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      xmin=+dlarge
      ymin=+dlarge
      zmin=+dlarge

      xmax=-dlarge
      ymax=-dlarge
      zmax=-dlarge

      do 1001 i=1,ncenters
      if(cent(1,i).lt.xmin) xmin=cent(1,i)
      if(cent(2,i).lt.ymin) ymin=cent(2,i)
 1001 if(cent(3,i).lt.zmin) zmin=cent(3,i)

      do 1002 i=1,ncenters
      if(cent(1,i).gt.xmax) xmax=cent(1,i)
      if(cent(2,i).gt.ymax) ymax=cent(2,i)
 1002 if(cent(3,i).gt.zmax) zmax=cent(3,i)

      xrange=xmax-xmin
      yrange=ymax-ymin
      zrange=zmax-zmin

      xmod=mod(xrange,four)
      ymod=mod(yrange,four)
      zmod=mod(zrange,four)

      xmin=xmin-(four-xmod)/two-two*eight*eight
      ymin=ymin-(four-ymod)/two-two*eight*eight
      zmin=zmin-(four-zmod)/two-two*eight*eight

      xmax=xmax+(four-xmod)/two+two*eight*eight
      ymax=ymax+(four-ymod)/two+two*eight*eight
      zmax=zmax+(four-zmod)/two+two*eight*eight

      nxboxes=int(((xmax-xmin)/four)+small)
      nyboxes=int(((ymax-ymin)/four)+small)
      nzboxes=int(((zmax-zmin)/four)+small)

      nboxes=nxboxes*nyboxes*nzboxes

      do 1003 i=1,nboxes
 1003 iwkvec(i)=0

      ja=1
      jb=ja+maxpoints
      jc=jb+maxpoints
      jd=jc+maxpoints
      je=jd+maxpoints
      jf=je+ncenters*maxpoints
      jg=jf+ncenters*ncenters
      jh=jg+ncenters

      ji=jh+ncenters

      if(ji.gt.nreal) stop 'real overflow in gengrid'
      if((nboxes+ncenters).gt.ninteger) stop 'int overflow in gengrid'

      call gridgen(ngridtype,nboxes,nxboxes,nyboxes,nzboxes,ncenters,
     &             nconts,ncontp,ncontd,ilfunc,icfunc,ngauss,nptrs,
     &             nptrp,nptrd,natomtype,nptsatom,iwkvec,
     &             iwkvec(nboxes+1),xmin,ymin,zmin,xmax,ymax,zmax,cent,
     &             alpha,coeff,wkvec(ja),wkvec(jb),wkvec(jc),wkvec(jd),
     &             wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh))

      if(myid.gt.0) return

      iboxes=0
      index=1

      do 1004 i=1,nboxes
      iadd=iwkvec(i)
      iwkvec(i)=index
      index=index+iadd
 1004 if(iadd.gt.0) iboxes=iboxes+1

      ia=1
      ib=ia+nboxes
      ic=ib+nboxes
      id=ic+index

      ja=maxpoints+1
      jb=ja+maxpoints
      jc=jb+maxpoints
      jd=jc+maxpoints
      je=jd+maxpoints
      jf=je+index
      jg=jf+index
      jh=jg+index
      ji=jh+index
      jj=ji+iboxes*3

      if(jj.gt.nreal) stop 'real overflow in gengrid'
      if(id.gt.ninteger) stop 'integer overflow in gengrid'

      call gridsort(nboxes,iboxes,nxboxes,nyboxes,nzboxes,ncenters,
     &              natomtype,nptsatom,iwkvec(ia),iwkvec(ib),iwkvec(ic),
     &              xmin,ymin,zmin,wkvec(ja),wkvec(jb),wkvec(jc),
     &              wkvec(jd),wkvec(je),wkvec(jf),wkvec(jg),wkvec(jh),
     &              wkvec(ji))

      return
      end
