      subroutine getks(nreal,ncontractions,nalpha,nbeta,iwkvec,dmixing,
     &                 elevelshift,changep,rmschange,amat,bmat,
     &                 fockalpha,fockbeta,coeffalpha,coeffbeta,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iwkvec(*)

      dimension amat(*),bmat(*),fockalpha(*),fockbeta(*)
      dimension coeffalpha(ncontractions,*),coeffbeta(ncontractions,*)
      dimension wkvec(*)

      ja=1
      jb=ja+ncontractions*ncontractions
      jc=jb+ncontractions
      jd=jc+ncontractions
      je=jd+ncontractions*ncontractions
      jf=je+ncontractions*ncontractions
      jg=jf+ncontractions*(ncontractions+1)/2
      jh=jg+ncontractions*3
      ji=jh+ncontractions*(ncontractions+1)/2

      if(ji.gt.nreal) stop 'real overflow in getks'

      call solveks(ncontractions,nalpha,nbeta,iwkvec,dmixing,
     &             elevelshift,changep,rmschange,amat,bmat,fockalpha,
     &             fockbeta,coeffalpha,coeffbeta,wkvec(ja),wkvec(jb),
     &             wkvec(jc),wkvec(jd),wkvec(je),wkvec(jf),wkvec(jg),
     &             wkvec(jh))

      return
      end
