      subroutine gradcddp(m,n,ncds,ilfunc,icfunc,icontr,inddyy,icentr,
     &                    iicontr,g,coord,density,gradient,cdfitc,
     &                    alphaaux,coeffs,zeta,twozetaa,twozetab,px,py,
     &                    pz,base,pxax,pyay,pzaz,axbx,ayby,azbz,zzeta,
     &                    ttwozetaa,ttwozetab,zetarec,ppx,ppy,ppz,ppxax,
     &                    ppyay,ppzaz,wxpx,wypy,wzpz,zetac1,u,sss0,sss1,
     &                    sss2,sss3,sss4,pss0,pss1,pss2,pss3,dss0,dss1,
     &                    dss2,fss0,fss1,gss0,c,c1,pscond,dscond,ppcond,
     &                    fscond,dpcond,gscond,fpcond,ddcond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension ilfunc(*),icfunc(*),icontr(*),inddyy(m,*),icentr(m,*),
     &          iicontr(*)

      dimension g(*),coord(3,*),density(*),gradient(3,*),cdfitc(*),
     &          alphaaux(*),coeffs(*),zeta(*),twozetaa(*),twozetab(*),
     &          px(*),py(*),pz(*),base(*),pxax(*),pyay(*),pzaz(*),
     &          axbx(*),ayby(*),azbz(*),zzeta(*),ttwozetaa(*),
     &          ttwozetab(*),zetarec(*),ppx(*),ppy(*),ppz(*),ppxax(*),
     &          ppyay(*),ppzaz(*),wxpx(*),wypy(*),wzpz(*),zetac1(*),
     &          u(*),sss0(*),sss1(*),sss2(*),sss3(*),sss4(*),pss0(n,*),
     &          pss1(n,*),pss2(n,*),pss3(n,*),dss0(n,*),dss1(n,*),
     &          dss2(n,*),fss0(n,*),fss1(n,*),gss0(n,*),c(*),c1(n,*),
     &          pscond(m,*),dscond(m,*),ppcond(m,*),fscond(m,*),
     &          dpcond(m,*),gscond(m,*),fpcond(m,*),ddcond(m,*),
     &          grad(m,*)

      data one,two,three,four,five,seven/1.0d0,2.0d0,3.0d0,
     &                                   4.0d0,5.0d0,7.0d0/
      data zero,half,thrhlf,pi/0.0d0,0.5d0,1.5d0,3.1415926535898d0/
      data calcut/1.0d-16/

      twoeconst=two*pi**(five/two)

      do 1001 naux=1,ncds

      ilaux=ilfunc(naux)

      nc=icfunc(ilaux)

      ccx=coord(1,nc)
      ccy=coord(2,nc)
      ccz=coord(3,nc)

      zetaux=alphaaux(ilaux)

      cdfits=cdfitc(naux)*coeffs(ilaux)

      do 1002 i=1,n
 1002 zetarec(i)=one/(zeta(i)+zetaux)

      do 1003 i=1,n
      pxcx=px(i)-ccx
      pycy=py(i)-ccy
      pzcz=pz(i)-ccz
 1003 u(i)=zeta(i)*zetaux*zetarec(i)*(pxcx*pxcx+pycy*pycy+pzcz*pzcz)

      do 1004 i=1,n
      call augg(5,u(i),g)
      sss0(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(1)/zeta(i)/zetaux
      sss1(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(2)/zeta(i)/zetaux
      sss2(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(3)/zeta(i)/zetaux
      sss3(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(4)/zeta(i)/zetaux
 1004 sss4(i)=base(i)*twoeconst*sqrt(zetarec(i))*g(5)/zeta(i)/zetaux

      nn=0

      do 1005 i=1,n
      if(abs(sss0(i)).gt.calcut) then
                                       nn=nn+1

                                       iicontr(nn)=icontr(i)

                                       zzeta(nn)=zeta(i)

                                       ttwozetaa(nn)=twozetaa(i)
                                       ttwozetab(nn)=twozetab(i)

                                       ppx(nn)=px(i)
                                       ppy(nn)=py(i)
                                       ppz(nn)=pz(i)

                                       ppxax(nn)=pxax(i)
                                       ppyay(nn)=pyay(i)
                                       ppzaz(nn)=pzaz(i)

                                       zetarec(nn)=zetarec(i)

                                       sss0(nn)=sss0(i)
                                       sss1(nn)=sss1(i)
                                       sss2(nn)=sss2(i)
                                       sss3(nn)=sss3(i)
                                       sss4(nn)=sss4(i)
                                 endif
 1005 continue

      do 1006 i=1,nn
 1006 zetac1(i)=zetaux*zetarec(i)

      do 1007 i=1,nn
      wxpx(i)=((zzeta(i)*ppx(i)+zetaux*ccx)*zetarec(i))-ppx(i)
      wypy(i)=((zzeta(i)*ppy(i)+zetaux*ccy)*zetarec(i))-ppy(i)
 1007 wzpz(i)=((zzeta(i)*ppz(i)+zetaux*ccz)*zetarec(i))-ppz(i)

      do 1008 i=1,nn
      pss0(i,1)=ppxax(i)*sss0(i)+wxpx(i)*sss1(i)
      pss0(i,2)=ppyay(i)*sss0(i)+wypy(i)*sss1(i)
 1008 pss0(i,3)=ppzaz(i)*sss0(i)+wzpz(i)*sss1(i)

      do 1009 i=1,nn
      pss1(i,1)=ppxax(i)*sss1(i)+wxpx(i)*sss2(i)
      pss1(i,2)=ppyay(i)*sss1(i)+wypy(i)*sss2(i)
 1009 pss1(i,3)=ppzaz(i)*sss1(i)+wzpz(i)*sss2(i)

      do 1010 i=1,nn
      pss2(i,1)=ppxax(i)*sss2(i)+wxpx(i)*sss3(i)
      pss2(i,2)=ppyay(i)*sss2(i)+wypy(i)*sss3(i)
 1010 pss2(i,3)=ppzaz(i)*sss2(i)+wzpz(i)*sss3(i)

      do 1011 i=1,nn
      pss3(i,1)=ppxax(i)*sss3(i)+wxpx(i)*sss4(i)
      pss3(i,2)=ppyay(i)*sss3(i)+wypy(i)*sss4(i)
 1011 pss3(i,3)=ppzaz(i)*sss3(i)+wzpz(i)*sss4(i)

      do 1012 i=1,nn
 1012 c(i)=(sss0(i)-zetac1(i)*sss1(i))/(two*zzeta(i))

      do 1013 i=1,nn
      dss0(i,1)=ppxax(i)*pss0(i,1)+wxpx(i)*pss1(i,1)+c(i)
      dss0(i,2)=ppyay(i)*pss0(i,1)+wypy(i)*pss1(i,1)
      dss0(i,3)=ppzaz(i)*pss0(i,1)+wzpz(i)*pss1(i,1)
      dss0(i,4)=ppyay(i)*pss0(i,2)+wypy(i)*pss1(i,2)+c(i)
      dss0(i,5)=ppzaz(i)*pss0(i,2)+wzpz(i)*pss1(i,2)
 1013 dss0(i,6)=ppzaz(i)*pss0(i,3)+wzpz(i)*pss1(i,3)+c(i)

      do 1014 i=1,nn
 1014 c(i)=(sss1(i)-zetac1(i)*sss2(i))/(two*zzeta(i))

      do 1015 i=1,nn
      dss1(i,1)=ppxax(i)*pss1(i,1)+wxpx(i)*pss2(i,1)+c(i)
      dss1(i,2)=ppyay(i)*pss1(i,1)+wypy(i)*pss2(i,1)
      dss1(i,3)=ppzaz(i)*pss1(i,1)+wzpz(i)*pss2(i,1)
      dss1(i,4)=ppyay(i)*pss1(i,2)+wypy(i)*pss2(i,2)+c(i)
      dss1(i,5)=ppzaz(i)*pss1(i,2)+wzpz(i)*pss2(i,2)
 1015 dss1(i,6)=ppzaz(i)*pss1(i,3)+wzpz(i)*pss2(i,3)+c(i)

      do 1016 i=1,nn
 1016 c(i)=(sss2(i)-zetac1(i)*sss3(i))/(two*zzeta(i))

      do 1017 i=1,nn
      dss2(i,1)=ppxax(i)*pss2(i,1)+wxpx(i)*pss3(i,1)+c(i)
      dss2(i,2)=ppyay(i)*pss2(i,1)+wypy(i)*pss3(i,1)
      dss2(i,3)=ppzaz(i)*pss2(i,1)+wzpz(i)*pss3(i,1)
      dss2(i,4)=ppyay(i)*pss2(i,2)+wypy(i)*pss3(i,2)+c(i)
      dss2(i,5)=ppzaz(i)*pss2(i,2)+wzpz(i)*pss3(i,2)
 1017 dss2(i,6)=ppzaz(i)*pss2(i,3)+wzpz(i)*pss3(i,3)+c(i)

      do 1018 j=1,3
      do 1018 i=1,nn
 1018 c1(i,j)=(pss0(i,j)-zetac1(i)*pss1(i,j))/(two*zzeta(i))

      do 1019 i=1,nn
      fss0(i,01)=ppxax(i)*dss0(i,1)+wxpx(i)*dss1(i,1)+c1(i,1)+c1(i,1)
      fss0(i,02)=ppyay(i)*dss0(i,1)+wypy(i)*dss1(i,1)
      fss0(i,03)=ppzaz(i)*dss0(i,1)+wzpz(i)*dss1(i,1)
      fss0(i,04)=ppyay(i)*dss0(i,2)+wypy(i)*dss1(i,2)+c1(i,1)
      fss0(i,05)=ppzaz(i)*dss0(i,2)+wzpz(i)*dss1(i,2)
      fss0(i,06)=ppzaz(i)*dss0(i,3)+wzpz(i)*dss1(i,3)+c1(i,1)
      fss0(i,07)=ppyay(i)*dss0(i,4)+wypy(i)*dss1(i,4)+c1(i,2)+c1(i,2)
      fss0(i,08)=ppzaz(i)*dss0(i,4)+wzpz(i)*dss1(i,4)
      fss0(i,09)=ppzaz(i)*dss0(i,5)+wzpz(i)*dss1(i,5)+c1(i,2)
 1019 fss0(i,10)=ppzaz(i)*dss0(i,6)+wzpz(i)*dss1(i,6)+c1(i,3)+c1(i,3)

      do 1020 j=1,3
      do 1020 i=1,nn
 1020 c1(i,j)=(pss1(i,j)-zetac1(i)*pss2(i,j))/(two*zzeta(i))

      do 1021 i=1,nn
      fss1(i,01)=ppxax(i)*dss1(i,1)+wxpx(i)*dss2(i,1)+c1(i,1)+c1(i,1)
      fss1(i,02)=ppyay(i)*dss1(i,1)+wypy(i)*dss2(i,1)
      fss1(i,03)=ppzaz(i)*dss1(i,1)+wzpz(i)*dss2(i,1)
      fss1(i,04)=ppyay(i)*dss1(i,2)+wypy(i)*dss2(i,2)+c1(i,1)
      fss1(i,05)=ppzaz(i)*dss1(i,2)+wzpz(i)*dss2(i,2)
      fss1(i,06)=ppzaz(i)*dss1(i,3)+wzpz(i)*dss2(i,3)+c1(i,1)
      fss1(i,07)=ppyay(i)*dss1(i,4)+wypy(i)*dss2(i,4)+c1(i,2)+c1(i,2)
      fss1(i,08)=ppzaz(i)*dss1(i,4)+wzpz(i)*dss2(i,4)
      fss1(i,09)=ppzaz(i)*dss1(i,5)+wzpz(i)*dss2(i,5)+c1(i,2)
 1021 fss1(i,10)=ppzaz(i)*dss1(i,6)+wzpz(i)*dss2(i,6)+c1(i,3)+c1(i,3)

      do 1022 j=1,6
      do 1022 i=1,nn
 1022 c1(i,j)=(dss0(i,j)-zetac1(i)*dss1(i,j))/(two*zzeta(i))

      do 1023 i=1,nn
      gss0(i,01)=ppxax(i)*fss0(i,01)+wxpx(i)*fss1(i,01)+c1(i,1)*three
      gss0(i,02)=ppyay(i)*fss0(i,01)+wypy(i)*fss1(i,01)
      gss0(i,03)=ppzaz(i)*fss0(i,01)+wzpz(i)*fss1(i,01)
      gss0(i,04)=ppyay(i)*fss0(i,02)+wypy(i)*fss1(i,02)+c1(i,1)
      gss0(i,05)=ppzaz(i)*fss0(i,02)+wzpz(i)*fss1(i,02)
      gss0(i,06)=ppzaz(i)*fss0(i,03)+wzpz(i)*fss1(i,03)+c1(i,1)
      gss0(i,07)=ppyay(i)*fss0(i,04)+wypy(i)*fss1(i,04)+c1(i,2)*two
      gss0(i,08)=ppzaz(i)*fss0(i,04)+wzpz(i)*fss1(i,04)
      gss0(i,09)=ppzaz(i)*fss0(i,05)+wzpz(i)*fss1(i,05)+c1(i,2)
      gss0(i,10)=ppzaz(i)*fss0(i,06)+wzpz(i)*fss1(i,06)+c1(i,3)*two
      gss0(i,11)=ppyay(i)*fss0(i,07)+wypy(i)*fss1(i,07)+c1(i,4)*three
      gss0(i,12)=ppzaz(i)*fss0(i,07)+wzpz(i)*fss1(i,07)
      gss0(i,13)=ppzaz(i)*fss0(i,08)+wzpz(i)*fss1(i,08)+c1(i,4)
      gss0(i,14)=ppzaz(i)*fss0(i,09)+wzpz(i)*fss1(i,09)+c1(i,5)*two
 1023 gss0(i,15)=ppzaz(i)*fss0(i,10)+wzpz(i)*fss1(i,10)+c1(i,6)*three

      do 1024 j=1,3
      do 1024 i=1,m
 1024 pscond(i,j)=zero

      do 1025 j=1,6
      do 1025 i=1,m
 1025 dscond(i,j)=zero

      do 1026 j=1,3
      do 1026 i=1,nn
 1026 pscond(iicontr(i),j)=pscond(iicontr(i),j)-pss0(i,j)

      do 1027 j=1,6
      do 1027 i=1,nn
 1027 dscond(iicontr(i),j)=dscond(iicontr(i),j)-dss0(i,j)

      do 1028 i=1,m
      ppcond(i,1)=axbx(i)*pscond(i,1)+dscond(i,1)
      ppcond(i,2)=ayby(i)*pscond(i,1)+dscond(i,2)
      ppcond(i,3)=azbz(i)*pscond(i,1)+dscond(i,3)
      ppcond(i,4)=axbx(i)*pscond(i,2)+dscond(i,2)
      ppcond(i,5)=ayby(i)*pscond(i,2)+dscond(i,4)
      ppcond(i,6)=azbz(i)*pscond(i,2)+dscond(i,5)
      ppcond(i,7)=axbx(i)*pscond(i,3)+dscond(i,3)
      ppcond(i,8)=ayby(i)*pscond(i,3)+dscond(i,5)
 1028 ppcond(i,9)=azbz(i)*pscond(i,3)+dscond(i,6)

      do 1029 i=1,m
      grad(i,01)=ppcond(i,1)*density(inddyy(i,01))*cdfits*two
      grad(i,02)=ppcond(i,2)*density(inddyy(i,02))*cdfits*two
      grad(i,03)=ppcond(i,3)*density(inddyy(i,03))*cdfits*two
      grad(i,04)=ppcond(i,4)*density(inddyy(i,04))*cdfits
      grad(i,05)=ppcond(i,5)*density(inddyy(i,05))*cdfits
      grad(i,06)=ppcond(i,6)*density(inddyy(i,06))*cdfits
      grad(i,07)=ppcond(i,7)*density(inddyy(i,07))*cdfits
      grad(i,08)=ppcond(i,8)*density(inddyy(i,08))*cdfits
      grad(i,09)=ppcond(i,9)*density(inddyy(i,09))*cdfits
      grad(i,10)=ppcond(i,1)*density(inddyy(i,04))*cdfits
      grad(i,11)=ppcond(i,2)*density(inddyy(i,05))*cdfits
      grad(i,12)=ppcond(i,3)*density(inddyy(i,06))*cdfits
      grad(i,13)=ppcond(i,4)*density(inddyy(i,10))*cdfits*two
      grad(i,14)=ppcond(i,5)*density(inddyy(i,11))*cdfits*two
      grad(i,15)=ppcond(i,6)*density(inddyy(i,12))*cdfits*two
      grad(i,16)=ppcond(i,7)*density(inddyy(i,13))*cdfits
      grad(i,17)=ppcond(i,8)*density(inddyy(i,14))*cdfits
      grad(i,18)=ppcond(i,9)*density(inddyy(i,15))*cdfits
      grad(i,19)=ppcond(i,1)*density(inddyy(i,07))*cdfits
      grad(i,20)=ppcond(i,2)*density(inddyy(i,08))*cdfits
      grad(i,21)=ppcond(i,3)*density(inddyy(i,09))*cdfits
      grad(i,22)=ppcond(i,4)*density(inddyy(i,13))*cdfits
      grad(i,23)=ppcond(i,5)*density(inddyy(i,14))*cdfits
      grad(i,24)=ppcond(i,6)*density(inddyy(i,15))*cdfits
      grad(i,25)=ppcond(i,7)*density(inddyy(i,16))*cdfits*two
      grad(i,26)=ppcond(i,8)*density(inddyy(i,17))*cdfits*two
 1029 grad(i,27)=ppcond(i,9)*density(inddyy(i,18))*cdfits*two

      do 1030 k=1,3
      do 1030 j=1,9
      do 1030 i=1,m
 1030 gradient(k,nc)=gradient(k,nc)-grad(i,9*(k-1)+j)

      do 1031 k=1,3
      do 1031 j=1,9
      do 1031 i=1,m
 1031 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,9*(k-1)+j)

      do 1032 i=1,m
      grad(i,01)=dscond(i,1)*density(inddyy(i,01))*cdfits
      grad(i,02)=dscond(i,2)*density(inddyy(i,04))*cdfits
      grad(i,03)=dscond(i,3)*density(inddyy(i,07))*cdfits
      grad(i,04)=dscond(i,4)*density(inddyy(i,10))*cdfits
      grad(i,05)=dscond(i,5)*density(inddyy(i,13))*cdfits
      grad(i,06)=dscond(i,6)*density(inddyy(i,16))*cdfits
      grad(i,07)=dscond(i,1)*density(inddyy(i,02))*cdfits
      grad(i,08)=dscond(i,2)*density(inddyy(i,05))*cdfits
      grad(i,09)=dscond(i,3)*density(inddyy(i,08))*cdfits
      grad(i,10)=dscond(i,4)*density(inddyy(i,11))*cdfits
      grad(i,11)=dscond(i,5)*density(inddyy(i,14))*cdfits
      grad(i,12)=dscond(i,6)*density(inddyy(i,17))*cdfits
      grad(i,13)=dscond(i,1)*density(inddyy(i,03))*cdfits
      grad(i,14)=dscond(i,2)*density(inddyy(i,06))*cdfits
      grad(i,15)=dscond(i,3)*density(inddyy(i,09))*cdfits
      grad(i,16)=dscond(i,4)*density(inddyy(i,12))*cdfits
      grad(i,17)=dscond(i,5)*density(inddyy(i,15))*cdfits
 1032 grad(i,18)=dscond(i,6)*density(inddyy(i,18))*cdfits

      do 1033 k=1,3
      do 1033 j=1,6
      do 1033 i=1,m
 1033 gradient(k,nc)=gradient(k,nc)-grad(i,6*(k-1)+j)

      do 1034 k=1,3
      do 1034 j=1,6
      do 1034 i=1,m
 1034 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,6*(k-1)+j)

      do 1035 j=1,10
      do 1035 i=1,m
 1035 fscond(i,j)=zero

      do 1036 j=1,15
      do 1036 i=1,m
 1036 gscond(i,j)=zero

      do 1037 j=1,10
      do 1037 i=1,nn
 1037 fscond(iicontr(i),j)=fscond(iicontr(i),j)+fss0(i,j)*ttwozetaa(i)

      do 1038 j=1,15
      do 1038 i=1,nn
 1038 gscond(iicontr(i),j)=gscond(iicontr(i),j)+gss0(i,j)*ttwozetaa(i)

      do 1039 i=1,m
      fpcond(i,01)=axbx(i)*fscond(i,01)+gscond(i,01)
      fpcond(i,02)=ayby(i)*fscond(i,01)+gscond(i,02)
      fpcond(i,03)=azbz(i)*fscond(i,01)+gscond(i,03)
      fpcond(i,04)=axbx(i)*fscond(i,02)+gscond(i,02)
      fpcond(i,05)=ayby(i)*fscond(i,02)+gscond(i,04)
      fpcond(i,06)=azbz(i)*fscond(i,02)+gscond(i,05)
      fpcond(i,07)=axbx(i)*fscond(i,03)+gscond(i,03)
      fpcond(i,08)=ayby(i)*fscond(i,03)+gscond(i,05)
      fpcond(i,09)=azbz(i)*fscond(i,03)+gscond(i,06)
      fpcond(i,10)=axbx(i)*fscond(i,04)+gscond(i,04)
      fpcond(i,11)=ayby(i)*fscond(i,04)+gscond(i,07)
      fpcond(i,12)=azbz(i)*fscond(i,04)+gscond(i,08)
      fpcond(i,13)=axbx(i)*fscond(i,05)+gscond(i,05)
      fpcond(i,14)=ayby(i)*fscond(i,05)+gscond(i,08)
      fpcond(i,15)=azbz(i)*fscond(i,05)+gscond(i,09)
      fpcond(i,16)=axbx(i)*fscond(i,06)+gscond(i,06)
      fpcond(i,17)=ayby(i)*fscond(i,06)+gscond(i,09)
      fpcond(i,18)=azbz(i)*fscond(i,06)+gscond(i,10)
      fpcond(i,19)=axbx(i)*fscond(i,07)+gscond(i,07)
      fpcond(i,20)=ayby(i)*fscond(i,07)+gscond(i,11)
      fpcond(i,21)=azbz(i)*fscond(i,07)+gscond(i,12)
      fpcond(i,22)=axbx(i)*fscond(i,08)+gscond(i,08)
      fpcond(i,23)=ayby(i)*fscond(i,08)+gscond(i,12)
      fpcond(i,24)=azbz(i)*fscond(i,08)+gscond(i,13)
      fpcond(i,25)=axbx(i)*fscond(i,09)+gscond(i,09)
      fpcond(i,26)=ayby(i)*fscond(i,09)+gscond(i,13)
      fpcond(i,27)=azbz(i)*fscond(i,09)+gscond(i,14)
      fpcond(i,28)=axbx(i)*fscond(i,10)+gscond(i,10)
      fpcond(i,29)=ayby(i)*fscond(i,10)+gscond(i,14)
 1039 fpcond(i,30)=azbz(i)*fscond(i,10)+gscond(i,15)

      do 1040 i=1,m
      grad(i,01)=fpcond(i,01)*density(inddyy(i,01))*cdfits
      grad(i,02)=fpcond(i,02)*density(inddyy(i,02))*cdfits
      grad(i,03)=fpcond(i,03)*density(inddyy(i,03))*cdfits
      grad(i,04)=fpcond(i,04)*density(inddyy(i,04))*cdfits
      grad(i,05)=fpcond(i,05)*density(inddyy(i,05))*cdfits
      grad(i,06)=fpcond(i,06)*density(inddyy(i,06))*cdfits
      grad(i,07)=fpcond(i,07)*density(inddyy(i,07))*cdfits
      grad(i,08)=fpcond(i,08)*density(inddyy(i,08))*cdfits
      grad(i,09)=fpcond(i,09)*density(inddyy(i,09))*cdfits
      grad(i,10)=fpcond(i,10)*density(inddyy(i,10))*cdfits
      grad(i,11)=fpcond(i,11)*density(inddyy(i,11))*cdfits
      grad(i,12)=fpcond(i,12)*density(inddyy(i,12))*cdfits
      grad(i,13)=fpcond(i,13)*density(inddyy(i,13))*cdfits
      grad(i,14)=fpcond(i,14)*density(inddyy(i,14))*cdfits
      grad(i,15)=fpcond(i,15)*density(inddyy(i,15))*cdfits
      grad(i,16)=fpcond(i,16)*density(inddyy(i,16))*cdfits
      grad(i,17)=fpcond(i,17)*density(inddyy(i,17))*cdfits
      grad(i,18)=fpcond(i,18)*density(inddyy(i,18))*cdfits
      grad(i,19)=fpcond(i,04)*density(inddyy(i,01))*cdfits
      grad(i,20)=fpcond(i,05)*density(inddyy(i,02))*cdfits
      grad(i,21)=fpcond(i,06)*density(inddyy(i,03))*cdfits
      grad(i,22)=fpcond(i,10)*density(inddyy(i,04))*cdfits
      grad(i,23)=fpcond(i,11)*density(inddyy(i,05))*cdfits
      grad(i,24)=fpcond(i,12)*density(inddyy(i,06))*cdfits
      grad(i,25)=fpcond(i,13)*density(inddyy(i,07))*cdfits
      grad(i,26)=fpcond(i,14)*density(inddyy(i,08))*cdfits
      grad(i,27)=fpcond(i,15)*density(inddyy(i,09))*cdfits
      grad(i,28)=fpcond(i,19)*density(inddyy(i,10))*cdfits
      grad(i,29)=fpcond(i,20)*density(inddyy(i,11))*cdfits
      grad(i,30)=fpcond(i,21)*density(inddyy(i,12))*cdfits
      grad(i,31)=fpcond(i,22)*density(inddyy(i,13))*cdfits
      grad(i,32)=fpcond(i,23)*density(inddyy(i,14))*cdfits
      grad(i,33)=fpcond(i,24)*density(inddyy(i,15))*cdfits
      grad(i,34)=fpcond(i,25)*density(inddyy(i,16))*cdfits
      grad(i,35)=fpcond(i,26)*density(inddyy(i,17))*cdfits
      grad(i,36)=fpcond(i,27)*density(inddyy(i,18))*cdfits
      grad(i,37)=fpcond(i,07)*density(inddyy(i,01))*cdfits
      grad(i,38)=fpcond(i,08)*density(inddyy(i,02))*cdfits
      grad(i,39)=fpcond(i,09)*density(inddyy(i,03))*cdfits
      grad(i,40)=fpcond(i,13)*density(inddyy(i,04))*cdfits
      grad(i,41)=fpcond(i,14)*density(inddyy(i,05))*cdfits
      grad(i,42)=fpcond(i,15)*density(inddyy(i,06))*cdfits
      grad(i,43)=fpcond(i,16)*density(inddyy(i,07))*cdfits
      grad(i,44)=fpcond(i,17)*density(inddyy(i,08))*cdfits
      grad(i,45)=fpcond(i,18)*density(inddyy(i,09))*cdfits
      grad(i,46)=fpcond(i,22)*density(inddyy(i,10))*cdfits
      grad(i,47)=fpcond(i,23)*density(inddyy(i,11))*cdfits
      grad(i,48)=fpcond(i,24)*density(inddyy(i,12))*cdfits
      grad(i,49)=fpcond(i,25)*density(inddyy(i,13))*cdfits
      grad(i,50)=fpcond(i,26)*density(inddyy(i,14))*cdfits
      grad(i,51)=fpcond(i,27)*density(inddyy(i,15))*cdfits
      grad(i,52)=fpcond(i,28)*density(inddyy(i,16))*cdfits
      grad(i,53)=fpcond(i,29)*density(inddyy(i,17))*cdfits
 1040 grad(i,54)=fpcond(i,30)*density(inddyy(i,18))*cdfits

      do 1041 k=1,3
      do 1041 j=1,18
      do 1041 i=1,m
 1041 gradient(k,nc)=gradient(k,nc)-grad(i,18*(k-1)+j)

      do 1042 k=1,3
      do 1042 j=1,18
      do 1042 i=1,m
 1042 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,18*(k-1)+j)

      do 1043 j=1,6
      do 1043 i=1,m
 1043 dscond(i,j)=zero

      do 1044 j=1,10
      do 1044 i=1,m
 1044 fscond(i,j)=zero

      do 1045 j=1,15
      do 1045 i=1,m
 1045 gscond(i,j)=zero

      do 1046 j=1,6
      do 1046 i=1,nn
 1046 dscond(iicontr(i),j)=dscond(iicontr(i),j)+dss0(i,j)*ttwozetab(i)

      do 1047 j=1,10
      do 1047 i=1,nn
 1047 fscond(iicontr(i),j)=fscond(iicontr(i),j)+fss0(i,j)*ttwozetab(i)

      do 1048 j=1,15
      do 1048 i=1,nn
 1048 gscond(iicontr(i),j)=gscond(iicontr(i),j)+gss0(i,j)*ttwozetab(i)

      do 1049 i=1,m
      dpcond(i,01)=axbx(i)*dscond(i,1)+fscond(i,01)
      dpcond(i,02)=ayby(i)*dscond(i,1)+fscond(i,02)
      dpcond(i,03)=azbz(i)*dscond(i,1)+fscond(i,03)
      dpcond(i,04)=axbx(i)*dscond(i,2)+fscond(i,02)
      dpcond(i,05)=ayby(i)*dscond(i,2)+fscond(i,04)
      dpcond(i,06)=azbz(i)*dscond(i,2)+fscond(i,05)
      dpcond(i,07)=axbx(i)*dscond(i,3)+fscond(i,03)
      dpcond(i,08)=ayby(i)*dscond(i,3)+fscond(i,05)
      dpcond(i,09)=azbz(i)*dscond(i,3)+fscond(i,06)
      dpcond(i,10)=axbx(i)*dscond(i,4)+fscond(i,04)
      dpcond(i,11)=ayby(i)*dscond(i,4)+fscond(i,07)
      dpcond(i,12)=azbz(i)*dscond(i,4)+fscond(i,08)
      dpcond(i,13)=axbx(i)*dscond(i,5)+fscond(i,05)
      dpcond(i,14)=ayby(i)*dscond(i,5)+fscond(i,08)
      dpcond(i,15)=azbz(i)*dscond(i,5)+fscond(i,09)
      dpcond(i,16)=axbx(i)*dscond(i,6)+fscond(i,06)
      dpcond(i,17)=ayby(i)*dscond(i,6)+fscond(i,09)
 1049 dpcond(i,18)=azbz(i)*dscond(i,6)+fscond(i,10)

      do 1050 i=1,m
      fpcond(i,01)=axbx(i)*fscond(i,01)+gscond(i,01)
      fpcond(i,02)=ayby(i)*fscond(i,01)+gscond(i,02)
      fpcond(i,03)=azbz(i)*fscond(i,01)+gscond(i,03)
      fpcond(i,04)=axbx(i)*fscond(i,02)+gscond(i,02)
      fpcond(i,05)=ayby(i)*fscond(i,02)+gscond(i,04)
      fpcond(i,06)=azbz(i)*fscond(i,02)+gscond(i,05)
      fpcond(i,07)=axbx(i)*fscond(i,03)+gscond(i,03)
      fpcond(i,08)=ayby(i)*fscond(i,03)+gscond(i,05)
      fpcond(i,09)=azbz(i)*fscond(i,03)+gscond(i,06)
      fpcond(i,10)=axbx(i)*fscond(i,04)+gscond(i,04)
      fpcond(i,11)=ayby(i)*fscond(i,04)+gscond(i,07)
      fpcond(i,12)=azbz(i)*fscond(i,04)+gscond(i,08)
      fpcond(i,13)=axbx(i)*fscond(i,05)+gscond(i,05)
      fpcond(i,14)=ayby(i)*fscond(i,05)+gscond(i,08)
      fpcond(i,15)=azbz(i)*fscond(i,05)+gscond(i,09)
      fpcond(i,16)=axbx(i)*fscond(i,06)+gscond(i,06)
      fpcond(i,17)=ayby(i)*fscond(i,06)+gscond(i,09)
      fpcond(i,18)=azbz(i)*fscond(i,06)+gscond(i,10)
      fpcond(i,19)=axbx(i)*fscond(i,07)+gscond(i,07)
      fpcond(i,20)=ayby(i)*fscond(i,07)+gscond(i,11)
      fpcond(i,21)=azbz(i)*fscond(i,07)+gscond(i,12)
      fpcond(i,22)=axbx(i)*fscond(i,08)+gscond(i,08)
      fpcond(i,23)=ayby(i)*fscond(i,08)+gscond(i,12)
      fpcond(i,24)=azbz(i)*fscond(i,08)+gscond(i,13)
      fpcond(i,25)=axbx(i)*fscond(i,09)+gscond(i,09)
      fpcond(i,26)=ayby(i)*fscond(i,09)+gscond(i,13)
      fpcond(i,27)=azbz(i)*fscond(i,09)+gscond(i,14)
      fpcond(i,28)=axbx(i)*fscond(i,10)+gscond(i,10)
      fpcond(i,29)=ayby(i)*fscond(i,10)+gscond(i,14)
 1050 fpcond(i,30)=azbz(i)*fscond(i,10)+gscond(i,15)

      do 1051 i=1,m
      ddcond(i,01)=axbx(i)*dpcond(i,01)+fpcond(i,01)
      ddcond(i,02)=ayby(i)*dpcond(i,01)+fpcond(i,04)
      ddcond(i,03)=azbz(i)*dpcond(i,01)+fpcond(i,07)
      ddcond(i,04)=ayby(i)*dpcond(i,02)+fpcond(i,05)
      ddcond(i,05)=azbz(i)*dpcond(i,02)+fpcond(i,08)
      ddcond(i,06)=azbz(i)*dpcond(i,03)+fpcond(i,09)
      ddcond(i,07)=axbx(i)*dpcond(i,04)+fpcond(i,04)
      ddcond(i,08)=ayby(i)*dpcond(i,04)+fpcond(i,10)
      ddcond(i,09)=azbz(i)*dpcond(i,04)+fpcond(i,13)
      ddcond(i,10)=ayby(i)*dpcond(i,05)+fpcond(i,11)
      ddcond(i,11)=azbz(i)*dpcond(i,05)+fpcond(i,14)
      ddcond(i,12)=azbz(i)*dpcond(i,06)+fpcond(i,15)
      ddcond(i,13)=axbx(i)*dpcond(i,07)+fpcond(i,07)
      ddcond(i,14)=ayby(i)*dpcond(i,07)+fpcond(i,13)
      ddcond(i,15)=azbz(i)*dpcond(i,07)+fpcond(i,16)
      ddcond(i,16)=ayby(i)*dpcond(i,08)+fpcond(i,14)
      ddcond(i,17)=azbz(i)*dpcond(i,08)+fpcond(i,17)
      ddcond(i,18)=azbz(i)*dpcond(i,09)+fpcond(i,18)
      ddcond(i,19)=axbx(i)*dpcond(i,10)+fpcond(i,10)
      ddcond(i,20)=ayby(i)*dpcond(i,10)+fpcond(i,19)
      ddcond(i,21)=azbz(i)*dpcond(i,10)+fpcond(i,22)
      ddcond(i,22)=ayby(i)*dpcond(i,11)+fpcond(i,20)
      ddcond(i,23)=azbz(i)*dpcond(i,11)+fpcond(i,23)
      ddcond(i,24)=azbz(i)*dpcond(i,12)+fpcond(i,24)
      ddcond(i,25)=axbx(i)*dpcond(i,13)+fpcond(i,13)
      ddcond(i,26)=ayby(i)*dpcond(i,13)+fpcond(i,22)
      ddcond(i,27)=azbz(i)*dpcond(i,13)+fpcond(i,25)
      ddcond(i,28)=ayby(i)*dpcond(i,14)+fpcond(i,23)
      ddcond(i,29)=azbz(i)*dpcond(i,14)+fpcond(i,26)
      ddcond(i,30)=azbz(i)*dpcond(i,15)+fpcond(i,27)
      ddcond(i,31)=axbx(i)*dpcond(i,16)+fpcond(i,16)
      ddcond(i,32)=ayby(i)*dpcond(i,16)+fpcond(i,25)
      ddcond(i,33)=azbz(i)*dpcond(i,16)+fpcond(i,28)
      ddcond(i,34)=ayby(i)*dpcond(i,17)+fpcond(i,26)
      ddcond(i,35)=azbz(i)*dpcond(i,17)+fpcond(i,29)
 1051 ddcond(i,36)=azbz(i)*dpcond(i,18)+fpcond(i,30)

      do 1052 i=1,m
      grad(i,01)=ddcond(i,01)*density(inddyy(i,01))*cdfits
      grad(i,02)=ddcond(i,02)*density(inddyy(i,02))*cdfits
      grad(i,03)=ddcond(i,03)*density(inddyy(i,03))*cdfits
      grad(i,04)=ddcond(i,07)*density(inddyy(i,04))*cdfits
      grad(i,05)=ddcond(i,08)*density(inddyy(i,05))*cdfits
      grad(i,06)=ddcond(i,09)*density(inddyy(i,06))*cdfits
      grad(i,07)=ddcond(i,13)*density(inddyy(i,07))*cdfits
      grad(i,08)=ddcond(i,14)*density(inddyy(i,08))*cdfits
      grad(i,09)=ddcond(i,15)*density(inddyy(i,09))*cdfits
      grad(i,10)=ddcond(i,19)*density(inddyy(i,10))*cdfits
      grad(i,11)=ddcond(i,20)*density(inddyy(i,11))*cdfits
      grad(i,12)=ddcond(i,21)*density(inddyy(i,12))*cdfits
      grad(i,13)=ddcond(i,25)*density(inddyy(i,13))*cdfits
      grad(i,14)=ddcond(i,26)*density(inddyy(i,14))*cdfits
      grad(i,15)=ddcond(i,27)*density(inddyy(i,15))*cdfits
      grad(i,16)=ddcond(i,31)*density(inddyy(i,16))*cdfits
      grad(i,17)=ddcond(i,32)*density(inddyy(i,17))*cdfits
      grad(i,18)=ddcond(i,33)*density(inddyy(i,18))*cdfits
      grad(i,19)=ddcond(i,02)*density(inddyy(i,01))*cdfits
      grad(i,20)=ddcond(i,04)*density(inddyy(i,02))*cdfits
      grad(i,21)=ddcond(i,05)*density(inddyy(i,03))*cdfits
      grad(i,22)=ddcond(i,08)*density(inddyy(i,04))*cdfits
      grad(i,23)=ddcond(i,10)*density(inddyy(i,05))*cdfits
      grad(i,24)=ddcond(i,11)*density(inddyy(i,06))*cdfits
      grad(i,25)=ddcond(i,14)*density(inddyy(i,07))*cdfits
      grad(i,26)=ddcond(i,16)*density(inddyy(i,08))*cdfits
      grad(i,27)=ddcond(i,17)*density(inddyy(i,09))*cdfits
      grad(i,28)=ddcond(i,20)*density(inddyy(i,10))*cdfits
      grad(i,29)=ddcond(i,22)*density(inddyy(i,11))*cdfits
      grad(i,30)=ddcond(i,23)*density(inddyy(i,12))*cdfits
      grad(i,31)=ddcond(i,26)*density(inddyy(i,13))*cdfits
      grad(i,32)=ddcond(i,28)*density(inddyy(i,14))*cdfits
      grad(i,33)=ddcond(i,29)*density(inddyy(i,15))*cdfits
      grad(i,34)=ddcond(i,32)*density(inddyy(i,16))*cdfits
      grad(i,35)=ddcond(i,34)*density(inddyy(i,17))*cdfits
      grad(i,36)=ddcond(i,35)*density(inddyy(i,18))*cdfits
      grad(i,37)=ddcond(i,03)*density(inddyy(i,01))*cdfits
      grad(i,38)=ddcond(i,05)*density(inddyy(i,02))*cdfits
      grad(i,39)=ddcond(i,06)*density(inddyy(i,03))*cdfits
      grad(i,40)=ddcond(i,09)*density(inddyy(i,04))*cdfits
      grad(i,41)=ddcond(i,11)*density(inddyy(i,05))*cdfits
      grad(i,42)=ddcond(i,12)*density(inddyy(i,06))*cdfits
      grad(i,43)=ddcond(i,15)*density(inddyy(i,07))*cdfits
      grad(i,44)=ddcond(i,17)*density(inddyy(i,08))*cdfits
      grad(i,45)=ddcond(i,18)*density(inddyy(i,09))*cdfits
      grad(i,46)=ddcond(i,21)*density(inddyy(i,10))*cdfits
      grad(i,47)=ddcond(i,23)*density(inddyy(i,11))*cdfits
      grad(i,48)=ddcond(i,24)*density(inddyy(i,12))*cdfits
      grad(i,49)=ddcond(i,27)*density(inddyy(i,13))*cdfits
      grad(i,50)=ddcond(i,29)*density(inddyy(i,14))*cdfits
      grad(i,51)=ddcond(i,30)*density(inddyy(i,15))*cdfits
      grad(i,52)=ddcond(i,33)*density(inddyy(i,16))*cdfits
      grad(i,53)=ddcond(i,35)*density(inddyy(i,17))*cdfits
 1052 grad(i,54)=ddcond(i,36)*density(inddyy(i,18))*cdfits

      do 1053 k=1,3
      do 1053 j=1,18
      do 1053 i=1,m
 1053 gradient(k,nc)=gradient(k,nc)-grad(i,18*(k-1)+j)

      do 1054 k=1,3
      do 1054 j=1,18
      do 1054 i=1,m
 1054 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))+grad(i,18*(k-1)+j)

 1001 continue

      return
      end
