      subroutine gradovps(ndim,m,n,icontr,inddyy,icentr,density,overlap,
     &                    gradient,zeta,twozetaa,eta,eta2,base,etarr,
     &                    pxax,pyay,pzaz,twozeta,ss0,ss,ps,ds,c,sscond,
     &                    dscond,grad)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension icontr(*),inddyy(m,*),icentr(m,*)

      dimension density(*),overlap(ndim,*),gradient(3,*),zeta(*),
     &          twozetaa(*),eta(*),eta2(*),base(*),etarr(*),pxax(*),
     &          pyay(*),pzaz(*),twozeta(*),ss0(*),ss(*),ps(n,*),ds(n,*),
     &          c(*),sscond(*),dscond(m,*),grad(m,*)

      data zero,thrhlf,two,three,pi/0.0d0,1.5d0,
     &                              2.0d0,3.0d0,3.1415926535898d0/

      do 1001 i=1,n
 1001 twozeta(i)=two*zeta(i)

      do 1002 i=1,n
 1002 ss0(i)=((pi/zeta(i))**thrhlf)*base(i)

      do 1003 i=1,n
      ps(i,1)=pxax(i)*ss0(i)
      ps(i,2)=pyay(i)*ss0(i)
 1003 ps(i,3)=pzaz(i)*ss0(i)

      do 1004 i=1,n
 1004 c(i)=ss0(i)/twozeta(i)

      do 1005 i=1,n
      ds(i,1)=pxax(i)*ps(i,1)+c(i)
      ds(i,2)=pyay(i)*ps(i,1)
      ds(i,3)=pzaz(i)*ps(i,1)
      ds(i,4)=pyay(i)*ps(i,2)+c(i)
      ds(i,5)=pzaz(i)*ps(i,2)
 1005 ds(i,6)=pzaz(i)*ps(i,3)+c(i)

      do 1006 i=1,m
 1006 sscond(i)=zero

      do 1007 j=1,6
      do 1007 i=1,m
 1007 dscond(i,j)=zero

      do 1008 i=1,n
 1008 sscond(icontr(i))=sscond(icontr(i))+ss0(i)

      do 1009 j=1,6
      do 1009 i=1,n
 1009 dscond(icontr(i),j)=dscond(icontr(i),j)+ds(i,j)*twozetaa(i)

      do 1010 j=1,3
      do 1010 i=1,m
 1010 overlap(inddyy(i,j),j)=overlap(inddyy(i,j),j)-sscond(i)

      do 1011 i=1,m
      overlap(inddyy(i,1),1)=overlap(inddyy(i,1),1)+dscond(i,1)
      overlap(inddyy(i,2),1)=overlap(inddyy(i,2),1)+dscond(i,2)
      overlap(inddyy(i,3),1)=overlap(inddyy(i,3),1)+dscond(i,3)
      overlap(inddyy(i,1),2)=overlap(inddyy(i,1),2)+dscond(i,2)
      overlap(inddyy(i,2),2)=overlap(inddyy(i,2),2)+dscond(i,4)
      overlap(inddyy(i,3),2)=overlap(inddyy(i,3),2)+dscond(i,5)
      overlap(inddyy(i,1),3)=overlap(inddyy(i,1),3)+dscond(i,3)
      overlap(inddyy(i,2),3)=overlap(inddyy(i,2),3)+dscond(i,5)
 1011 overlap(inddyy(i,3),3)=overlap(inddyy(i,3),3)+dscond(i,6)

      do 1012 i=1,n
 1012 ss(i)=eta(i)*(three-two*etarr(i))*ss0(i)

      do 1013 i=1,n
      ps(i,1)=pxax(i)*ss(i)+eta2(i)*ps(i,1)
      ps(i,2)=pyay(i)*ss(i)+eta2(i)*ps(i,2)
 1013 ps(i,3)=pzaz(i)*ss(i)+eta2(i)*ps(i,3)

      do 1014 i=1,n
 1014 c(i)=ss(i)/twozeta(i)-eta2(i)*ss0(i)/twozetaa(i)

      do 1015 i=1,n
      ds(i,1)=pxax(i)*ps(i,1)+eta2(i)*ds(i,1)+c(i)
      ds(i,2)=pyay(i)*ps(i,1)+eta2(i)*ds(i,2)
      ds(i,3)=pzaz(i)*ps(i,1)+eta2(i)*ds(i,3)
      ds(i,4)=pyay(i)*ps(i,2)+eta2(i)*ds(i,4)+c(i)
      ds(i,5)=pzaz(i)*ps(i,2)+eta2(i)*ds(i,5)
 1015 ds(i,6)=pzaz(i)*ps(i,3)+eta2(i)*ds(i,6)+c(i)

      do 1016 i=1,m
 1016 sscond(i)=zero

      do 1017 j=1,6
      do 1017 i=1,m
 1017 dscond(i,j)=zero

      do 1018 i=1,n
 1018 sscond(icontr(i))=sscond(icontr(i))+ss(i)

      do 1019 j=1,6
      do 1019 i=1,n
 1019 dscond(icontr(i),j)=dscond(icontr(i),j)+ds(i,j)*twozetaa(i)

      do 1020 j=1,3
      do 1020 i=1,m
 1020 grad(i,j)=sscond(i)*density(inddyy(i,j))

      do 1021 j=1,3
      do 1021 i=1,m
 1021 gradient(j,icentr(i,1))=gradient(j,icentr(i,1))-grad(i,j)

      do 1022 j=1,3
      do 1022 i=1,m
 1022 gradient(j,icentr(i,2))=gradient(j,icentr(i,2))+grad(i,j)

      do 1023 i=1,m
      grad(i,1)=dscond(i,1)*density(inddyy(i,1))
      grad(i,2)=dscond(i,2)*density(inddyy(i,2))
      grad(i,3)=dscond(i,3)*density(inddyy(i,3))
      grad(i,4)=dscond(i,2)*density(inddyy(i,1))
      grad(i,5)=dscond(i,4)*density(inddyy(i,2))
      grad(i,6)=dscond(i,5)*density(inddyy(i,3))
      grad(i,7)=dscond(i,3)*density(inddyy(i,1))
      grad(i,8)=dscond(i,5)*density(inddyy(i,2))
 1023 grad(i,9)=dscond(i,6)*density(inddyy(i,3))

      do 1024 k=1,3
      do 1024 j=1,3
      do 1024 i=1,m
 1024 gradient(k,icentr(i,1))=gradient(k,icentr(i,1))+grad(i,3*(k-1)+j)

      do 1025 k=1,3
      do 1025 j=1,3
      do 1025 i=1,m
 1025 gradient(k,icentr(i,2))=gradient(k,icentr(i,2))-grad(i,3*(k-1)+j)

      return
      end
