      subroutine gridcall(nreal,nfunctional,ncenters,nalpha,nbeta,
     &                    nconts,ncontp,ncontd,natomtype,nshels,nshelp,
     &                    nsheld,ilfunc,icfunc,ngauss,iwkvec,rmsrho,
     &                    coord,alpha,coeffs,amat,bmat,fock,focka,fockb,
     &                    focke,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension natomtype(*),nshels(*),nshelp(*),nsheld(*),ilfunc(*),
     &          icfunc(*),ngauss(*),iwkvec(*)

      dimension coord(3,*),amat(*),bmat(*),alpha(*),coeffs(*),
     &          fock(*),focka(*),fockb(*),focke(*),wkvec(*)

      data zero/0.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      ncntrt=nconts+3*ncontp+6*ncontd
      ndim=ncntrt*(ncntrt+1)/2

      call utility2(ndim,zero,focka)
      call utility2(ndim,zero,fockb)
      call utility2(ndim,zero,focke)

      call mpi_bcast(amat,ndim,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(bmat,ndim,mpi_real8,0,mpi_comm_world,ierr)

      if(myid.eq.0) then
                          rewind 11

                          read(11) iboxes,ipoints
                          read(11) imaxbox
                    endif

      call mpi_bcast(iboxes,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ipoints,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(imaxbox,1,mpi_integer,0,mpi_comm_world,ierr)

      nstart=64

      npoints=nstart+16

 1002 npoints=npoints-16

      if(npoints.le.0) stop 'real overflow for scf grid work'

      ja=1
      jb=ja+iboxes
      jc=jb+iboxes

      ka=1
      kb=ka+npoints*ncntrt
      kc=kb+npoints*3
      kd=kc+imaxbox*2
      ke=kd+imaxbox
      kf=ke+npoints*3
      kg=kf+npoints*3
      kh=kg+npoints*3
      ki=kh+npoints*3
      kj=ki+npoints*3
      kk=kj+npoints*3
      kl=kk+imaxbox
      km=kl+imaxbox
      kn=km+imaxbox
      ko=kn+imaxbox
      kp=ko+npoints*40
      kq=kp+npoints*ncntrt
      kr=kq+npoints*ncntrt
      ks=kr+npoints*ncntrt
      kt=ks+npoints*ncntrt
      ku=kt+npoints*ncntrt
      kv=ku+npoints*ncntrt
      kw=kv+npoints*ncntrt
      kx=kw+ncntrt
      ky=kx+ncntrt
      kz=ky+ncenters
      la=kz+iboxes*3
      lb=la+ipoints
      lc=lb+ipoints
      ld=lc+ipoints
      le=ld+ipoints

      if(le.gt.nreal) goto 1002

      call gridwork(nfunctional,npoints,ncntrt,ncenters,nalpha,nbeta,
     &              nconts,ncontp,ncontd,natomtype,nshels,nshelp,nsheld,
     &              ilfunc,icfunc,ngauss,iwkvec(ja),iwkvec(jb),
     &              iwkvec(jc),rmsrho,coord,alpha,coeffs,amat,bmat,
     &              wkvec(ka),wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),
     &              wkvec(kf),wkvec(kg),wkvec(kh),wkvec(ki),wkvec(kj),
     &              wkvec(kk),wkvec(kl),wkvec(km),wkvec(kn),wkvec(ko),
     &              wkvec(kp),wkvec(kq),wkvec(kr),wkvec(ks),wkvec(kt),
     &              wkvec(ku),wkvec(kv),wkvec(kw),wkvec(kx),wkvec(ky),
     &              wkvec(kz),wkvec(la),wkvec(lb),wkvec(lc),wkvec(ld),
     &              focka,fockb,focke)

      call mpi_reduce(focka,wkvec,ndim,
     &                mpi_real8,mpi_sum,0,mpi_comm_world,ierr)

      if(myid.eq.0) call stringcopy(ndim,focka,wkvec)

      call mpi_reduce(fockb,wkvec,ndim,
     &                mpi_real8,mpi_sum,0,mpi_comm_world,ierr)

      if(myid.eq.0) call stringcopy(ndim,fockb,wkvec)

      call mpi_reduce(focke,wkvec,ndim,
     &                mpi_real8,mpi_sum,0,mpi_comm_world,ierr)

      if(myid.eq.0) call stringcopy(ndim,focke,wkvec)

      if(myid.eq.0) then
                          call utilitya(ndim,focka,fock)
                          call utilitya(ndim,fockb,fock)
                          call utilitya(ndim,focke,fock)
                    endif

      return
      end
