      subroutine gridsort(nboxes,iboxes,nx,ny,nz,ncenters,natomtype,
     &                    nptsatom,index,inbox,myatom,xmin,ymin,zmin,
     &                    xcoord,ycoord,zcoord,weight,x,y,z,w,cent)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension natomtype(*),nptsatom(*),index(*),inbox(*),myatom(*)

      dimension xcoord(*),ycoord(*),zcoord(*),weight(*)
      dimension x(*),y(*),z(*),w(*),cent(3,*)

      data zero,two,four/0.0d0,2.0d0,4.0d0/

      rewind 11

      do 1001 i=1,nboxes
 1001 inbox(i)=0

      do 1002 iatom=1,ncenters

      if(natomtype(iatom).eq.0) goto 1002

      call fastrd(11,xcoord,nptsatom(iatom))
      call fastrd(11,ycoord,nptsatom(iatom))
      call fastrd(11,zcoord,nptsatom(iatom))
      call fastrd(11,weight,nptsatom(iatom))

      do 1003 ipoint=1,nptsatom(iatom)

      ix=int((xcoord(ipoint)-xmin)/four)+1
      iy=int((ycoord(ipoint)-ymin)/four)+1
      iz=int((zcoord(ipoint)-zmin)/four)+1

      ii=(ix-1)*(ny*nz)+(iy-1)*nz+iz

      inbox(ii)=inbox(ii)+1

      x(index(ii))=xcoord(ipoint)
      y(index(ii))=ycoord(ipoint)
      z(index(ii))=zcoord(ipoint)
      w(index(ii))=weight(ipoint)

      myatom(index(ii))=iatom

      index(ii)=index(ii)+1

 1003 continue
 1002 continue

      rewind 11

      write(11) iboxes,index(nboxes)-1

      ibox=0

      do 1005 ix=1,nx
      i1=(ix-1)*(ny*nz)
      xcent=xmin+real64(ix-1)*four+two

      do 1005 iy=1,ny
      i2=i1+(iy-1)*nz
      ycent=ymin+real64(iy-1)*four+two

      do 1005 iz=1,nz
      ii=i2+iz

      if(inbox(ii).eq.0) goto 1005

      zcent=zmin+real64(iz-1)*four+two

      iii=index(ii)-inbox(ii)

      ibox=ibox+1

      index(ibox)=iii
      inbox(ibox)=inbox(ii)

      cent(1,ibox)=xcent
      cent(2,ibox)=ycent
      cent(3,ibox)=zcent

 1005 continue

      imaxbox=0

      do 1006 i=1,iboxes
 1006 if(inbox(i).gt.imaxbox) imaxbox=inbox(i)

      write(11) imaxbox

      call ifastwr(11,index,iboxes)
      call ifastwr(11,inbox,iboxes)

      call fastwr(11,cent,3*iboxes)

      call fastwr(11,x,index(nboxes)-1)
      call fastwr(11,y,index(nboxes)-1)
      call fastwr(11,z,index(nboxes)-1)
      call fastwr(11,w,index(nboxes)-1)

      call ifastwr(11,myatom,index(nboxes)-1)

      return
      end
