      subroutine gridwork(nfunctional,npoints,ncontractions,ncenters,
     &                    nalpha,nbeta,nconts,ncontp,ncontd,natomtype,
     &                    nshels,nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &                    index,inbox,iwkvec,rmsrho,coord,alpha,coeff,
     &                    amat,bmat,fv,dnsty,xcpot,xcnrg,gradx,grady,
     &                    gradz,hssyy,hssyz,hsszz,xpoint,ypoint,zpoint,
     &                    wpoint,wkvec,fvx,fvy,fvz,wf,wfx,wfy,wfz,
     &                    extent1,extent3,dcc,dmidpts,xvec,yvec,zvec,
     &                    wvec,focka,fockb,focke)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension istat(mpi_status_size)

      dimension natomtype(*),nshels(*),nshelp(*),nsheld(*),ilfunc(*),
     &          icfunc(*),ngaussians(*),index(*),inbox(*),iwkvec(*)

      dimension coord(3,*),alpha(*),coeff(*),amat(*),bmat(*),
     &          fv(npoints,*),dnsty(npoints,*),xcpot(npoints,*),
     &          xcnrg(*),gradx(npoints,*),grady(npoints,*),
     &          gradz(npoints,*),hssyy(npoints,*),hssyz(npoints,*),
     &          hsszz(npoints,*),xpoint(*),ypoint(*),zpoint(*),
     &          wpoint(*),wkvec(*),fvx(npoints,*),fvy(npoints,*),
     &          fvz(npoints,*),wf(npoints,*),wfx(npoints,*),
     &          wfy(npoints,*),wfz(npoints,*),extent1(*),extent3(*),
     &          dcc(*),dmidpts(3,*),xvec(*),yvec(*),zvec(*),wvec(*),
     &          focka(*),fockb(*),focke(*)

      data zero,half,one,two,three/0.0d0,0.5d0,1.0d0,2.0d0,3.0d0/
      data tol,tolmin,tolmax/1.0d-04,1.0d-04,1.0d-16/
      data cut,cutmin,cutmax/1.0d-02,1.0d-02,1.0d-14/
      data rms1,rms2,onethousand/1.0d-06,1.0d-07,1000.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      toltemp=min(tolmin,tol*rmsrho)
      tolerance=max(tolmax,toltemp)

      if(rmsrho.le.rms1) tolerance=tolmax*onethousand
      if(rmsrho.le.rms2) tolerance=tolmax

      cuttemp=min(cutmin,cut*rmsrho)
      cutoff=max(cutmax,cuttemp)

      if(rmsrho.le.rms1) cutoff=cutmax*onethousand
      if(rmsrho.le.rms2) cutoff=cutmax

      call diffuse2(nconts,ncontp,ncontd,ilfunc,icfunc,ngaussians,
     &              nshels,nshelp,nsheld,cutoff,alpha,coeff,extent1)

      if(myid.eq.0) then
                          rewind 11

                          read(11) iboxes,ipoints
                          read(11) imaxbox

                          call ifastrd(11,index,iboxes)
                          call ifastrd(11,inbox,iboxes)

                          call fastrd(11,dmidpts,3*iboxes)

                          call fastrd(11,xvec,ipoints)
                          call fastrd(11,yvec,ipoints)
                          call fastrd(11,zvec,ipoints)
                          call fastrd(11,wvec,ipoints)

                          call ifastrd(11,idummy,1)
                    endif

      call mpi_bcast(iboxes,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(inbox,iboxes,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(dmidpts,3*iboxes,mpi_real8,0,mpi_comm_world,ierr)

      do 1001 iloop=1,iboxes

      nbox=inbox(iloop)

      xcenter=dmidpts(1,iloop)
      ycenter=dmidpts(2,iloop)
      zcenter=dmidpts(3,iloop)

      do 1002 i=1,ncenters
      xxx=abs(coord(1,i)-xcenter)
      yyy=abs(coord(2,i)-ycenter)
      zzz=abs(coord(3,i)-zcenter)
      if(xxx.gt.two) then
                           xxx=xxx-two
                     else
                           xxx=zero
                     endif
      if(yyy.gt.two) then
                           yyy=yyy-two
                     else
                           yyy=zero
                     endif
      if(zzz.gt.two) then
                           zzz=zzz-two
                     else
                           zzz=zero
                     endif
 1002 dcc(i)=sqrt((xxx**2)+(yyy**2)+(zzz**2))

      if(myid.eq.0) then

                    call stringcopy(nbox,xpoint,xvec(index(iloop)))
                    call stringcopy(nbox,ypoint,yvec(index(iloop)))
                    call stringcopy(nbox,zpoint,zvec(index(iloop)))
                    call stringcopy(nbox,wpoint,wvec(index(iloop)))

                    endif

      do 1003 ia=1,nbox,npoints*numprocs

      ib=min(ia+npoints*numprocs-1,nbox)

      npts=ib-ia+1

      nmaxloop=(npts/numprocs)
      if((nmaxloop*numprocs).lt.npts) nmaxloop=nmaxloop+1
      if((nmaxloop*numprocs).lt.npts) stop 'problem in gridwork'

      if(myid.eq.0) then
                          ja=ia

                          islave=0

                          do 1004 i=1,npts,nmaxloop

                          nloop=min(nmaxloop,npts-i+1)

                          call mpi_bsend(nloop,1,mpi_integer,
     &                                   islave,77,mpi_comm_world,ierr)
                          call mpi_bsend(ja,1,mpi_integer,
     &                                   islave,77,mpi_comm_world,ierr)

                          call mpi_bsend(xpoint(ja),nloop,mpi_real8,
     &                                   islave,77,mpi_comm_world,ierr)
                          call mpi_bsend(ypoint(ja),nloop,mpi_real8,
     &                                   islave,77,mpi_comm_world,ierr)
                          call mpi_bsend(zpoint(ja),nloop,mpi_real8,
     &                                   islave,77,mpi_comm_world,ierr)
                          call mpi_bsend(wpoint(ja),nloop,mpi_real8,
     &                                   islave,77,mpi_comm_world,ierr)

                          ja=ja+nloop

                          last_slave=islave
                           
 1004                     islave=islave+1

                          do 1005 i=islave,numprocs-1
                          nloop=0
 1005                     call mpi_bsend(nloop,1,mpi_integer,
     &                                   i,77,mpi_comm_world,ierr)
                    endif

      call mpi_recv(npts,1,mpi_integer,0,77,mpi_comm_world,istat,ierr)

      if(npts.eq.0) goto 1003

      call mpi_recv(ja,1,mpi_integer,0,77,mpi_comm_world,istat,ierr)

      call mpi_recv(xpoint(ja),npts,mpi_real8,
     &              0,77,mpi_comm_world,istat,ierr)
      call mpi_recv(ypoint(ja),npts,mpi_real8,
     &              0,77,mpi_comm_world,istat,ierr)
      call mpi_recv(zpoint(ja),npts,mpi_real8,
     &              0,77,mpi_comm_world,istat,ierr)
      call mpi_recv(wpoint(ja),npts,mpi_real8,
     &              0,77,mpi_comm_world,istat,ierr)

      if(nfunctional.eq.0) then

                    call compg0(ncontractions,npts,npoints,
     &                          ncenters,nconts,ncontp,ncontd,ilfunc,
     &                          icfunc,ngaussians,nshels,nshelp,nsheld,
     &                          coord,alpha,coeff,xpoint(ja),
     &                          ypoint(ja),zpoint(ja),fv,
     &                          extent1,extent3,dcc,wkvec(00*npoints+1),
     &                          wkvec(01*npoints+1),wkvec(02*npoints+1),
     &                          wkvec(03*npoints+1),wkvec(04*npoints+1),
     &                          wkvec(05*npoints+1),wkvec(06*npoints+1),
     &                          wkvec(07*npoints+1),wkvec(08*npoints+1),
     &                          wkvec(09*npoints+1),wkvec(10*npoints+1),
     &                          wkvec(11*npoints+1),wkvec(12*npoints+1),
     &                          wkvec(13*npoints+1),wkvec(14*npoints+1))

                           endif

      if(nfunctional.eq.1) then

                    call compg1(ncontractions,npts,npoints,
     &                          ncenters,nconts,ncontp,ncontd,ilfunc,
     &                          icfunc,ngaussians,nshels,nshelp,nsheld,
     &                          coord,alpha,coeff,xpoint(ja),
     &                          ypoint(ja),zpoint(ja),fv,fvx,fvy,fvz,
     &                          extent1,extent3,dcc,wkvec(00*npoints+1),
     &                          wkvec(01*npoints+1),wkvec(02*npoints+1),
     &                          wkvec(03*npoints+1),wkvec(04*npoints+1),
     &                          wkvec(05*npoints+1),wkvec(06*npoints+1),
     &                          wkvec(07*npoints+1),wkvec(08*npoints+1),
     &                          wkvec(09*npoints+1),wkvec(10*npoints+1),
     &                          wkvec(11*npoints+1),wkvec(12*npoints+1),
     &                          wkvec(13*npoints+1),wkvec(14*npoints+1),
     &                          wkvec(15*npoints+1),wkvec(16*npoints+1),
     &                          wkvec(17*npoints+1),wkvec(18*npoints+1),
     &                          wkvec(19*npoints+1),wkvec(20*npoints+1),
     &                          wkvec(21*npoints+1),wkvec(22*npoints+1),
     &                          wkvec(23*npoints+1),wkvec(24*npoints+1))

                           endif

      call utility2(npts,zero,dnsty(1,1))
      call utility2(npts,zero,dnsty(1,2))

      if(nfunctional.gt.0) then
                                 call utility2(npts,zero,gradx(1,1))
                                 call utility2(npts,zero,gradx(1,2))
                                 call utility2(npts,zero,grady(1,1))
                                 call utility2(npts,zero,grady(1,2))
                                 call utility2(npts,zero,gradz(1,1))
                                 call utility2(npts,zero,gradz(1,2))
                           endif

      ihits=0

      do 1006 i=1,ncontractions
      if(extent3(i).gt.tolerance) then
                                        ihits=ihits+1
                                        iwkvec(ihits)=i
                                  endif
 1006 continue

      call genwf(nfunctional,ihits,npoints,npts,iwkvec,
     &           amat,wf,wfx,wfy,wfz,fv)

      if(nfunctional.gt.0) then

             call genrho(npoints,npts,ihits,iwkvec,wf,fv,fvx,fvy,fvz,
     &                   dnsty(1,1),gradx(1,1),grady(1,1),gradz(1,1))

                           else

             do 1007 i=1,ihits
             ii=iwkvec(i)
 1007        call utility4(npts,dnsty(1,1),fv(1,ii),wf(1,ii))

                           endif

      call utility5(npts,half,dnsty(1,1))

      if(nalpha.eq.nbeta) then

                call stringcopy(npts,dnsty(1,2),dnsty(1,1))

                if(nfunctional.gt.0) then

                           call stringcopy(npts,gradx(1,2),gradx(1,1))
                           call stringcopy(npts,grady(1,2),grady(1,1))
                           call stringcopy(npts,gradz(1,2),gradz(1,1))

                                     endif

                   goto 1009

                          endif

      call genwf(nfunctional,ihits,npoints,npts,iwkvec,
     &           bmat,wf,wfx,wfy,wfz,fv)

      if(nfunctional.gt.0) then

             call genrho(npoints,npts,ihits,iwkvec,wf,fv,fvx,fvy,fvz,
     &                   dnsty(1,2),gradx(1,2),grady(1,2),gradz(1,2))

                           else

             do 1008 i=1,ihits
             ii=iwkvec(i)
 1008        call utility4(npts,dnsty(1,2),fv(1,ii),wf(1,ii))

                           endif

      call utility5(npts,half,dnsty(1,2))

 1009 continue

      call addvecs(npts,dnsty(1,3),dnsty(1,1),dnsty(1,2))

      if(nfunctional.gt.0) then

                     call addvecs(npts,gradx(1,3),gradx(1,1),gradx(1,2))
                     call addvecs(npts,grady(1,3),grady(1,1),grady(1,2))
                     call addvecs(npts,gradz(1,3),gradz(1,1),gradz(1,2))

                           endif

      call xcfunctional(npts,nfunctional,nalpha,nbeta,
     &                  dnsty(1,1),dnsty(1,2),dnsty(1,3),
     &                  xcnrg,xcpot(1,1),xcpot(1,2))

      if(nfunctional.gt.0) then

                     call xc_partial(npts,nalpha,nbeta,
     &                               xcnrg,xcpot(1,1),xcpot(1,2),
     &                               dnsty(1,1),dnsty(1,2),dnsty(1,3),
     &                               gradx(1,1),grady(1,1),gradz(1,1),
     &                               gradx(1,2),grady(1,2),gradz(1,2),
     &                               gradx(1,3),grady(1,3),gradz(1,3),
     &                               hssyy(1,3),hssyz(1,3),hsszz(1,3),
     &                               wkvec(0*npts+1),wkvec(1*npts+1),
     &                               wkvec(2*npts+1),wkvec(3*npts+1),
     &                               wkvec(4*npts+1),wkvec(5*npts+1))

                           endif

      jstart=ja-1

      call utility6(npts,xcpot(1,1),wpoint(ja))
      call utility6(npts,xcpot(1,2),wpoint(ja))
      call utility6(npts,xcnrg,wpoint(ja))

      if(nfunctional.gt.0) then

                call utility7(npts,hssyy(1,3),wpoint(ja),two)
                call utility7(npts,hssyz(1,3),wpoint(ja),two)
                call utility6(npts,hsszz(1,3),wpoint(ja))

                call utility8(npts,hssyy(1,1),hssyy(1,3),gradx)
                call utility8(npts,hssyy(1,2),hssyy(1,3),grady)
                call utility8(npts,hssyy(1,3),hssyy(1,3),gradz)

                           endif

      if(nalpha.ne.nbeta) then

                call utility8(npts,hssyz(1,1),hssyz(1,3),gradx(1,2))
                call utility8(npts,hssyz(1,2),hssyz(1,3),grady(1,2))
                call utility8(npts,hssyz(1,3),hssyz(1,3),gradz(1,2))

                          endif

      call utility6(npts,gradx(1,1),hsszz(1,3))
      call utility6(npts,grady(1,1),hsszz(1,3))
      call utility6(npts,gradz(1,1),hsszz(1,3))
      call utility6(npts,gradx(1,2),hsszz(1,3))
      call utility6(npts,grady(1,2),hsszz(1,3))
      call utility6(npts,gradz(1,2),hsszz(1,3))

      ka=00*npts+1
      kb=01*npts+1
      kc=02*npts+1
      kd=03*npts+1
      ke=04*npts+1
      kf=05*npts+1
      kg=06*npts+1
      kh=07*npts+1
      ki=08*npts+1
      kj=09*npts+1
      kk=10*npts+1
      kl=11*npts+1
      km=12*npts+1
      kn=13*npts+1
      ko=14*npts+1
      kp=15*npts+1
      kq=16*npts+1
      kr=17*npts+1
      la=18*npts+1
      lb=19*npts+1
      lc=20*npts+1
      ld=21*npts+1
      le=22*npts+1
      lf=23*npts+1
      lg=24*npts+1
      lh=25*npts+1
      li=26*npts+1
      lj=27*npts+1
      lk=28*npts+1
      ll=29*npts+1

      ihits=0

      do 1010 i=1,ncontractions
      if(extent3(i).gt.tolerance) then

            ihits=ihits+1
            iwkvec(ihits)=i

            ii=i*(i-1)/2

            call utility8(npts,wkvec(ka),fv(1,i),xcpot)
            call utility8(npts,wkvec(kc),fv(1,i),xcnrg)

            if(nalpha.ne.nbeta) call utility8(npts,wkvec(kb),
     &                                        fv(1,i),xcpot(1,2))

            if(nfunctional.eq.1) then

                 call utility8(npts,wkvec(kg),fv(1,i),hssyy(1,1))
                 call utility8(npts,wkvec(kh),fv(1,i),hssyy(1,2))
                 call utility8(npts,wkvec(ki),fv(1,i),hssyy(1,3))
                 call utility8(npts,wkvec(km),fvx(1,i),hssyy(1,1))
                 call utility8(npts,wkvec(kn),fvy(1,i),hssyy(1,2))
                 call utility8(npts,wkvec(ko),fvz(1,i),hssyy(1,3))
                 call utility8(npts,wkvec(la),fv(1,i),gradx(1,2))
                 call utility8(npts,wkvec(lb),fv(1,i),grady(1,2))
                 call utility8(npts,wkvec(lc),fv(1,i),gradz(1,2))
                 call utility8(npts,wkvec(lg),fvx(1,i),gradx(1,2))
                 call utility8(npts,wkvec(lh),fvy(1,i),grady(1,2))
                 call utility8(npts,wkvec(li),fvz(1,i),gradz(1,2))

                 if(nalpha.ne.nbeta) then

                      call utility8(npts,wkvec(kj),fv(1,i),hssyz(1,1))
                      call utility8(npts,wkvec(kk),fv(1,i),hssyz(1,2))
                      call utility8(npts,wkvec(kl),fv(1,i),hssyz(1,3))
                      call utility8(npts,wkvec(kp),fvx(1,i),hssyz(1,1))
                      call utility8(npts,wkvec(kq),fvy(1,i),hssyz(1,2))
                      call utility8(npts,wkvec(kr),fvz(1,i),hssyz(1,3))
                      call utility8(npts,wkvec(ld),fv(1,i),gradx(1,1))
                      call utility8(npts,wkvec(le),fv(1,i),grady(1,1))
                      call utility8(npts,wkvec(lf),fv(1,i),gradz(1,1))
                      call utility8(npts,wkvec(lj),fvx(1,i),gradx(1,1))
                      call utility8(npts,wkvec(lk),fvy(1,i),grady(1,1))
                      call utility8(npts,wkvec(ll),fvz(1,i),gradz(1,1))

                                     endif

                 call utility9(npts,wkvec(km),wkvec(kn),wkvec(ko),
     &                              wkvec(lg),wkvec(lh),wkvec(li))

                 if(nalpha.ne.nbeta) then

                      call utility9(npts,wkvec(kp),wkvec(kq),wkvec(kr),
     &                                   wkvec(lj),wkvec(lk),wkvec(ll))

                                     endif

                 call stringcopy(npts,wkvec(ke),wkvec(km))

                 call utilitya(npts,wkvec(kg),wkvec(la))
                 call utilitya(npts,wkvec(kh),wkvec(lb))
                 call utilitya(npts,wkvec(ki),wkvec(lc))

                 if(nalpha.ne.nbeta) then

                      call stringcopy(npts,wkvec(kf),wkvec(kp))

                      call utilitya(npts,wkvec(kj),wkvec(ld))
                      call utilitya(npts,wkvec(kk),wkvec(le))
                      call utilitya(npts,wkvec(kl),wkvec(lf))

                                     endif

                 call utilitya(npts,wkvec(ka),wkvec(ke))

                 if(nalpha.ne.nbeta) call utilitya(npts,
     &                                             wkvec(kb),wkvec(kf))

                                 endif

            call buildks(i,ii,nfunctional,npoints,npts,ihits,nalpha,
     &                   nbeta,iwkvec,tolerance,extent3,focka,fockb,
     &                   focke,fv,fvx,fvy,fvz,wkvec(ka),wkvec(kb),
     &                   wkvec(kc),wkvec(kg),wkvec(kh),wkvec(ki),
     &                   wkvec(kj),wkvec(kk),wkvec(kl))

                                  endif
 1010 continue
 1003 continue
 1001 continue

      if(nalpha.eq.nbeta) then
                                jmax=(ncontractions*(ncontractions+1))/2
                                do 1034 j=1,jmax
 1034                           fockb(j)=focka(j)
                          endif

      return
      end
