      subroutine inputmm(nmaxatoms,nauxfunctions,imode,imesp,irestart,
     &                   ioptimize,ncenters,nalpha,nbeta,nconts,ncontp,
     &                   ncontd,ncontractions,ncds,ncdsets,ncdfunctions,
     &                   nptcharges,iptsflag,ngridtype,nfunctional,
     &                   idiis,idiffuse,iptsweight,nmaxiterations,
     &                   nmaxgeometries,ivibrations,ilocalize,nfdpbt,
     &                   intcoordflag,nequivalences,nbneutrals,
     &                   nbsystems,ibfrozen,iafrozen,idfrozen,iifrozen,
     &                   isys,nequivvec,neutral,icfunc,ilfunc,
     &                   ngaussians,mtloca,nshels,nshelp,nsheld,
     &                   icdcfunc,icdlfunc,izmat1,izmat2,izmat3,
     &                   natomtype,ibfreeze,iafreeze,idfreeze,iifreeze,
     &                   ibmode,iamode,idmode,iimode,dmixing,dmaxstep,
     &                   econvergence,gconvergence,elevelshift,epsilon,
     &                   cutoff,coord,charge,coordptcharge,ptcharge,
     &                   alpha,coeff,alphacd,coefscd,coefpcd,coefdcd,
     &                   cdfitc,tvector,atomsymbol,inputstring)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      character inputstring(nmaxatoms,*)*30,atomsymbol(*)*4

      dimension ibmode(2),iamode(3),idmode(4),iimode(4)

      dimension natomtype(*),izmat1(*),izmat2(*),izmat3(*),
     &          neutral(nmaxatoms,*),isys(nmaxatoms,*),
     &          nequivvec(nmaxatoms,*),ilfunc(*),icfunc(*),mtloca(*),
     &          ngaussians(*),nshels(*),nshelp(*),nsheld(*),icdlfunc(*),
     &          icdcfunc(*),ibfreeze(2,*),iafreeze(3,*),idfreeze(4,*),
     &          iifreeze(4,*)

      dimension coord(3,*),charge(*),coordptcharge(3,*),
     &          ptcharge(*),alpha(*),coeff(*),alphacd(*),coefscd(*),
     &          coefpcd(*),coefdcd(*),cdfitc(*),tvector(*)

      data zero,one,five,seven/0.0d0,1.0d0,5.0d0,7.0d0/
      data gcon,econ,dmax,big/0.0018d0,0.00000001d0,0.30d0,1.0d+35/

      imode=0
      imesp=0
      irestart=0
      ioptimize=0
      ncenters=0
      nptcharges=0
      iptsflag=1
      icharge=0
      imultiplicity=1
      ngridtype=54
      nfunctional=0
      idiis=1
      idiffuse=0
      iptsweight=1
      nmaxiterations=250
      nmaxgeometries=25
      ivibrations=0
      ilocalize=0
      nfdpbt=0
      nequivalences=0
      nbneutrals=0
      nbsystems=1
      ibfrozen=0
      iafrozen=0
      idfrozen=0
      iifrozen=0

      do 1001 j=1,nmaxatoms
      do 1001 i=1,nmaxatoms
      isys(i+1,1)=i
      nequivvec(i,1)=0
      nequivvec(i,2)=0
 1001 neutral(i,j)=0

      dmixing=one
      dmaxstep=0.30
      econvergence=econ
      gconvergence=gcon
      elevelshift=zero
      epsilon=one
      cutoff=five

      call input(nmaxatoms,ncenters,nptcharges,ilocalize,ibfrozen,
     &           iafrozen,idfrozen,iifrozen,nfunctional,ngridtype,
     &           nmaxiterations,nmaxgeometries,iptsflag,icharge,
     &           imultiplicity,idiis,nfdpbt,irestart,imesp,ioptimize,
     &           ivibrations,intcoordflag,imode,nequivalences,
     &           nbneutrals,nbsystems,idiffuse,iptsweight,izmat1,izmat2,
     &           izmat3,natomtype,nequivvec,neutral,isys,ibfreeze,
     &           iafreeze,idfreeze,iifreeze,ibmode,iamode,idmode,iimode,
     &           econvergence,gconvergence,dmixing,dmaxstep,elevelshift,
     &           epsilon,cutoff,coord,charge,coordptcharge,ptcharge,
     &           atomsymbol)

      if(nbsystems.gt.1) nbsystems=nbsystems-1

      if(nbsystems.eq.1) isys(1,1)=ncenters

      write(6,1002)
 1002 format(//)

      dnuclearcharge=zero

      do 1003 i=1,ncenters
 1003 dnuclearcharge=dnuclearcharge+charge(i)

      nelectrons=nint(dnuclearcharge)-icharge

      if((mod(imultiplicity,2)).eq.1) then

                         nalpha=(nelectrons/2)+((imultiplicity-1)/2)
                         nbeta=(nelectrons/2)-((imultiplicity-1)/2)

                                      else

                         nalpha=((nelectrons+1)/2)+((imultiplicity-2)/2)
                         nbeta=((nelectrons-1)/2)-((imultiplicity-2)/2)

                                      endif

      if((nalpha+nbeta).ne.nelectrons) then

                write(6,1004)
 1004           format(' the charge and multiplicity do not make sense')
                stop

                                       endif

      call inputbases(nmaxatoms,ncenters,nconts,ncontp,ncontd,
     &                ncontractions,ncds,ncdsets,ncdfunctions,idiffuse,
     &                cdfitc,tvector,
     &                icfunc,ilfunc,ngaussians,mtloca,nshels,nshelp,
     &                nsheld,icdcfunc,icdlfunc,natomtype,alpha,coeff,
     &                alphacd,coefscd,coefpcd,coefdcd,inputstring)

      return
      end
