      subroutine irspectrum(natoms,natomtype,stepsize,coord,wkmata,
     &                      wkmatb,wkmatc,wkmatd,freqncy,dipole,aux1,
     &                      aux2,aux3)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension atwght(102),component(3)

      dimension natomtype(*)

      dimension coord(3,*),wkmata(natoms*3,*),wkmatb(natoms*3,*),
     &          wkmatc(3,*),wkmatd(3,*),freqncy(*),dipole(3,*),aux1(*),
     &          aux2(*),aux3(*)

      data zero,two,pi/0.0d0,2.0d0,3.1415926535898d0/

      data shift,eliminate/20.0d0,5000.0d0/

      data factor1,factor2,factor3/9.6828862d+14,
     &                             2.9979246d+10,974.8644d0/

      data atwght/
     &    1.0078d0,   4.0026d0,   7.0160d0,   9.0122d0,  11.0093d0,
     &   12.0000d0,  14.0031d0,  15.9949d0,  18.9984d0,  19.9924d0,
     &   22.9898d0,  23.9850d0,  26.9815d0,  27.9769d0,  30.9738d0,
     &   31.9721d0,  34.9689d0,  39.9480d0,  38.9637d0,  39.9626d0,
     &   44.9559d0,  47.9000d0,  50.9440d0,  51.9405d0,  54.9381d0,
     &   55.9349d0,  58.9332d0,  57.9353d0,  62.9298d0,  63.9291d0,
     &   68.9257d0,  73.9219d0,  74.9216d0,  79.9165d0,  78.9183d0,
     &   83.8000d0,  84.9117d0,  87.9056d0,  88.9054d0,  89.9043d0,
     &   92.9060d0,  97.9055d0,  98.9062d0, 101.9037d0, 102.9048d0,
     &  105.9032d0, 106.9051d0, 113.9036d0, 114.9041d0, 117.9018d0,
     &  120.9038d0, 129.9067d0, 126.9004d0, 131.9042d0, 133.9051d0,
     &  137.9050d0, 138.9061d0, 139.9053d0, 140.9074d0, 141.9075d0,
     &  147.0000d0, 151.9195d0, 152.9209d0, 157.9241d0, 159.9250d0,
     &  163.9288d0, 164.9303d0, 165.9304d0, 168.9344d0, 173.9390d0,
     &  174.9409d0, 179.9468d0, 180.9480d0, 183.9510d0, 186.9560d0,
     &  190.2000d0, 192.9633d0, 194.9648d0, 196.9666d0, 201.9706d0,
     &  204.9745d0, 207.9766d0, 208.9804d0, 209.0000d0, 210.0000d0,
     &  222.0000d0, 223.0000d0, 226.0254d0, 227.0000d0, 232.0381d0,
     &  231.0359d0, 238.0289d0, 237.0482d0, 242.0000d0, 243.0000d0,
     &  247.0000d0, 247.0000d0, 249.0000d0, 254.0000d0, 253.0000d0,
     &  256.0000d0, 254.0000d0/

      rewind 73
      rewind 74

      do 1001 i=1,2
      do 1001 j=1,natoms*3
      do 1001 k=1,natoms

      read(74) x,y,z

      if(i.eq.1) then
                       wkmata(j,3*(k-1)+1)=x
                       wkmata(j,3*(k-1)+2)=y
                       wkmata(j,3*(k-1)+3)=z
                 else
                       wkmatb(j,3*(k-1)+1)=x
                       wkmatb(j,3*(k-1)+2)=y
                       wkmatb(j,3*(k-1)+3)=z
                 endif
 1001 continue

      do 1002 i=1,natoms*3
      do 1002 j=1,natoms*3
 1002 wkmata(j,i)=(wkmata(j,i)-wkmatb(j,i))/(two*stepsize)

      do 1003 i=1,natoms*3
      do 1003 j=1,natoms*3
 1003 wkmatb(i,j)=(wkmata(j,i)+wkmata(i,j))/two

      do 1004 i=1,natoms
      do 1004 j=1,natoms*3
      wkmatb(3*(i-1)+1,j)=wkmatb(3*(i-1)+1,j)/sqrt(atwght(natomtype(i)))
      wkmatb(3*(i-1)+2,j)=wkmatb(3*(i-1)+2,j)/sqrt(atwght(natomtype(i)))
 1004 wkmatb(3*(i-1)+3,j)=wkmatb(3*(i-1)+3,j)/sqrt(atwght(natomtype(i)))

      do 1005 i=1,natoms
      do 1005 j=1,natoms*3
      wkmatb(j,3*(i-1)+1)=wkmatb(j,3*(i-1)+1)/sqrt(atwght(natomtype(i)))
      wkmatb(j,3*(i-1)+2)=wkmatb(j,3*(i-1)+2)/sqrt(atwght(natomtype(i)))
 1005 wkmatb(j,3*(i-1)+3)=wkmatb(j,3*(i-1)+3)/sqrt(atwght(natomtype(i)))

      do 1006 i=1,2
      do 1006 j=1,natoms
      do 1006 k=1,3

      read(73) x,y,z

      if(i.eq.1) then
                       wkmatc(1,3*(j-1)+k)=x/sqrt(atwght(natomtype(j)))
                       wkmatc(2,3*(j-1)+k)=y/sqrt(atwght(natomtype(j)))
                       wkmatc(3,3*(j-1)+k)=z/sqrt(atwght(natomtype(j)))
                 else
                       wkmatd(1,3*(j-1)+k)=x/sqrt(atwght(natomtype(j)))
                       wkmatd(2,3*(j-1)+k)=y/sqrt(atwght(natomtype(j)))
                       wkmatd(3,3*(j-1)+k)=z/sqrt(atwght(natomtype(j)))
                 endif
 1006 continue

      do 1007 i=1,natoms*3
      do 1007 j=1,3
 1007 dipole(j,i)=(wkmatc(j,i)-wkmatd(j,i))/(two*stepsize)

      do 1008 jj=1,3
      do 1009 ii=1,natoms
 1009 aux1(3*(ii-1)+jj)=shift*sqrt(atwght(natomtype(ii)))
      do 1008 i=1,natoms*3
      do 1008 j=1,natoms*3
      do 1008 k=1,natoms*3
      do 1008 l=1,natoms*3
 1008 if((i.eq.k).and.(j.eq.l)) wkmatb(i,j)=wkmatb(i,j)-aux1(k)*aux1(l)

      do 1011 j=1,3
      do 1012 jj=1,3*natoms
 1012 aux1(jj)=zero
      do 1013 i=1,natoms
      dmass=atwght(natomtype(i))
      if(j.eq.1) aux1(3*(i-1)+2)=-shift*sqrt(dmass)*coord(3,i)
      if(j.eq.1) aux1(3*(i-1)+3)=+shift*sqrt(dmass)*coord(2,i)
      if(j.eq.2) aux1(3*(i-1)+1)=+shift*sqrt(dmass)*coord(3,i)
      if(j.eq.2) aux1(3*(i-1)+3)=-shift*sqrt(dmass)*coord(1,i)
      if(j.eq.3) aux1(3*(i-1)+1)=-shift*sqrt(dmass)*coord(2,i)
 1013 if(j.eq.3) aux1(3*(i-1)+2)=+shift*sqrt(dmass)*coord(1,i)
      do 1011 k=1,natoms*3
      do 1011 l=1,natoms*3
      do 1011 m=1,natoms*3
      do 1011 n=1,natoms*3
 1011 if((k.eq.m).and.(l.eq.n)) wkmatb(k,l)=wkmatb(k,l)-aux1(m)*aux1(n)

 1010 continue

      do 1014 j=1,3*natoms
      do 1014 i=1,j
 1014 aux3((j*(j-1)/2)+i)=wkmatb(i,j)

      call dspev('v','u',natoms*3,
     &           aux3,freqncy,wkmata,natoms*3,aux2,info)

      write(6,1015)
 1015 format(/////////,' calculated infrafred spectrum :',/)

      do 1016 i=1,natoms*3

      if(freqncy(i).lt.zero) then
                                   iflag=1
                                   freqncy(i)=-freqncy(i)
                             else
                                   iflag=0
                             endif

      freqncy(i)=sqrt(freqncy(i))*factor1/(two*pi*factor2)

      if(freqncy(i).gt.eliminate) goto 1016

      do 1017 j=1,3
 1017 component(j)=zero

      do 1018 j=1,3
      do 1018 k=1,natoms*3
 1018 component(j)=component(j)+dipole(j,k)*wkmata(k,i)

      dintensity=factor3*(component(1)*component(1)
     &                   +component(2)*component(2)
     &                   +component(3)*component(3))

      if(iflag.eq.0) write(6,1019) i,+freqncy(i),dintensity
      if(iflag.eq.1) write(6,1020) i,-freqncy(i),dintensity

 1019 format(' normal mode # ',i3,//,
     &       '      real frequency       : ',f15.3,' 1/cm',/,
     &       '      infrared intensity   : ',f15.3,' km/mol',/)

 1020 format(' normal mode # ',i3,//,
     &       '      imaginary frequency  : ',f15.3,' 1/cm',/,
     &       '      infrared intensity   : ',f15.3,' km/mol',/)

      write(6,1021)
 1021 format('      atom #    ',
     &       'x-coordinate    y-coordinate    z-coordinate',
     &       ' (bohr * amu**0.5)',/)

      do 1022 j=1,natoms
 1022 write(6,1023) j,wkmata(3*(j-1)+1,i),
     &                wkmata(3*(j-1)+2,i),
     &                wkmata(3*(j-1)+3,i)
 1023 format(5x,i5,5x,f12.6,4x,f12.6,4x,f12.6)

      write(6,1024)
 1024 format(///)

 1016 continue

      return
      end
