      program main

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"
      include "params.h"

      character input(maxatoms,2)*30,atomsymbol(maxatoms)*4

      real timer,tarray(2)

      common/ci/iwkvec(ninteger),
     &          nptsatom(maxatoms),natomtype(maxatoms),
     &          izmat1(maxatoms),izmat2(maxatoms),izmat3(maxatoms),
     &          isys(maxatoms,maxatoms),
     &          neutral(maxatoms,maxatoms),nequivvec(maxatoms,2),
     &          ilfunc(maxaos),icfunc(maxaos),
     &          mtloca(maxaos),ngaussians(maxaos),nfuncatom(maxaos),
     &          nshels(maxaos),nshelp(maxaos),nsheld(maxaos),
     &          icdlfunc(maxaux),icdcfunc(maxaux),
     &          ibfreeze(2,maxatoms),iafreeze(3,maxatoms),
     &          idfreeze(4,maxatoms),iifreeze(4,maxatoms),
     &          ibmode(2),iamode(3),idmode(4),iimode(4)

      common/cr/coord(3,maxatoms),coordsv(3,maxatoms),
     &          charge(maxatoms),grad(3,maxatoms),
     &          coordptcharge(3,nmaxptcharges),ptcharge(nmaxptcharges),
     &          alpha(nprimitives),coeff(nprimitives),
     &          alphacd(maxaux),
     &          coefscd(maxaux),coefpcd(maxaux),coefdcd(maxaux),
     &          cdfitc(maxaux),tvector(maxaux)

      common/mpii/ibuffer(nibuffer),iis,iir,irs,irr
      common/mpir/buffer(nrbuffer)

      call mpi_init(ierr)

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      call startup

      if(myid.eq.0) then

         call inputmm(maxatoms,maxaux,imode,imesp,irestart,ioptimize,
     &                ncenters,nalpha,nbeta,nconts,ncontp,ncontd,
     &                ncontractions,ncds,ncdsets,ncdfunctions,
     &                nptcharges,iptsflag,ngridtype,nfunctional,idiis,
     &                idiffuse,iptsweight,nmaxiterations,nmaxgeometries,
     &                ivibrations,ilocalize,nfdpbt,intcoordflag,
     &                nequivalences,nbneutrals,nbsystems,ibfrozen,
     &                iafrozen,idfrozen,iifrozen,isys,nequivvec,neutral,
     &                icfunc,ilfunc,ngaussians,mtloca,nshels,nshelp,
     &                nsheld,icdcfunc,icdlfunc,izmat1,izmat2,izmat3,
     &                natomtype,ibfreeze,iafreeze,idfreeze,iifreeze,
     &                ibmode,iamode,idmode,iimode,dmixing,dmaxstep,
     &                econvergence,gconvergence,elevelshift,epsilon,
     &                cutoff,coord,charge,coordptcharge,ptcharge,alpha,
     &                coeff,alphacd,coefscd,coefpcd,coefdcd,cdfitc,
     &                tvector,atomsymbol,input)

                    endif

      naux=2*ncdfunctions*ncdfunctions+100*ncdfunctions
      if(nbsystems.gt.1) naux=ncdfunctions*ncdfunctions+100*ncdfunctions

      nreal=max(12000000,6*(ncontractions**2),naux)

      ndim1=8*((ncontractions*(ncontractions+1))/2)
      ndim2=8*ncontractions*(nalpha+10)
      ndim3=8*nreal

      call mpi_bcast(ndim1,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ndim2,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ndim3,1,mpi_integer,0,mpi_comm_world,ierr)

      call deftcc(nreal,ninteger,nrbuffer,maxatoms,maxaos,nfockdim,
     &            maxaux,nmaxpts,nesppts,ncontacts,imode,imesp,irestart,
     &            ioptimize,ncenters,nalpha,nbeta,nconts,ncontp,ncontd,
     &            ncontractions,ncds,ncdsets,ncdfunctions,nptcharges,
     &            iptsflag,ngridtype,nfunctional,idiis,idiffuse,
     &            iptsweight,nmaxiterations,nmaxgeometries,ivibrations,
     &            ilocalize,nfdpbt,intcoordflag,nequivalences,
     &            nbneutrals,nbsystems,ibfrozen,iafrozen,idfrozen,
     &            iifrozen,iwkvec,nptsatom,natomtype,izmat1,izmat2,
     &            izmat3,neutral,isys,nequivvec,nfuncatom,ilfunc,icfunc,
     &            mtloca,ngaussians,nshels,nshelp,nsheld,icdlfunc,
     &            icdcfunc,ibfreeze,iafreeze,idfreeze,iifreeze,ibmode,
     &            iamode,idmode,iimode,ndim1,ndim2,ndim3,dmixing,
     &            dmaxstep,econvergence,gconvergence,elevelshift,
     &            epsilon,cutoff,wkvec,coord,coordsv,charge,
     &            coordptcharge,ptcharge,grad,coeffa,coeffb,dmata,dmatb,
     &            core,focka,fockb,focke,alpha,coeff,alphacd,coefscd,
     &            coefpcd,coefdcd,cdfitc,tvector,buffer,input,
     &            atomsymbol)

      timer=etime(tarray)
      if(myid.eq.0) write(6,1001) tarray(1),tarray(2),timer
 1001 format(//,' total cpu time of job (seconds) = ',3f12.2)

      call mpi_finalize(ierr)

      end
