      subroutine mulliken(n,natoms,nconts,ncontp,ncontd,nshels,nshelp,
     &                    nsheld,icfunc,nfunc,natomtype,overlap,dmta,
     &                    dmtb,pmat,smat,pstmat,pssmat,pop,bond)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa, ottawa, canada.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension nshels(*),nshelp(*),nsheld(*),nfunc(*),icfunc(*),
     &          natomtype(*)

      dimension overlap(*),dmta(*),dmtb(*)

      dimension pmat(n,*),smat(n,*),pstmat(n,*),pssmat(n,*)
      dimension pop(*),bond(natoms,*)

      data zero,half,one,two,tol/0.0d0,0.5d0,1.0d0,2.0d0,1.0d-14/

      ij=0
      do 1001 i=1,n
      do 1001 j=1,i
      ij=ij+1
      smat(i,j)=overlap(ij)
      smat(j,i)=overlap(ij)
      pmat(i,j)=(dmta(ij)+dmtb(ij))*half
 1001 pmat(j,i)=(dmta(ij)+dmtb(ij))*half

      do 1002 i=1,n
 1002 pmat(i,i)=dmta((i*(i+1))/2)+dmtb((i*(i+1))/2)

      do 1003 j=1,n
      call utility2(n,zero,pstmat(1,j))
      do 1003 k=1,n
 1003 if(abs(smat(k,j)).gt.tol) call utility3(n,smat(k,j),
     &                                        pstmat(1,j),pmat(1,k))

      ij=0
      do 1004 i=1,n
      do 1004 j=1,i
      ij=ij+1
      pmat(i,j)=(dmta(ij)-dmtb(ij))*half
 1004 pmat(j,i)=(dmta(ij)-dmtb(ij))*half

      do 1005 i=1,n
 1005 pmat(i,i)=dmta((i*(i+1))/2)-dmtb((i*(i+1))/2)

      do 1006 j=1,n
      call utility2(n,zero,pssmat(1,j))
      do 1006 k=1,n
 1006 if(abs(smat(k,j)).gt.tol) call utility3(n,smat(k,j),
     &                                        pssmat(1,j),pmat(1,k))

      write(6,1007)
 1007 format(//,' mulliken population analysis :',/)

      call utility2(natoms,zero,pop)

      do 1008 j=1,n
 1008 pop(nfunc(j))=pop(nfunc(j))+pstmat(j,j)

      do 1009 i=1,natoms
 1009 write(6,1010) i,real64(natomtype(i))-pop(i)
 1010 format(5x,' atom # ',i4,'       charge = ',f8.4)

      write(6,1011)
 1011 format(//,' mayer bond order analysis :',/)

      call utility2(natoms*natoms,zero,bond)

      do 1012 k=1,n
      kk=nfunc(k)
      do 1012 l=1,n
 1012 bond(kk,nfunc(l))=bond(kk,nfunc(l))+pstmat(k,l)*pstmat(l,k)
     &                                   -pssmat(k,l)*pssmat(l,k)

      do 1013 i=1,natoms
      do 1013 j=i+1,natoms
 1013 write(6,1014) i,j,bond(i,j)
 1014 format(5x,' atoms # ',i4,' and ',i4,'       bond order = ',f8.4)

      write(6,1015)
 1015 format(//,' mayer valence indices :',/)

      call utility5(natoms,two,pop)

      do 1016 j=1,n
      jj=nfunc(j)
      do 1016 k=1,n
 1016 if(nfunc(k).eq.jj) pop(jj)=pop(jj)-pstmat(j,k)*pstmat(k,j)

      do 1017 i=1,natoms
 1017 write(6,1018) i,pop(i)
 1018 format(5x,' atom # ',i4,'       valence = ',f8.4)

      return
      end
