      subroutine multipoles(natoms,ncds,ncdspd,ilfunc,icfunc,alpha,
     &                      coeffs,coeffp,coeffd,cdfitc,redfit,charge,
     &                      dipole,qdpole,tcharge,tdipole,tqdpole,rr,
     &                      trr)

c  this subroutine written by alain st-amant of the
c  department of chemistry, university of ottawa.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension amat(10,10),bvec(10)

      dimension ilfunc(*),icfunc(*)

      dimension alpha(*),coeffs(*),coeffp(*),coeffd(*),cdfitc(*)

      dimension redfit(10,*)
      dimension charge(*),dipole(*),qdpole(*)
      dimension tcharge(*),tdipole(*),tqdpole(*)
      dimension rr(*),trr(*)

      data zero,one,two,three,four/0.0d0,1.0d0,2.0d0,3.0d0,4.0d0/
      data pi,fortynine,onethousand/3.1415926535898d0,49.0d0,1000.0d0/
      data cs,cp,cd/1130.5901d0,123849.94d0,10112305.0d0/
      data small/1.0d-08/

      thrhlf=three/two
      sq493=sqrt(fortynine/three)

      ncdfunc=ncds+10*ncdspd

      do 1001 i=1,ncdfunc
 1001 charge(i)=zero

      do 1002 i=1,ncds
 1002 charge(i)=cdfitc(i)*coeffs(ilfunc(i))
     &         *((pi/alpha(ilfunc(i)))**thrhlf)

      do 1003 i=1,ncdspd

      val1=((pi/alpha(ilfunc(ncds+i)))**thrhlf)

      vala=val1*coeffs(ilfunc(ncds+i))
      valb=val1*coeffd(ilfunc(ncds+i))/(two*alpha(ilfunc(ncds+i)))/sq493

 1003 charge(ncds+i)=cdfitc(ncds+10*(i-1)+01)*vala
     &              +cdfitc(ncds+10*(i-1)+05)*valb
     &              +cdfitc(ncds+10*(i-1)+08)*valb
     &              +cdfitc(ncds+10*(i-1)+10)*valb

      do 1004 i=1,3*ncdfunc
 1004 dipole(i)=zero

      do 1005 i=1,ncdspd

      val1=((pi/alpha(ilfunc(ncds+i)))**thrhlf)

      vala=val1*coeffp(ilfunc(ncds+i))/(two*alpha(ilfunc(ncds+i)))

      dipole(3*(ncds+i-1)+1)=cdfitc(ncds+10*(i-1)+02)*vala
      dipole(3*(ncds+i-1)+2)=cdfitc(ncds+10*(i-1)+03)*vala
 1005 dipole(3*(ncds+i-1)+3)=cdfitc(ncds+10*(i-1)+04)*vala

      do 1006 i=1,6*ncdfunc
 1006 qdpole(i)=zero

      do 1007 i=1,ncdspd

      val1=((pi/alpha(ilfunc(ncds+i)))**thrhlf)

      vala=val1*coeffd(ilfunc(ncds+i))/four/(alpha(ilfunc(ncds+i))**2)
      valb=vala/sq493

      rr(i)=cdfitc(ncds+10*(i-1)+05)*valb
     &     +cdfitc(ncds+10*(i-1)+08)*valb
     &     +cdfitc(ncds+10*(i-1)+10)*valb

      qdpole(6*(ncds+i-1)+1)=cdfitc(ncds+10*(i-1)+05)*valb*two
     &                      -cdfitc(ncds+10*(i-1)+08)*valb
     &                      -cdfitc(ncds+10*(i-1)+10)*valb

      qdpole(6*(ncds+i-1)+4)=cdfitc(ncds+10*(i-1)+08)*valb*two
     &                      -cdfitc(ncds+10*(i-1)+05)*valb
     &                      -cdfitc(ncds+10*(i-1)+10)*valb

      qdpole(6*(ncds+i-1)+6)=cdfitc(ncds+10*(i-1)+10)*valb*two
     &                      -cdfitc(ncds+10*(i-1)+05)*valb
     &                      -cdfitc(ncds+10*(i-1)+08)*valb

      qdpole(6*(ncds+i-1)+2)=cdfitc(ncds+10*(i-1)+06)*vala*thrhlf
      qdpole(6*(ncds+i-1)+3)=cdfitc(ncds+10*(i-1)+07)*vala*thrhlf
 1007 qdpole(6*(ncds+i-1)+5)=cdfitc(ncds+10*(i-1)+09)*vala*thrhlf

      do 1008 i=1,natoms
      trr(i)=zero
 1008 tcharge(i)=zero

      do 1009 i=1,3*natoms
 1009 tdipole(i)=zero

      do 1010 i=1,6*natoms
 1010 tqdpole(i)=zero

      do 1011 i=1,ncds
 1011 tcharge(icfunc(ilfunc(i)))=tcharge(icfunc(ilfunc(i)))+charge(i)

      do 1012 i=1,ncdspd

      ic=icfunc(ilfunc(ncds+i))

      tcharge(ic)=tcharge(ic)+charge(ncds+i)

      tdipole(3*(ic-1)+1)=tdipole(3*(ic-1)+1)+dipole(3*(ncds+i-1)+1)
      tdipole(3*(ic-1)+2)=tdipole(3*(ic-1)+2)+dipole(3*(ncds+i-1)+2)
      tdipole(3*(ic-1)+3)=tdipole(3*(ic-1)+3)+dipole(3*(ncds+i-1)+3)

      tqdpole(6*(ic-1)+1)=tqdpole(6*(ic-1)+1)+qdpole(6*(ncds+i-1)+1)
      tqdpole(6*(ic-1)+2)=tqdpole(6*(ic-1)+2)+qdpole(6*(ncds+i-1)+2)
      tqdpole(6*(ic-1)+3)=tqdpole(6*(ic-1)+3)+qdpole(6*(ncds+i-1)+3)
      tqdpole(6*(ic-1)+4)=tqdpole(6*(ic-1)+4)+qdpole(6*(ncds+i-1)+4)
      tqdpole(6*(ic-1)+5)=tqdpole(6*(ic-1)+5)+qdpole(6*(ncds+i-1)+5)
      tqdpole(6*(ic-1)+6)=tqdpole(6*(ic-1)+6)+qdpole(6*(ncds+i-1)+6)

      trr(ic)=trr(ic)+rr(i)

 1012 continue

      do 1013 iatom=1,natoms

      do 1014 j=1,10
      do 1014 i=1,10
 1014 amat(i,j)=zero

      c1=((pi/onethousand)**thrhlf)

      vala=c1*cs
      valb=c1*cd/(two*onethousand)/sq493

      amat(01,01)=amat(01,01)+vala
      amat(01,05)=amat(01,05)+valb
      amat(01,08)=amat(01,08)+valb
      amat(01,10)=amat(01,10)+valb

      bvec(01)=tcharge(iatom)

      vala=c1*cp/(two*onethousand)

      amat(02,02)=amat(02,02)+vala
      amat(03,03)=amat(03,03)+vala
      amat(04,04)=amat(04,04)+vala

      bvec(02)=tdipole(3*(iatom-1)+1)
      bvec(03)=tdipole(3*(iatom-1)+2)
      bvec(04)=tdipole(3*(iatom-1)+3)

      vala=c1*cd/four/(onethousand**2)
      valb=vala/sq493

      amat(06,06)=amat(06,06)+vala*thrhlf
      amat(07,07)=amat(07,07)+vala*thrhlf
      amat(09,09)=amat(09,09)+vala*thrhlf

      bvec(06)=tqdpole(6*(iatom-1)+2)
      bvec(07)=tqdpole(6*(iatom-1)+3)
      bvec(09)=tqdpole(6*(iatom-1)+5)

      amat(05,05)=amat(05,05)+valb*two
      amat(05,08)=amat(05,08)-valb
      amat(05,10)=amat(05,10)-valb

      amat(08,05)=amat(08,05)-valb
      amat(08,08)=amat(08,08)+valb*two
      amat(08,10)=amat(08,10)-valb

      amat(10,05)=amat(10,05)+one
      amat(10,08)=amat(10,08)+one
      amat(10,10)=amat(10,10)+one

      bvec(05)=tqdpole(6*(iatom-1)+1)
      bvec(08)=tqdpole(6*(iatom-1)+4)
      bvec(10)=trr(iatom)

      call matinv(amat,bvec,10,2,10)

      redfit(01,iatom)=bvec(01)
      redfit(02,iatom)=bvec(02)
      redfit(03,iatom)=bvec(03)
      redfit(04,iatom)=bvec(04)
      redfit(05,iatom)=bvec(05)
      redfit(06,iatom)=bvec(06)
      redfit(07,iatom)=bvec(07)
      redfit(08,iatom)=bvec(08)
      redfit(09,iatom)=bvec(09)
      redfit(10,iatom)=bvec(10)

      val1=((pi/onethousand)**thrhlf)

      vala=val1*cs
      valb=val1*cd/(two*onethousand)/sq493

      charge(iatom)=redfit(01,iatom)*vala
     &             +redfit(05,iatom)*valb
     &             +redfit(08,iatom)*valb
     &             +redfit(10,iatom)*valb

      val1=((pi/onethousand)**thrhlf)

      vala=val1*cp/(two*onethousand)

      dipole(3*(iatom-1)+1)=redfit(02,iatom)*vala
      dipole(3*(iatom-1)+2)=redfit(03,iatom)*vala
      dipole(3*(iatom-1)+3)=redfit(04,iatom)*vala

      val1=((pi/onethousand)**thrhlf)

      vala=val1*cd/four/(onethousand**2)
      valb=vala/sq493

      qdpole(6*(iatom-1)+1)=redfit(05,iatom)*valb*two
     &                     -redfit(08,iatom)*valb
     &                     -redfit(10,iatom)*valb

      qdpole(6*(iatom-1)+4)=redfit(08,iatom)*valb*two
     &                     -redfit(05,iatom)*valb
     &                     -redfit(10,iatom)*valb

      qdpole(6*(iatom-1)+6)=redfit(10,iatom)*valb*two
     &                     -redfit(05,iatom)*valb
     &                     -redfit(08,iatom)*valb

      qdpole(6*(iatom-1)+2)=redfit(06,iatom)*vala*thrhlf
      qdpole(6*(iatom-1)+3)=redfit(07,iatom)*vala*thrhlf
      qdpole(6*(iatom-1)+5)=redfit(09,iatom)*vala*thrhlf

      check1=abs(charge(iatom)-tcharge(iatom))
      check2=abs(dipole(3*(iatom-1)+1)-tdipole(3*(iatom-1)+1))
      check3=abs(dipole(3*(iatom-1)+2)-tdipole(3*(iatom-1)+2))
      check4=abs(dipole(3*(iatom-1)+3)-tdipole(3*(iatom-1)+3))
      check5=abs(qdpole(6*(iatom-1)+1)-tqdpole(6*(iatom-1)+1))
      check6=abs(qdpole(6*(iatom-1)+2)-tqdpole(6*(iatom-1)+2))
      check7=abs(qdpole(6*(iatom-1)+3)-tqdpole(6*(iatom-1)+3))
      check8=abs(qdpole(6*(iatom-1)+4)-tqdpole(6*(iatom-1)+4))
      check9=abs(qdpole(6*(iatom-1)+5)-tqdpole(6*(iatom-1)+5))
      check0=abs(qdpole(6*(iatom-1)+6)-tqdpole(6*(iatom-1)+6))

      check=check1+check2+check3+check4+check5
     &     +check6+check7+check8+check9+check0

      if(check.gt.small) then

             write(6,1015) iatom
             write(6,1016) charge(iatom),tcharge(iatom)
             write(6,1016) dipole(3*(iatom-1)+1),tdipole(3*(iatom-1)+1)
             write(6,1016) dipole(3*(iatom-1)+2),tdipole(3*(iatom-1)+2)
             write(6,1016) dipole(3*(iatom-1)+3),tdipole(3*(iatom-1)+3)
             write(6,1016) qdpole(6*(iatom-1)+1),tqdpole(6*(iatom-1)+1)
             write(6,1016) qdpole(6*(iatom-1)+2),tqdpole(6*(iatom-1)+2)
             write(6,1016) qdpole(6*(iatom-1)+3),tqdpole(6*(iatom-1)+3)
             write(6,1016) qdpole(6*(iatom-1)+4),tqdpole(6*(iatom-1)+4)
             write(6,1016) qdpole(6*(iatom-1)+5),tqdpole(6*(iatom-1)+5)
             write(6,1016) qdpole(6*(iatom-1)+6),tqdpole(6*(iatom-1)+6)
 1015        format(' multipoles problem ',i6)
 1016        format(' multipoles problem ',2f12.7)

             stop

                         endif

 1013 continue

      return
      end
