      SUBROUTINE MATINV(A,B,N,L,IDIM)

      IMPLICIT REAL*8(A-H,O-Z)

      PARAMETER (NDMATI=1000)

      DIMENSION A(IDIM,IDIM),B(IDIM),IP(NDMATI),IN(NDMATI,2)

      DATA ZERO,ONE,SMALL/0.0D0,1.0D0,1.0D-30/

      IF(N.GT.NDMATI) stop 'increase size of tables in matinv'

      D=ONE
      DO 1002 I=1,N
 1002 IP(I)=0

      DO 1003 I=1,N

      AMAX=ZERO

      DO 1004 J=1,N

      IF(IP(J).GT.0) GOTO 1004
      IF(IP(J).LT.0) GOTO 1005

      DO 1006 K=1,N

      IF(IP(K).EQ.1) GOTO 1006
      IF(IP(K).GT.1) GOTO 1005

      IF(ABS(A(J,K)).LE.AMAX) GOTO 1006
      IR=J
      IC=K
      AMAX=ABS(A(J,K))

 1006 CONTINUE

 1004 CONTINUE

      IP(IC)=IP(IC)+1

      IF(AMAX.GT.SMALL) GOTO 1007

 1005 STOP 'MATINV'

 1007 IF(IR.EQ.IC) GOTO 1008

      D=-D

      DO 1009 K=1,N
      AMAX=A(IR,K)
      A(IR,K)=A(IC,K)
 1009 A(IC,K)=AMAX

      IF(L.EQ.0) GOTO 1008

      AMAX=B(IR)
      B(IR)=B(IC)
      B(IC)=AMAX

 1008 IN(I,1)=IR

      IN(I,2)=IC
      AMAX=A(IC,IC)
      D=D*AMAX
      A(IC,IC)=ONE

      DO 1010 K=1,N
 1010 A(IC,K)=A(IC,K)/AMAX

      IF(L.EQ.0) GOTO 1011

      B(IC)=B(IC)/AMAX

 1011 DO 1003 J=1,N

      IF(J.EQ.IC) GOTO 1003

      AMAX=A(J,IC)
      A(J,IC)=ZERO

      DO 1012 K=1,N
 1012 A(J,K)=A(J,K)-A(IC,K)*AMAX

      IF(L.EQ.0) GOTO 1003
      B(J)=B(J)-B(IC)*AMAX

 1003 CONTINUE

      IF(L.EQ.1) GOTO 1013

      DO 1014 I=1,N

      J=N+1-I

      IF(IN(J,1).EQ.IN(J,2)) GOTO 1014
      IR=IN(J,1)
      IC=IN(J,2)

      DO 1015 K=1,N
      AMAX=A(K,IR)
      A(K,IR)=A(K,IC)
 1015 A(K,IC)=AMAX

 1014 CONTINUE
 1013 CONTINUE

      return
      end

      subroutine vmmpy(n,ndim,y,x,z)

      implicit real*8(a-h,o-z)

      dimension y(*),x(*),z(ndim,*)

      data zero/0.0d0/

      nloop=(n/10)

      do 1001 i=1,n
      y(i)=zero
      do 1002 j=1,nloop
      jj=10*(j-1)
 1002 y(i)=y(i)+x(jj+01)*z(jj+01,i)
     &         +x(jj+02)*z(jj+02,i)
     &         +x(jj+03)*z(jj+03,i)
     &         +x(jj+04)*z(jj+04,i)
     &         +x(jj+05)*z(jj+05,i)
     &         +x(jj+06)*z(jj+06,i)
     &         +x(jj+07)*z(jj+07,i)
     &         +x(jj+08)*z(jj+08,i)
     &         +x(jj+09)*z(jj+09,i)
     &         +x(jj+10)*z(jj+10,i)
      do 1003 jj=10*nloop+1,n
 1003 y(i)=y(i)+x(jj)*z(jj,i)
 1001 continue

      return
      end

      subroutine symtr(n,ndim,a,x,y)

      implicit real*8(a-h,o-z)

      dimension a(ndim,*),x(*),y(*)

      do 1001 j=1,n

      do 1002 i=j+1,n
 1002 y(i)=y(i)+a(i,j)*x(j)

      y(j)=y(j)+a(j,j)*x(j)

      do 1003 i=1,j-1
 1003 y(i)=y(i)+a(j,i)*x(j)

 1001 continue

      return
      end

      subroutine tql2(d,e,n,z,iz,eps)

      implicit real*8(a-h,o-z)

      parameter (maxit=30)

      dimension d(*),e(*),z(iz,*)

      data zero,one,two/0.0d0,1.0d0,2.0d0/

      if(n.eq.1) return

      do 1001 i=2,n
 1001 e(i-1)=e(i)

      e(n)=zero

      b=zero
      f=zero

      do 1002 l=1,n

      h=eps*(abs(d(l))+abs(e(l)))

      if(b.lt.h) b=h

      do 1003 m=l,n
      k=m
 1003 if(abs(e(k)).le.b) goto 1004

 1004 m=k

      if(m.ne.l) then
                       do 1005 j=1,maxit

                       p=(d(l+1)-d(l))/(two*e(l))
                       r=sqrt(p*p+one)

                       if(p.ge.zero) then
                                           h=d(l)-e(l)/(p+r)
                                     else
                                           h=d(l)-e(l)/(p-r)
                                     endif

                       do 1006 i=l,n
 1006                  d(i)=d(i)-h

                       f=f+h
                       p=d(m)

                       c=one
                       s=zero

                       do 1007 i=(m-1),l,-1

                       g=c*e(i)
                       h=c*p

                       if(abs(p).ge.abs(e(i))) then
                                                     c=e(i)/p
                                                     r=sqrt(c*c+one)
                                                     e(i+1)=s*p*r
                                                     s=c/r
                                                     c=one/r
                                               else
                                                     c=p/e(i)
                                                     r=sqrt(c*c+one)
                                                     e(i+1)=s*e(i)*r
                                                     s=one/r
                                                     c=c/r
                                               endif

                       p=c*d(i)-s*g

                       d(i+1)=h+s*(c*g+s*d(i))

                       do 1008 k=1,n
                       h=z(k,i+1)
                       z(k,i+1)=s*z(k,i)+c*h
 1008                  z(k,i)=c*z(k,i)-s*h

 1007                  continue

                       e(l)=s*p
                       d(l)=c*p

 1005                  if(abs(e(l)).le.b) goto 1002
                 endif

 1002 d(l)=d(l)+f

      return
      end

      subroutine tred2(nm,n,a,d,e,z,yy,d2,y2)

      implicit real*8(a-h,o-z)

      dimension a(nm,*),d(*),e(*),z(nm,*),yy(*),d2(*),y2(*)

c  this subroutine is a translation of the algol procedure tred2,
c  num. math. 11, 181-195 (1968) by matrin, reinsch, and wilkinson.
c  handbook for auto. comp., vol. II-linear algebra, 212-226(1971).

c  this is a modification of a modification (by dongarra and kaufman)
c  of the eispack routine

      data zero,one/0.0d0,1.0d0/

      do 1001 i=1,n
      do 1002 j=i,n
 1002 z(j,i)=a(j,i)
 1001 d(i)=a(n,i)

      if(n.eq.1) goto 1003

      do 1004 ii=2,n

      i=n+2-ii
      l=i-1

      h=zero
      scale=zero

      if(l.lt.2) goto 1005

      do 1006 k=1,l
 1006 scale=scale+abs(d(k))

      if(scale.ne.zero) goto 1007

 1005 e(i)=d(l)

      do 1008 j=1,l
      d(j)=z(l,j)
      z(i,j)=zero
 1008 z(j,i)=zero

      goto 1009

 1007 continue

      do 1010 k=1,l
      d(k)=d(k)/scale
 1010 h=h+d(k)*d(k)

      f=d(l)
      g=-sign(sqrt(h),f)
      e(i)=scale*g
      h=h-f*g
      d(l)=f-g

      do 1011 j=1,l
      z(j,i)=d(j)
 1011 e(j)=zero

      call symtr(l,nm,z,d,e)

      f=zero

      do 1012 j=1,l
      e(j)=e(j)/h
 1012 f=f+e(j)*d(j)

      hh=f/(h+h)

      do 1013 j=1,l
 1013 e(j)=e(j)-hh*d(j)

      do 1014 j=1,l

      f=d(j)
      g=e(j)

      do 1015 k=j,l
 1015 z(k,j)=z(k,j)-f*e(k)-g*d(k)

      d(j)=z(l,j)
      z(i,j)=zero

 1014 continue

 1009 d(i)=h

 1004 continue

      do 1016 i=2,n,2

      l=i-1

      z(n,l)=z(l,l)
      z(l,l)=one

      h=zero

      if(d(i).ne.zero) h=one/d(i)

      do 1017 k=1,l
 1017 d(k)=z(k,i)*h

      call vmmpy(l,nm,yy,z(1,i),z)

      if(i.lt.n) goto 1018

      do 1019 j=1,l
      g=yy(j)
      do 1019 k=1,l
 1019 z(k,j)=z(k,j)-g*d(k)

      do 1020 k=1,l
 1020 z(k,i)=zero

      goto 1016

 1018 z(n,i)=z(i,i)

      ip1=i+1

      hi=zero
      if(d(i+1).ne.zero) hi=one/d(ip1)

      do 1021 k=1,i
 1021 d2(k)=z(k,ip1)*hi

      do 1022 j=1,i
      z(j,i)=zero
 1022 y2(j)=zero

      z(i,i)=one

      call vmmpy(i,nm,y2,z(1,ip1),z)

      vtw=zero

      do 1023 j=1,l
 1023 vtw=vtw+d(j)*d2(j)

      vtw=vtw*hi

      if(hi.ne.zero) vtw=vtw/(hi*hi)

      yy(i)=zero
      d(i)=zero

      do 1024 j=1,i
      g=-yy(j)
      g2=-y2(j)+vtw*yy(j)
      do 1024 k=1,i
 1024 z(k,j)=z(k,j)+g*d(k)+g2*d2(k)

      do 1025 k=1,i
 1025 z(k,ip1)=zero

 1016 continue

 1003 continue

      do 1026 i=1,n
      d(i)=z(n,i)
 1026 z(n,i)=zero

      z(n,n)=one
      e(1)=zero

      return
      end
