      subroutine scfcontrol(nfdpbcalc,nreal,ninteger,natoms,nmaxorbs,
     &                      nmaxaux,nmaxpts,nmaxesp,mesp,nmaxiterations,
     &                      nfunctional,idiis,ngridtype,iptsflag,
     &                      ncenters,nptcharges,nbsystems,level,nalpha,
     &                      nbeta,nconts,ncontp,ncontd,ncds,ncdspd,
     &                      nxcsw,natomtype,nptsatom,nshels,
     &                      nshelp,nsheld,ilfunc,icfunc,ngaussians,
     &                      mtloca,nfuncatom,icdlfunc,icdcfunc,
     &                      isys,iwkvec,epsilon,econvergence,
     &                      dmixing,elevelshift,cutoff,coord,charge,
     &                      coordpc,ptcharge,core,focka,fockb,focke,
     &                      dmta,dmtb,coeffa,coeffb,alpha,coeffs,
     &                      alphacd,coefscd,coefpcd,coefdcd,
     &                      cdfitc,tvector,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),ngaussians(*),mtloca(*),
     &          nfuncatom(*),icdlfunc(*),icdcfunc(*),isys(natoms,*),
     &          iwkvec(*)

      dimension coord(3,*),charge(*),coordpc(3,*),ptcharge(*),
     &          core(*),focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),alpha(*),
     &          coeffs(*),alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),
     &          cdfitc(*),tvector(*),wkvec(*)

      data v02,v05,v10,one,ten/0.02d0,0.05d0,0.10d0,1.0d0,10.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      call mpi_bcast(nfdpbcalc,1,mpi_integer,0,mpi_comm_world,ierr)

 1001 continue

      save_dmixing=dmixing

      if(nfdpbcalc.eq.1) then

         call delphidr(nreal,ninteger,natoms,nmaxorbs,nmaxaux,nmaxpts,
     &                 nmaxesp,mesp,nmaxiterations,idiis,ngridtype,
     &                 nfunctional,iptsflag,ncenters,nptcharges,
     &                 nbsystems,level,nalpha,nbeta,nconts,ncontp,
     &                 ncontd,ncds,ncdspd,nxcsw,natomtype,
     &                 nptsatom,nshels,nshelp,nsheld,ilfunc,icfunc,
     &                 ngaussians,mtloca,nfuncatom,icdlfunc,icdcfunc,
     &                 isys,iwkvec,cutoff,epsilon,
     &                 econvergence,dmixing,elevelshift,coord,charge,
     &                 coordpc,ptcharge,core,focka,fockb,focke,dmta,
     &                 dmtb,coeffa,coeffb,alpha,coeffs,alphacd,coefscd,
     &                 coefpcd,coefdcd,cdfitc,tvector,wkvec)

                         else

         call scfrun(nreal,ninteger,natoms,nmaxorbs,nmaxaux,nmaxpts,
     &               nfunctional,nmaxiterations,idiis,ngridtype,
     &               ncenters,nptcharges,nbsystems,level,nalpha,nbeta,
     &               nconts,ncontp,ncontd,ncds,ncdspd,nxcsw,natomtype,
     &               nptsatom,nshels,nshelp,nsheld,ilfunc,icfunc,mtloca,
     &               ngaussians,nfuncatom,icdlfunc,icdcfunc,isys,iwkvec,
     &               econvergence,dmixing,elevelshift,diiserror,cutoff,
     &               coord,charge,coordpc,ptcharge,core,focka,fockb,
     &               focke,dmta,dmtb,coeffa,coeffb,alpha,coeffs,alphacd,
     &               coefscd,coefpcd,coefdcd,cdfitc,tvector,wkvec)

                         endif

      if(dmixing.gt.one) then

                    if(save_dmixing.eq.one) dmixing=v10
                    if(save_dmixing.eq.v10) dmixing=v05
                    if(save_dmixing.eq.v05) dmixing=v02

                    write(6,1002)
 1002               format(/////,' resetting SCF procedure ',/////)

                    goto 1001

                         endif

      return
      end
