      subroutine scfcycle(iteration,maxiterations,nreal,ninteger,
     &                    nmaxatoms,nmaxpoints,idiis,nfunctional,
     &                    ngridtype,natoms,nptcharges,nbsystems,nalpha,
     &                    nbeta,ncontractions,nconts,ncontp,ncontd,ncds,
     &                    ncdspd,nxcsw,natomtype,nptsatom,nshels,nshelp,
     &                    nsheld,mtloca,ilfunc,icfunc,ngaussians,
     &                    nfuncatom,icdlfunc,icdcfunc,isys,icdlsave,
     &                    iwkvec,converged,energy,eshift,dmixing,dmaxpc,
     &                    rmschange,cutoff,coord,coordpc,charge,
     &                    ptcharge,core,focka,fockb,focke,dmta,dmtb,
     &                    coeffa,coeffb,alpha,coeffs,alphacd,coefscd,
     &                    coefpcd,coefdcd,cdfitc,tvector,storecd,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      real timea,timeb,timec,timed,timee,ta,tb,tc,time1,time2,tarray(2)

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          mtloca(*),ilfunc(*),icfunc(*),ngaussians(*),
     &          nfuncatom(*),icdlfunc(*),icdcfunc(*),isys(nmaxatoms,*),
     &          icdlsave(*),iwkvec(*)

      dimension coord(3,*),coordpc(3,*),charge(*),ptcharge(*),core(*),
     &          focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(ncontractions,*),coeffb(ncontractions,*),
     &          alpha(*),coeffs(*),alphacd(*),coefscd(*),coefpcd(*),
     &          coefdcd(*),cdfitc(*),tvector(*),storecd(*),wkvec(*)

      data zero,one,four/0.0d0,1.0d0,4.0d0/
      data hundred,thousand/100.0d0,1000.0d0/
      data ev/27.212d0/

      save timea,timecb,timec,timed,timee

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      ndim=ncontractions*(ncontractions+1)/2

      ncdfunc=ncds+10*ncdspd

      if(iteration.eq.1) then
                               timea=zero
                               timeb=zero
                               timec=zero
                               timed=zero
                               timee=zero
                         endif

      if(iteration.eq.1) call startscf(nreal,ninteger,ncontractions,
     &                                 nalpha,nbeta,nmaxatoms,
     &                                 nmaxpoints,natoms,nptcharges,
     &                                 nconts,ncontp,ncontd,ncds,ncdspd,
     &                                 ngridtype,nbsystems,isys,
     &                                 icdlsave,iwkvec,nshels,nshelp,
     &                                 nsheld,ilfunc,icfunc,ngaussians,
     &                                 mtloca,icdlfunc,icdcfunc,
     &                                 natomtype,nptsatom,cutoff,wkvec,
     &                                 core,coord,coordpc,charge,
     &                                 ptcharge,alpha,coeffs,alphacd,
     &                                 coefscd,coefpcd,coefdcd,cdfitc)

      time1=etime(tarray)
      call twoemm(iteration,nreal-2*ndim-10*natoms,ninteger,natoms,
     &            nconts,ncontp,ncontd,ncds,ncdspd,nshels,nshelp,nsheld,
     &            mtloca,ilfunc,ngaussians,icfunc,icdlfunc,icdcfunc,
     &            iwkvec,rmschange,coord,alpha,coeffs,alphacd,coefscd,
     &            coefpcd,coefdcd,cdfitc,focka,wkvec,wkvec(ndim+1),
     &            wkvec(ndim+10*natoms+1),ta,tb,tc)

      call mpi_reduce(focka,wkvec,ndim,
     &                mpi_real8,mpi_sum,0,mpi_comm_world,ierr)

      call utilitya(ndim,wkvec,core)
      time2=etime(tarray)
      timeb=timeb+(time2-time1)

      time1=etime(tarray)
      if(nxcsw.gt.0) rmschange=one
      if((nxcsw.gt.0).and.(myid.eq.0)) call getks(nreal-ndim,
     &                                            ncontractions,nalpha,
     &                                            nbeta,iwkvec,one,
     &                                            eshift,dmaxpc,
     &                                            rmschange,dmta,dmtb,
     &                                            wkvec,wkvec,coeffa,
     &                                            coeffb,wkvec(ndim+1))

      call mpi_bcast(dmaxpc,1,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(rmschange,1,mpi_real8,0,mpi_comm_world,ierr)
      time2=etime(tarray)
      timec=timec+(time2-time1)

      time1=etime(tarray)
      call gridcall(nreal-ndim,nfunctional,natoms,nalpha,nbeta,nconts,
     &              ncontp,ncontd,natomtype,nshels,nshelp,nsheld,ilfunc,
     &              icfunc,ngaussians,iwkvec,rmschange,coord,alpha,
     &              coeffs,dmta,dmtb,wkvec,focka,fockb,focke,
     &              wkvec(ndim+1))
      time2=etime(tarray)
      timea=timea+(time2-time1)

      time1=etime(tarray)
      ja=1
      jb=ja+ncontractions*ncontractions
      jc=jb+ncontractions*ncontractions

      shift_save=eshift

      if((eshift.eq.zero).and.
     &   (rmschange.gt.(one/thousand))) eshift=four/ev

      if(eshift.lt.zero) eshift=zero

      if((eshift.ne.zero).
     &    and.(myid.eq.0)) call carbo(ncontractions,nalpha,eshift,focka,
     &                                coeffa,wkvec(ja),wkvec(jb),
     &                                wkvec(jc))

      if((nalpha.ne.nbeta).
     &    and.(eshift.ne.zero).
     &    and.(myid.eq.0)) call carbo(ncontractions,nbeta,eshift,fockb,
     &                                coeffb,wkvec(ja),wkvec(jb),
     &                                wkvec(jc))

      eshift=shift_save

      if((nxcsw.gt.0).and.(myid.eq.0)) call getks(nreal,ncontractions,
     &                                            nalpha,nbeta,iwkvec,
     &                                            dmixing,eshift,dmaxpc,
     &                                            rmschange,dmta,dmtb,
     &                                            focka,fockb,coeffa,
     &                                            coeffb,wkvec)

      call mpi_bcast(dmaxpc,1,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(rmschange,1,mpi_real8,0,mpi_comm_world,ierr)
      time2=etime(tarray)
      timec=timec+(time2-time1)

      time1=etime(tarray)
      if((idiis.eq.1).and.(myid.eq.0)) then

           ka=1
           kb=ka+ncontractions*ncontractions
           kc=kb+ncontractions*ncontractions
           kd=kc+ncontractions*ncontractions
           ke=kd+ncontractions*ncontractions
           kf=ke+ncontractions*ncontractions
           kg=kf+ncontractions

           if(kg.gt.nreal) stop 'calling diis'

           call ddiis(81,nalpha,nbeta,iteration,ncontractions,iwkvec,
     &                dmixing,eshift,focka,fockb,dmta,dmtb,wkvec(ka),
     &                wkvec(kb),wkvec(kc),wkvec(kd),wkvec(ke),wkvec(kf))

                                       endif
      time2=etime(tarray)
      timec=timec+(time2-time1)

      if(myid.eq.0) then
                          time1=etime(tarray)
                          call totale(ncontractions,ncdfunc,iteration,
     &                                nptcharges,natoms,energy,dmaxpc,
     &                                rmschange,dmta,dmtb,focke,coord,
     &                                charge,coordpc,ptcharge,wkvec,
     &                                cdfitc)
                          time2=etime(tarray)
                          timed=timed+(time2-time1)

                          time1=etime(tarray)
                          if(nxcsw.eq.0) then

                                   call getks(nreal,ncontractions,
     &                                        nalpha,nbeta,iwkvec,
     &                                        dmixing,eshift,dmaxpc,
     &                                        rmschange,dmta,dmtb,focka,
     &                                        fockb,coeffa,coeffb,wkvec)

                                         endif

                          time2=etime(tarray)
                          timec=timec+(time2-time1)
                    endif


      if(myid.eq.0) call writet(natoms,ncdfunc,ncontractions,nalpha,
     &                          nbeta,coord,cdfitc,coeffa,coeffb)

      nxcsw=0

      call mpi_bcast(dmaxpc,1,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(rmschange,1,mpi_real8,0,mpi_comm_world,ierr)

      if((iteration.gt.3).and.
     &   (dmaxpc.le.(converged*hundred)).and.
     &   (rmschange.le.converged)) then

                 if(myid.eq.0) write(6,1001) timea,timeb,ta,tb,tc,
     &                                       timee,timec,timed
 1001            format(/,' scf cpu times, grid            : ',f7.1,
     &                  /,'                two electron    : ',f7.1,
     &                    ' (',f7.1,',',f7.1,',',f7.1,')',
     &                  /,'                cd fitting      : ',f7.1,
     &                  /,'                diagonalization : ',f7.1,
     &                  /,'                total energy    : ',f7.1,/)
                 return

                                   endif

      if(iteration.eq.maxiterations) then

                 if(myid.eq.0) write(6,1001) timea,timeb,ta,tb,tc,
     &                                       timee,timec,timed

                                     endif

      time1=etime(tarray)
      ka=1
      kb=ka+nbsystems
      kc=kb+ncontractions*ncontractions
      kd=kc+ncontractions*ncontractions
      ke=kd+ncontractions
      kf=ke+ncontractions

      if(myid.eq.0) rewind 43
      if(myid.eq.0) call fastrd(43,wkvec(kf),ndim)

      call mpi_bcast(wkvec(kf),ndim,mpi_real8,0,mpi_comm_world,ierr)

      if(myid.eq.0) call cdpops(ncontractions,natoms,nmaxatoms,
     &                          nbsystems,icfunc,nfuncatom,isys,
     &                          wkvec(kf),dmta,dmtb,wkvec(ka),wkvec(kb),
     &                          wkvec(kc),wkvec(kd),wkvec(ke))

      call utility2(ncdfunc,zero,storecd)

      ncds_save=ncds
      ncdspd_save=ncdspd

      do 1002 i=1,ncdfunc
 1002 icdlsave(i)=icdlfunc(i)

      if(myid.eq.0) rewind 18

      do 1003 i=1,nbsystems

      call utilityj(ndim,wkvec(nbsystems+1),dmta,dmtb)

      do 1004 j=1,natoms
 1004 iwkvec(j)=0

      do 1005 j=1,natoms
      do 1005 k=1,isys(1,i)
 1005 if(dist(coord(1,j),coord(1,isys(k+1,i))).le.cutoff) iwkvec(j)=1

      ncds=0

      do 1006 j=1,ncds_save
      if(iwkvec(icdcfunc(icdlsave(j))).eq.1) then

                             ncds=ncds+1
                             icdlfunc(ncds)=icdlsave(j)

                                             endif
 1006 continue

      ncdspd=0

      do 1007 j=1,ncdspd_save
      if(iwkvec(icdcfunc(icdlsave(ncds_save+j))).eq.1) then

                             ncdspd=ncdspd+1
                             icdlfunc(ncds+ncdspd)=icdlsave(ncds_save+j)

                                                       endif
 1007 continue

      do 1008 j=1,natoms
 1008 iwkvec(j)=0

      do 1009 j=1,isys(1,i)
 1009 if(myid.eq.0) iwkvec(isys(j+1,i))=1

      call mpi_bcast(iwkvec,natoms,mpi_integer,0,mpi_comm_world,ierr)

      call cdftmm(nreal-nbsystems-ndim,ninteger,nconts,ncontp,ncontd,
     &            ncds,ncdspd,nshels,nshelp,nsheld,mtloca,ilfunc,
     &            ngaussians,icfunc,icdlfunc,icdcfunc,iwkvec,
     &            iwkvec(nmaxatoms+1),rmschange,coord,alpha,coeffs,
     &            alphacd,coefscd,coefpcd,coefdcd,tvector,
     &            wkvec(nbsystems+1),wkvec(nbsystems+ndim+1))

      nsize=ncds+10*ncdspd

      ja=nbsystems+1
      jb=ja+nsize**2

      if(myid.eq.0) call docdfit(nsize,ncds,ncdspd,icdlfunc,wkvec(i),
     &                           alphacd,coefscd,coefdcd,cdfitc,tvector,
     &                           wkvec(ja),wkvec(jb))

      call stringcopy(ncdfunc,tvector,cdfitc)

      do 1010 j=1,natoms
 1010 iwkvec(j)=0

      do 1011 j=1,natoms
      do 1011 k=1,isys(1,i)
 1011 if(dist(coord(1,j),coord(1,isys(k+1,i))).le.cutoff) iwkvec(j)=1

      ncds=0

      do 1012 j=1,ncds_save
      if(iwkvec(icdcfunc(icdlsave(j))).eq.1) then

                                             ncds=ncds+1
                                             cdfitc(j)=tvector(ncds)

                                             else

                                             cdfitc(j)=zero

                                             endif
 1012 continue

      ncdspd=0

      do 1013 j=1,ncdspd_save
      if(iwkvec(icdcfunc(icdlsave(ncds_save+j))).eq.1) then

            ncdspd=ncdspd+1
            cdfitc(ncds_save+10*(j-1)+01)=tvector(ncds+10*(ncdspd-1)+01)
            cdfitc(ncds_save+10*(j-1)+02)=tvector(ncds+10*(ncdspd-1)+02)
            cdfitc(ncds_save+10*(j-1)+03)=tvector(ncds+10*(ncdspd-1)+03)
            cdfitc(ncds_save+10*(j-1)+04)=tvector(ncds+10*(ncdspd-1)+04)
            cdfitc(ncds_save+10*(j-1)+05)=tvector(ncds+10*(ncdspd-1)+05)
            cdfitc(ncds_save+10*(j-1)+06)=tvector(ncds+10*(ncdspd-1)+06)
            cdfitc(ncds_save+10*(j-1)+07)=tvector(ncds+10*(ncdspd-1)+07)
            cdfitc(ncds_save+10*(j-1)+08)=tvector(ncds+10*(ncdspd-1)+08)
            cdfitc(ncds_save+10*(j-1)+09)=tvector(ncds+10*(ncdspd-1)+09)
            cdfitc(ncds_save+10*(j-1)+10)=tvector(ncds+10*(ncdspd-1)+10)

                                                       else

            cdfitc(ncds_save+10*(j-1)+01)=zero
            cdfitc(ncds_save+10*(j-1)+02)=zero
            cdfitc(ncds_save+10*(j-1)+03)=zero
            cdfitc(ncds_save+10*(j-1)+04)=zero
            cdfitc(ncds_save+10*(j-1)+05)=zero
            cdfitc(ncds_save+10*(j-1)+06)=zero
            cdfitc(ncds_save+10*(j-1)+07)=zero
            cdfitc(ncds_save+10*(j-1)+08)=zero
            cdfitc(ncds_save+10*(j-1)+09)=zero
            cdfitc(ncds_save+10*(j-1)+10)=zero

                                             endif
 1013 continue

      call utilitya(ncdfunc,storecd,cdfitc)

      ncds=ncds_save
      ncdspd=ncdspd_save

      do 1014 j=1,ncdfunc
 1014 icdlfunc(j)=icdlsave(j)

 1003 continue

      call stringcopy(ncdfunc,cdfitc,storecd)
      time2=etime(tarray)
      timee=timee+(time2-time1)

      return
      end
