      subroutine scfrun(nreal,ninteger,nmaxatoms,nmaxorbs,nmaxaux,
     &                  nmaxpoints,nfunctional,maxiterations,idiis,
     &                  ngridtype,natoms,nptcharges,nbsystems,level,
     &                  nalpha,nbeta,nconts,ncontp,ncontd,ncds,ncdspd,
     &                  nxcsw,natomtype,nptsatom,nshels,
     &                  nshelp,nsheld,ilfunc,icfunc,mtloca,ngaussian,
     &                  nfuncatom,icdlfunc,icdcfunc,isys,iwkvec,
     &                  converged,dmixing,eshift,diiserror,cutoff,coord,
     &                  charge,coordpc,ptcharge,core,focka,fockb,focke,
     &                  dmta,dmtb,coeffa,coeffb,alpha,coeffs,alphacd,
     &                  coefscd,coefpcd,coefdcd,cdfitc,tvector,wkvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      real time1,time2,tarray(2)

      include "mpif.h"

      dimension natomtype(*),nptsatom(*),nshels(*),nshelp(*),nsheld(*),
     &          ilfunc(*),icfunc(*),mtloca(*),ngaussian(*),nfuncatom(*),
     &          icdlfunc(*),icdcfunc(*),
     &          isys(nmaxatoms,*),iwkvec(*)

      dimension coord(3,*),charge(*),coordpc(3,*),ptcharge(*),
     &          core(*),focka(*),fockb(*),focke(*),dmta(*),dmtb(*),
     &          coeffa(nmaxorbs,*),coeffb(nmaxorbs,*),alpha(*),
     &          coeffs(*),alphacd(*),coefscd(*),coefpcd(*),coefdcd(*),
     &          cdfitc(*),tvector(*),wkvec(*)

      data zero,one,hundred,thousand/0.0d0,1.0d0,100.0d0,1000.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      call mpi_bcast(natoms,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nptcharges,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nbsystems,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(level,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nalpha,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nbeta,1,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(nconts,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ncontp,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ncontd,1,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(ncds,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ncdspd,1,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(nxcsw,1,mpi_integer,0,mpi_comm_world,ierr)

      ncontractions=nconts+3*ncontp+6*ncontd

      ndim=ncontractions*(ncontractions+1)/2

      ncdfunc=ncds+10*ncdspd

      call mpi_bcast(idiis,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ngridtype,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nfunctional,1,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(maxiterations,1,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(natomtype,natoms,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(nshels,nconts,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nshelp,ncontp,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(nsheld,ncontd,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(mtloca,ncontractions,
     &               mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ilfunc,ncontractions,
     &               mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(icfunc,ncontractions,
     &               mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(ngaussian,ncontractions,
     &               mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(icdlfunc,ncdfunc,mpi_integer,0,mpi_comm_world,ierr)
      call mpi_bcast(icdcfunc,ncdfunc,mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(isys,nmaxatoms*nmaxatoms,
     &               mpi_integer,0,mpi_comm_world,ierr)

      call mpi_bcast(converged,1,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(dmixing,1,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(cutoff,1,mpi_real8,0,mpi_comm_world,ierr)

      call mpi_bcast(coord,3*natoms,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(charge,natoms,mpi_real8,0,mpi_comm_world,ierr)

      call mpi_bcast(coordpc,3*nptcharges,
     &               mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(ptcharge,nptcharges,
     &               mpi_real8,0,mpi_comm_world,ierr)

      call mpi_bcast(alpha,10000,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(coeffs,10000,mpi_real8,0,mpi_comm_world,ierr)

      call mpi_bcast(cdfitc,ncdfunc,mpi_real8,0,mpi_comm_world,ierr)

      call mpi_bcast(alphacd,ncdfunc,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(coefscd,ncdfunc,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(coefpcd,ncdfunc,mpi_real8,0,mpi_comm_world,ierr)
      call mpi_bcast(coefdcd,ncdfunc,mpi_real8,0,mpi_comm_world,ierr)

      dmixing_save=dmixing
      eshift_save=eshift
      idiis_save=idiis

      dmaxpc=thousand
      rmschange=zero

      iconverged=0

      do 1001 i=1,maxiterations

      if((i.gt.3).and.(dmaxpc.le.(converged*hundred)).and.
     &                          (rmschange.le.converged)) then

                                         iconverged=1
                                         goto 1001
                                                          endif

      ja=1
      jb=ja+nmaxaux

      call scfcycle(i,maxiterations,nreal-jb,ninteger-nmaxaux,nmaxatoms,
     &              nmaxpoints,idiis,nfunctional,ngridtype,natoms,
     &              nptcharges,nbsystems,nalpha,nbeta,ncontractions,
     &              nconts,ncontp,ncontd,ncds,ncdspd,nxcsw,natomtype,
     &              nptsatom,nshels,nshelp,nsheld,mtloca,ilfunc,icfunc,
     &              ngaussian,nfuncatom,icdlfunc,icdcfunc,isys,iwkvec,
     &              iwkvec(nmaxaux+1),converged,energy,eshift,dmixing,
     &              dmaxpc,rmschange,cutoff,coord,coordpc,charge,
     &              ptcharge,core,focka,fockb,focke,dmta,dmtb,coeffa,
     &              coeffb,alpha,coeffs,alphacd,coefscd,coefpcd,coefdcd,
     &              cdfitc,tvector,wkvec(ja),wkvec(jb))

 1001 continue

      if(myid.eq.0) write(6,1002) energy
 1002 format(/,' total energy = ',f20.10,' hartrees')

      dmixing=dmixing_save
      idiis=idiis_save

      if(iconverged.eq.1) then
                                if(myid.eq.0) write(6,1003) 
                          else
                                if(myid.eq.0) write(6,1004)

                                stop
                          endif

 1003 format(/,' scf converged!!! :-) :-) :-) ')
 1004 format(/,' scf terminated unsuccessfully??? :-( :-( :-( ')

      if(nalpha.eq.nbeta) then
                                do 1005 j=1,nbeta
                                do 1005 i=1,ncontractions
 1005                           coeffb(i,j)=coeffa(i,j)
                          endif

      call flush(6)

      return
      end
