      subroutine solveks(ncontractions,nalpha,nbeta,iwkvec,dmixing,
     &                   elevelshift,changep,rmschange,amat,bmat,
     &                   fockalpha,fockbeta,coeffalpha,coeffbeta,
     &                   sinverse,enrgalpha,enrgbeta,wkmat1,wkmat2,
     &                   wkvec,vectmp,tmpvec)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension iwkvec(*)

      dimension amat(*),bmat(*),fockalpha(*),fockbeta(*)
      dimension coeffalpha(ncontractions,*),coeffbeta(ncontractions,*)
      dimension sinverse(ncontractions,*)

      dimension enrgalpha(*),enrgbeta(*)
      dimension wkmat1(ncontractions,*),wkmat2(ncontractions,*)
      dimension wkvec(*),vectmp(*),tmpvec(*)

      data zero,half,one,cutoff/0.0d0,0.5d0,1.0d0,1.0d-16/

      rewind 44
      rewind 51

      call fastrd(44,sinverse,ncontractions**2)

      ndim=ncontractions*(ncontractions+1)/2

      ij=0
      do 1001 i=1,ncontractions
      do 1001 j=1,i
      ij=ij+1
      wkmat2(j,i)=fockalpha(ij)
 1001 wkmat2(i,j)=fockalpha(ij)

      call utility2(ncontractions**2,zero,wkmat1)

      do 1002 i=1,ncontractions
      ihits=0
      do 1003 k=1,ncontractions
      if(abs(wkmat2(k,i)).gt.cutoff) then
                                           ihits=ihits+1
                                           iwkvec(ihits)=k
                                           wkvec(ihits)=wkmat2(k,i)
                                     endif
 1003 continue
      do 1002 j=1,ncontractions
      do 1002 k=1,ihits
 1002 wkmat1(i,j)=wkmat1(i,j)+sinverse(iwkvec(k),j)*wkvec(k)

      do 1004 j=1,ncontractions
      jj=(j*(j-1))/2
      do 1004 i=1,j
 1004 tmpvec(jj+i)=dot(ncontractions,sinverse(1,i),wkmat1(1,j))

      call dspev('v','u',ncontractions,tmpvec,
     &           wkvec,wkmat1,ncontractions,vectmp,info)

      norbitals=min(nalpha+10,ncontractions)

      call frac_occ(nalpha,norbitals,wkvec,tmpvec)

      do 1005 i=1,norbitals
      enrgalpha(i)=wkvec(i)+elevelshift
 1005 if(i.gt.nalpha) enrgalpha(i)=wkvec(i)

      do 1006 j=1,norbitals
      call utility2(norbitals,zero,wkmat2(1,j))
 1006 wkmat2(j,j)=tmpvec(j)*enrgalpha(j)

      write(51) norbitals

      do 1007 i=1,norbitals
 1007 call fastwr(51,wkmat2(1,i),norbitals)

      do 1008 j=1,norbitals
      call utility2(ncontractions,zero,coeffalpha(1,j))
      do 1008 k=1,ncontractions
 1008 if(abs(wkmat1(k,j)).gt.cutoff) call utility3(ncontractions,
     &                                             wkmat1(k,j),
     &                                             coeffalpha(1,j),
     &                                             sinverse(1,k))

      call stringcopy(ndim,wkvec,amat)
      call utility2(ndim,zero,amat)

      do 1009 k=1,norbitals
      do 1009 i=1,ncontractions
      ii=((i*(i-1))/2)+1
      factor=tmpvec(k)*coeffalpha(i,k)
 1009 if(abs(factor).gt.cutoff) call utility3(i,factor,
     &                                        amat(ii),coeffalpha(1,k))

      ij=0
      do 1010 i=1,ncontractions
      do 1010 j=1,i
      ij=ij+1
 1010 if(i.ne.j) amat(ij)=amat(ij)+amat(ij)

      changep=zero
      rmschange=zero

      ij=0
      do 1011 j=1,ncontractions
      do 1011 i=1,j
      ij=ij+1
      amat(ij)=(one-dmixing)*wkvec(ij)+dmixing*amat(ij)
      delta=abs(amat(ij)-wkvec(ij))
      if(i.ne.j) delta=delta*half
      rmschange=rmschange+delta*delta
      if(i.ne.j) rmschange=rmschange+delta*delta
 1011 if(delta.gt.changep) changep=delta

      if(nalpha.eq.nbeta) then

           do 1012 i=1,nalpha
           enrgbeta(i)=enrgalpha(i)
 1012      call stringcopy(ncontractions,coeffbeta(1,i),coeffalpha(1,i))

           call stringcopy(ndim,bmat,amat)

           goto 1024

                          endif

      if(nbeta.eq.0) goto 1024

      ij=0
      do 1013 i=1,ncontractions
      do 1013 j=1,i
      ij=ij+1
      wkmat2(j,i)=fockbeta(ij)
 1013 wkmat2(i,j)=fockbeta(ij)

      call utility2(ncontractions**2,zero,wkmat1)

      do 1014 i=1,ncontractions
      ihits=0
      do 1015 k=1,ncontractions
      if(abs(wkmat2(k,i)).gt.cutoff) then
                                           ihits=ihits+1
                                           iwkvec(ihits)=k
                                           wkvec(ihits)=wkmat2(k,i)
                                     endif
 1015 continue
      do 1014 j=1,ncontractions
      do 1014 k=1,ihits
 1014 wkmat1(i,j)=wkmat1(i,j)+sinverse(iwkvec(k),j)*wkvec(k)

      do 1016 j=1,ncontractions
      jj=(j*(j-1))/2
      do 1016 i=1,j
 1016 tmpvec(jj+i)=dot(ncontractions,sinverse(1,i),wkmat1(1,j))

      call dspev('v','u',ncontractions,tmpvec,
     &           wkvec,wkmat1,ncontractions,vectmp,info)

      norbitals=min(nbeta+10,ncontractions)

      call frac_occ(nbeta,norbitals,wkvec,tmpvec)

      do 1017 i=1,norbitals
      enrgbeta(i)=wkvec(i)+elevelshift
 1017 if(i.gt.nbeta) enrgbeta(i)=wkvec(i)

      do 1018 j=1,norbitals
      call utility2(norbitals,zero,wkmat2(1,j))
 1018 wkmat2(j,j)=tmpvec(j)*enrgbeta(j)

      write(51) norbitals

      do 1019 i=1,norbitals
 1019 call fastwr(51,wkmat2(1,i),norbitals)

      do 1020 j=1,norbitals
      call utility2(ncontractions,zero,coeffbeta(1,j))
      do 1020 k=1,ncontractions
 1020 if(abs(wkmat1(k,j)).gt.cutoff) call utility3(ncontractions,
     &                                             wkmat1(k,j),
     &                                             coeffbeta(1,j),
     &                                             sinverse(1,k))

      call stringcopy(ndim,wkvec,bmat)
      call utility2(ndim,zero,bmat)

      do 1021 k=1,norbitals
      do 1021 i=1,ncontractions
      ii=((i*(i-1))/2)+1
      factor=tmpvec(k)*coeffbeta(i,k)
 1021 if(abs(factor).gt.cutoff) call utility3(i,factor,
     &                                        bmat(ii),coeffbeta(1,k))

      ij=0
      do 1022 i=1,ncontractions
      do 1022 j=1,i
      ij=ij+1
 1022 if(i.ne.j) bmat(ij)=bmat(ij)+bmat(ij)

      ij=0
      do 1023 j=1,ncontractions
      do 1023 i=1,j
      ij=ij+1
      bmat(ij)=(one-dmixing)*wkvec(ij)+dmixing*bmat(ij)
      delta=abs(bmat(ij)-wkvec(ij))
      if(i.ne.j) delta=delta*half
      rmschange=rmschange+delta*delta
      if(i.ne.j) rmschange=rmschange+delta*delta
 1023 if(delta.gt.changep) changep=delta

 1024 continue

      if(nalpha.eq.nbeta) rmschange=rmschange/real64(1*ncontractions**2)
      if(nalpha.ne.nbeta) rmschange=rmschange/real64(2*ncontractions**2)

      rmschange=sqrt(rmschange)

      return
      end
