      subroutine startscf(nreal,ninteger,ncontractions,nalpha,nbeta,
     &                    nmaxatoms,nmaxpoints,natoms,nptcharges,nconts,
     &                    ncontp,ncontd,ncds,ncdspd,igridtype,nbsystems,
     &                    isys,icdlsave,iwkvec,nshels,nshelp,nsheld,
     &                    ilfunc,icfunc,ngaussians,matloca,icdlfunc,
     &                    icdcfunc,natomtype,nptsatom,cutoff,wkvec,core,
     &                    coord,coordptcharges,charge,ptcharge,alpha,
     &                    coeff,alphacd,coefscd,coefpcd,coefdcd,cdcoef)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      real timea,timeb,timec,timed,time1,time2,tarray(2)

      dimension isys(nmaxatoms,*),icdlsave(*),iwkvec(*),nshels(*),
     &          nshelp(*),nsheld(*),ilfunc(*),icfunc(*),ngaussians(*),
     &          matloca(*),icdlfunc(*),icdcfunc(*),natomtype(*),
     &          nptsatom(*)

      dimension wkvec(*),core(*),coord(3,*),coordptcharges(3,*),
     &          charge(*),ptcharge(*),alpha(*),coeff(*),alphacd(*),
     &          coefscd(*),coefpcd(*),coefdcd(*),cdcoef(*)

      data zero/0.0d0/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      if(myid.eq.0) then
                          rewind 43
                          rewind 44
                          rewind 45
                          rewind 66
                    endif

      ndim=(ncontractions*(ncontractions+1))/2

      time1=etime(tarray)
      call gengrid(nreal,ninteger,nmaxpoints,igridtype,natoms,nconts,
     &             ncontp,ncontd,ilfunc,icfunc,ngaussians,nshels,nshelp,
     &             nsheld,natomtype,nptsatom,iwkvec,coord,alpha,coeff,
     &             wkvec)
      time2=etime(tarray)
      timea=time2-time1

      ja=1
      jb=ja+(natoms+nptcharges)*3
      jc=jb+(natoms+nptcharges)
      jd=jc+ndim

      time1=etime(tarray)
      call coremm(nreal-jd-ndim,ninteger,natoms,nptcharges,nconts,
     &            ncontp,ncontd,nshels,nshelp,nsheld,matloca,ilfunc,
     &            ngaussians,icfunc,iwkvec,wkvec(ja),coord,
     &            coordptcharges,wkvec(jb),charge,ptcharge,alpha,coeff,
     &            wkvec(jc),core,wkvec(jd))
      time2=etime(tarray)
      timeb=time2-time1

      if(myid.eq.0) call fastwr(43,wkvec(jc),ndim)

      ka=jd
      kb=ka+ncontractions*ncontractions
      kc=kb+ncontractions*ncontractions
      kd=kc+ncontractions*3

      if((kd+ncontractions).gt.nreal) stop 'startscf'

      time1=etime(tarray)
      if(myid.eq.0) call sinvmt(ncontractions,wkvec(ka),wkvec(jc),
     &                          wkvec(kb),wkvec(kc),wkvec(kd))
      time2=etime(tarray)
      timec=time2-time1

      nsize=ncds+10*ncdspd

      nspace=(nsize*(nsize+1))/2

      time1=etime(tarray)
      call cdcalls(nreal-nspace,ncds,ncdspd,nsize,nmaxatoms,natoms,
     &             nbsystems,isys,icdlsave,icdlfunc,icdcfunc,iwkvec,
     &             cutoff,alphacd,coefscd,coefpcd,coefdcd,wkvec,
     &             coord,wkvec(nspace+1))
      time2=etime(tarray)
      timed=time2-time1

      if(myid.eq.0) write(6,1001) timea,timeb,timec,timed
 1001 format(' setup cpu times (grid, core, overlap, cd fits): ',4f7.1)

      return
      end
