      subroutine totale(ncntrt,ncd,iter,nbpc,ncentr,energy,dmaxdm,rmsdm,
     &                  dmta,dmtb,fock,coord,charge,coordpc,pcharge,
     &                  overcd,cdcoef)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension dmta(*),dmtb(*),fock(*)
      dimension coord(3,*),charge(*),coordpc(3,*),pcharge(*)
      dimension overcd(*),cdcoef(*)

      data zero,half/0.0d0,0.5d0/

      if(iter.eq.1) then

       write(6,1001)
 1001  format(
     & /,5x,
     & '                                           density matrix     ',
     & /,5x,
     & '                                      ------------------------',
     & /,5x,
     & ' cycle            total energy        max change    rms change',
     & /,5x,
     & ' -------------------------------------------------------------')

                    endif

      energy=zero

      do 1002 i=1,ncntrt*(ncntrt+1)/2
 1002 energy=energy+(dmta(i)+dmtb(i))*fock(i)

      rewind 17

      call fastrd(17,overcd,(ncd*(ncd+1))/2)

      do 1003 i=1,ncd
      ii=(i*(i-1))/2
 1003 energy=energy-cdcoef(i)*dot(i,cdcoef,overcd(ii+1))

      do 1004 i=1,ncd
 1004 energy=energy+half*cdcoef(i)*cdcoef(i)*overcd((i*(i+1))/2)

      do 1005 i=1,ncentr
      do 1005 j=1,i
      if(i.ne.j) then
                       rrij=dist(coord(1,i),coord(1,j))
                       energy=energy+charge(i)*charge(j)/rrij
                 endif
 1005 continue

      if(nbpc.ne.0) then
                          do 1006 i=1,nbpc

                          do 1007 j=1,ncentr
                          rrij=dist(coord(1,j),coordpc(1,i))
 1007                     energy=energy+charge(j)*pcharge(i)/rrij

                          do 1006 j=1,i
                          if(i.ne.j) then

                               rrij=dist(coordpc(1,j),coordpc(1,i))
                               energy=energy+pcharge(j)*pcharge(i)/rrij

                                     endif
 1006                     continue
                    endif

      write(6,1008) iter,energy,dmaxdm,rmsdm
 1008 format(6x,i4,5x,f20.10,7x,e11.4,3x,e11.4)

      call flush(6)

      return
      end
