      subroutine xcfunctional(npts,nfunctional,nalpha,nbeta,dnstya,
     &                        dnstyb,dnstyt,xcnrgy,xcpota,xcpotb)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      dimension dnstya(*),dnstyb(*),dnstyt(*)
      dimension xcnrgy(*),xcpota(*),xcpotb(*)

      data small/1.0d-15/

      data zero,one,two,three,four,six/
     &                              0.0d0,1.0d0,2.0d0,3.0d0,4.0d0,6.0d0/

      data third,threequarters,fthird/
     &                      0.33333333333333d0,0.75d0,1.3333333333333d0/

      data pi,dnom,zetadnom,pialpha/
     &        3.1415926535898d0,5.1297633d0,0.519842099d0,1.636963801d0/

      do 1001 i=1,npts

      if(dnstyt(i).gt.small) then
                                   rs=one/(pi*fthird*dnstyt(i))**third

                                   zeta=(dnstya(i)-dnstyb(i))/dnstyt(i)

                                   if(zeta.gt.+one) zeta=+one
                                   if(zeta.lt.-one) zeta=-one
                             else
                                   xcnrgy(i)=zero

                                   xcpota(i)=zero
                                   xcpotb(i)=zero

                                   goto 1001
                             endif

      azeta=abs(zeta)

      if(azeta.gt.small) then
                               ex=-(threequarters/(pialpha*rs))
     &                            *((one+zeta)**fthird
     &                             +(one-zeta)**fthird)/two
                         else
                               ex=-(threequarters/(pialpha*rs))
                         endif

      if(nfunctional.eq.0) then

                     factor=-threequarters*(three/pi)**third

                     vxa=factor*((two*dnstya(i))**third)*fthird
                     vxb=factor*((two*dnstyb(i))**third)*fthird

                           else

                     ex=zero

                     vxa=zero
                     vxb=zero

                           endif

      sqrtrs=sqrt(rs)

      aa=vwnf1(1,sqrtrs)/two
      bb=vwnf2(1,sqrtrs)/two

      ec=aa

      vca=aa-bb*sqrtrs/six
      vcb=vca

      if(azeta.gt.small) then
                               cc=(vwnf1(2,sqrtrs)/two)-aa
                               dd=(vwnf2(2,sqrtrs)/two)-bb
                               ee=(vwnf1(3,sqrtrs)/two)*three/dnom

                               sf1=((one+zeta)**third
     &                             -(one-zeta)**third)*dnom/two
                               sf2=(((one+zeta)**fthird
     &                             +(one-zeta)**fthird)-two)/zetadnom

                               ff=sf2*(cc*zeta**4+ee*(one-zeta**4)
     &                           -(sqrtrs/six)*(dd*zeta**4+(one-zeta**4)
     &                           *vwnf2(3,sqrtrs)*three/two/dnom))

                               gg=sf1*(cc*zeta**4+ee*(one-zeta**4))
     &                           +four*sf2*((cc-ee)*zeta**3)

                               ec=ec+sf2*(cc*(zeta**4)+ee*(one-zeta**4))

                               vca=vca+ff+(one-zeta)*gg
                               vcb=vcb+ff-(one+zeta)*gg
                       endif

      xcnrgy(i)=ex+ec

      xcpota(i)=vxa+vca
      xcpotb(i)=vxb+vcb

 1001 continue

      return
      end
