      subroutine xcgrad(nalpha,nbeta,nfunctional,nptsbatch,nmaxpts,
     &                  ngridtype,iptsweight,ncntrt,nconts,ncontp,
     &                  ncontd,ncentr,ilfunc,icfunc,ngauss,nptrs,nptrp,
     &                  nptrd,nptsatom,natnumber,nfuncatom,istore,index,
     &                  inbox,myatom,iwkvec,alpha,coeff,dmta,dmtb,cent,
     &                  grad,x,y,z,w,dfdrhoa,dfdrhob,xcenergy,dfdgaa,
     &                  dfdgbb,dfdgab,rho,gradrhox,gradrhoy,gradrhoz,qf,
     &                  qx,qy,qz,qxx,qxy,qxz,qyy,qyz,qzz,dcc,extent1,
     &                  extent3,drvtv,wv,wf,wfx,wfy,wfz,xvec,yvec,zvec,
     &                  wvec,dmidpts,distmat)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.

      implicit real*8(a-h,o-z)

      include "mpif.h"

      dimension istat(mpi_status_size)

      dimension ilfunc(*),icfunc(*),ngauss(*),nptrs(*),nptrp(*),nptrd(*)
      dimension nptsatom(*),natnumber(*),nfuncatom(*)
      dimension istore(*),index(*),inbox(*),myatom(*),iwkvec(*)

      dimension alpha(*),coeff(*),dmta(*),dmtb(*),cent(3,*),grad(3,*)

      dimension x(*),y(*),z(*),w(*)
      dimension dfdrhoa(*),dfdrhob(*),xcenergy(*)
      dimension dfdgaa(*),dfdgbb(*),dfdgab(*)
      dimension rho(nptsbatch,*),gradrhox(nptsbatch,*),
     &                           gradrhoy(nptsbatch,*),
     &                           gradrhoz(nptsbatch,*)
      dimension qf(nptsbatch,*)
      dimension qx(nptsbatch,*),qy(nptsbatch,*),qz(nptsbatch,*)
      dimension qxx(nptsbatch,*),qxy(nptsbatch,*),qxz(nptsbatch,*),
     &          qyy(nptsbatch,*),qyz(nptsbatch,*),qzz(nptsbatch,*)
      dimension dcc(*),extent1(*),extent3(*)
      dimension drvtv(nptsbatch,*)
      dimension wv(*)
      dimension wf(nptsbatch,*),wfx(nptsbatch,*),
     &                          wfy(nptsbatch,*),
     &                          wfz(nptsbatch,*)
      dimension xvec(*),yvec(*),zvec(*),wvec(*),dmidpts(3,*)
      dimension distmat(ncentr,*)

      data zero,half,two,four/0.0d0,0.5d0,2.0d0,4.0d0/
      data cutoff,tolerance/1.0d-16,1.0d-18/

      call mpi_comm_rank(mpi_comm_world,myid,ierr)
      call mpi_comm_size(mpi_comm_world,numprocs,ierr)

      call diffuse2(nconts,ncontp,ncontd,ilfunc,icfunc,ngauss,nptrs,
     &              nptrp,nptrd,cutoff,alpha,coeff,extent1)

      do 1001 j=1,ncentr
      do 1001 i=1,ncentr
 1001 distmat(i,j)=dist(cent(1,i),cent(1,j))

      if(myid.eq.0) then
                          rewind 11

                          read(11) iboxes,ipoints
                          read(11) imaxbox

                          call ifastrd(11,index,iboxes)
                          call ifastrd(11,inbox,iboxes)

                          call fastrd(11,dmidpts,3*iboxes)

                          call fastrd(11,xvec,ipoints)
                          call fastrd(11,yvec,ipoints)
                          call fastrd(11,zvec,ipoints)
                          call fastrd(11,wvec,ipoints)

                          call ifastrd(11,myatom,ipoints)
                    endif

      do 1002 iloop=1,iboxes

      nbox=inbox(iloop)

      xcenter=dmidpts(1,iloop)
      ycenter=dmidpts(2,iloop)
      zcenter=dmidpts(3,iloop)

      do 1003 i=1,ncentr
      xxx=abs(cent(1,i)-xcenter)
      yyy=abs(cent(2,i)-ycenter)
      zzz=abs(cent(3,i)-zcenter)
      if(xxx.gt.two) then
                           xxx=xxx-two
                     else
                           xxx=zero
                     endif
      if(yyy.gt.two) then
                           yyy=yyy-two
                     else
                           yyy=zero
                     endif
      if(zzz.gt.two) then
                           zzz=zzz-two
                     else
                           zzz=zero
                     endif
 1003 dcc(i)=sqrt((xxx**2)+(yyy**2)+(zzz**2))

      if(myid.eq.0) then
                          call stringcopy(nbox,x,xvec(index(iloop)))
                          call stringcopy(nbox,y,yvec(index(iloop)))
                          call stringcopy(nbox,z,zvec(index(iloop)))
                          call stringcopy(nbox,w,wvec(index(iloop)))
                    endif

      do 1004 ia=1,nbox,nptsbatch

      ib=min(ia+nptsbatch-1,nbox)

      npts=ib-ia+1

      kindex=index(iloop)+ia-1

      nmaxloop=(npts/numprocs)+1
      if((nmaxloop*numprocs).lt.npts) nmaxloop=nmaxloop+1

      if(myid.eq.0) then
                          ja=ia

                          islave=0

                          do 1005 i=1,npts,nmaxloop

                          nloop=min(nmaxloop,npts-i+1)

                          call mpi_bsend(nloop,1,mpi_integer,islave,
     &                                   islave,mpi_comm_world,ierr)
                          call mpi_bsend(ja,1,mpi_integer,islave,
     &                                   islave,mpi_comm_world,ierr)

                          call mpi_bsend(x(ja),nloop,mpi_real8,islave,
     &                                   islave,mpi_comm_world,ierr)
                          call mpi_bsend(y(ja),nloop,mpi_real8,islave,
     &                                   islave,mpi_comm_world,ierr)
                          call mpi_bsend(z(ja),nloop,mpi_real8,islave,
     &                                   islave,mpi_comm_world,ierr)
                          call mpi_bsend(w(ja),nloop,mpi_real8,islave,
     &                                   islave,mpi_comm_world,ierr)

                          ja=ja+nloop

                          last_slave=islave
                           
 1005                     islave=islave+1

                          do 1006 i=islave,numprocs-1
                          ii=0
 1006                     call mpi_bsend(ii,1,mpi_integer,
     &                                   i,i,mpi_comm_world,ierr)
                    endif

      call mpi_recv(npts,1,mpi_integer,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)

      if(npts.eq.0) goto 1004

      call mpi_recv(ja,1,mpi_integer,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)

      call mpi_recv(x(ja),npts,mpi_real8,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)
      call mpi_recv(y(ja),npts,mpi_real8,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)
      call mpi_recv(z(ja),npts,mpi_real8,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)
      call mpi_recv(w(ja),npts,mpi_real8,0,
     &              mpi_any_tag,mpi_comm_world,istat,ierr)

      ka=1
      kb=ka+ncentr
      kc=kb+ncentr
      kd=kc+ncentr
      ke=kd+ncentr*ncentr

      if(iptsweight.eq.1) call gridgrad(myatom(kindex),npts,nptsbatch,
     &                                  ncentr,nconts,ncontp,ncontd,
     &                                  ilfunc,icfunc,ngauss,nptrs,
     &                                  nptrp,nptrd,natnumber,istore,
     &                                  iwkvec,cent,alpha,coeff,wv(ka),
     &                                  wv(kb),wv(kc),distmat,wv(kd),
     &                                  wv(ke),drvtv,x(ja),y(ja),z(ja),
     &                                  w(ja))

      call compg2(ncntrt,npts,nptsbatch,nconts,ncontp,ncontd,ilfunc,
     &            icfunc,ngauss,nptrs,nptrp,nptrd,xcenter,ycenter,
     &            zcenter,cent,alpha,coeff,x(ja),y(ja),z(ja),qf,qx,qy,
     &            qz,qxx,qxy,qxz,qyy,qyz,qzz,extent1,extent3,dcc,
     &            wv(00*npts+1),wv(01*npts+1),wv(02*npts+1),
     &            wv(03*npts+1),wv(04*npts+1),wv(05*npts+1),
     &            wv(06*npts+1),wv(07*npts+1),wv(08*npts+1),
     &            wv(09*npts+1),wv(10*npts+1),wv(11*npts+1),
     &            wv(12*npts+1),wv(13*npts+1),wv(14*npts+1),
     &            wv(15*npts+1),wv(16*npts+1),wv(17*npts+1),
     &            wv(18*npts+1),wv(19*npts+1),wv(20*npts+1),
     &            wv(21*npts+1),wv(22*npts+1),wv(23*npts+1),
     &            wv(24*npts+1),wv(25*npts+1),wv(26*npts+1),
     &            wv(27*npts+1),wv(28*npts+1),wv(29*npts+1),
     &            wv(30*npts+1),wv(31*npts+1),wv(32*npts+1),
     &            wv(33*npts+1),wv(34*npts+1),wv(35*npts+1),
     &            wv(36*npts+1),wv(37*npts+1),wv(38*npts+1),
     &            wv(39*npts+1))

      jstop=1
      if(nalpha.ne.nbeta) jstop=2

      do 1007 j=1,jstop
      call utility2(npts,zero,rho(1,j))
      call utility2(npts,zero,gradrhox(1,j))
      call utility2(npts,zero,gradrhoy(1,j))
 1007 call utility2(npts,zero,gradrhoz(1,j))

      ihits=0

      do 1008 i=1,ncntrt
      if(extent3(i).gt.tolerance) then
                                        ihits=ihits+1
                                        iwkvec(ncentr+ihits)=i
                                  endif
 1008 continue

      do 1009 i=1,ihits
      ii=iwkvec(ncentr+i)

      call utility2(npts,zero,wf(1,ii))

      if(nfunctional.gt.0) then
                                 call utility2(npts,zero,wfx(1,ii))
                                 call utility2(npts,zero,wfy(1,ii))
                                 call utility2(npts,zero,wfz(1,ii))
                           endif

      do 1009 j=1,ihits
      jj=iwkvec(ncentr+j)

      ijmax=max(ii,jj)
      ijmin=min(ii,jj)
      ij=(ijmax*(ijmax-1)/2)+ijmin

      if(ii.eq.jj) then
                         factor=dmta(ij)*two
                   else
                         factor=dmta(ij)
                   endif

      call utility3(npts,factor,wf(1,ii),qf(1,jj))

      if(nfunctional.gt.0) then

                           call utility3(npts,factor,wfx(1,ii),qx(1,jj))
                           call utility3(npts,factor,wfy(1,ii),qy(1,jj))
                           call utility3(npts,factor,wfz(1,ii),qz(1,jj))

                           endif

 1009 continue
 
      do 1010 i=1,ihits
      ii=iwkvec(ncentr+i)
 1010 call utility1(npts,rho(1,1),qf(1,ii),wf(1,ii))

      call utility5(npts,half,rho(1,1))

      if(nfunctional.gt.0) then

                     do 1011 i=1,ihits
                     ii=iwkvec(ncentr+i)
                     call utility1(npts,gradrhox(1,1),qx(1,ii),wf(1,ii))
                     call utility1(npts,gradrhoy(1,1),qy(1,ii),wf(1,ii))
 1011                call utility1(npts,gradrhoz(1,1),qz(1,ii),wf(1,ii))

                           endif

      if(nalpha.eq.nbeta) then

                call stringcopy(npts,rho(1,2),rho(1,1))

                if(nfunctional.gt.0) then

                       call stringcopy(npts,gradrhox(1,2),gradrhox(1,1))
                       call stringcopy(npts,gradrhoy(1,2),gradrhoy(1,1))
                       call stringcopy(npts,gradrhoz(1,2),gradrhoz(1,1))

                                     endif

                goto 1015

                          endif

      do 1012 i=1,ihits
      ii=iwkvec(ncentr+i)

      call utility2(npts,zero,wf(1,ii))

      if(nfunctional.gt.0) then
                                 call utility2(npts,zero,wfx(1,ii))
                                 call utility2(npts,zero,wfy(1,ii))
                                 call utility2(npts,zero,wfz(1,ii))
                           endif

      do 1012 j=1,ihits
      jj=iwkvec(ncentr+j)

      ijmax=max(ii,jj)
      ijmin=min(ii,jj)
      ij=(ijmax*(ijmax-1)/2)+ijmin

      if(ii.eq.jj) then
                         factor=dmtb(ij)*two
                   else
                         factor=dmtb(ij)
                   endif

      call utility3(npts,factor,wf(1,ii),qf(1,jj))

      if(nfunctional.gt.0) then

                           call utility3(npts,factor,wfx(1,ii),qx(1,jj))
                           call utility3(npts,factor,wfy(1,ii),qy(1,jj))
                           call utility3(npts,factor,wfz(1,ii),qz(1,jj))

                           endif

 1012 continue

      do 1013 i=1,ihits
      ii=iwkvec(ncentr+i)
 1013 call utility1(npts,rho(1,2),qf(1,ii),wf(1,ii))

      call utility5(npts,half,rho(1,2))

      if(nfunctional.gt.0) then

                     do 1014 i=1,ihits
                     ii=iwkvec(ncentr+i)
                     call utility1(npts,gradrhox(1,2),qx(1,ii),wf(1,ii))
                     call utility1(npts,gradrhoy(1,2),qy(1,ii),wf(1,ii))
 1014                call utility1(npts,gradrhoz(1,2),qz(1,ii),wf(1,ii))

                           endif

 1015 continue

      call addvecs(npts,rho(1,3),rho(1,1),rho(1,2))

      if(nfunctional.gt.0) then

            call addvecs(npts,gradrhox(1,3),gradrhox(1,1),gradrhox(1,2))
            call addvecs(npts,gradrhoy(1,3),gradrhoy(1,1),gradrhoy(1,2))
            call addvecs(npts,gradrhoz(1,3),gradrhoz(1,1),gradrhoz(1,2))

                           endif

      call xcfunctional(npts,nfunctional,nalpha,nbeta,
     &                  rho(1,1),rho(1,2),rho(1,3),
     &                  xcenergy,dfdrhoa,dfdrhob)

      if(nfunctional.gt.0) then

              call xc_partial(npts,nalpha,nbeta,
     &                        xcenergy,dfdrhoa,dfdrhob,
     &                        rho(1,1),rho(1,2),rho(1,3),
     &                        gradrhox(1,1),gradrhoy(1,1),gradrhoz(1,1),
     &                        gradrhox(1,2),gradrhoy(1,2),gradrhoz(1,2),
     &                        gradrhox(1,3),gradrhoy(1,3),gradrhoz(1,3),
     &                        dfdgaa,dfdgbb,dfdgab,
     &                        wv(0*npts+1),wv(1*npts+1),wv(2*npts+1),
     &                        wv(3*npts+1),wv(4*npts+1),wv(5*npts+1))

                           endif

      call utility6(npts,dfdrhoa,w(ja))
      call utility6(npts,dfdrhob,w(ja))

      if(nfunctional.gt.0) then
                                 call utility7(npts,dfdgaa,w(ja),two)
                                 call utility7(npts,dfdgbb,w(ja),two)
                                 call utility6(npts,dfdgab,w(ja))
                           endif

      xcmax=dmaxvec(xcenergy,npts)

      ihits=0

      do 1016 i=1,ncntrt
      if(extent3(i).gt.tolerance) then
                                        ihits=ihits+1
                                        iwkvec(ncentr+ihits)=i
                                  endif
 1016 continue

      do 1017 i=1,ihits
      ii=iwkvec(ncentr+i)

      icenter=nfuncatom(ii)

      do 1017 j=1,ihits
      jj=iwkvec(ncentr+j)

      ijmax=max(ii,jj)
      ijmin=min(ii,jj)
      ij=(ijmax*(ijmax-1)/2)+ijmin

      if(ii.eq.jj) then
                         dnstya=dmta(ij)*two
                         dnstyb=dmtb(ij)*two
                   else
                         dnstya=dmta(ij)
                         dnstyb=dmtb(ij)
                   endif

      call utilitye(npts,wv,dnstya,dfdrhoa,dnstyb,dfdrhob,qf(1,jj))

      if(nfunctional.gt.0) then

          call utilityf(npts,wv(1*npts+1),dnstya,
     &                  dfdgaa,gradrhox(1,1),dfdgab,gradrhox(1,2))
          call utilityf(npts,wv(2*npts+1),dnstya,
     &                  dfdgaa,gradrhoy(1,1),dfdgab,gradrhoy(1,2))
          call utilityf(npts,wv(3*npts+1),dnstya,
     &                  dfdgaa,gradrhoz(1,1),dfdgab,gradrhoz(1,2))

          if(nalpha.ne.nbeta) then

                call utilityf(npts,wv(4*npts+1),dnstyb,
     &                        dfdgbb,gradrhox(1,2),dfdgab,gradrhox(1,1))
                call utilityf(npts,wv(5*npts+1),dnstyb,
     &                        dfdgbb,gradrhoy(1,2),dfdgab,gradrhoy(1,1))
                call utilityf(npts,wv(6*npts+1),dnstyb,
     &                        dfdgbb,gradrhoz(1,2),dfdgab,gradrhoz(1,1))

                              endif

          if(nalpha.ne.nbeta) then

                              call utilityg(npts,wv(11*npts+1),qf(1,jj),
     &                                      wv(1*npts+1),wv(4*npts+1))
                              call utilityg(npts,wv(12*npts+1),qf(1,jj),
     &                                      wv(2*npts+1),wv(5*npts+1))
                              call utilityg(npts,wv(13*npts+1),qf(1,jj),
     &                                      wv(3*npts+1),wv(6*npts+1))

                              call utilityg(npts,wv(21*npts+1),qx(1,jj),
     &                                      wv(1*npts+1),wv(4*npts+1))
                              call utilityg(npts,wv(22*npts+1),qy(1,jj),
     &                                      wv(2*npts+1),wv(5*npts+1))
                              call utilityg(npts,wv(23*npts+1),qz(1,jj),
     &                                      wv(3*npts+1),wv(6*npts+1))

                              else

                              call utility8(npts,wv(11*npts+1),
     &                                      wv(1*npts+1),qf(1,jj))
                              call utility8(npts,wv(12*npts+1),
     &                                      wv(2*npts+1),qf(1,jj))
                              call utility8(npts,wv(13*npts+1),
     &                                      wv(3*npts+1),qf(1,jj))

                              call utility8(npts,wv(21*npts+1),
     &                                      wv(1*npts+1),qx(1,jj))
                              call utility8(npts,wv(22*npts+1),
     &                                      wv(2*npts+1),qy(1,jj))
                              call utility8(npts,wv(23*npts+1),
     &                                      wv(3*npts+1),qz(1,jj))

                              endif

                           endif

      grad(1,icenter)=grad(1,icenter)-dot(npts,qx(1,ii),wv)
      grad(2,icenter)=grad(2,icenter)-dot(npts,qy(1,ii),wv)
      grad(3,icenter)=grad(3,icenter)-dot(npts,qz(1,ii),wv)

      call utilityh(npts,wv(24*npts+1),
     &              wv(21*npts+1),wv(22*npts+1),wv(23*npts+1))

      if(nfunctional.gt.0) then

              if(nalpha.ne.nbeta) then

                   grad(1,icenter)=grad(1,icenter)
     &                            -dot(npts,wv(11*npts+1),qxx(1,ii))
     &                            -dot(npts,wv(12*npts+1),qxy(1,ii))
     &                            -dot(npts,wv(13*npts+1),qxz(1,ii))
     &                            -dot(npts,wv(24*npts+1),qx(1,ii))
                   grad(2,icenter)=grad(2,icenter)
     &                            -dot(npts,wv(11*npts+1),qxy(1,ii))
     &                            -dot(npts,wv(12*npts+1),qyy(1,ii))
     &                            -dot(npts,wv(13*npts+1),qyz(1,ii))
     &                            -dot(npts,wv(24*npts+1),qy(1,ii))
                   grad(3,icenter)=grad(3,icenter)
     &                            -dot(npts,wv(11*npts+1),qxz(1,ii))
     &                            -dot(npts,wv(12*npts+1),qyz(1,ii))
     &                            -dot(npts,wv(13*npts+1),qzz(1,ii))
     &                            -dot(npts,wv(24*npts+1),qz(1,ii))

                                  else

                   grad(1,icenter)=grad(1,icenter)
     &                            -two*dot(npts,wv(11*npts+1),qxx(1,ii))
     &                            -two*dot(npts,wv(12*npts+1),qxy(1,ii))
     &                            -two*dot(npts,wv(13*npts+1),qxz(1,ii))
     &                            -two*dot(npts,wv(24*npts+1),qx(1,ii))
                   grad(2,icenter)=grad(2,icenter)
     &                            -two*dot(npts,wv(11*npts+1),qxy(1,ii))
     &                            -two*dot(npts,wv(12*npts+1),qyy(1,ii))
     &                            -two*dot(npts,wv(13*npts+1),qyz(1,ii))
     &                            -two*dot(npts,wv(24*npts+1),qy(1,ii))
                   grad(3,icenter)=grad(3,icenter)
     &                            -two*dot(npts,wv(11*npts+1),qxz(1,ii))
     &                            -two*dot(npts,wv(12*npts+1),qyz(1,ii))
     &                            -two*dot(npts,wv(13*npts+1),qzz(1,ii))
     &                            -two*dot(npts,wv(24*npts+1),qz(1,ii))

                                  endif
                           endif

      if((jj.gt.ii).or.(iptsweight.eq.0)) goto 1017

      dnstya=dmta(ij)
      dnstyb=dmtb(ij)

      check=(dnstya+dnstyb)*extent3(ii)*extent3(jj)*xcmax

      if(abs(check).lt.tolerance) goto 1017

      call utilityi(npts,wv,dnstya+dnstyb,xcenergy,qf(1,ii),qf(1,jj))

      do 1018 l=1,ncentr
      if(iwkvec(l).eq.1) then
                               do 1019 m=1,3
                               n=3*(l-1)+m
 1019                          grad(m,l)=grad(m,l)
     &                                  +dot(npts,wv,drvtv(1,n))
                         endif
 1018 continue
 1017 continue
 1004 continue
 1002 continue

      return
      end
