      subroutine zmatrix(nnn,c,izmat1,izmat2,izmat3,label)

c  this subroutine written by alain st-amant of the department of
c  pharmaceutical chemistry, university of california, san francisco.
c  all rights reserved.  this is part of the DeFT project.
 
      implicit real*8(a-h,o-z)
 
      dimension c(3,*)
      dimension izmat1(*),izmat2(*),izmat3(*)
      character label(*)*4
 
      data bohr,pi/0.529177d0,3.1415926535898d0/
 
      write(6,1001)
 1001 format(' z-matrix :',/)
 
      write(6,1002) label(1)
 1002 format(5x,a4,50x,'   0   0   0')
 
      if(nnn.eq.1) goto 1007 
 
      coord1=dist(c(1,1),c(1,2))*bohr
 
      write(6,1003) label(2),coord1
 1003 format(5x,a4,5x,f10.7,35x,'   1   0   0')
 
      if(nnn.eq.2) goto 1007
 
      iii1=izmat1(3)
      iii2=izmat2(3)
 
      coord1=dist(c(1,3),c(1,iii1))*bohr
      coord2=ang(c(1,3),c(1,iii1),c(1,iii2))
 
      write(6,1004) label(3),coord1,coord2,iii1,iii2
 1004 format(5x,a4,5x,f10.7,5x,f10.4,20x,2i4,'   0')
 
      if(nnn.eq.3) goto 1007
 
      do 1005 i=4,nnn
 
      iii=i
      iii1=izmat1(i)
      iii2=izmat2(i)
      iii3=izmat3(i)
 
      coord1=dist(c(1,iii),c(1,iii1))*bohr
      coord2=ang(c(1,iii),c(1,iii1),c(1,iii2))
      coord3=dihed(c(1,iii),c(1,iii1),c(1,iii2),c(1,iii3))
 
      write(6,1006) label(i),coord1,coord2,coord3,iii1,iii2,iii3
 1006 format(5x,a4,5x,f10.7,5x,f10.4,5x,f10.4,5x,3i4)
 
 1005 continue
 
 1007 write(6,1008)
 1008 format()
 
      return
      end
