############################################################################
#cr                                                                       
#cr            (C) Copyright 1995 The Board of Trustees of the            
#cr                        University of Illinois                         
#cr                         All Rights Reserved                           
#cr                                                                       
############################################################################

############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: vmdinit.tcl,v $
# 	$Author: dalke $	$Locker:  $		$State: Exp $
#	$Revision: 1.3 $	$Date: 1997/03/24 05:30:30 $
#
############################################################################
# DESCRIPTION:
#   install the "core" vmd/tcl procedures and variables
#
############################################################################

# This is part of the VMD installation.
# For more information about VMD, see http://www.ks.uiuc.edu/Research/vmd


# catch ^C (SIGINT) to prevent VMD from dying when I stop a Tcl script
signal error SIGINT

# rename the Tcl commands that VMD overrides
# VMD 1.2 will use Tk while 1.2b1 and earlier use XForms
# VMD 1.1 and Tk have some conflicts in their names.  The VMD
# commands with this problem are: label, menu and scale
# Luckily, the 1st word in all these for Tk require a .path.name,
# and VMD does not, so we can write a wrapper to distinguish them.
if {[info commands label] == "label"} {
    rename label vmd_tk_label
}
proc label {args} {
    lassign $args arg1
    if {[string first . $arg1] >= 0} {
	return [eval "vmd_tk_label $args"]
    } else {
	return [eval "vmd_label $args"]
    }
}
if {[info commands menu] == "menu"} {
    rename menu vmd_tk_menu
}
proc menu {args} {
    lassign $args arg1
    if {[string first . $arg1] >= 0} {
	return [eval "vmd_tk_menu $args"]
    } else {
	return [eval "vmd_menu $args"]
    }
}
if {[info commands scale] == "scale"} {
    rename scale vmd_tk_scale
}
proc scale {args} {
    lassign $args arg1
    if {[string first . $arg1] >= 0} {
	return [eval "vmd_tk_scale $args"]
    } else {
	return [eval "vmd_scale $args"]
    }
}
# and "help" is a TclX command that VMD ignores
proc help {args} {
    return [eval "vmd_help $args"]
}

# default directory locations
if {![info exists env(VMDDIR)]} {
    set env(VMDDIR) /usr/local/lib/vmd
}
if {![info exists env(TMPDIR)]} {
    set env(TMPDIR) /usr/tmp
}

# set the autoloading functions
if {! [info exists auto_path]} {
    set auto_path {}
}
set auto_path "$env(VMDDIR)/scripts/vmd $env(VMDDIR)/scripts/tcl \
$env(VMDDIR)/scripts/tclX $auto_path"

# initialize the vmd_mouse_mode and vmd_mouse_submode variables
set vmd_mouse_mode rotate
set vmd_mouse_submode -1

# some things are NOT autoloaded since that overrides the 
# definitions overridden (for performance reasons) in C++

source $env(VMDDIR)/scripts/vmd/vectors.tcl
source $env(VMDDIR)/scripts/vmd/atomselect.tcl

# whereas this is needed to set the hotkeys
source $env(VMDDIR)/scripts/vmd/hotkeys.tcl

#  everything else is safe to autoload, except that fit.tcl can
#  be barely, only okay since Mouse.C can handle not knowing some variables

# the index is made with:
# auto_mkindex . \
#     {{basic,draw,fit,measure,stride,external,popup,save_state,remote,\
# openURL,www}.tcl}
#
# The following should not be indexed:
#  {atomselect,hotkeys,vectors,vmdinit}.tcl
#

#######################################
#  This uses the Perl script 'url_get' to load a structure available
# from a URL
# It cannot be autoloaded since VMD calls 'vmd_mol_urlload'
# directly (w/o using one of the Eval commands)
#  (Is that comment really correct?  I don't think so ...)
proc vmd_mol_urlload {url} {
    global env
    # get the full path to the executable $VMDDIR/lib/script/vmd/url_get
    set execname $env(VMDDIR) 
    append execname /scripts/vmd/url_get

    # get the file name in which to save
    set filename $env(TMPDIR)
    append filename "/urlload"
    set filename [unique_file $filename]
    # and call the program
    exec perl $execname $url > $filename
    return $filename
}

