/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: AlphaShape.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 95/05/31 06:47:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * C++ interface to the Alpha shapes library based on routines written
 * by Michael Facello.  The Alpha shapes library was developed by
 * Ernst Mucke and Michael Facello under the supervision of Herbert
 * Edelsbrunner, Department of Computer Science, University of Illinois
 * at Urbana-Champaign
 *
 ***************************************************************************/


#ifndef ALPHASHAPE_H
#define ALPHASHAPE_H


typedef int Tvect[3];
typedef int Evect[2];

class AlphaShape {
 private:
   char *dirname;    // where the temp dir is located
   char *filename;   // base name of the three alpha files
   float scale;      // scaling factor (or 1.0 if none was given)
   int is_okay;      // was the creation/ read okay?
   void init(void);
   void free_all(void);
   
 public:
   // constructor takes the x,y,z,r array
   // This is the slowest way to do things
   AlphaShape(float radius, int num_points, float *x, float *y, 
	      float *z, float *r, float scaling_factor = 100.0);

   // this constructor takes the filename prefix
   AlphaShape(float radius, const char *new_filename);

   // deallocate everything
   ~AlphaShape(void);
   
   // returns 0 if the data was read correctly during the constructor
   int okay(void) { return is_okay; }

   // find the alpha shape of the given weight
   void get_faces(float radius);
   
   // the raw data (no accessor functions here)
   int num_triangles;
   int num_edges;
   int num_vertices;
   int rank;
   // and direct to the raw data ...
   Tvect *triangles;   // returns 3 indicies
   Evect *edges;      // returns 2 indicies
   int *vertices;      // returns 1 index
   
};
#endif

